/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:01:44 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_c -simd -trivial-stores -compact -variables 4 -n 8 -name n1fv_8 -include n1f.h */

/*
 * This function contains 26 FP additions, 2 FP multiplications,
 * (or, 26 additions, 2 multiplications, 0 fused multiply/add),
 * 20 stack variables, and 16 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_c.ml,v 1.9 2003/04/16 21:21:53 athena Exp $
 */

#include "n1f.h"

static void n1fv_8(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     int i;
     const R *xi;
     R *xo;
     xi = ri;
     xo = ro;
     BEGIN_SIMD();
     for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs)) {
	  V T3, Tv, Tf, Tp, Ta, Tw, Tc, Ts;
	  {
	       V T1, T2, Tn, Td, Te, To;
	       T1 = LD(&(xi[0]), ivs, &(xi[0]));
	       T2 = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
	       Tn = VADD(T1, T2);
	       Td = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
	       Te = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
	       To = VADD(Td, Te);
	       T3 = VSUB(T1, T2);
	       Tv = VSUB(Tn, To);
	       Tf = VSUB(Td, Te);
	       Tp = VADD(Tn, To);
	  }
	  {
	       V T6, Tq, T9, Tr;
	       {
		    V T4, T5, T7, T8;
		    T4 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
		    T5 = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
		    T6 = VSUB(T4, T5);
		    Tq = VADD(T4, T5);
		    T7 = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
		    T8 = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
		    T9 = VSUB(T7, T8);
		    Tr = VADD(T7, T8);
	       }
	       Ta = VMUL(LDK(KP707106781), VADD(T6, T9));
	       Tw = VBYI(VSUB(Tr, Tq));
	       Tc = VMUL(LDK(KP707106781), VSUB(T9, T6));
	       Ts = VADD(Tq, Tr);
	  }
	  {
	       V Tt, Tu, Ty, Tx;
	       Tt = VSUB(Tp, Ts);
	       ST(&(xo[WS(os, 4)]), Tt, ovs, &(xo[0]));
	       Tu = VADD(Tp, Ts);
	       ST(&(xo[0]), Tu, ovs, &(xo[0]));
	       Ty = VADD(Tv, Tw);
	       ST(&(xo[WS(os, 2)]), Ty, ovs, &(xo[0]));
	       Tx = VSUB(Tv, Tw);
	       ST(&(xo[WS(os, 6)]), Tx, ovs, &(xo[0]));
	       {
		    V Tl, Tm, Tj, Tk;
		    Tj = VSUB(T3, Ta);
		    Tk = VBYI(VADD(Tf, Tc));
		    Tl = VSUB(Tj, Tk);
		    Tm = VADD(Tj, Tk);
		    ST(&(xo[WS(os, 5)]), Tl, ovs, &(xo[WS(os, 1)]));
		    ST(&(xo[WS(os, 3)]), Tm, ovs, &(xo[WS(os, 1)]));
	       }
	       {
		    V Th, Ti, Tb, Tg;
		    Tb = VADD(T3, Ta);
		    Tg = VBYI(VSUB(Tc, Tf));
		    Th = VSUB(Tb, Tg);
		    Ti = VADD(Tb, Tg);
		    ST(&(xo[WS(os, 7)]), Th, ovs, &(xo[WS(os, 1)]));
		    ST(&(xo[WS(os, 1)]), Ti, ovs, &(xo[WS(os, 1)]));
	       }
	  }
     }
     END_SIMD();
}

static const kdft_desc desc = { 8, "n1fv_8", {26, 2, 0, 0}, &GENUS, 0, 0, 0, 0 };
void X(codelet_n1fv_8) (planner *p) {
     X(kdft_register) (p, n1fv_8, &desc);
}
