/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:02:28 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_c -simd -trivial-stores -compact -variables 4 -sign 1 -n 15 -name n2bv_15 -with-ostride 2 -include n2b.h */

/*
 * This function contains 78 FP additions, 25 FP multiplications,
 * (or, 64 additions, 11 multiplications, 14 fused multiply/add),
 * 57 stack variables, and 30 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_c.ml,v 1.9 2003/04/16 21:21:53 athena Exp $
 */

#include "n2b.h"

static void n2bv_15(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     DVK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DVK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DVK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DVK(KP509036960, +0.509036960455127183450980863393907648510733164);
     DVK(KP823639103, +0.823639103546331925877420039278190003029660514);
     DVK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DVK(KP216506350, +0.216506350946109661690930792688234045867850657);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DVK(KP484122918, +0.484122918275927110647408174972799951354115213);
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     int i;
     const R *xi;
     R *xo;
     xi = ii;
     xo = io;
     BEGIN_SIMD();
     for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs)) {
	  V Ti, Tf, Tz, T1n, Ts, T1m, T1b, TH, Tj, Tk, T1e, T1h, T1i, TE, TI;
	  V TN, TY, T1v;
	  {
	       V TF, TG, T3, T6, T7, T1d, To, Tr, T1c, Ta, Td, Te, T1g, Tv, Ty;
	       V T1f, Tg, Th;
	       TF = LD(&(xi[0]), ivs, &(xi[0]));
	       Tg = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
	       Th = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
	       Ti = VSUB(Tg, Th);
	       TG = VADD(Tg, Th);
	       {
		    V Tm, Tp, Tn, Tq;
		    Tm = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
		    Tp = LD(&(xi[WS(is, 12)]), ivs, &(xi[0]));
		    {
			 V T1, T2, T4, T5;
			 T1 = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
			 T2 = LD(&(xi[WS(is, 13)]), ivs, &(xi[WS(is, 1)]));
			 T3 = VSUB(T1, T2);
			 Tn = VADD(T1, T2);
			 T4 = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
			 T5 = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
			 T6 = VSUB(T4, T5);
			 Tq = VADD(T4, T5);
		    }
		    T7 = VADD(T3, T6);
		    T1d = VADD(Tp, Tq);
		    To = VFNMS(LDK(KP500000000), Tn, Tm);
		    Tr = VFNMS(LDK(KP500000000), Tq, Tp);
		    T1c = VADD(Tm, Tn);
	       }
	       {
		    V Tt, Tw, Tu, Tx;
		    Tt = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
		    Tw = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
		    {
			 V T8, T9, Tb, Tc;
			 T8 = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
			 T9 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
			 Ta = VSUB(T8, T9);
			 Tu = VADD(T8, T9);
			 Tb = LD(&(xi[WS(is, 14)]), ivs, &(xi[0]));
			 Tc = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
			 Td = VSUB(Tb, Tc);
			 Tx = VADD(Tb, Tc);
		    }
		    Te = VADD(Ta, Td);
		    T1g = VADD(Tw, Tx);
		    Tv = VFNMS(LDK(KP500000000), Tu, Tt);
		    Ty = VFNMS(LDK(KP500000000), Tx, Tw);
		    T1f = VADD(Tt, Tu);
	       }
	       Tf = VMUL(LDK(KP484122918), VSUB(T7, Te));
	       Tz = VSUB(Tv, Ty);
	       T1n = VSUB(T1f, T1g);
	       Ts = VSUB(To, Tr);
	       T1m = VSUB(T1c, T1d);
	       T1b = VADD(TF, TG);
	       TH = VFNMS(LDK(KP500000000), TG, TF);
	       Tj = VADD(T7, Te);
	       Tk = VFNMS(LDK(KP216506350), Tj, VMUL(LDK(KP866025403), Ti));
	       T1e = VADD(T1c, T1d);
	       T1h = VADD(T1f, T1g);
	       T1i = VADD(T1e, T1h);
	       {
		    V TC, TD, TL, TM;
		    TC = VADD(To, Tr);
		    TD = VADD(Tv, Ty);
		    TE = VMUL(LDK(KP559016994), VSUB(TC, TD));
		    TI = VADD(TC, TD);
		    TL = VSUB(T3, T6);
		    TM = VSUB(Ta, Td);
		    TN = VFMA(LDK(KP823639103), TL, VMUL(LDK(KP509036960), TM));
		    TY = VFNMS(LDK(KP823639103), TM, VMUL(LDK(KP509036960), TL));
	       }
	  }
	  T1v = VADD(T1b, T1i);
	  ST(&(xo[0]), T1v, ovs, &(xo[0]));
	  {
	       V T19, T1a, T17, T18;
	       T17 = VADD(TH, TI);
	       T18 = VBYI(VMUL(LDK(KP866025403), VADD(Ti, Tj)));
	       T19 = VSUB(T17, T18);
	       T1a = VADD(T18, T17);
	       ST(&(xo[10]), T19, ovs, &(xo[2]));
	       ST(&(xo[20]), T1a, ovs, &(xo[0]));
	  }
	  {
	       V T1o, T1r, T1l, T1s, T1j, T1k;
	       T1o = VBYI(VFNMS(LDK(KP951056516), T1n, VMUL(LDK(KP587785252), T1m)));
	       T1r = VBYI(VFMA(LDK(KP951056516), T1m, VMUL(LDK(KP587785252), T1n)));
	       T1j = VFNMS(LDK(KP250000000), T1i, T1b);
	       T1k = VMUL(LDK(KP559016994), VSUB(T1e, T1h));
	       T1l = VSUB(T1j, T1k);
	       T1s = VADD(T1k, T1j);
	       {
		    V T1p, T1u, T1q, T1t;
		    T1p = VSUB(T1l, T1o);
		    ST(&(xo[6]), T1p, ovs, &(xo[2]));
		    T1u = VSUB(T1s, T1r);
		    ST(&(xo[18]), T1u, ovs, &(xo[2]));
		    T1q = VADD(T1o, T1l);
		    ST(&(xo[24]), T1q, ovs, &(xo[0]));
		    T1t = VADD(T1r, T1s);
		    ST(&(xo[12]), T1t, ovs, &(xo[0]));
	       }
	  }
	  {
	       V TB, TR, TX, T13, TO, T14, TS, T10, Tl, TA;
	       Tl = VADD(Tf, Tk);
	       TA = VFMA(LDK(KP951056516), Ts, VMUL(LDK(KP587785252), Tz));
	       TB = VBYI(VADD(Tl, TA));
	       TR = VBYI(VSUB(Tl, TA));
	       {
		    V TV, TW, TK, TZ, TJ;
		    TV = VSUB(Tf, Tk);
		    TW = VFNMS(LDK(KP951056516), Tz, VMUL(LDK(KP587785252), Ts));
		    TX = VBYI(VADD(TV, TW));
		    T13 = VBYI(VSUB(TW, TV));
		    TJ = VFNMS(LDK(KP250000000), TI, TH);
		    TK = VADD(TE, TJ);
		    TZ = VSUB(TJ, TE);
		    TO = VSUB(TK, TN);
		    T14 = VSUB(TZ, TY);
		    TS = VADD(TN, TK);
		    T10 = VADD(TY, TZ);
	       }
	       {
		    V TP, T15, T16, TQ;
		    TP = VADD(TB, TO);
		    ST(&(xo[2]), TP, ovs, &(xo[2]));
		    T15 = VADD(T13, T14);
		    ST(&(xo[14]), T15, ovs, &(xo[2]));
		    T16 = VSUB(T14, T13);
		    ST(&(xo[16]), T16, ovs, &(xo[0]));
		    TQ = VSUB(TO, TB);
		    ST(&(xo[28]), TQ, ovs, &(xo[0]));
	       }
	       {
		    V TT, T11, T12, TU;
		    TT = VADD(TR, TS);
		    ST(&(xo[8]), TT, ovs, &(xo[0]));
		    T11 = VADD(TX, T10);
		    ST(&(xo[4]), T11, ovs, &(xo[0]));
		    T12 = VSUB(T10, TX);
		    ST(&(xo[26]), T12, ovs, &(xo[2]));
		    TU = VSUB(TS, TR);
		    ST(&(xo[22]), TU, ovs, &(xo[2]));
	       }
	  }
     }
     END_SIMD();
}

static const kdft_desc desc = { 15, "n2bv_15", {64, 11, 14, 0}, &GENUS, 0, 2, 0, 0 };
void X(codelet_n2bv_15) (planner *p) {
     X(kdft_register) (p, n2bv_15, &desc);
}
