/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:02:12 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_c -simd -trivial-stores -compact -variables 4 -n 12 -name n2fv_12 -with-ostride 2 -include n2f.h */

/*
 * This function contains 48 FP additions, 8 FP multiplications,
 * (or, 44 additions, 4 multiplications, 4 fused multiply/add),
 * 29 stack variables, and 24 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_c.ml,v 1.9 2003/04/16 21:21:53 athena Exp $
 */

#include "n2f.h"

static void n2fv_12(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     int i;
     const R *xi;
     R *xo;
     xi = ri;
     xo = ro;
     BEGIN_SIMD();
     for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs)) {
	  V T5, TR, Ta, TC, Tv, TN, Tg, TQ, Tl, Ty, TF, TO;
	  {
	       V T1, T6, T4, TA, T9, TB, Tt, Tu;
	       T1 = LD(&(xi[0]), ivs, &(xi[0]));
	       T6 = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
	       {
		    V T2, T3, T7, T8;
		    T2 = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
		    T3 = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
		    T4 = VADD(T2, T3);
		    TA = VSUB(T3, T2);
		    T7 = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
		    T8 = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
		    T9 = VADD(T7, T8);
		    TB = VSUB(T8, T7);
	       }
	       T5 = VADD(T1, T4);
	       TR = VADD(TA, TB);
	       Ta = VADD(T6, T9);
	       TC = VMUL(LDK(KP866025403), VSUB(TA, TB));
	       Tt = VFNMS(LDK(KP500000000), T4, T1);
	       Tu = VFNMS(LDK(KP500000000), T9, T6);
	       Tv = VSUB(Tt, Tu);
	       TN = VADD(Tt, Tu);
	  }
	  {
	       V Tc, Th, Tf, Tw, Tk, Tx, TD, TE;
	       Tc = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
	       Th = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
	       {
		    V Td, Te, Ti, Tj;
		    Td = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
		    Te = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
		    Tf = VADD(Td, Te);
		    Tw = VSUB(Te, Td);
		    Ti = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
		    Tj = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
		    Tk = VADD(Ti, Tj);
		    Tx = VSUB(Tj, Ti);
	       }
	       Tg = VADD(Tc, Tf);
	       TQ = VADD(Tw, Tx);
	       Tl = VADD(Th, Tk);
	       Ty = VMUL(LDK(KP866025403), VSUB(Tw, Tx));
	       TD = VFNMS(LDK(KP500000000), Tf, Tc);
	       TE = VFNMS(LDK(KP500000000), Tk, Th);
	       TF = VSUB(TD, TE);
	       TO = VADD(TD, TE);
	  }
	  {
	       V Tn, To, Tb, Tm;
	       Tb = VSUB(T5, Ta);
	       Tm = VBYI(VSUB(Tg, Tl));
	       Tn = VSUB(Tb, Tm);
	       To = VADD(Tb, Tm);
	       ST(&(xo[18]), Tn, ovs, &(xo[2]));
	       ST(&(xo[6]), To, ovs, &(xo[2]));
	  }
	  {
	       V Tr, Ts, Tp, Tq;
	       Tp = VADD(T5, Ta);
	       Tq = VADD(Tg, Tl);
	       Tr = VSUB(Tp, Tq);
	       Ts = VADD(Tp, Tq);
	       ST(&(xo[12]), Tr, ovs, &(xo[0]));
	       ST(&(xo[0]), Ts, ovs, &(xo[0]));
	  }
	  {
	       V TX, TY, TV, TW;
	       TV = VADD(TN, TO);
	       TW = VBYI(VMUL(LDK(KP866025403), VADD(TR, TQ)));
	       TX = VSUB(TV, TW);
	       TY = VADD(TV, TW);
	       ST(&(xo[16]), TX, ovs, &(xo[0]));
	       ST(&(xo[8]), TY, ovs, &(xo[0]));
	  }
	  {
	       V TT, TU, TP, TS;
	       TP = VSUB(TN, TO);
	       TS = VBYI(VMUL(LDK(KP866025403), VSUB(TQ, TR)));
	       TT = VSUB(TP, TS);
	       TU = VADD(TP, TS);
	       ST(&(xo[20]), TT, ovs, &(xo[0]));
	       ST(&(xo[4]), TU, ovs, &(xo[0]));
	  }
	  {
	       V TL, TM, TJ, TK;
	       TJ = VBYI(VSUB(TC, TF));
	       TK = VADD(Tv, Ty);
	       TL = VADD(TJ, TK);
	       TM = VSUB(TK, TJ);
	       ST(&(xo[2]), TL, ovs, &(xo[2]));
	       ST(&(xo[22]), TM, ovs, &(xo[2]));
	  }
	  {
	       V TH, TI, Tz, TG;
	       Tz = VSUB(Tv, Ty);
	       TG = VBYI(VADD(TC, TF));
	       TH = VSUB(Tz, TG);
	       TI = VADD(TG, Tz);
	       ST(&(xo[10]), TH, ovs, &(xo[2]));
	       ST(&(xo[14]), TI, ovs, &(xo[2]));
	  }
     }
     END_SIMD();
}

static const kdft_desc desc = { 12, "n2fv_12", {44, 4, 4, 0}, &GENUS, 0, 2, 0, 0 };
void X(codelet_n2fv_12) (planner *p) {
     X(kdft_register) (p, n2fv_12, &desc);
}
