/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:02:14 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_c -simd -trivial-stores -compact -variables 4 -n 14 -name n2fv_14 -with-ostride 2 -include n2f.h */

/*
 * This function contains 74 FP additions, 36 FP multiplications,
 * (or, 50 additions, 12 multiplications, 24 fused multiply/add),
 * 35 stack variables, and 28 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_c.ml,v 1.9 2003/04/16 21:21:53 athena Exp $
 */

#include "n2f.h"

static void n2fv_14(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     DVK(KP222520933, +0.222520933956314404288902564496794759466355569);
     DVK(KP900968867, +0.900968867902419126236102319507445051165919162);
     DVK(KP623489801, +0.623489801858733530525004884004239810632274731);
     DVK(KP433883739, +0.433883739117558120475768332848358754609990728);
     DVK(KP781831482, +0.781831482468029808708444526674057750232334519);
     DVK(KP974927912, +0.974927912181823607018131682993931217232785801);
     int i;
     const R *xi;
     R *xo;
     xi = ri;
     xo = ro;
     BEGIN_SIMD();
     for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs)) {
	  V T3, TF, To, TR, Ts, TL, Ta, TQ, Tr, TI, Th, TS, Tt, TO, T1;
	  V T2, Tp, T10;
	  T1 = LD(&(xi[0]), ivs, &(xi[0]));
	  T2 = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
	  T3 = VSUB(T1, T2);
	  TF = VADD(T1, T2);
	  {
	       V Tk, TJ, Tn, TK;
	       {
		    V Ti, Tj, Tl, Tm;
		    Ti = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
		    Tj = LD(&(xi[WS(is, 13)]), ivs, &(xi[WS(is, 1)]));
		    Tk = VSUB(Ti, Tj);
		    TJ = VADD(Ti, Tj);
		    Tl = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
		    Tm = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
		    Tn = VSUB(Tl, Tm);
		    TK = VADD(Tl, Tm);
	       }
	       To = VADD(Tk, Tn);
	       TR = VSUB(TJ, TK);
	       Ts = VSUB(Tn, Tk);
	       TL = VADD(TJ, TK);
	  }
	  {
	       V T6, TG, T9, TH;
	       {
		    V T4, T5, T7, T8;
		    T4 = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
		    T5 = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
		    T6 = VSUB(T4, T5);
		    TG = VADD(T4, T5);
		    T7 = LD(&(xi[WS(is, 12)]), ivs, &(xi[0]));
		    T8 = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
		    T9 = VSUB(T7, T8);
		    TH = VADD(T7, T8);
	       }
	       Ta = VADD(T6, T9);
	       TQ = VSUB(TH, TG);
	       Tr = VSUB(T9, T6);
	       TI = VADD(TG, TH);
	  }
	  {
	       V Td, TM, Tg, TN;
	       {
		    V Tb, Tc, Te, Tf;
		    Tb = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
		    Tc = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
		    Td = VSUB(Tb, Tc);
		    TM = VADD(Tb, Tc);
		    Te = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
		    Tf = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
		    Tg = VSUB(Te, Tf);
		    TN = VADD(Te, Tf);
	       }
	       Th = VADD(Td, Tg);
	       TS = VSUB(TM, TN);
	       Tt = VSUB(Tg, Td);
	       TO = VADD(TM, TN);
	  }
	  Tp = VADD(T3, VADD(Ta, VADD(Th, To)));
	  ST(&(xo[14]), Tp, ovs, &(xo[2]));
	  T10 = VADD(TF, VADD(TI, VADD(TO, TL)));
	  ST(&(xo[0]), T10, ovs, &(xo[0]));
	  {
	       V Tv, Tw, Tu, Tq;
	       Tu = VBYI(VFNMS(LDK(KP781831482), Ts, VFNMS(LDK(KP433883739), Tt, VMUL(LDK(KP974927912), Tr))));
	       Tq = VFMA(LDK(KP623489801), To, VFNMS(LDK(KP900968867), Th, VFNMS(LDK(KP222520933), Ta, T3)));
	       Tv = VSUB(Tq, Tu);
	       Tw = VADD(Tq, Tu);
	       ST(&(xo[10]), Tv, ovs, &(xo[2]));
	       ST(&(xo[18]), Tw, ovs, &(xo[2]));
	  }
	  {
	       V T13, T14, T11, T12;
	       T11 = VBYI(VFMA(LDK(KP974927912), TQ, VFMA(LDK(KP433883739), TS, VMUL(LDK(KP781831482), TR))));
	       T12 = VFMA(LDK(KP623489801), TL, VFNMS(LDK(KP900968867), TO, VFNMS(LDK(KP222520933), TI, TF)));
	       T13 = VADD(T11, T12);
	       T14 = VSUB(T12, T11);
	       ST(&(xo[4]), T13, ovs, &(xo[0]));
	       ST(&(xo[24]), T14, ovs, &(xo[0]));
	  }
	  {
	       V Tz, TA, Ty, Tx;
	       Ty = VBYI(VFMA(LDK(KP781831482), Tr, VFMA(LDK(KP974927912), Tt, VMUL(LDK(KP433883739), Ts))));
	       Tx = VFMA(LDK(KP623489801), Ta, VFNMS(LDK(KP900968867), To, VFNMS(LDK(KP222520933), Th, T3)));
	       Tz = VSUB(Tx, Ty);
	       TA = VADD(Tx, Ty);
	       ST(&(xo[26]), Tz, ovs, &(xo[2]));
	       ST(&(xo[2]), TA, ovs, &(xo[2]));
	  }
	  {
	       V TU, TV, TT, TP;
	       TT = VBYI(VFNMS(LDK(KP433883739), TR, VFNMS(LDK(KP974927912), TS, VMUL(LDK(KP781831482), TQ))));
	       TP = VFMA(LDK(KP623489801), TI, VFNMS(LDK(KP900968867), TL, VFNMS(LDK(KP222520933), TO, TF)));
	       TU = VSUB(TP, TT);
	       TV = VADD(TT, TP);
	       ST(&(xo[12]), TU, ovs, &(xo[0]));
	       ST(&(xo[16]), TV, ovs, &(xo[0]));
	  }
	  {
	       V TY, TZ, TX, TW;
	       TX = VBYI(VFMA(LDK(KP433883739), TQ, VFNMS(LDK(KP974927912), TR, VMUL(LDK(KP781831482), TS))));
	       TW = VFMA(LDK(KP623489801), TO, VFNMS(LDK(KP222520933), TL, VFNMS(LDK(KP900968867), TI, TF)));
	       TY = VSUB(TW, TX);
	       TZ = VADD(TX, TW);
	       ST(&(xo[8]), TY, ovs, &(xo[0]));
	       ST(&(xo[20]), TZ, ovs, &(xo[0]));
	  }
	  {
	       V TD, TE, TC, TB;
	       TC = VBYI(VFMA(LDK(KP433883739), Tr, VFNMS(LDK(KP781831482), Tt, VMUL(LDK(KP974927912), Ts))));
	       TB = VFMA(LDK(KP623489801), Th, VFNMS(LDK(KP222520933), To, VFNMS(LDK(KP900968867), Ta, T3)));
	       TD = VSUB(TB, TC);
	       TE = VADD(TB, TC);
	       ST(&(xo[22]), TD, ovs, &(xo[2]));
	       ST(&(xo[6]), TE, ovs, &(xo[2]));
	  }
     }
     END_SIMD();
}

static const kdft_desc desc = { 14, "n2fv_14", {50, 12, 24, 0}, &GENUS, 0, 2, 0, 0 };
void X(codelet_n2fv_14) (planner *p) {
     X(kdft_register) (p, n2fv_14, &desc);
}
