/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:02:15 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_c -simd -trivial-stores -compact -variables 4 -n 15 -name n2fv_15 -with-ostride 2 -include n2f.h */

/*
 * This function contains 78 FP additions, 25 FP multiplications,
 * (or, 64 additions, 11 multiplications, 14 fused multiply/add),
 * 57 stack variables, and 30 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_c.ml,v 1.9 2003/04/16 21:21:53 athena Exp $
 */

#include "n2f.h"

static void n2fv_15(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     DVK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DVK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DVK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DVK(KP509036960, +0.509036960455127183450980863393907648510733164);
     DVK(KP823639103, +0.823639103546331925877420039278190003029660514);
     DVK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DVK(KP216506350, +0.216506350946109661690930792688234045867850657);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DVK(KP484122918, +0.484122918275927110647408174972799951354115213);
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     int i;
     const R *xi;
     R *xo;
     xi = ri;
     xo = ro;
     BEGIN_SIMD();
     for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs)) {
	  V T15, T5, Tx, T14, Tw, T10, TZ, TG, T16, T17, Tg, Tr, Ts, TN, TP;
	  V TX, T1h, TF;
	  {
	       V T1, T4, TU, TV, Ta, T12, Tf, TH, TI, TR, TS, Tl, T13, Tq, TK;
	       V TL, T2, T3;
	       T1 = LD(&(xi[0]), ivs, &(xi[0]));
	       T2 = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
	       T3 = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
	       T4 = VADD(T2, T3);
	       T15 = VSUB(T3, T2);
	       {
		    V T6, Tb, T9, Te;
		    T6 = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
		    Tb = LD(&(xi[WS(is, 12)]), ivs, &(xi[0]));
		    {
			 V T7, T8, Tc, Td;
			 T7 = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
			 T8 = LD(&(xi[WS(is, 13)]), ivs, &(xi[WS(is, 1)]));
			 T9 = VADD(T7, T8);
			 TU = VSUB(T8, T7);
			 Tc = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
			 Td = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
			 Te = VADD(Tc, Td);
			 TV = VSUB(Td, Tc);
		    }
		    Ta = VADD(T6, T9);
		    T12 = VADD(TU, TV);
		    Tf = VADD(Tb, Te);
		    TH = VFNMS(LDK(KP500000000), T9, T6);
		    TI = VFNMS(LDK(KP500000000), Te, Tb);
	       }
	       {
		    V Th, Tm, Tk, Tp;
		    Th = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
		    Tm = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
		    {
			 V Ti, Tj, Tn, To;
			 Ti = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
			 Tj = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
			 Tk = VADD(Ti, Tj);
			 TR = VSUB(Tj, Ti);
			 Tn = LD(&(xi[WS(is, 14)]), ivs, &(xi[0]));
			 To = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
			 Tp = VADD(Tn, To);
			 TS = VSUB(To, Tn);
		    }
		    Tl = VADD(Th, Tk);
		    T13 = VADD(TR, TS);
		    Tq = VADD(Tm, Tp);
		    TK = VFNMS(LDK(KP500000000), Tk, Th);
		    TL = VFNMS(LDK(KP500000000), Tp, Tm);
	       }
	       T5 = VADD(T1, T4);
	       Tx = VSUB(Ta, Tf);
	       T14 = VMUL(LDK(KP484122918), VSUB(T12, T13));
	       Tw = VSUB(Tl, Tq);
	       T10 = VSUB(TH, TI);
	       TZ = VSUB(TK, TL);
	       TG = VFNMS(LDK(KP500000000), T4, T1);
	       T16 = VADD(T12, T13);
	       T17 = VFNMS(LDK(KP216506350), T16, VMUL(LDK(KP866025403), T15));
	       Tg = VADD(Ta, Tf);
	       Tr = VADD(Tl, Tq);
	       Ts = VADD(Tg, Tr);
	       {
		    V TJ, TM, TT, TW;
		    TJ = VADD(TH, TI);
		    TM = VADD(TK, TL);
		    TN = VADD(TJ, TM);
		    TP = VMUL(LDK(KP559016994), VSUB(TJ, TM));
		    TT = VSUB(TR, TS);
		    TW = VSUB(TU, TV);
		    TX = VFNMS(LDK(KP509036960), TW, VMUL(LDK(KP823639103), TT));
		    T1h = VFMA(LDK(KP823639103), TW, VMUL(LDK(KP509036960), TT));
	       }
	  }
	  TF = VADD(T5, Ts);
	  ST(&(xo[0]), TF, ovs, &(xo[0]));
	  {
	       V T1u, T1v, T1s, T1t;
	       T1s = VADD(TG, TN);
	       T1t = VBYI(VMUL(LDK(KP866025403), VADD(T15, T16)));
	       T1u = VSUB(T1s, T1t);
	       T1v = VADD(T1s, T1t);
	       ST(&(xo[10]), T1u, ovs, &(xo[2]));
	       ST(&(xo[20]), T1v, ovs, &(xo[0]));
	  }
	  {
	       V Ty, TC, Tv, TB, Tt, Tu;
	       Ty = VBYI(VFNMS(LDK(KP587785252), Tx, VMUL(LDK(KP951056516), Tw)));
	       TC = VBYI(VFMA(LDK(KP951056516), Tx, VMUL(LDK(KP587785252), Tw)));
	       Tt = VFNMS(LDK(KP250000000), Ts, T5);
	       Tu = VMUL(LDK(KP559016994), VSUB(Tg, Tr));
	       Tv = VSUB(Tt, Tu);
	       TB = VADD(Tu, Tt);
	       {
		    V Tz, TE, TA, TD;
		    Tz = VSUB(Tv, Ty);
		    ST(&(xo[6]), Tz, ovs, &(xo[2]));
		    TE = VADD(TC, TB);
		    ST(&(xo[18]), TE, ovs, &(xo[2]));
		    TA = VADD(Ty, Tv);
		    ST(&(xo[24]), TA, ovs, &(xo[0]));
		    TD = VSUB(TB, TC);
		    ST(&(xo[12]), TD, ovs, &(xo[0]));
	       }
	  }
	  {
	       V T19, T1d, T1l, T1p, TY, T1o, T1c, T1i, T11, T18;
	       T11 = VFNMS(LDK(KP587785252), T10, VMUL(LDK(KP951056516), TZ));
	       T18 = VSUB(T14, T17);
	       T19 = VBYI(VSUB(T11, T18));
	       T1d = VBYI(VADD(T11, T18));
	       {
		    V T1j, T1k, TQ, T1g, TO;
		    T1j = VADD(T14, T17);
		    T1k = VFMA(LDK(KP951056516), T10, VMUL(LDK(KP587785252), TZ));
		    T1l = VBYI(VSUB(T1j, T1k));
		    T1p = VBYI(VADD(T1k, T1j));
		    TO = VFNMS(LDK(KP250000000), TN, TG);
		    TQ = VSUB(TO, TP);
		    T1g = VADD(TP, TO);
		    TY = VSUB(TQ, TX);
		    T1o = VSUB(T1g, T1h);
		    T1c = VADD(TQ, TX);
		    T1i = VADD(T1g, T1h);
	       }
	       {
		    V T1a, T1q, T1r, T1b;
		    T1a = VSUB(TY, T19);
		    ST(&(xo[16]), T1a, ovs, &(xo[0]));
		    T1q = VSUB(T1o, T1p);
		    ST(&(xo[22]), T1q, ovs, &(xo[2]));
		    T1r = VADD(T1o, T1p);
		    ST(&(xo[8]), T1r, ovs, &(xo[0]));
		    T1b = VADD(TY, T19);
		    ST(&(xo[14]), T1b, ovs, &(xo[2]));
	       }
	       {
		    V T1e, T1m, T1n, T1f;
		    T1e = VSUB(T1c, T1d);
		    ST(&(xo[26]), T1e, ovs, &(xo[2]));
		    T1m = VSUB(T1i, T1l);
		    ST(&(xo[28]), T1m, ovs, &(xo[0]));
		    T1n = VADD(T1i, T1l);
		    ST(&(xo[2]), T1n, ovs, &(xo[2]));
		    T1f = VADD(T1c, T1d);
		    ST(&(xo[4]), T1f, ovs, &(xo[0]));
	       }
	  }
     }
     END_SIMD();
}

static const kdft_desc desc = { 15, "n2fv_15", {64, 11, 14, 0}, &GENUS, 0, 2, 0, 0 };
void X(codelet_n2fv_15) (planner *p) {
     X(kdft_register) (p, n2fv_15, &desc);
}
