/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:02:05 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_c -simd -trivial-stores -compact -variables 4 -n 6 -name n2fv_6 -with-ostride 2 -include n2f.h */

/*
 * This function contains 18 FP additions, 4 FP multiplications,
 * (or, 16 additions, 2 multiplications, 2 fused multiply/add),
 * 23 stack variables, and 12 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_c.ml,v 1.9 2003/04/16 21:21:53 athena Exp $
 */

#include "n2f.h"

static void n2fv_6(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     int i;
     const R *xi;
     R *xo;
     xi = ri;
     xo = ro;
     BEGIN_SIMD();
     for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs)) {
	  V T3, Tg, Ta, Tm, Td, Tj, T1, T2, Tb, Tk;
	  T1 = LD(&(xi[0]), ivs, &(xi[0]));
	  T2 = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
	  T3 = VSUB(T1, T2);
	  Tg = VADD(T1, T2);
	  {
	       V T6, Th, T9, Ti;
	       {
		    V T4, T5, T7, T8;
		    T4 = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
		    T5 = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
		    T6 = VSUB(T4, T5);
		    Th = VADD(T4, T5);
		    T7 = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
		    T8 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
		    T9 = VSUB(T7, T8);
		    Ti = VADD(T7, T8);
	       }
	       Ta = VADD(T6, T9);
	       Tm = VBYI(VMUL(LDK(KP866025403), VSUB(Ti, Th)));
	       Td = VBYI(VMUL(LDK(KP866025403), VSUB(T9, T6)));
	       Tj = VADD(Th, Ti);
	  }
	  Tb = VADD(T3, Ta);
	  ST(&(xo[6]), Tb, ovs, &(xo[2]));
	  Tk = VADD(Tg, Tj);
	  ST(&(xo[0]), Tk, ovs, &(xo[0]));
	  {
	       V Te, Tf, Tc, Tn, To, Tl;
	       Tc = VFNMS(LDK(KP500000000), Ta, T3);
	       Te = VSUB(Tc, Td);
	       Tf = VADD(Tc, Td);
	       ST(&(xo[10]), Te, ovs, &(xo[2]));
	       ST(&(xo[2]), Tf, ovs, &(xo[2]));
	       Tl = VFNMS(LDK(KP500000000), Tj, Tg);
	       Tn = VSUB(Tl, Tm);
	       To = VADD(Tl, Tm);
	       ST(&(xo[4]), Tn, ovs, &(xo[0]));
	       ST(&(xo[8]), To, ovs, &(xo[0]));
	  }
     }
     END_SIMD();
}

static const kdft_desc desc = { 6, "n2fv_6", {16, 2, 2, 0}, &GENUS, 0, 2, 0, 0 };
void X(codelet_n2fv_6) (planner *p) {
     X(kdft_register) (p, n2fv_6, &desc);
}
