/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:02:08 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_c -simd -trivial-stores -compact -variables 4 -n 9 -name n2fv_9 -with-ostride 2 -include n2f.h */

/*
 * This function contains 46 FP additions, 26 FP multiplications,
 * (or, 30 additions, 10 multiplications, 16 fused multiply/add),
 * 42 stack variables, and 18 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_c.ml,v 1.9 2003/04/16 21:21:53 athena Exp $
 */

#include "n2f.h"

static void n2fv_9(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     DVK(KP342020143, +0.342020143325668733044099614682259580763083368);
     DVK(KP813797681, +0.813797681349373692844693217248393223289101568);
     DVK(KP939692620, +0.939692620785908384054109277324731469936208134);
     DVK(KP296198132, +0.296198132726023843175338011893050938967728390);
     DVK(KP984807753, +0.984807753012208059366743024589523013670643252);
     DVK(KP150383733, +0.150383733180435296639271897612501926072238258);
     DVK(KP852868531, +0.852868531952443209628250963940074071936020296);
     DVK(KP173648177, +0.173648177666930348851716626769314796000375677);
     DVK(KP642787609, +0.642787609686539326322643409907263432907559884);
     DVK(KP663413948, +0.663413948168938396205421319635891297216863310);
     DVK(KP556670399, +0.556670399226419366452912952047023132968291906);
     DVK(KP766044443, +0.766044443118978035202392650555416673935832457);
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     int i;
     const R *xi;
     R *xo;
     xi = ri;
     xo = ro;
     BEGIN_SIMD();
     for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs)) {
	  V T5, Tv, Tm, To, Tr, Tn, Tp, Tw, Tq, Ts, Tx, Ta, Tf, Tg, Th;
	  {
	       V T1, T2, T3, T4;
	       T1 = LD(&(xi[0]), ivs, &(xi[0]));
	       T2 = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
	       T3 = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
	       T4 = VADD(T2, T3);
	       T5 = VADD(T1, T4);
	       Tv = VMUL(LDK(KP866025403), VSUB(T3, T2));
	       Tm = VFNMS(LDK(KP500000000), T4, T1);
	  }
	  {
	       V T6, Tb, T9, Te;
	       T6 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
	       Tb = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
	       {
		    V T7, T8, Tc, Td;
		    T7 = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
		    T8 = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
		    T9 = VADD(T7, T8);
		    To = VSUB(T8, T7);
		    Tc = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
		    Td = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
		    Te = VADD(Tc, Td);
		    Tr = VSUB(Td, Tc);
	       }
	       Tn = VFNMS(LDK(KP500000000), T9, T6);
	       Tp = VFMA(LDK(KP766044443), Tn, VMUL(LDK(KP556670399), To));
	       Tw = VFNMS(LDK(KP642787609), Tn, VMUL(LDK(KP663413948), To));
	       Tq = VFNMS(LDK(KP500000000), Te, Tb);
	       Ts = VFMA(LDK(KP173648177), Tq, VMUL(LDK(KP852868531), Tr));
	       Tx = VFNMS(LDK(KP984807753), Tq, VMUL(LDK(KP150383733), Tr));
	       Ta = VADD(T6, T9);
	       Tf = VADD(Tb, Te);
	       Tg = VADD(Ta, Tf);
	  }
	  Th = VADD(T5, Tg);
	  ST(&(xo[0]), Th, ovs, &(xo[0]));
	  {
	       V Tk, Tl, Ti, Tj;
	       Ti = VFNMS(LDK(KP500000000), Tg, T5);
	       Tj = VBYI(VMUL(LDK(KP866025403), VSUB(Tf, Ta)));
	       Tk = VSUB(Ti, Tj);
	       Tl = VADD(Ti, Tj);
	       ST(&(xo[12]), Tk, ovs, &(xo[0]));
	       ST(&(xo[6]), Tl, ovs, &(xo[2]));
	  }
	  {
	       V TI, TJ, TG, TH;
	       TG = VFMA(LDK(KP173648177), Tn, VFNMS(LDK(KP296198132), Tr, VFNMS(LDK(KP939692620), Tq, VFNMS(LDK(KP852868531), To, Tm))));
	       TH = VBYI(VSUB(VFNMS(LDK(KP342020143), Tq, VFNMS(LDK(KP150383733), To, VFNMS(LDK(KP984807753), Tn, VMUL(LDK(KP813797681), Tr)))), Tv));
	       TI = VSUB(TG, TH);
	       TJ = VADD(TG, TH);
	       ST(&(xo[14]), TI, ovs, &(xo[2]));
	       ST(&(xo[4]), TJ, ovs, &(xo[0]));
	  }
	  {
	       V Tu, TC, Tz, TD, Tt, Ty;
	       Tt = VADD(Tp, Ts);
	       Tu = VADD(Tm, Tt);
	       TC = VFMA(LDK(KP866025403), VSUB(Tw, Tx), VFNMS(LDK(KP500000000), Tt, Tm));
	       Ty = VADD(Tw, Tx);
	       Tz = VBYI(VADD(Tv, Ty));
	       TD = VBYI(VADD(Tv, VFNMS(LDK(KP500000000), Ty, VMUL(LDK(KP866025403), VSUB(Ts, Tp)))));
	       {
		    V TA, TF, TB, TE;
		    TA = VSUB(Tu, Tz);
		    ST(&(xo[16]), TA, ovs, &(xo[0]));
		    TF = VADD(TC, TD);
		    ST(&(xo[8]), TF, ovs, &(xo[0]));
		    TB = VADD(Tz, Tu);
		    ST(&(xo[2]), TB, ovs, &(xo[2]));
		    TE = VSUB(TC, TD);
		    ST(&(xo[10]), TE, ovs, &(xo[2]));
	       }
	  }
     }
     END_SIMD();
}

static const kdft_desc desc = { 9, "n2fv_9", {30, 10, 16, 0}, &GENUS, 0, 2, 0, 0 };
void X(codelet_n2fv_9) (planner *p) {
     X(kdft_register) (p, n2fv_9, &desc);
}
