/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:06:07 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twidsq_c -simd -trivial-stores -compact -variables 4 -n 4 -dif -name q1fv_4 -include q1f.h */

/*
 * This function contains 44 FP additions, 24 FP multiplications,
 * (or, 44 additions, 24 multiplications, 0 fused multiply/add),
 * 22 stack variables, and 32 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twidsq_c.ml,v 1.1 2003/03/26 12:45:03 athena Exp $
 */

#include "q1f.h"

static const R *q1fv_4(R *ri, R *ii, const R *W, stride is, stride vs, int m, int dist)
{
     int i;
     R *x;
     x = ri;
     BEGIN_SIMD();
     for (i = 0; i < m; i = i + VL, x = x + (VL * dist), W = W + (TWVL * 6)) {
	  V T3, T9, TD, TJ, TG, TK, T6, Ta, Tf, Tl, Tr, Tx, Tu, Ty, Ti;
	  V Tm;
	  {
	       V T1, T2, TB, TC;
	       T1 = LD(&(x[0]), dist, &(x[0]));
	       T2 = LD(&(x[WS(is, 2)]), dist, &(x[0]));
	       T3 = VSUB(T1, T2);
	       T9 = VADD(T1, T2);
	       TB = LD(&(x[WS(vs, 3)]), dist, &(x[WS(vs, 3)]));
	       TC = LD(&(x[WS(vs, 3) + WS(is, 2)]), dist, &(x[WS(vs, 3)]));
	       TD = VSUB(TB, TC);
	       TJ = VADD(TB, TC);
	  }
	  {
	       V TE, TF, T4, T5;
	       TE = LD(&(x[WS(vs, 3) + WS(is, 1)]), dist, &(x[WS(vs, 3) + WS(is, 1)]));
	       TF = LD(&(x[WS(vs, 3) + WS(is, 3)]), dist, &(x[WS(vs, 3) + WS(is, 1)]));
	       TG = VBYI(VSUB(TE, TF));
	       TK = VADD(TE, TF);
	       T4 = LD(&(x[WS(is, 1)]), dist, &(x[WS(is, 1)]));
	       T5 = LD(&(x[WS(is, 3)]), dist, &(x[WS(is, 1)]));
	       T6 = VBYI(VSUB(T4, T5));
	       Ta = VADD(T4, T5);
	  }
	  {
	       V Td, Te, Tp, Tq;
	       Td = LD(&(x[WS(vs, 1)]), dist, &(x[WS(vs, 1)]));
	       Te = LD(&(x[WS(vs, 1) + WS(is, 2)]), dist, &(x[WS(vs, 1)]));
	       Tf = VSUB(Td, Te);
	       Tl = VADD(Td, Te);
	       Tp = LD(&(x[WS(vs, 2)]), dist, &(x[WS(vs, 2)]));
	       Tq = LD(&(x[WS(vs, 2) + WS(is, 2)]), dist, &(x[WS(vs, 2)]));
	       Tr = VSUB(Tp, Tq);
	       Tx = VADD(Tp, Tq);
	  }
	  {
	       V Ts, Tt, Tg, Th;
	       Ts = LD(&(x[WS(vs, 2) + WS(is, 1)]), dist, &(x[WS(vs, 2) + WS(is, 1)]));
	       Tt = LD(&(x[WS(vs, 2) + WS(is, 3)]), dist, &(x[WS(vs, 2) + WS(is, 1)]));
	       Tu = VBYI(VSUB(Ts, Tt));
	       Ty = VADD(Ts, Tt);
	       Tg = LD(&(x[WS(vs, 1) + WS(is, 1)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
	       Th = LD(&(x[WS(vs, 1) + WS(is, 3)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
	       Ti = VBYI(VSUB(Tg, Th));
	       Tm = VADD(Tg, Th);
	  }
	  {
	       V Tc, To, TA, TM;
	       Tc = VADD(T9, Ta);
	       ST(&(x[0]), Tc, dist, &(x[0]));
	       To = VADD(Tl, Tm);
	       ST(&(x[WS(is, 1)]), To, dist, &(x[WS(is, 1)]));
	       TA = VADD(Tx, Ty);
	       ST(&(x[WS(is, 2)]), TA, dist, &(x[0]));
	       TM = VADD(TJ, TK);
	       ST(&(x[WS(is, 3)]), TM, dist, &(x[WS(is, 1)]));
	  }
	  {
	       V T7, Tj, Tv, TH;
	       T7 = BYTWJ(&(W[0]), VSUB(T3, T6));
	       ST(&(x[WS(vs, 1)]), T7, dist, &(x[WS(vs, 1)]));
	       Tj = BYTWJ(&(W[0]), VSUB(Tf, Ti));
	       ST(&(x[WS(vs, 1) + WS(is, 1)]), Tj, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	       Tv = BYTWJ(&(W[0]), VSUB(Tr, Tu));
	       ST(&(x[WS(vs, 1) + WS(is, 2)]), Tv, dist, &(x[WS(vs, 1)]));
	       TH = BYTWJ(&(W[0]), VSUB(TD, TG));
	       ST(&(x[WS(vs, 1) + WS(is, 3)]), TH, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	  }
	  {
	       V T8, Tk, Tw, TI;
	       T8 = BYTWJ(&(W[TWVL * 4]), VADD(T3, T6));
	       ST(&(x[WS(vs, 3)]), T8, dist, &(x[WS(vs, 3)]));
	       Tk = BYTWJ(&(W[TWVL * 4]), VADD(Tf, Ti));
	       ST(&(x[WS(vs, 3) + WS(is, 1)]), Tk, dist, &(x[WS(vs, 3) + WS(is, 1)]));
	       Tw = BYTWJ(&(W[TWVL * 4]), VADD(Tr, Tu));
	       ST(&(x[WS(vs, 3) + WS(is, 2)]), Tw, dist, &(x[WS(vs, 3)]));
	       TI = BYTWJ(&(W[TWVL * 4]), VADD(TD, TG));
	       ST(&(x[WS(vs, 3) + WS(is, 3)]), TI, dist, &(x[WS(vs, 3) + WS(is, 1)]));
	  }
	  {
	       V Tb, Tn, Tz, TL;
	       Tb = BYTWJ(&(W[TWVL * 2]), VSUB(T9, Ta));
	       ST(&(x[WS(vs, 2)]), Tb, dist, &(x[WS(vs, 2)]));
	       Tn = BYTWJ(&(W[TWVL * 2]), VSUB(Tl, Tm));
	       ST(&(x[WS(vs, 2) + WS(is, 1)]), Tn, dist, &(x[WS(vs, 2) + WS(is, 1)]));
	       Tz = BYTWJ(&(W[TWVL * 2]), VSUB(Tx, Ty));
	       ST(&(x[WS(vs, 2) + WS(is, 2)]), Tz, dist, &(x[WS(vs, 2)]));
	       TL = BYTWJ(&(W[TWVL * 2]), VSUB(TJ, TK));
	       ST(&(x[WS(vs, 2) + WS(is, 3)]), TL, dist, &(x[WS(vs, 2) + WS(is, 1)]));
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 4, "q1fv_4", twinstr, {44, 24, 0, 0}, &GENUS, 0, 0, 0 };

void X(codelet_q1fv_4) (planner *p) {
     X(kdft_difsq_register) (p, q1fv_4, &desc);
}
