/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:05:27 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 10 -name t1bv_10 -include t1b.h -sign 1 */

/*
 * This function contains 51 FP additions, 30 FP multiplications,
 * (or, 45 additions, 24 multiplications, 6 fused multiply/add),
 * 35 stack variables, and 20 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1b.h"

static const R *t1bv_10(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DVK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DVK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DVK(KP951056516, +0.951056516295153572116439333379382143405698634);
     int i;
     R *x;
     x = ii;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 18)) {
	  V Tu, TM, Tb, Tm, TK, TH, TN, TO, TP, To, Tp, Tv, Tr, Tt, Ts;
	  V TE, TZ;
	  Tr = LD(&(x[0]), dist, &(x[0]));
	  Ts = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
	  Tt = BYTW(&(W[TWVL * 8]), Ts);
	  Tu = VSUB(Tr, Tt);
	  TM = VADD(Tr, Tt);
	  {
	       V T5, TF, Tl, TJ, Ta, TG, Tg, TI;
	       {
		    V T2, T4, T1, T3;
		    T1 = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
		    T2 = BYTW(&(W[TWVL * 2]), T1);
		    T3 = LD(&(x[WS(ios, 7)]), dist, &(x[WS(ios, 1)]));
		    T4 = BYTW(&(W[TWVL * 12]), T3);
		    T5 = VSUB(T2, T4);
		    TF = VADD(T2, T4);
	       }
	       {
		    V Ti, Tk, Th, Tj;
		    Th = LD(&(x[WS(ios, 6)]), dist, &(x[0]));
		    Ti = BYTW(&(W[TWVL * 10]), Th);
		    Tj = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
		    Tk = BYTW(&(W[0]), Tj);
		    Tl = VSUB(Ti, Tk);
		    TJ = VADD(Ti, Tk);
	       }
	       {
		    V T7, T9, T6, T8;
		    T6 = LD(&(x[WS(ios, 8)]), dist, &(x[0]));
		    T7 = BYTW(&(W[TWVL * 14]), T6);
		    T8 = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
		    T9 = BYTW(&(W[TWVL * 4]), T8);
		    Ta = VSUB(T7, T9);
		    TG = VADD(T7, T9);
	       }
	       {
		    V Td, Tf, Tc, Te;
		    Tc = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
		    Td = BYTW(&(W[TWVL * 6]), Tc);
		    Te = LD(&(x[WS(ios, 9)]), dist, &(x[WS(ios, 1)]));
		    Tf = BYTW(&(W[TWVL * 16]), Te);
		    Tg = VSUB(Td, Tf);
		    TI = VADD(Td, Tf);
	       }
	       Tb = VSUB(T5, Ta);
	       Tm = VSUB(Tg, Tl);
	       TK = VSUB(TI, TJ);
	       TH = VSUB(TF, TG);
	       TN = VADD(TF, TG);
	       TO = VADD(TI, TJ);
	       TP = VADD(TN, TO);
	       To = VADD(T5, Ta);
	       Tp = VADD(Tg, Tl);
	       Tv = VADD(To, Tp);
	  }
	  TE = VADD(Tu, Tv);
	  ST(&(x[WS(ios, 5)]), TE, dist, &(x[WS(ios, 1)]));
	  TZ = VADD(TM, TP);
	  ST(&(x[0]), TZ, dist, &(x[0]));
	  {
	       V Tn, TB, Tx, TA, Tq, Tw;
	       Tn = VBYI(VFMA(LDK(KP951056516), Tb, VMUL(LDK(KP587785252), Tm)));
	       TB = VBYI(VFNMS(LDK(KP951056516), Tm, VMUL(LDK(KP587785252), Tb)));
	       Tq = VMUL(LDK(KP559016994), VSUB(To, Tp));
	       Tw = VFNMS(LDK(KP250000000), Tv, Tu);
	       Tx = VADD(Tq, Tw);
	       TA = VSUB(Tw, Tq);
	       {
		    V Ty, TD, Tz, TC;
		    Ty = VADD(Tn, Tx);
		    ST(&(x[WS(ios, 1)]), Ty, dist, &(x[WS(ios, 1)]));
		    TD = VADD(TB, TA);
		    ST(&(x[WS(ios, 7)]), TD, dist, &(x[WS(ios, 1)]));
		    Tz = VSUB(Tx, Tn);
		    ST(&(x[WS(ios, 9)]), Tz, dist, &(x[WS(ios, 1)]));
		    TC = VSUB(TA, TB);
		    ST(&(x[WS(ios, 3)]), TC, dist, &(x[WS(ios, 1)]));
	       }
	  }
	  {
	       V TL, TW, TS, TV, TQ, TR;
	       TL = VBYI(VFNMS(LDK(KP951056516), TK, VMUL(LDK(KP587785252), TH)));
	       TW = VBYI(VFMA(LDK(KP951056516), TH, VMUL(LDK(KP587785252), TK)));
	       TQ = VFNMS(LDK(KP250000000), TP, TM);
	       TR = VMUL(LDK(KP559016994), VSUB(TN, TO));
	       TS = VSUB(TQ, TR);
	       TV = VADD(TR, TQ);
	       {
		    V TT, TY, TU, TX;
		    TT = VADD(TL, TS);
		    ST(&(x[WS(ios, 2)]), TT, dist, &(x[0]));
		    TY = VADD(TW, TV);
		    ST(&(x[WS(ios, 6)]), TY, dist, &(x[0]));
		    TU = VSUB(TS, TL);
		    ST(&(x[WS(ios, 8)]), TU, dist, &(x[0]));
		    TX = VSUB(TV, TW);
		    ST(&(x[WS(ios, 4)]), TX, dist, &(x[0]));
	       }
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     VTW(8),
     VTW(9),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 10, "t1bv_10", twinstr, {45, 24, 6, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1bv_10) (planner *p) {
     X(kdft_dit_register) (p, t1bv_10, &desc);
}
