/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:05:42 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 32 -name t1bv_32 -include t1b.h -sign 1 */

/*
 * This function contains 217 FP additions, 104 FP multiplications,
 * (or, 201 additions, 88 multiplications, 16 fused multiply/add),
 * 60 stack variables, and 64 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1b.h"

static const R *t1bv_32(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     int i;
     R *x;
     x = ii;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 62)) {
	  V Tg, T22, T35, T3F, T1E, T2e, T30, T3G, T3x, T3y, T3z, T2P, T39, T1k, T28;
	  V T1r, T29, T3u, T3v, T3w, T2I, T38, TV, T25, T12, T26, T3B, T3C, TD, T2d;
	  V T1x, T23, T2X, T36;
	  {
	       V T1, T3, T1C, T1A, Tb, Td, Te, T6, T8, T9, T2, T1B, T1z;
	       T1 = LD(&(x[0]), dist, &(x[0]));
	       T2 = LD(&(x[WS(ios, 16)]), dist, &(x[0]));
	       T3 = BYTW(&(W[TWVL * 30]), T2);
	       T1B = LD(&(x[WS(ios, 24)]), dist, &(x[0]));
	       T1C = BYTW(&(W[TWVL * 46]), T1B);
	       T1z = LD(&(x[WS(ios, 8)]), dist, &(x[0]));
	       T1A = BYTW(&(W[TWVL * 14]), T1z);
	       {
		    V Ta, Tc, T5, T7;
		    Ta = LD(&(x[WS(ios, 28)]), dist, &(x[0]));
		    Tb = BYTW(&(W[TWVL * 54]), Ta);
		    Tc = LD(&(x[WS(ios, 12)]), dist, &(x[0]));
		    Td = BYTW(&(W[TWVL * 22]), Tc);
		    Te = VSUB(Tb, Td);
		    T5 = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
		    T6 = BYTW(&(W[TWVL * 6]), T5);
		    T7 = LD(&(x[WS(ios, 20)]), dist, &(x[0]));
		    T8 = BYTW(&(W[TWVL * 38]), T7);
		    T9 = VSUB(T6, T8);
	       }
	       {
		    V T4, Tf, T33, T34;
		    T4 = VSUB(T1, T3);
		    Tf = VMUL(LDK(KP707106781), VADD(T9, Te));
		    Tg = VSUB(T4, Tf);
		    T22 = VADD(T4, Tf);
		    T33 = VADD(T1, T3);
		    T34 = VADD(T1A, T1C);
		    T35 = VSUB(T33, T34);
		    T3F = VADD(T33, T34);
	       }
	       {
		    V T1y, T1D, T2Y, T2Z;
		    T1y = VMUL(LDK(KP707106781), VSUB(T9, Te));
		    T1D = VSUB(T1A, T1C);
		    T1E = VSUB(T1y, T1D);
		    T2e = VADD(T1D, T1y);
		    T2Y = VADD(T6, T8);
		    T2Z = VADD(Tb, Td);
		    T30 = VSUB(T2Y, T2Z);
		    T3G = VADD(T2Y, T2Z);
	       }
	  }
	  {
	       V T1g, T1i, T2K, T1m, T1o, T2J, T18, T2M, T1d, T2N, T2L, T2O;
	       {
		    V T1f, T1h, T1l, T1n;
		    T1f = LD(&(x[WS(ios, 7)]), dist, &(x[WS(ios, 1)]));
		    T1g = BYTW(&(W[TWVL * 12]), T1f);
		    T1h = LD(&(x[WS(ios, 23)]), dist, &(x[WS(ios, 1)]));
		    T1i = BYTW(&(W[TWVL * 44]), T1h);
		    T2K = VADD(T1g, T1i);
		    T1l = LD(&(x[WS(ios, 31)]), dist, &(x[WS(ios, 1)]));
		    T1m = BYTW(&(W[TWVL * 60]), T1l);
		    T1n = LD(&(x[WS(ios, 15)]), dist, &(x[WS(ios, 1)]));
		    T1o = BYTW(&(W[TWVL * 28]), T1n);
		    T2J = VADD(T1m, T1o);
	       }
	       {
		    V T15, T17, T14, T16;
		    T14 = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
		    T15 = BYTW(&(W[TWVL * 4]), T14);
		    T16 = LD(&(x[WS(ios, 19)]), dist, &(x[WS(ios, 1)]));
		    T17 = BYTW(&(W[TWVL * 36]), T16);
		    T18 = VSUB(T15, T17);
		    T2M = VADD(T15, T17);
	       }
	       {
		    V T1a, T1c, T19, T1b;
		    T19 = LD(&(x[WS(ios, 27)]), dist, &(x[WS(ios, 1)]));
		    T1a = BYTW(&(W[TWVL * 52]), T19);
		    T1b = LD(&(x[WS(ios, 11)]), dist, &(x[WS(ios, 1)]));
		    T1c = BYTW(&(W[TWVL * 20]), T1b);
		    T1d = VSUB(T1a, T1c);
		    T2N = VADD(T1a, T1c);
	       }
	       T3x = VADD(T2J, T2K);
	       T3y = VADD(T2M, T2N);
	       T3z = VSUB(T3x, T3y);
	       T2L = VSUB(T2J, T2K);
	       T2O = VSUB(T2M, T2N);
	       T2P = VFMA(LDK(KP923879532), T2L, VMUL(LDK(KP382683432), T2O));
	       T39 = VFNMS(LDK(KP382683432), T2L, VMUL(LDK(KP923879532), T2O));
	       {
		    V T1e, T1j, T1p, T1q;
		    T1e = VMUL(LDK(KP707106781), VSUB(T18, T1d));
		    T1j = VSUB(T1g, T1i);
		    T1k = VSUB(T1e, T1j);
		    T28 = VADD(T1j, T1e);
		    T1p = VSUB(T1m, T1o);
		    T1q = VMUL(LDK(KP707106781), VADD(T18, T1d));
		    T1r = VSUB(T1p, T1q);
		    T29 = VADD(T1p, T1q);
	       }
	  }
	  {
	       V TR, TT, T2D, TX, TZ, T2C, TJ, T2F, TO, T2G, T2E, T2H;
	       {
		    V TQ, TS, TW, TY;
		    TQ = LD(&(x[WS(ios, 9)]), dist, &(x[WS(ios, 1)]));
		    TR = BYTW(&(W[TWVL * 16]), TQ);
		    TS = LD(&(x[WS(ios, 25)]), dist, &(x[WS(ios, 1)]));
		    TT = BYTW(&(W[TWVL * 48]), TS);
		    T2D = VADD(TR, TT);
		    TW = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
		    TX = BYTW(&(W[0]), TW);
		    TY = LD(&(x[WS(ios, 17)]), dist, &(x[WS(ios, 1)]));
		    TZ = BYTW(&(W[TWVL * 32]), TY);
		    T2C = VADD(TX, TZ);
	       }
	       {
		    V TG, TI, TF, TH;
		    TF = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
		    TG = BYTW(&(W[TWVL * 8]), TF);
		    TH = LD(&(x[WS(ios, 21)]), dist, &(x[WS(ios, 1)]));
		    TI = BYTW(&(W[TWVL * 40]), TH);
		    TJ = VSUB(TG, TI);
		    T2F = VADD(TG, TI);
	       }
	       {
		    V TL, TN, TK, TM;
		    TK = LD(&(x[WS(ios, 29)]), dist, &(x[WS(ios, 1)]));
		    TL = BYTW(&(W[TWVL * 56]), TK);
		    TM = LD(&(x[WS(ios, 13)]), dist, &(x[WS(ios, 1)]));
		    TN = BYTW(&(W[TWVL * 24]), TM);
		    TO = VSUB(TL, TN);
		    T2G = VADD(TL, TN);
	       }
	       T3u = VADD(T2C, T2D);
	       T3v = VADD(T2F, T2G);
	       T3w = VSUB(T3u, T3v);
	       T2E = VSUB(T2C, T2D);
	       T2H = VSUB(T2F, T2G);
	       T2I = VFNMS(LDK(KP382683432), T2H, VMUL(LDK(KP923879532), T2E));
	       T38 = VFMA(LDK(KP382683432), T2E, VMUL(LDK(KP923879532), T2H));
	       {
		    V TP, TU, T10, T11;
		    TP = VMUL(LDK(KP707106781), VSUB(TJ, TO));
		    TU = VSUB(TR, TT);
		    TV = VSUB(TP, TU);
		    T25 = VADD(TU, TP);
		    T10 = VSUB(TX, TZ);
		    T11 = VMUL(LDK(KP707106781), VADD(TJ, TO));
		    T12 = VSUB(T10, T11);
		    T26 = VADD(T10, T11);
	       }
	  }
	  {
	       V Tl, T2R, TB, T2U, Tq, T2S, Tw, T2V, Tr, TC;
	       {
		    V Ti, Tk, Th, Tj;
		    Th = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
		    Ti = BYTW(&(W[TWVL * 2]), Th);
		    Tj = LD(&(x[WS(ios, 18)]), dist, &(x[0]));
		    Tk = BYTW(&(W[TWVL * 34]), Tj);
		    Tl = VSUB(Ti, Tk);
		    T2R = VADD(Ti, Tk);
	       }
	       {
		    V Ty, TA, Tx, Tz;
		    Tx = LD(&(x[WS(ios, 30)]), dist, &(x[0]));
		    Ty = BYTW(&(W[TWVL * 58]), Tx);
		    Tz = LD(&(x[WS(ios, 14)]), dist, &(x[0]));
		    TA = BYTW(&(W[TWVL * 26]), Tz);
		    TB = VSUB(Ty, TA);
		    T2U = VADD(Ty, TA);
	       }
	       {
		    V Tn, Tp, Tm, To;
		    Tm = LD(&(x[WS(ios, 10)]), dist, &(x[0]));
		    Tn = BYTW(&(W[TWVL * 18]), Tm);
		    To = LD(&(x[WS(ios, 26)]), dist, &(x[0]));
		    Tp = BYTW(&(W[TWVL * 50]), To);
		    Tq = VSUB(Tn, Tp);
		    T2S = VADD(Tn, Tp);
	       }
	       {
		    V Tt, Tv, Ts, Tu;
		    Ts = LD(&(x[WS(ios, 6)]), dist, &(x[0]));
		    Tt = BYTW(&(W[TWVL * 10]), Ts);
		    Tu = LD(&(x[WS(ios, 22)]), dist, &(x[0]));
		    Tv = BYTW(&(W[TWVL * 42]), Tu);
		    Tw = VSUB(Tt, Tv);
		    T2V = VADD(Tt, Tv);
	       }
	       T3B = VADD(T2R, T2S);
	       T3C = VADD(T2U, T2V);
	       Tr = VFMA(LDK(KP382683432), Tl, VMUL(LDK(KP923879532), Tq));
	       TC = VFNMS(LDK(KP382683432), TB, VMUL(LDK(KP923879532), Tw));
	       TD = VSUB(Tr, TC);
	       T2d = VADD(Tr, TC);
	       {
		    V T1v, T1w, T2T, T2W;
		    T1v = VFNMS(LDK(KP382683432), Tq, VMUL(LDK(KP923879532), Tl));
		    T1w = VFMA(LDK(KP923879532), TB, VMUL(LDK(KP382683432), Tw));
		    T1x = VSUB(T1v, T1w);
		    T23 = VADD(T1v, T1w);
		    T2T = VSUB(T2R, T2S);
		    T2W = VSUB(T2U, T2V);
		    T2X = VMUL(LDK(KP707106781), VSUB(T2T, T2W));
		    T36 = VMUL(LDK(KP707106781), VADD(T2T, T2W));
	       }
	  }
	  {
	       V T3E, T3M, T3J, T3N;
	       {
		    V T3A, T3D, T3H, T3I;
		    T3A = VMUL(LDK(KP707106781), VSUB(T3w, T3z));
		    T3D = VSUB(T3B, T3C);
		    T3E = VBYI(VSUB(T3A, T3D));
		    T3M = VBYI(VADD(T3D, T3A));
		    T3H = VSUB(T3F, T3G);
		    T3I = VMUL(LDK(KP707106781), VADD(T3w, T3z));
		    T3J = VSUB(T3H, T3I);
		    T3N = VADD(T3H, T3I);
	       }
	       {
		    V T3K, T3P, T3L, T3O;
		    T3K = VADD(T3E, T3J);
		    ST(&(x[WS(ios, 12)]), T3K, dist, &(x[0]));
		    T3P = VSUB(T3N, T3M);
		    ST(&(x[WS(ios, 28)]), T3P, dist, &(x[0]));
		    T3L = VSUB(T3J, T3E);
		    ST(&(x[WS(ios, 20)]), T3L, dist, &(x[0]));
		    T3O = VADD(T3M, T3N);
		    ST(&(x[WS(ios, 4)]), T3O, dist, &(x[0]));
	       }
	  }
	  {
	       V T32, T3e, T3b, T3f;
	       {
		    V T2Q, T31, T37, T3a;
		    T2Q = VSUB(T2I, T2P);
		    T31 = VSUB(T2X, T30);
		    T32 = VBYI(VSUB(T2Q, T31));
		    T3e = VBYI(VADD(T31, T2Q));
		    T37 = VSUB(T35, T36);
		    T3a = VSUB(T38, T39);
		    T3b = VSUB(T37, T3a);
		    T3f = VADD(T37, T3a);
	       }
	       {
		    V T3c, T3h, T3d, T3g;
		    T3c = VADD(T32, T3b);
		    ST(&(x[WS(ios, 10)]), T3c, dist, &(x[0]));
		    T3h = VSUB(T3f, T3e);
		    ST(&(x[WS(ios, 26)]), T3h, dist, &(x[0]));
		    T3d = VSUB(T3b, T32);
		    ST(&(x[WS(ios, 22)]), T3d, dist, &(x[0]));
		    T3g = VADD(T3e, T3f);
		    ST(&(x[WS(ios, 6)]), T3g, dist, &(x[0]));
	       }
	  }
	  {
	       V T3S, T3Y, T3V, T3Z;
	       {
		    V T3Q, T3R, T3T, T3U;
		    T3Q = VADD(T3F, T3G);
		    T3R = VADD(T3B, T3C);
		    T3S = VSUB(T3Q, T3R);
		    T3Y = VADD(T3Q, T3R);
		    T3T = VADD(T3u, T3v);
		    T3U = VADD(T3x, T3y);
		    T3V = VBYI(VSUB(T3T, T3U));
		    T3Z = VADD(T3T, T3U);
	       }
	       {
		    V T3W, T41, T3X, T40;
		    T3W = VSUB(T3S, T3V);
		    ST(&(x[WS(ios, 24)]), T3W, dist, &(x[0]));
		    T41 = VADD(T3Y, T3Z);
		    ST(&(x[0]), T41, dist, &(x[0]));
		    T3X = VADD(T3S, T3V);
		    ST(&(x[WS(ios, 8)]), T3X, dist, &(x[0]));
		    T40 = VSUB(T3Y, T3Z);
		    ST(&(x[WS(ios, 16)]), T40, dist, &(x[0]));
	       }
	  }
	  {
	       V T3k, T3q, T3n, T3r;
	       {
		    V T3i, T3j, T3l, T3m;
		    T3i = VADD(T35, T36);
		    T3j = VADD(T2I, T2P);
		    T3k = VADD(T3i, T3j);
		    T3q = VSUB(T3i, T3j);
		    T3l = VADD(T30, T2X);
		    T3m = VADD(T38, T39);
		    T3n = VBYI(VADD(T3l, T3m));
		    T3r = VBYI(VSUB(T3m, T3l));
	       }
	       {
		    V T3o, T3t, T3p, T3s;
		    T3o = VSUB(T3k, T3n);
		    ST(&(x[WS(ios, 30)]), T3o, dist, &(x[0]));
		    T3t = VADD(T3q, T3r);
		    ST(&(x[WS(ios, 14)]), T3t, dist, &(x[0]));
		    T3p = VADD(T3k, T3n);
		    ST(&(x[WS(ios, 2)]), T3p, dist, &(x[0]));
		    T3s = VSUB(T3q, T3r);
		    ST(&(x[WS(ios, 18)]), T3s, dist, &(x[0]));
	       }
	  }
	  {
	       V T2c, T2y, T2m, T2s, T2j, T2z, T2n, T2v;
	       {
		    V T24, T2r, T2b, T2q, T27, T2a;
		    T24 = VSUB(T22, T23);
		    T2r = VADD(T2e, T2d);
		    T27 = VFMA(LDK(KP980785280), T25, VMUL(LDK(KP195090322), T26));
		    T2a = VFNMS(LDK(KP195090322), T29, VMUL(LDK(KP980785280), T28));
		    T2b = VSUB(T27, T2a);
		    T2q = VADD(T27, T2a);
		    T2c = VADD(T24, T2b);
		    T2y = VBYI(VADD(T2r, T2q));
		    T2m = VSUB(T24, T2b);
		    T2s = VBYI(VSUB(T2q, T2r));
	       }
	       {
		    V T2f, T2t, T2i, T2u, T2g, T2h;
		    T2f = VSUB(T2d, T2e);
		    T2t = VADD(T22, T23);
		    T2g = VFNMS(LDK(KP195090322), T25, VMUL(LDK(KP980785280), T26));
		    T2h = VFMA(LDK(KP195090322), T28, VMUL(LDK(KP980785280), T29));
		    T2i = VSUB(T2g, T2h);
		    T2u = VADD(T2g, T2h);
		    T2j = VBYI(VADD(T2f, T2i));
		    T2z = VADD(T2t, T2u);
		    T2n = VBYI(VSUB(T2i, T2f));
		    T2v = VSUB(T2t, T2u);
	       }
	       {
		    V T2k, T2A, T2B, T2l;
		    T2k = VSUB(T2c, T2j);
		    ST(&(x[WS(ios, 25)]), T2k, dist, &(x[WS(ios, 1)]));
		    T2A = VADD(T2y, T2z);
		    ST(&(x[WS(ios, 1)]), T2A, dist, &(x[WS(ios, 1)]));
		    T2B = VSUB(T2z, T2y);
		    ST(&(x[WS(ios, 31)]), T2B, dist, &(x[WS(ios, 1)]));
		    T2l = VADD(T2c, T2j);
		    ST(&(x[WS(ios, 7)]), T2l, dist, &(x[WS(ios, 1)]));
	       }
	       {
		    V T2o, T2w, T2x, T2p;
		    T2o = VSUB(T2m, T2n);
		    ST(&(x[WS(ios, 23)]), T2o, dist, &(x[WS(ios, 1)]));
		    T2w = VADD(T2s, T2v);
		    ST(&(x[WS(ios, 15)]), T2w, dist, &(x[WS(ios, 1)]));
		    T2x = VSUB(T2v, T2s);
		    ST(&(x[WS(ios, 17)]), T2x, dist, &(x[WS(ios, 1)]));
		    T2p = VADD(T2m, T2n);
		    ST(&(x[WS(ios, 9)]), T2p, dist, &(x[WS(ios, 1)]));
	       }
	  }
	  {
	       V T1u, T1Y, T1M, T1S, T1J, T1Z, T1N, T1V;
	       {
		    V TE, T1R, T1t, T1Q, T13, T1s;
		    TE = VSUB(Tg, TD);
		    T1R = VADD(T1E, T1x);
		    T13 = VFMA(LDK(KP831469612), TV, VMUL(LDK(KP555570233), T12));
		    T1s = VFNMS(LDK(KP555570233), T1r, VMUL(LDK(KP831469612), T1k));
		    T1t = VSUB(T13, T1s);
		    T1Q = VADD(T13, T1s);
		    T1u = VADD(TE, T1t);
		    T1Y = VBYI(VADD(T1R, T1Q));
		    T1M = VSUB(TE, T1t);
		    T1S = VBYI(VSUB(T1Q, T1R));
	       }
	       {
		    V T1F, T1T, T1I, T1U, T1G, T1H;
		    T1F = VSUB(T1x, T1E);
		    T1T = VADD(Tg, TD);
		    T1G = VFNMS(LDK(KP555570233), TV, VMUL(LDK(KP831469612), T12));
		    T1H = VFMA(LDK(KP555570233), T1k, VMUL(LDK(KP831469612), T1r));
		    T1I = VSUB(T1G, T1H);
		    T1U = VADD(T1G, T1H);
		    T1J = VBYI(VADD(T1F, T1I));
		    T1Z = VADD(T1T, T1U);
		    T1N = VBYI(VSUB(T1I, T1F));
		    T1V = VSUB(T1T, T1U);
	       }
	       {
		    V T1K, T20, T21, T1L;
		    T1K = VSUB(T1u, T1J);
		    ST(&(x[WS(ios, 27)]), T1K, dist, &(x[WS(ios, 1)]));
		    T20 = VADD(T1Y, T1Z);
		    ST(&(x[WS(ios, 3)]), T20, dist, &(x[WS(ios, 1)]));
		    T21 = VSUB(T1Z, T1Y);
		    ST(&(x[WS(ios, 29)]), T21, dist, &(x[WS(ios, 1)]));
		    T1L = VADD(T1u, T1J);
		    ST(&(x[WS(ios, 5)]), T1L, dist, &(x[WS(ios, 1)]));
	       }
	       {
		    V T1O, T1W, T1X, T1P;
		    T1O = VSUB(T1M, T1N);
		    ST(&(x[WS(ios, 21)]), T1O, dist, &(x[WS(ios, 1)]));
		    T1W = VADD(T1S, T1V);
		    ST(&(x[WS(ios, 13)]), T1W, dist, &(x[WS(ios, 1)]));
		    T1X = VSUB(T1V, T1S);
		    ST(&(x[WS(ios, 19)]), T1X, dist, &(x[WS(ios, 1)]));
		    T1P = VADD(T1M, T1N);
		    ST(&(x[WS(ios, 11)]), T1P, dist, &(x[WS(ios, 1)]));
	       }
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     VTW(8),
     VTW(9),
     VTW(10),
     VTW(11),
     VTW(12),
     VTW(13),
     VTW(14),
     VTW(15),
     VTW(16),
     VTW(17),
     VTW(18),
     VTW(19),
     VTW(20),
     VTW(21),
     VTW(22),
     VTW(23),
     VTW(24),
     VTW(25),
     VTW(26),
     VTW(27),
     VTW(28),
     VTW(29),
     VTW(30),
     VTW(31),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 32, "t1bv_32", twinstr, {201, 88, 16, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1bv_32) (planner *p) {
     X(kdft_dit_register) (p, t1bv_32, &desc);
}
