/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:05:20 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 8 -name t1bv_8 -include t1b.h -sign 1 */

/*
 * This function contains 33 FP additions, 16 FP multiplications,
 * (or, 33 additions, 16 multiplications, 0 fused multiply/add),
 * 24 stack variables, and 16 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1b.h"

static const R *t1bv_8(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     int i;
     R *x;
     x = ii;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 14)) {
	  V Tl, Tu, Tg, Tv, Tx, Ty, Tb, Tm, Ti, Tk, Tj;
	  Ti = LD(&(x[0]), dist, &(x[0]));
	  Tj = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
	  Tk = BYTW(&(W[TWVL * 6]), Tj);
	  Tl = VSUB(Ti, Tk);
	  Tu = VADD(Ti, Tk);
	  {
	       V Td, Tf, Tc, Te;
	       Tc = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
	       Td = BYTW(&(W[TWVL * 2]), Tc);
	       Te = LD(&(x[WS(ios, 6)]), dist, &(x[0]));
	       Tf = BYTW(&(W[TWVL * 10]), Te);
	       Tg = VSUB(Td, Tf);
	       Tv = VADD(Td, Tf);
	  }
	  {
	       V T2, T9, T4, T7, T5, Ta;
	       {
		    V T1, T8, T3, T6;
		    T1 = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
		    T2 = BYTW(&(W[0]), T1);
		    T8 = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
		    T9 = BYTW(&(W[TWVL * 4]), T8);
		    T3 = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
		    T4 = BYTW(&(W[TWVL * 8]), T3);
		    T6 = LD(&(x[WS(ios, 7)]), dist, &(x[WS(ios, 1)]));
		    T7 = BYTW(&(W[TWVL * 12]), T6);
	       }
	       Tx = VADD(T2, T4);
	       Ty = VADD(T7, T9);
	       T5 = VSUB(T2, T4);
	       Ta = VSUB(T7, T9);
	       Tb = VMUL(LDK(KP707106781), VSUB(T5, Ta));
	       Tm = VMUL(LDK(KP707106781), VADD(T5, Ta));
	  }
	  {
	       V To, Tp, Th, Tn;
	       Th = VBYI(VSUB(Tb, Tg));
	       Tn = VSUB(Tl, Tm);
	       To = VADD(Th, Tn);
	       Tp = VSUB(Tn, Th);
	       ST(&(x[WS(ios, 3)]), To, dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 5)]), Tp, dist, &(x[WS(ios, 1)]));
	  }
	  {
	       V TE, TF, TC, TD;
	       TC = VADD(Tu, Tv);
	       TD = VADD(Tx, Ty);
	       TE = VSUB(TC, TD);
	       TF = VADD(TC, TD);
	       ST(&(x[WS(ios, 4)]), TE, dist, &(x[0]));
	       ST(&(x[0]), TF, dist, &(x[0]));
	  }
	  {
	       V Ts, Tt, Tq, Tr;
	       Tq = VBYI(VADD(Tg, Tb));
	       Tr = VADD(Tl, Tm);
	       Ts = VADD(Tq, Tr);
	       Tt = VSUB(Tr, Tq);
	       ST(&(x[WS(ios, 1)]), Ts, dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 7)]), Tt, dist, &(x[WS(ios, 1)]));
	  }
	  {
	       V TA, TB, Tw, Tz;
	       Tw = VSUB(Tu, Tv);
	       Tz = VBYI(VSUB(Tx, Ty));
	       TA = VSUB(Tw, Tz);
	       TB = VADD(Tw, Tz);
	       ST(&(x[WS(ios, 6)]), TA, dist, &(x[0]));
	       ST(&(x[WS(ios, 2)]), TB, dist, &(x[0]));
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 8, "t1bv_8", twinstr, {33, 16, 0, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1bv_8) (planner *p) {
     X(kdft_dit_register) (p, t1bv_8, &desc);
}
