/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:04:52 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 10 -name t1fv_10 -include t1f.h */

/*
 * This function contains 51 FP additions, 30 FP multiplications,
 * (or, 45 additions, 24 multiplications, 6 fused multiply/add),
 * 35 stack variables, and 20 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1f.h"

static const R *t1fv_10(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DVK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DVK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DVK(KP951056516, +0.951056516295153572116439333379382143405698634);
     int i;
     R *x;
     x = ri;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 18)) {
	  V Tr, TM, Tv, Tw, TK, TH, TN, TO, TP, Tb, Tm, Ts, To, Tq, Tp;
	  V TE, TZ;
	  To = LD(&(x[0]), dist, &(x[0]));
	  Tp = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
	  Tq = BYTWJ(&(W[TWVL * 8]), Tp);
	  Tr = VSUB(To, Tq);
	  TM = VADD(To, Tq);
	  {
	       V T5, TI, Tl, TG, Ta, TJ, Tg, TF;
	       {
		    V T2, T4, T1, T3;
		    T1 = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
		    T2 = BYTWJ(&(W[TWVL * 2]), T1);
		    T3 = LD(&(x[WS(ios, 7)]), dist, &(x[WS(ios, 1)]));
		    T4 = BYTWJ(&(W[TWVL * 12]), T3);
		    T5 = VSUB(T2, T4);
		    TI = VADD(T2, T4);
	       }
	       {
		    V Ti, Tk, Th, Tj;
		    Th = LD(&(x[WS(ios, 6)]), dist, &(x[0]));
		    Ti = BYTWJ(&(W[TWVL * 10]), Th);
		    Tj = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
		    Tk = BYTWJ(&(W[0]), Tj);
		    Tl = VSUB(Ti, Tk);
		    TG = VADD(Ti, Tk);
	       }
	       {
		    V T7, T9, T6, T8;
		    T6 = LD(&(x[WS(ios, 8)]), dist, &(x[0]));
		    T7 = BYTWJ(&(W[TWVL * 14]), T6);
		    T8 = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
		    T9 = BYTWJ(&(W[TWVL * 4]), T8);
		    Ta = VSUB(T7, T9);
		    TJ = VADD(T7, T9);
	       }
	       {
		    V Td, Tf, Tc, Te;
		    Tc = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
		    Td = BYTWJ(&(W[TWVL * 6]), Tc);
		    Te = LD(&(x[WS(ios, 9)]), dist, &(x[WS(ios, 1)]));
		    Tf = BYTWJ(&(W[TWVL * 16]), Te);
		    Tg = VSUB(Td, Tf);
		    TF = VADD(Td, Tf);
	       }
	       Tv = VSUB(T5, Ta);
	       Tw = VSUB(Tg, Tl);
	       TK = VSUB(TI, TJ);
	       TH = VSUB(TF, TG);
	       TN = VADD(TI, TJ);
	       TO = VADD(TF, TG);
	       TP = VADD(TN, TO);
	       Tb = VADD(T5, Ta);
	       Tm = VADD(Tg, Tl);
	       Ts = VADD(Tb, Tm);
	  }
	  TE = VADD(Tr, Ts);
	  ST(&(x[WS(ios, 5)]), TE, dist, &(x[WS(ios, 1)]));
	  TZ = VADD(TM, TP);
	  ST(&(x[0]), TZ, dist, &(x[0]));
	  {
	       V Tx, TB, Tu, TA, Tn, Tt;
	       Tx = VBYI(VFMA(LDK(KP951056516), Tv, VMUL(LDK(KP587785252), Tw)));
	       TB = VBYI(VFNMS(LDK(KP587785252), Tv, VMUL(LDK(KP951056516), Tw)));
	       Tn = VMUL(LDK(KP559016994), VSUB(Tb, Tm));
	       Tt = VFNMS(LDK(KP250000000), Ts, Tr);
	       Tu = VADD(Tn, Tt);
	       TA = VSUB(Tt, Tn);
	       {
		    V Ty, TD, Tz, TC;
		    Ty = VSUB(Tu, Tx);
		    ST(&(x[WS(ios, 1)]), Ty, dist, &(x[WS(ios, 1)]));
		    TD = VADD(TB, TA);
		    ST(&(x[WS(ios, 7)]), TD, dist, &(x[WS(ios, 1)]));
		    Tz = VADD(Tx, Tu);
		    ST(&(x[WS(ios, 9)]), Tz, dist, &(x[WS(ios, 1)]));
		    TC = VSUB(TA, TB);
		    ST(&(x[WS(ios, 3)]), TC, dist, &(x[WS(ios, 1)]));
	       }
	  }
	  {
	       V TL, TV, TS, TW, TQ, TR;
	       TL = VBYI(VFNMS(LDK(KP587785252), TK, VMUL(LDK(KP951056516), TH)));
	       TV = VBYI(VFMA(LDK(KP951056516), TK, VMUL(LDK(KP587785252), TH)));
	       TQ = VFNMS(LDK(KP250000000), TP, TM);
	       TR = VMUL(LDK(KP559016994), VSUB(TN, TO));
	       TS = VSUB(TQ, TR);
	       TW = VADD(TR, TQ);
	       {
		    V TT, TY, TU, TX;
		    TT = VADD(TL, TS);
		    ST(&(x[WS(ios, 2)]), TT, dist, &(x[0]));
		    TY = VSUB(TW, TV);
		    ST(&(x[WS(ios, 6)]), TY, dist, &(x[0]));
		    TU = VSUB(TS, TL);
		    ST(&(x[WS(ios, 8)]), TU, dist, &(x[0]));
		    TX = VADD(TV, TW);
		    ST(&(x[WS(ios, 4)]), TX, dist, &(x[0]));
	       }
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     VTW(8),
     VTW(9),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 10, "t1fv_10", twinstr, {45, 24, 6, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1fv_10) (planner *p) {
     X(kdft_dit_register) (p, t1fv_10, &desc);
}
