/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:05:02 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 32 -name t1fv_32 -include t1f.h */

/*
 * This function contains 217 FP additions, 104 FP multiplications,
 * (or, 201 additions, 88 multiplications, 16 fused multiply/add),
 * 60 stack variables, and 64 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1f.h"

static const R *t1fv_32(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     int i;
     R *x;
     x = ri;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 62)) {
	  V Tg, T22, T2H, T3D, T1B, T2d, T2E, T3q, T2S, T2V, T2W, T3A, T3H, T1k, T28;
	  V T1r, T29, T2L, T2O, T2P, T3x, T3G, TV, T25, T12, T26, T31, T34, TD, T2e;
	  V T1E, T23, T3t, T3E;
	  {
	       V T1, T3, T1z, T1x, Tb, Td, Te, T6, T8, T9, T2, T1y, T1w;
	       T1 = LD(&(x[0]), dist, &(x[0]));
	       T2 = LD(&(x[WS(ios, 16)]), dist, &(x[0]));
	       T3 = BYTWJ(&(W[TWVL * 30]), T2);
	       T1y = LD(&(x[WS(ios, 24)]), dist, &(x[0]));
	       T1z = BYTWJ(&(W[TWVL * 46]), T1y);
	       T1w = LD(&(x[WS(ios, 8)]), dist, &(x[0]));
	       T1x = BYTWJ(&(W[TWVL * 14]), T1w);
	       {
		    V Ta, Tc, T5, T7;
		    Ta = LD(&(x[WS(ios, 28)]), dist, &(x[0]));
		    Tb = BYTWJ(&(W[TWVL * 54]), Ta);
		    Tc = LD(&(x[WS(ios, 12)]), dist, &(x[0]));
		    Td = BYTWJ(&(W[TWVL * 22]), Tc);
		    Te = VSUB(Tb, Td);
		    T5 = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
		    T6 = BYTWJ(&(W[TWVL * 6]), T5);
		    T7 = LD(&(x[WS(ios, 20)]), dist, &(x[0]));
		    T8 = BYTWJ(&(W[TWVL * 38]), T7);
		    T9 = VSUB(T6, T8);
	       }
	       {
		    V T4, Tf, T2F, T2G;
		    T4 = VSUB(T1, T3);
		    Tf = VMUL(LDK(KP707106781), VADD(T9, Te));
		    Tg = VADD(T4, Tf);
		    T22 = VSUB(T4, Tf);
		    T2F = VADD(T6, T8);
		    T2G = VADD(Tb, Td);
		    T2H = VADD(T2F, T2G);
		    T3D = VSUB(T2G, T2F);
	       }
	       {
		    V T1v, T1A, T2C, T2D;
		    T1v = VMUL(LDK(KP707106781), VSUB(Te, T9));
		    T1A = VSUB(T1x, T1z);
		    T1B = VSUB(T1v, T1A);
		    T2d = VADD(T1A, T1v);
		    T2C = VADD(T1, T3);
		    T2D = VADD(T1x, T1z);
		    T2E = VADD(T2C, T2D);
		    T3q = VSUB(T2C, T2D);
	       }
	  }
	  {
	       V T15, T17, T2Q, T1n, T1p, T2R, T1d, T2T, T1i, T2U, T3y, T3z;
	       {
		    V T14, T16, T1m, T1o;
		    T14 = LD(&(x[WS(ios, 31)]), dist, &(x[WS(ios, 1)]));
		    T15 = BYTWJ(&(W[TWVL * 60]), T14);
		    T16 = LD(&(x[WS(ios, 15)]), dist, &(x[WS(ios, 1)]));
		    T17 = BYTWJ(&(W[TWVL * 28]), T16);
		    T2Q = VADD(T15, T17);
		    T1m = LD(&(x[WS(ios, 7)]), dist, &(x[WS(ios, 1)]));
		    T1n = BYTWJ(&(W[TWVL * 12]), T1m);
		    T1o = LD(&(x[WS(ios, 23)]), dist, &(x[WS(ios, 1)]));
		    T1p = BYTWJ(&(W[TWVL * 44]), T1o);
		    T2R = VADD(T1n, T1p);
	       }
	       {
		    V T1a, T1c, T19, T1b;
		    T19 = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
		    T1a = BYTWJ(&(W[TWVL * 4]), T19);
		    T1b = LD(&(x[WS(ios, 19)]), dist, &(x[WS(ios, 1)]));
		    T1c = BYTWJ(&(W[TWVL * 36]), T1b);
		    T1d = VSUB(T1a, T1c);
		    T2T = VADD(T1a, T1c);
	       }
	       {
		    V T1f, T1h, T1e, T1g;
		    T1e = LD(&(x[WS(ios, 27)]), dist, &(x[WS(ios, 1)]));
		    T1f = BYTWJ(&(W[TWVL * 52]), T1e);
		    T1g = LD(&(x[WS(ios, 11)]), dist, &(x[WS(ios, 1)]));
		    T1h = BYTWJ(&(W[TWVL * 20]), T1g);
		    T1i = VSUB(T1f, T1h);
		    T2U = VADD(T1f, T1h);
	       }
	       T2S = VADD(T2Q, T2R);
	       T2V = VADD(T2T, T2U);
	       T2W = VSUB(T2S, T2V);
	       T3y = VSUB(T2Q, T2R);
	       T3z = VSUB(T2U, T2T);
	       T3A = VFNMS(LDK(KP382683432), T3z, VMUL(LDK(KP923879532), T3y));
	       T3H = VFMA(LDK(KP382683432), T3y, VMUL(LDK(KP923879532), T3z));
	       {
		    V T18, T1j, T1l, T1q;
		    T18 = VSUB(T15, T17);
		    T1j = VMUL(LDK(KP707106781), VADD(T1d, T1i));
		    T1k = VADD(T18, T1j);
		    T28 = VSUB(T18, T1j);
		    T1l = VMUL(LDK(KP707106781), VSUB(T1i, T1d));
		    T1q = VSUB(T1n, T1p);
		    T1r = VSUB(T1l, T1q);
		    T29 = VADD(T1q, T1l);
	       }
	  }
	  {
	       V TG, TI, T2J, TY, T10, T2K, TO, T2M, TT, T2N, T3v, T3w;
	       {
		    V TF, TH, TX, TZ;
		    TF = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
		    TG = BYTWJ(&(W[0]), TF);
		    TH = LD(&(x[WS(ios, 17)]), dist, &(x[WS(ios, 1)]));
		    TI = BYTWJ(&(W[TWVL * 32]), TH);
		    T2J = VADD(TG, TI);
		    TX = LD(&(x[WS(ios, 9)]), dist, &(x[WS(ios, 1)]));
		    TY = BYTWJ(&(W[TWVL * 16]), TX);
		    TZ = LD(&(x[WS(ios, 25)]), dist, &(x[WS(ios, 1)]));
		    T10 = BYTWJ(&(W[TWVL * 48]), TZ);
		    T2K = VADD(TY, T10);
	       }
	       {
		    V TL, TN, TK, TM;
		    TK = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
		    TL = BYTWJ(&(W[TWVL * 8]), TK);
		    TM = LD(&(x[WS(ios, 21)]), dist, &(x[WS(ios, 1)]));
		    TN = BYTWJ(&(W[TWVL * 40]), TM);
		    TO = VSUB(TL, TN);
		    T2M = VADD(TL, TN);
	       }
	       {
		    V TQ, TS, TP, TR;
		    TP = LD(&(x[WS(ios, 29)]), dist, &(x[WS(ios, 1)]));
		    TQ = BYTWJ(&(W[TWVL * 56]), TP);
		    TR = LD(&(x[WS(ios, 13)]), dist, &(x[WS(ios, 1)]));
		    TS = BYTWJ(&(W[TWVL * 24]), TR);
		    TT = VSUB(TQ, TS);
		    T2N = VADD(TQ, TS);
	       }
	       T2L = VADD(T2J, T2K);
	       T2O = VADD(T2M, T2N);
	       T2P = VSUB(T2L, T2O);
	       T3v = VSUB(T2J, T2K);
	       T3w = VSUB(T2N, T2M);
	       T3x = VFMA(LDK(KP923879532), T3v, VMUL(LDK(KP382683432), T3w));
	       T3G = VFNMS(LDK(KP382683432), T3v, VMUL(LDK(KP923879532), T3w));
	       {
		    V TJ, TU, TW, T11;
		    TJ = VSUB(TG, TI);
		    TU = VMUL(LDK(KP707106781), VADD(TO, TT));
		    TV = VADD(TJ, TU);
		    T25 = VSUB(TJ, TU);
		    TW = VMUL(LDK(KP707106781), VSUB(TT, TO));
		    T11 = VSUB(TY, T10);
		    T12 = VSUB(TW, T11);
		    T26 = VADD(T11, TW);
	       }
	  }
	  {
	       V Tl, T32, TB, T30, Tq, T33, Tw, T2Z, Tr, TC;
	       {
		    V Ti, Tk, Th, Tj;
		    Th = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
		    Ti = BYTWJ(&(W[TWVL * 2]), Th);
		    Tj = LD(&(x[WS(ios, 18)]), dist, &(x[0]));
		    Tk = BYTWJ(&(W[TWVL * 34]), Tj);
		    Tl = VSUB(Ti, Tk);
		    T32 = VADD(Ti, Tk);
	       }
	       {
		    V Ty, TA, Tx, Tz;
		    Tx = LD(&(x[WS(ios, 6)]), dist, &(x[0]));
		    Ty = BYTWJ(&(W[TWVL * 10]), Tx);
		    Tz = LD(&(x[WS(ios, 22)]), dist, &(x[0]));
		    TA = BYTWJ(&(W[TWVL * 42]), Tz);
		    TB = VSUB(Ty, TA);
		    T30 = VADD(Ty, TA);
	       }
	       {
		    V Tn, Tp, Tm, To;
		    Tm = LD(&(x[WS(ios, 10)]), dist, &(x[0]));
		    Tn = BYTWJ(&(W[TWVL * 18]), Tm);
		    To = LD(&(x[WS(ios, 26)]), dist, &(x[0]));
		    Tp = BYTWJ(&(W[TWVL * 50]), To);
		    Tq = VSUB(Tn, Tp);
		    T33 = VADD(Tn, Tp);
	       }
	       {
		    V Tt, Tv, Ts, Tu;
		    Ts = LD(&(x[WS(ios, 30)]), dist, &(x[0]));
		    Tt = BYTWJ(&(W[TWVL * 58]), Ts);
		    Tu = LD(&(x[WS(ios, 14)]), dist, &(x[0]));
		    Tv = BYTWJ(&(W[TWVL * 26]), Tu);
		    Tw = VSUB(Tt, Tv);
		    T2Z = VADD(Tt, Tv);
	       }
	       T31 = VADD(T2Z, T30);
	       T34 = VADD(T32, T33);
	       Tr = VFNMS(LDK(KP382683432), Tq, VMUL(LDK(KP923879532), Tl));
	       TC = VFMA(LDK(KP923879532), Tw, VMUL(LDK(KP382683432), TB));
	       TD = VADD(Tr, TC);
	       T2e = VSUB(TC, Tr);
	       {
		    V T1C, T1D, T3r, T3s;
		    T1C = VFNMS(LDK(KP923879532), TB, VMUL(LDK(KP382683432), Tw));
		    T1D = VFMA(LDK(KP382683432), Tl, VMUL(LDK(KP923879532), Tq));
		    T1E = VSUB(T1C, T1D);
		    T23 = VADD(T1D, T1C);
		    T3r = VSUB(T32, T33);
		    T3s = VSUB(T2Z, T30);
		    T3t = VMUL(LDK(KP707106781), VADD(T3r, T3s));
		    T3E = VMUL(LDK(KP707106781), VSUB(T3s, T3r));
	       }
	  }
	  {
	       V T2Y, T3a, T37, T3b;
	       {
		    V T2I, T2X, T35, T36;
		    T2I = VSUB(T2E, T2H);
		    T2X = VMUL(LDK(KP707106781), VADD(T2P, T2W));
		    T2Y = VADD(T2I, T2X);
		    T3a = VSUB(T2I, T2X);
		    T35 = VSUB(T31, T34);
		    T36 = VMUL(LDK(KP707106781), VSUB(T2W, T2P));
		    T37 = VBYI(VADD(T35, T36));
		    T3b = VBYI(VSUB(T36, T35));
	       }
	       {
		    V T38, T3d, T39, T3c;
		    T38 = VSUB(T2Y, T37);
		    ST(&(x[WS(ios, 28)]), T38, dist, &(x[0]));
		    T3d = VADD(T3a, T3b);
		    ST(&(x[WS(ios, 12)]), T3d, dist, &(x[0]));
		    T39 = VADD(T2Y, T37);
		    ST(&(x[WS(ios, 4)]), T39, dist, &(x[0]));
		    T3c = VSUB(T3a, T3b);
		    ST(&(x[WS(ios, 20)]), T3c, dist, &(x[0]));
	       }
	  }
	  {
	       V T3g, T3m, T3j, T3n;
	       {
		    V T3e, T3f, T3h, T3i;
		    T3e = VADD(T2E, T2H);
		    T3f = VADD(T34, T31);
		    T3g = VADD(T3e, T3f);
		    T3m = VSUB(T3e, T3f);
		    T3h = VADD(T2L, T2O);
		    T3i = VADD(T2S, T2V);
		    T3j = VADD(T3h, T3i);
		    T3n = VBYI(VSUB(T3i, T3h));
	       }
	       {
		    V T3k, T3p, T3l, T3o;
		    T3k = VSUB(T3g, T3j);
		    ST(&(x[WS(ios, 16)]), T3k, dist, &(x[0]));
		    T3p = VADD(T3m, T3n);
		    ST(&(x[WS(ios, 8)]), T3p, dist, &(x[0]));
		    T3l = VADD(T3g, T3j);
		    ST(&(x[0]), T3l, dist, &(x[0]));
		    T3o = VSUB(T3m, T3n);
		    ST(&(x[WS(ios, 24)]), T3o, dist, &(x[0]));
	       }
	  }
	  {
	       V T3S, T3Y, T3V, T3Z;
	       {
		    V T3Q, T3R, T3T, T3U;
		    T3Q = VSUB(T3A, T3x);
		    T3R = VSUB(T3E, T3D);
		    T3S = VBYI(VSUB(T3Q, T3R));
		    T3Y = VBYI(VADD(T3R, T3Q));
		    T3T = VSUB(T3q, T3t);
		    T3U = VSUB(T3H, T3G);
		    T3V = VSUB(T3T, T3U);
		    T3Z = VADD(T3T, T3U);
	       }
	       {
		    V T3W, T41, T3X, T40;
		    T3W = VADD(T3S, T3V);
		    ST(&(x[WS(ios, 10)]), T3W, dist, &(x[0]));
		    T41 = VSUB(T3Z, T3Y);
		    ST(&(x[WS(ios, 26)]), T41, dist, &(x[0]));
		    T3X = VSUB(T3V, T3S);
		    ST(&(x[WS(ios, 22)]), T3X, dist, &(x[0]));
		    T40 = VADD(T3Y, T3Z);
		    ST(&(x[WS(ios, 6)]), T40, dist, &(x[0]));
	       }
	  }
	  {
	       V T3C, T3M, T3J, T3N;
	       {
		    V T3u, T3B, T3F, T3I;
		    T3u = VADD(T3q, T3t);
		    T3B = VADD(T3x, T3A);
		    T3C = VADD(T3u, T3B);
		    T3M = VSUB(T3u, T3B);
		    T3F = VADD(T3D, T3E);
		    T3I = VADD(T3G, T3H);
		    T3J = VBYI(VADD(T3F, T3I));
		    T3N = VBYI(VSUB(T3I, T3F));
	       }
	       {
		    V T3K, T3P, T3L, T3O;
		    T3K = VSUB(T3C, T3J);
		    ST(&(x[WS(ios, 30)]), T3K, dist, &(x[0]));
		    T3P = VADD(T3M, T3N);
		    ST(&(x[WS(ios, 14)]), T3P, dist, &(x[0]));
		    T3L = VADD(T3C, T3J);
		    ST(&(x[WS(ios, 2)]), T3L, dist, &(x[0]));
		    T3O = VSUB(T3M, T3N);
		    ST(&(x[WS(ios, 18)]), T3O, dist, &(x[0]));
	       }
	  }
	  {
	       V T2c, T2y, T2m, T2s, T2j, T2z, T2n, T2v;
	       {
		    V T24, T2r, T2b, T2q, T27, T2a;
		    T24 = VADD(T22, T23);
		    T2r = VSUB(T2e, T2d);
		    T27 = VFMA(LDK(KP831469612), T25, VMUL(LDK(KP555570233), T26));
		    T2a = VFNMS(LDK(KP555570233), T29, VMUL(LDK(KP831469612), T28));
		    T2b = VADD(T27, T2a);
		    T2q = VSUB(T2a, T27);
		    T2c = VADD(T24, T2b);
		    T2y = VBYI(VADD(T2r, T2q));
		    T2m = VSUB(T24, T2b);
		    T2s = VBYI(VSUB(T2q, T2r));
	       }
	       {
		    V T2f, T2t, T2i, T2u, T2g, T2h;
		    T2f = VADD(T2d, T2e);
		    T2t = VSUB(T22, T23);
		    T2g = VFNMS(LDK(KP555570233), T25, VMUL(LDK(KP831469612), T26));
		    T2h = VFMA(LDK(KP555570233), T28, VMUL(LDK(KP831469612), T29));
		    T2i = VADD(T2g, T2h);
		    T2u = VSUB(T2h, T2g);
		    T2j = VBYI(VADD(T2f, T2i));
		    T2z = VADD(T2t, T2u);
		    T2n = VBYI(VSUB(T2i, T2f));
		    T2v = VSUB(T2t, T2u);
	       }
	       {
		    V T2k, T2A, T2B, T2l;
		    T2k = VSUB(T2c, T2j);
		    ST(&(x[WS(ios, 29)]), T2k, dist, &(x[WS(ios, 1)]));
		    T2A = VADD(T2y, T2z);
		    ST(&(x[WS(ios, 5)]), T2A, dist, &(x[WS(ios, 1)]));
		    T2B = VSUB(T2z, T2y);
		    ST(&(x[WS(ios, 27)]), T2B, dist, &(x[WS(ios, 1)]));
		    T2l = VADD(T2c, T2j);
		    ST(&(x[WS(ios, 3)]), T2l, dist, &(x[WS(ios, 1)]));
	       }
	       {
		    V T2o, T2w, T2x, T2p;
		    T2o = VSUB(T2m, T2n);
		    ST(&(x[WS(ios, 19)]), T2o, dist, &(x[WS(ios, 1)]));
		    T2w = VADD(T2s, T2v);
		    ST(&(x[WS(ios, 11)]), T2w, dist, &(x[WS(ios, 1)]));
		    T2x = VSUB(T2v, T2s);
		    ST(&(x[WS(ios, 21)]), T2x, dist, &(x[WS(ios, 1)]));
		    T2p = VADD(T2m, T2n);
		    ST(&(x[WS(ios, 13)]), T2p, dist, &(x[WS(ios, 1)]));
	       }
	  }
	  {
	       V T1u, T1Y, T1M, T1S, T1J, T1Z, T1N, T1V;
	       {
		    V TE, T1R, T1t, T1Q, T13, T1s;
		    TE = VADD(Tg, TD);
		    T1R = VSUB(T1E, T1B);
		    T13 = VFMA(LDK(KP980785280), TV, VMUL(LDK(KP195090322), T12));
		    T1s = VFNMS(LDK(KP195090322), T1r, VMUL(LDK(KP980785280), T1k));
		    T1t = VADD(T13, T1s);
		    T1Q = VSUB(T1s, T13);
		    T1u = VADD(TE, T1t);
		    T1Y = VBYI(VADD(T1R, T1Q));
		    T1M = VSUB(TE, T1t);
		    T1S = VBYI(VSUB(T1Q, T1R));
	       }
	       {
		    V T1F, T1T, T1I, T1U, T1G, T1H;
		    T1F = VADD(T1B, T1E);
		    T1T = VSUB(Tg, TD);
		    T1G = VFNMS(LDK(KP195090322), TV, VMUL(LDK(KP980785280), T12));
		    T1H = VFMA(LDK(KP195090322), T1k, VMUL(LDK(KP980785280), T1r));
		    T1I = VADD(T1G, T1H);
		    T1U = VSUB(T1H, T1G);
		    T1J = VBYI(VADD(T1F, T1I));
		    T1Z = VADD(T1T, T1U);
		    T1N = VBYI(VSUB(T1I, T1F));
		    T1V = VSUB(T1T, T1U);
	       }
	       {
		    V T1K, T20, T21, T1L;
		    T1K = VSUB(T1u, T1J);
		    ST(&(x[WS(ios, 31)]), T1K, dist, &(x[WS(ios, 1)]));
		    T20 = VADD(T1Y, T1Z);
		    ST(&(x[WS(ios, 7)]), T20, dist, &(x[WS(ios, 1)]));
		    T21 = VSUB(T1Z, T1Y);
		    ST(&(x[WS(ios, 25)]), T21, dist, &(x[WS(ios, 1)]));
		    T1L = VADD(T1u, T1J);
		    ST(&(x[WS(ios, 1)]), T1L, dist, &(x[WS(ios, 1)]));
	       }
	       {
		    V T1O, T1W, T1X, T1P;
		    T1O = VSUB(T1M, T1N);
		    ST(&(x[WS(ios, 17)]), T1O, dist, &(x[WS(ios, 1)]));
		    T1W = VADD(T1S, T1V);
		    ST(&(x[WS(ios, 9)]), T1W, dist, &(x[WS(ios, 1)]));
		    T1X = VSUB(T1V, T1S);
		    ST(&(x[WS(ios, 23)]), T1X, dist, &(x[WS(ios, 1)]));
		    T1P = VADD(T1M, T1N);
		    ST(&(x[WS(ios, 15)]), T1P, dist, &(x[WS(ios, 1)]));
	       }
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     VTW(8),
     VTW(9),
     VTW(10),
     VTW(11),
     VTW(12),
     VTW(13),
     VTW(14),
     VTW(15),
     VTW(16),
     VTW(17),
     VTW(18),
     VTW(19),
     VTW(20),
     VTW(21),
     VTW(22),
     VTW(23),
     VTW(24),
     VTW(25),
     VTW(26),
     VTW(27),
     VTW(28),
     VTW(29),
     VTW(30),
     VTW(31),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 32, "t1fv_32", twinstr, {201, 88, 16, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1fv_32) (planner *p) {
     X(kdft_dit_register) (p, t1fv_32, &desc);
}
