/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:04:51 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 9 -name t1fv_9 -include t1f.h */

/*
 * This function contains 54 FP additions, 42 FP multiplications,
 * (or, 38 additions, 26 multiplications, 16 fused multiply/add),
 * 39 stack variables, and 18 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1f.h"

static const R *t1fv_9(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP342020143, +0.342020143325668733044099614682259580763083368);
     DVK(KP813797681, +0.813797681349373692844693217248393223289101568);
     DVK(KP939692620, +0.939692620785908384054109277324731469936208134);
     DVK(KP296198132, +0.296198132726023843175338011893050938967728390);
     DVK(KP642787609, +0.642787609686539326322643409907263432907559884);
     DVK(KP663413948, +0.663413948168938396205421319635891297216863310);
     DVK(KP556670399, +0.556670399226419366452912952047023132968291906);
     DVK(KP766044443, +0.766044443118978035202392650555416673935832457);
     DVK(KP984807753, +0.984807753012208059366743024589523013670643252);
     DVK(KP150383733, +0.150383733180435296639271897612501926072238258);
     DVK(KP852868531, +0.852868531952443209628250963940074071936020296);
     DVK(KP173648177, +0.173648177666930348851716626769314796000375677);
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     int i;
     R *x;
     x = ri;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 16)) {
	  V TD, T7, Tu, Tn, Ty, Tz, TA, TF, Tf, Tv, Tw, Tx, TE;
	  {
	       V T1, T5, T3, T4, T2, T6;
	       T1 = LD(&(x[0]), dist, &(x[0]));
	       T4 = LD(&(x[WS(ios, 6)]), dist, &(x[0]));
	       T5 = BYTWJ(&(W[TWVL * 10]), T4);
	       T2 = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
	       T3 = BYTWJ(&(W[TWVL * 4]), T2);
	       TD = VMUL(LDK(KP866025403), VSUB(T5, T3));
	       T6 = VADD(T3, T5);
	       T7 = VADD(T1, T6);
	       Tu = VFNMS(LDK(KP500000000), T6, T1);
	  }
	  {
	       V Th, Tj, Tl, Tm, Tg, Ti, Tk;
	       Tg = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
	       Th = BYTWJ(&(W[TWVL * 2]), Tg);
	       Ti = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
	       Tj = BYTWJ(&(W[TWVL * 8]), Ti);
	       Tk = LD(&(x[WS(ios, 8)]), dist, &(x[0]));
	       Tl = BYTWJ(&(W[TWVL * 14]), Tk);
	       Tm = VADD(Tj, Tl);
	       Tn = VADD(Th, Tm);
	       Ty = VFNMS(LDK(KP500000000), Tm, Th);
	       Tz = VSUB(Tl, Tj);
	       TA = VFMA(LDK(KP173648177), Ty, VMUL(LDK(KP852868531), Tz));
	       TF = VFNMS(LDK(KP984807753), Ty, VMUL(LDK(KP150383733), Tz));
	  }
	  {
	       V T9, Tb, Td, Te, T8, Ta, Tc;
	       T8 = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
	       T9 = BYTWJ(&(W[0]), T8);
	       Ta = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
	       Tb = BYTWJ(&(W[TWVL * 6]), Ta);
	       Tc = LD(&(x[WS(ios, 7)]), dist, &(x[WS(ios, 1)]));
	       Td = BYTWJ(&(W[TWVL * 12]), Tc);
	       Te = VADD(Tb, Td);
	       Tf = VADD(T9, Te);
	       Tv = VFNMS(LDK(KP500000000), Te, T9);
	       Tw = VSUB(Td, Tb);
	       Tx = VFMA(LDK(KP766044443), Tv, VMUL(LDK(KP556670399), Tw));
	       TE = VFNMS(LDK(KP642787609), Tv, VMUL(LDK(KP663413948), Tw));
	  }
	  {
	       V Tr, Tp, Tq, To, Tt, Ts;
	       Tr = VBYI(VMUL(LDK(KP866025403), VSUB(Tn, Tf)));
	       To = VADD(Tf, Tn);
	       Tp = VADD(T7, To);
	       Tq = VFNMS(LDK(KP500000000), To, T7);
	       ST(&(x[0]), Tp, dist, &(x[0]));
	       Tt = VADD(Tq, Tr);
	       ST(&(x[WS(ios, 3)]), Tt, dist, &(x[WS(ios, 1)]));
	       Ts = VSUB(Tq, Tr);
	       ST(&(x[WS(ios, 6)]), Ts, dist, &(x[0]));
	  }
	  {
	       V TQ, TR, TO, TP;
	       TO = VFMA(LDK(KP173648177), Tv, VFNMS(LDK(KP296198132), Tz, VFNMS(LDK(KP939692620), Ty, VFNMS(LDK(KP852868531), Tw, Tu))));
	       TP = VBYI(VSUB(VFNMS(LDK(KP342020143), Ty, VFNMS(LDK(KP150383733), Tw, VFNMS(LDK(KP984807753), Tv, VMUL(LDK(KP813797681), Tz)))), TD));
	       TQ = VSUB(TO, TP);
	       TR = VADD(TO, TP);
	       ST(&(x[WS(ios, 7)]), TQ, dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 2)]), TR, dist, &(x[0]));
	  }
	  {
	       V TC, TK, TH, TL, TB, TG;
	       TB = VADD(Tx, TA);
	       TC = VADD(Tu, TB);
	       TK = VFMA(LDK(KP866025403), VSUB(TE, TF), VFNMS(LDK(KP500000000), TB, Tu));
	       TG = VADD(TE, TF);
	       TH = VBYI(VADD(TD, TG));
	       TL = VBYI(VADD(TD, VFNMS(LDK(KP500000000), TG, VMUL(LDK(KP866025403), VSUB(TA, Tx)))));
	       {
		    V TI, TN, TJ, TM;
		    TI = VSUB(TC, TH);
		    ST(&(x[WS(ios, 8)]), TI, dist, &(x[0]));
		    TN = VADD(TK, TL);
		    ST(&(x[WS(ios, 4)]), TN, dist, &(x[0]));
		    TJ = VADD(TH, TC);
		    ST(&(x[WS(ios, 1)]), TJ, dist, &(x[WS(ios, 1)]));
		    TM = VSUB(TK, TL);
		    ST(&(x[WS(ios, 5)]), TM, dist, &(x[WS(ios, 1)]));
	       }
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     VTW(8),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 9, "t1fv_9", twinstr, {38, 26, 16, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1fv_9) (planner *p) {
     X(kdft_dit_register) (p, t1fv_9, &desc);
}
