/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 17:51:42 EDT 2003 */

#include "codelet-rdft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_hc2hc -compact -variables 4 -sign 1 -n 32 -dif -name hb_32 -include hb.h */

/*
 * This function contains 434 FP additions, 208 FP multiplications,
 * (or, 340 additions, 114 multiplications, 94 fused multiply/add),
 * 98 stack variables, and 128 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.9 2003/04/17 19:25:50 athena Exp $
 */

#include "hb.h"

static const R *hb_32(R *rio, R *iio, const R *W, stride ios, int m, int dist)
{
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     int i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 62) {
	  E T5n, T6y, T77, T5u, Tf, T3i, T5x, T76, T3G, T47, T1a, T2I, T5k, T6z, T2o;
	  E T2Y, Tu, T3D, T6D, T73, T6G, T74, T1j, T2d, T1s, T2e, T55, T5z, T5c, T5A;
	  E T3l, T48, TK, T3n, T6L, T7t, T6O, T7s, T1D, T2L, T1M, T2M, T4w, T62, T4D;
	  E T61, T3q, T41, TZ, T3s, T6S, T7w, T6V, T7v, T1W, T2O, T25, T2P, T4P, T64;
	  E T4W, T65, T3v, T42;
	  {
	       E T3, T5l, T2j, T5t, T6, T5s, T2m, T5m, Ta, T5i, T15, T5h, Td, T5e, T18;
	       E T5f;
	       {
		    E T1, T2, T2h, T2i;
		    T1 = rio[0];
		    T2 = iio[-WS(ios, 16)];
		    T3 = T1 + T2;
		    T5l = T1 - T2;
		    T2h = iio[0];
		    T2i = rio[WS(ios, 16)];
		    T2j = T2h - T2i;
		    T5t = T2h + T2i;
	       }
	       {
		    E T4, T5, T2k, T2l;
		    T4 = rio[WS(ios, 8)];
		    T5 = iio[-WS(ios, 24)];
		    T6 = T4 + T5;
		    T5s = T4 - T5;
		    T2k = iio[-WS(ios, 8)];
		    T2l = rio[WS(ios, 24)];
		    T2m = T2k - T2l;
		    T5m = T2k + T2l;
	       }
	       {
		    E T8, T9, T13, T14;
		    T8 = rio[WS(ios, 4)];
		    T9 = iio[-WS(ios, 20)];
		    Ta = T8 + T9;
		    T5i = T8 - T9;
		    T13 = iio[-WS(ios, 4)];
		    T14 = rio[WS(ios, 20)];
		    T15 = T13 - T14;
		    T5h = T13 + T14;
	       }
	       {
		    E Tb, Tc, T16, T17;
		    Tb = iio[-WS(ios, 28)];
		    Tc = rio[WS(ios, 12)];
		    Td = Tb + Tc;
		    T5e = Tb - Tc;
		    T16 = iio[-WS(ios, 12)];
		    T17 = rio[WS(ios, 28)];
		    T18 = T16 - T17;
		    T5f = T17 + T16;
	       }
	       {
		    E T7, Te, T12, T19;
		    T5n = T5l - T5m;
		    T6y = T5t - T5s;
		    T77 = T5l + T5m;
		    T5u = T5s + T5t;
		    T7 = T3 + T6;
		    Te = Ta + Td;
		    Tf = T7 + Te;
		    T3i = T7 - Te;
		    {
			 E T5v, T5w, T3E, T3F;
			 T5v = T5i + T5h;
			 T5w = T5e + T5f;
			 T5x = KP707106781 * (T5v - T5w);
			 T76 = KP707106781 * (T5v + T5w);
			 T3E = T2j + T2m;
			 T3F = T15 + T18;
			 T3G = T3E - T3F;
			 T47 = T3F + T3E;
		    }
		    T12 = T3 - T6;
		    T19 = T15 - T18;
		    T1a = T12 + T19;
		    T2I = T12 - T19;
		    {
			 E T5g, T5j, T2g, T2n;
			 T5g = T5e - T5f;
			 T5j = T5h - T5i;
			 T5k = KP707106781 * (T5g - T5j);
			 T6z = KP707106781 * (T5j + T5g);
			 T2g = Td - Ta;
			 T2n = T2j - T2m;
			 T2o = T2g + T2n;
			 T2Y = T2n - T2g;
		    }
	       }
	  }
	  {
	       E Ti, T4Z, T1e, T53, Tl, T52, T1h, T50, Tp, T56, T1n, T5a, Ts, T59, T1q;
	       E T57;
	       {
		    E Tg, Th, T1c, T1d;
		    Tg = rio[WS(ios, 2)];
		    Th = iio[-WS(ios, 18)];
		    Ti = Tg + Th;
		    T4Z = Tg - Th;
		    T1c = iio[-WS(ios, 2)];
		    T1d = rio[WS(ios, 18)];
		    T1e = T1c - T1d;
		    T53 = T1c + T1d;
	       }
	       {
		    E Tj, Tk, T1f, T1g;
		    Tj = rio[WS(ios, 10)];
		    Tk = iio[-WS(ios, 26)];
		    Tl = Tj + Tk;
		    T52 = Tj - Tk;
		    T1f = iio[-WS(ios, 10)];
		    T1g = rio[WS(ios, 26)];
		    T1h = T1f - T1g;
		    T50 = T1f + T1g;
	       }
	       {
		    E Tn, To, T1l, T1m;
		    Tn = iio[-WS(ios, 30)];
		    To = rio[WS(ios, 14)];
		    Tp = Tn + To;
		    T56 = Tn - To;
		    T1l = iio[-WS(ios, 14)];
		    T1m = rio[WS(ios, 30)];
		    T1n = T1l - T1m;
		    T5a = T1m + T1l;
	       }
	       {
		    E Tq, Tr, T1o, T1p;
		    Tq = rio[WS(ios, 6)];
		    Tr = iio[-WS(ios, 22)];
		    Ts = Tq + Tr;
		    T59 = Tq - Tr;
		    T1o = iio[-WS(ios, 6)];
		    T1p = rio[WS(ios, 22)];
		    T1q = T1o - T1p;
		    T57 = T1o + T1p;
	       }
	       {
		    E Tm, Tt, T6B, T6C;
		    Tm = Ti + Tl;
		    Tt = Tp + Ts;
		    Tu = Tm + Tt;
		    T3D = Tt - Tm;
		    T6B = T53 - T52;
		    T6C = T4Z + T50;
		    T6D = FNMS(KP382683432, T6C, KP923879532 * T6B);
		    T73 = FMA(KP382683432, T6B, KP923879532 * T6C);
	       }
	       {
		    E T6E, T6F, T1b, T1i;
		    T6E = T56 + T57;
		    T6F = T59 + T5a;
		    T6G = FNMS(KP923879532, T6F, KP382683432 * T6E);
		    T74 = FMA(KP923879532, T6E, KP382683432 * T6F);
		    T1b = Ti - Tl;
		    T1i = T1e - T1h;
		    T1j = T1b + T1i;
		    T2d = T1i - T1b;
	       }
	       {
		    E T1k, T1r, T51, T54;
		    T1k = Tp - Ts;
		    T1r = T1n - T1q;
		    T1s = T1k - T1r;
		    T2e = T1k + T1r;
		    T51 = T4Z - T50;
		    T54 = T52 + T53;
		    T55 = FNMS(KP382683432, T54, KP923879532 * T51);
		    T5z = FMA(KP923879532, T54, KP382683432 * T51);
	       }
	       {
		    E T58, T5b, T3j, T3k;
		    T58 = T56 - T57;
		    T5b = T59 - T5a;
		    T5c = FMA(KP923879532, T58, KP382683432 * T5b);
		    T5A = FNMS(KP382683432, T58, KP923879532 * T5b);
		    T3j = T1e + T1h;
		    T3k = T1q + T1n;
		    T3l = T3j - T3k;
		    T48 = T3j + T3k;
	       }
	  }
	  {
	       E Ty, T4t, T1H, T4y, TB, T4x, T1K, T4u, TI, T4B, T1B, T4o, TF, T4A, T1y;
	       E T4r;
	       {
		    E Tw, Tx, T1I, T1J;
		    Tw = rio[WS(ios, 1)];
		    Tx = iio[-WS(ios, 17)];
		    Ty = Tw + Tx;
		    T4t = Tw - Tx;
		    {
			 E T1F, T1G, Tz, TA;
			 T1F = iio[-WS(ios, 1)];
			 T1G = rio[WS(ios, 17)];
			 T1H = T1F - T1G;
			 T4y = T1F + T1G;
			 Tz = rio[WS(ios, 9)];
			 TA = iio[-WS(ios, 25)];
			 TB = Tz + TA;
			 T4x = Tz - TA;
		    }
		    T1I = iio[-WS(ios, 9)];
		    T1J = rio[WS(ios, 25)];
		    T1K = T1I - T1J;
		    T4u = T1I + T1J;
		    {
			 E TG, TH, T4m, T1z, T1A, T4n;
			 TG = iio[-WS(ios, 29)];
			 TH = rio[WS(ios, 13)];
			 T4m = TG - TH;
			 T1z = iio[-WS(ios, 13)];
			 T1A = rio[WS(ios, 29)];
			 T4n = T1A + T1z;
			 TI = TG + TH;
			 T4B = T4m + T4n;
			 T1B = T1z - T1A;
			 T4o = T4m - T4n;
		    }
		    {
			 E TD, TE, T4q, T1w, T1x, T4p;
			 TD = rio[WS(ios, 5)];
			 TE = iio[-WS(ios, 21)];
			 T4q = TD - TE;
			 T1w = iio[-WS(ios, 5)];
			 T1x = rio[WS(ios, 21)];
			 T4p = T1w + T1x;
			 TF = TD + TE;
			 T4A = T4q + T4p;
			 T1y = T1w - T1x;
			 T4r = T4p - T4q;
		    }
	       }
	       {
		    E TC, TJ, T6J, T6K;
		    TC = Ty + TB;
		    TJ = TF + TI;
		    TK = TC + TJ;
		    T3n = TC - TJ;
		    T6J = T4y - T4x;
		    T6K = KP707106781 * (T4r + T4o);
		    T6L = T6J + T6K;
		    T7t = T6J - T6K;
	       }
	       {
		    E T6M, T6N, T1v, T1C;
		    T6M = KP707106781 * (T4A + T4B);
		    T6N = T4t + T4u;
		    T6O = T6M + T6N;
		    T7s = T6N - T6M;
		    T1v = Ty - TB;
		    T1C = T1y - T1B;
		    T1D = T1v + T1C;
		    T2L = T1v - T1C;
	       }
	       {
		    E T1E, T1L, T4s, T4v;
		    T1E = TI - TF;
		    T1L = T1H - T1K;
		    T1M = T1E + T1L;
		    T2M = T1L - T1E;
		    T4s = KP707106781 * (T4o - T4r);
		    T4v = T4t - T4u;
		    T4w = T4s + T4v;
		    T62 = T4v - T4s;
	       }
	       {
		    E T4z, T4C, T3o, T3p;
		    T4z = T4x + T4y;
		    T4C = KP707106781 * (T4A - T4B);
		    T4D = T4z + T4C;
		    T61 = T4z - T4C;
		    T3o = T1H + T1K;
		    T3p = T1y + T1B;
		    T3q = T3o - T3p;
		    T41 = T3p + T3o;
	       }
	  }
	  {
	       E TN, T4T, T20, T4N, TQ, T4M, T23, T4U, TX, T4Q, T1U, T4K, TU, T4R, T1R;
	       E T4H;
	       {
		    E TL, TM, T21, T22;
		    TL = iio[-WS(ios, 31)];
		    TM = rio[WS(ios, 15)];
		    TN = TL + TM;
		    T4T = TL - TM;
		    {
			 E T1Y, T1Z, TO, TP;
			 T1Y = iio[-WS(ios, 15)];
			 T1Z = rio[WS(ios, 31)];
			 T20 = T1Y - T1Z;
			 T4N = T1Z + T1Y;
			 TO = rio[WS(ios, 7)];
			 TP = iio[-WS(ios, 23)];
			 TQ = TO + TP;
			 T4M = TO - TP;
		    }
		    T21 = iio[-WS(ios, 7)];
		    T22 = rio[WS(ios, 23)];
		    T23 = T21 - T22;
		    T4U = T21 + T22;
		    {
			 E TV, TW, T4I, T1S, T1T, T4J;
			 TV = iio[-WS(ios, 27)];
			 TW = rio[WS(ios, 11)];
			 T4I = TV - TW;
			 T1S = iio[-WS(ios, 11)];
			 T1T = rio[WS(ios, 27)];
			 T4J = T1T + T1S;
			 TX = TV + TW;
			 T4Q = T4I - T4J;
			 T1U = T1S - T1T;
			 T4K = T4I + T4J;
		    }
		    {
			 E TS, TT, T4F, T1P, T1Q, T4G;
			 TS = rio[WS(ios, 3)];
			 TT = iio[-WS(ios, 19)];
			 T4F = TS - TT;
			 T1P = iio[-WS(ios, 3)];
			 T1Q = rio[WS(ios, 19)];
			 T4G = T1P + T1Q;
			 TU = TS + TT;
			 T4R = T4G - T4F;
			 T1R = T1P - T1Q;
			 T4H = T4F + T4G;
		    }
	       }
	       {
		    E TR, TY, T6Q, T6R;
		    TR = TN + TQ;
		    TY = TU + TX;
		    TZ = TR + TY;
		    T3s = TR - TY;
		    T6Q = KP707106781 * (T4R + T4Q);
		    T6R = T4M + T4N;
		    T6S = T6Q - T6R;
		    T7w = T6Q + T6R;
	       }
	       {
		    E T6T, T6U, T1O, T1V;
		    T6T = KP707106781 * (T4H + T4K);
		    T6U = T4T + T4U;
		    T6V = T6T + T6U;
		    T7v = T6U - T6T;
		    T1O = TN - TQ;
		    T1V = T1R - T1U;
		    T1W = T1O + T1V;
		    T2O = T1O - T1V;
	       }
	       {
		    E T1X, T24, T4L, T4O;
		    T1X = TX - TU;
		    T24 = T20 - T23;
		    T25 = T1X + T24;
		    T2P = T24 - T1X;
		    T4L = KP707106781 * (T4H - T4K);
		    T4O = T4M - T4N;
		    T4P = T4L + T4O;
		    T64 = T4O - T4L;
	       }
	       {
		    E T4S, T4V, T3t, T3u;
		    T4S = KP707106781 * (T4Q - T4R);
		    T4V = T4T - T4U;
		    T4W = T4S + T4V;
		    T65 = T4V - T4S;
		    T3t = T20 + T23;
		    T3u = T1R + T1U;
		    T3v = T3t - T3u;
		    T42 = T3u + T3t;
	       }
	  }
	  {
	       E Tv, T10, T4g, T4i, T4j, T4k, T4f, T4h;
	       Tv = Tf + Tu;
	       T10 = TK + TZ;
	       T4g = Tv - T10;
	       T4i = T48 + T47;
	       T4j = T41 + T42;
	       T4k = T4i - T4j;
	       rio[0] = Tv + T10;
	       iio[-WS(ios, 31)] = T4j + T4i;
	       T4f = W[30];
	       T4h = W[31];
	       rio[WS(ios, 16)] = FNMS(T4h, T4k, T4f * T4g);
	       iio[-WS(ios, 15)] = FMA(T4h, T4g, T4f * T4k);
	  }
	  {
	       E T44, T4c, T4a, T4e;
	       {
		    E T40, T43, T46, T49;
		    T40 = Tf - Tu;
		    T43 = T41 - T42;
		    T44 = T40 + T43;
		    T4c = T40 - T43;
		    T46 = TZ - TK;
		    T49 = T47 - T48;
		    T4a = T46 + T49;
		    T4e = T49 - T46;
	       }
	       {
		    E T3Z, T45, T4b, T4d;
		    T3Z = W[46];
		    T45 = W[47];
		    rio[WS(ios, 24)] = FNMS(T45, T4a, T3Z * T44);
		    iio[-WS(ios, 7)] = FMA(T45, T44, T3Z * T4a);
		    T4b = W[14];
		    T4d = W[15];
		    rio[WS(ios, 8)] = FNMS(T4d, T4e, T4b * T4c);
		    iio[-WS(ios, 23)] = FMA(T4d, T4c, T4b * T4e);
	       }
	  }
	  {
	       E T3m, T3H, T3T, T3O, T3C, T3P, T3x, T3S;
	       T3m = T3i + T3l;
	       T3H = T3D + T3G;
	       T3T = T3G - T3D;
	       T3O = T3i - T3l;
	       {
		    E T3A, T3B, T3r, T3w;
		    T3A = T3q - T3n;
		    T3B = T3s + T3v;
		    T3C = KP707106781 * (T3A + T3B);
		    T3P = KP707106781 * (T3B - T3A);
		    T3r = T3n + T3q;
		    T3w = T3s - T3v;
		    T3x = KP707106781 * (T3r + T3w);
		    T3S = KP707106781 * (T3r - T3w);
	       }
	       {
		    E T3y, T3I, T3h, T3z;
		    T3y = T3m + T3x;
		    T3I = T3C + T3H;
		    T3h = W[54];
		    T3z = W[55];
		    rio[WS(ios, 28)] = FNMS(T3z, T3I, T3h * T3y);
		    iio[-WS(ios, 3)] = FMA(T3z, T3y, T3h * T3I);
	       }
	       {
		    E T3W, T3Y, T3V, T3X;
		    T3W = T3O - T3P;
		    T3Y = T3T - T3S;
		    T3V = W[38];
		    T3X = W[39];
		    rio[WS(ios, 20)] = FNMS(T3X, T3Y, T3V * T3W);
		    iio[-WS(ios, 11)] = FMA(T3X, T3W, T3V * T3Y);
	       }
	       {
		    E T3K, T3M, T3J, T3L;
		    T3K = T3m - T3x;
		    T3M = T3H - T3C;
		    T3J = W[22];
		    T3L = W[23];
		    rio[WS(ios, 12)] = FNMS(T3L, T3M, T3J * T3K);
		    iio[-WS(ios, 19)] = FMA(T3L, T3K, T3J * T3M);
	       }
	       {
		    E T3Q, T3U, T3N, T3R;
		    T3Q = T3O + T3P;
		    T3U = T3S + T3T;
		    T3N = W[6];
		    T3R = W[7];
		    rio[WS(ios, 4)] = FNMS(T3R, T3U, T3N * T3Q);
		    iio[-WS(ios, 27)] = FMA(T3R, T3Q, T3N * T3U);
	       }
	  }
	  {
	       E T2K, T36, T2Z, T3b, T2R, T3a, T2W, T37, T2J, T2X;
	       T2J = KP707106781 * (T2e - T2d);
	       T2K = T2I + T2J;
	       T36 = T2I - T2J;
	       T2X = KP707106781 * (T1j - T1s);
	       T2Z = T2X + T2Y;
	       T3b = T2Y - T2X;
	       {
		    E T2N, T2Q, T2U, T2V;
		    T2N = FNMS(KP382683432, T2M, KP923879532 * T2L);
		    T2Q = FMA(KP923879532, T2O, KP382683432 * T2P);
		    T2R = T2N + T2Q;
		    T3a = T2Q - T2N;
		    T2U = FMA(KP382683432, T2L, KP923879532 * T2M);
		    T2V = FNMS(KP382683432, T2O, KP923879532 * T2P);
		    T2W = T2U + T2V;
		    T37 = T2U - T2V;
	       }
	       {
		    E T2S, T30, T2H, T2T;
		    T2S = T2K + T2R;
		    T30 = T2W + T2Z;
		    T2H = W[2];
		    T2T = W[3];
		    rio[WS(ios, 2)] = FNMS(T2T, T30, T2H * T2S);
		    iio[-WS(ios, 29)] = FMA(T2T, T2S, T2H * T30);
	       }
	       {
		    E T3e, T3g, T3d, T3f;
		    T3e = T36 - T37;
		    T3g = T3b - T3a;
		    T3d = W[18];
		    T3f = W[19];
		    rio[WS(ios, 10)] = FNMS(T3f, T3g, T3d * T3e);
		    iio[-WS(ios, 21)] = FMA(T3f, T3e, T3d * T3g);
	       }
	       {
		    E T32, T34, T31, T33;
		    T32 = T2K - T2R;
		    T34 = T2Z - T2W;
		    T31 = W[34];
		    T33 = W[35];
		    rio[WS(ios, 18)] = FNMS(T33, T34, T31 * T32);
		    iio[-WS(ios, 13)] = FMA(T33, T32, T31 * T34);
	       }
	       {
		    E T38, T3c, T35, T39;
		    T38 = T36 + T37;
		    T3c = T3a + T3b;
		    T35 = W[50];
		    T39 = W[51];
		    rio[WS(ios, 26)] = FNMS(T39, T3c, T35 * T38);
		    iio[-WS(ios, 5)] = FMA(T39, T38, T35 * T3c);
	       }
	  }
	  {
	       E T1u, T2w, T2p, T2B, T27, T2A, T2c, T2x, T1t, T2f;
	       T1t = KP707106781 * (T1j + T1s);
	       T1u = T1a + T1t;
	       T2w = T1a - T1t;
	       T2f = KP707106781 * (T2d + T2e);
	       T2p = T2f + T2o;
	       T2B = T2o - T2f;
	       {
		    E T1N, T26, T2a, T2b;
		    T1N = FMA(KP923879532, T1D, KP382683432 * T1M);
		    T26 = FNMS(KP382683432, T25, KP923879532 * T1W);
		    T27 = T1N + T26;
		    T2A = T1N - T26;
		    T2a = FNMS(KP382683432, T1D, KP923879532 * T1M);
		    T2b = FMA(KP382683432, T1W, KP923879532 * T25);
		    T2c = T2a + T2b;
		    T2x = T2b - T2a;
	       }
	       {
		    E T28, T2q, T11, T29;
		    T28 = T1u + T27;
		    T2q = T2c + T2p;
		    T11 = W[58];
		    T29 = W[59];
		    rio[WS(ios, 30)] = FNMS(T29, T2q, T11 * T28);
		    iio[-WS(ios, 1)] = FMA(T29, T28, T11 * T2q);
	       }
	       {
		    E T2E, T2G, T2D, T2F;
		    T2E = T2w - T2x;
		    T2G = T2B - T2A;
		    T2D = W[42];
		    T2F = W[43];
		    rio[WS(ios, 22)] = FNMS(T2F, T2G, T2D * T2E);
		    iio[-WS(ios, 9)] = FMA(T2F, T2E, T2D * T2G);
	       }
	       {
		    E T2s, T2u, T2r, T2t;
		    T2s = T1u - T27;
		    T2u = T2p - T2c;
		    T2r = W[26];
		    T2t = W[27];
		    rio[WS(ios, 14)] = FNMS(T2t, T2u, T2r * T2s);
		    iio[-WS(ios, 17)] = FMA(T2t, T2s, T2r * T2u);
	       }
	       {
		    E T2y, T2C, T2v, T2z;
		    T2y = T2w + T2x;
		    T2C = T2A + T2B;
		    T2v = W[10];
		    T2z = W[11];
		    rio[WS(ios, 6)] = FNMS(T2z, T2C, T2v * T2y);
		    iio[-WS(ios, 25)] = FMA(T2z, T2y, T2v * T2C);
	       }
	  }
	  {
	       E T4Y, T5N, T5F, T5Q, T5p, T5R, T5C, T5M;
	       {
		    E T4E, T4X, T5D, T5E;
		    T4E = FNMS(KP195090322, T4D, KP980785280 * T4w);
		    T4X = FMA(KP195090322, T4P, KP980785280 * T4W);
		    T4Y = T4E + T4X;
		    T5N = T4X - T4E;
		    T5D = FMA(KP980785280, T4D, KP195090322 * T4w);
		    T5E = FNMS(KP195090322, T4W, KP980785280 * T4P);
		    T5F = T5D + T5E;
		    T5Q = T5D - T5E;
	       }
	       {
		    E T5d, T5o, T5y, T5B;
		    T5d = T55 + T5c;
		    T5o = T5k + T5n;
		    T5p = T5d + T5o;
		    T5R = T5o - T5d;
		    T5y = T5u + T5x;
		    T5B = T5z + T5A;
		    T5C = T5y + T5B;
		    T5M = T5y - T5B;
	       }
	       {
		    E T5q, T5G, T4l, T5r;
		    T5q = T4Y + T5p;
		    T5G = T5C + T5F;
		    T4l = W[0];
		    T5r = W[1];
		    rio[WS(ios, 1)] = FNMS(T5r, T5G, T4l * T5q);
		    iio[-WS(ios, 30)] = FMA(T4l, T5G, T5r * T5q);
	       }
	       {
		    E T5U, T5W, T5T, T5V;
		    T5U = T5R - T5Q;
		    T5W = T5M - T5N;
		    T5T = W[16];
		    T5V = W[17];
		    rio[WS(ios, 9)] = FNMS(T5V, T5W, T5T * T5U);
		    iio[-WS(ios, 22)] = FMA(T5T, T5W, T5V * T5U);
	       }
	       {
		    E T5I, T5K, T5H, T5J;
		    T5I = T5C - T5F;
		    T5K = T5p - T4Y;
		    T5H = W[32];
		    T5J = W[33];
		    iio[-WS(ios, 14)] = FMA(T5H, T5I, T5J * T5K);
		    rio[WS(ios, 17)] = FNMS(T5J, T5I, T5H * T5K);
	       }
	       {
		    E T5O, T5S, T5L, T5P;
		    T5O = T5M + T5N;
		    T5S = T5Q + T5R;
		    T5L = W[48];
		    T5P = W[49];
		    iio[-WS(ios, 6)] = FMA(T5L, T5O, T5P * T5S);
		    rio[WS(ios, 25)] = FNMS(T5P, T5O, T5L * T5S);
	       }
	  }
	  {
	       E T60, T6q, T6f, T6n, T67, T6m, T6c, T6r;
	       {
		    E T5Y, T5Z, T6d, T6e;
		    T5Y = T5u - T5x;
		    T5Z = T5c - T55;
		    T60 = T5Y + T5Z;
		    T6q = T5Y - T5Z;
		    T6d = T5z - T5A;
		    T6e = T5n - T5k;
		    T6f = T6d + T6e;
		    T6n = T6e - T6d;
	       }
	       {
		    E T63, T66, T6a, T6b;
		    T63 = FNMS(KP555570233, T62, KP831469612 * T61);
		    T66 = FMA(KP831469612, T64, KP555570233 * T65);
		    T67 = T63 + T66;
		    T6m = T66 - T63;
		    T6a = FMA(KP555570233, T61, KP831469612 * T62);
		    T6b = FNMS(KP555570233, T64, KP831469612 * T65);
		    T6c = T6a + T6b;
		    T6r = T6a - T6b;
	       }
	       {
		    E T68, T6g, T5X, T69;
		    T68 = T60 + T67;
		    T6g = T6c + T6f;
		    T5X = W[56];
		    T69 = W[57];
		    iio[-WS(ios, 2)] = FMA(T5X, T68, T69 * T6g);
		    rio[WS(ios, 29)] = FNMS(T69, T68, T5X * T6g);
	       }
	       {
		    E T6u, T6w, T6t, T6v;
		    T6u = T6q - T6r;
		    T6w = T6n - T6m;
		    T6t = W[40];
		    T6v = W[41];
		    iio[-WS(ios, 10)] = FMA(T6t, T6u, T6v * T6w);
		    rio[WS(ios, 21)] = FNMS(T6v, T6u, T6t * T6w);
	       }
	       {
		    E T6i, T6k, T6h, T6j;
		    T6i = T6f - T6c;
		    T6k = T60 - T67;
		    T6h = W[24];
		    T6j = W[25];
		    rio[WS(ios, 13)] = FNMS(T6j, T6k, T6h * T6i);
		    iio[-WS(ios, 18)] = FMA(T6h, T6k, T6j * T6i);
	       }
	       {
		    E T6o, T6s, T6l, T6p;
		    T6o = T6m + T6n;
		    T6s = T6q + T6r;
		    T6l = W[8];
		    T6p = W[9];
		    rio[WS(ios, 5)] = FNMS(T6p, T6s, T6l * T6o);
		    iio[-WS(ios, 26)] = FMA(T6l, T6s, T6p * T6o);
	       }
	  }
	  {
	       E T7y, T7R, T7J, T7U, T7B, T7V, T7G, T7Q;
	       {
		    E T7u, T7x, T7H, T7I;
		    T7u = FNMS(KP555570233, T7t, KP831469612 * T7s);
		    T7x = FNMS(KP555570233, T7w, KP831469612 * T7v);
		    T7y = T7u + T7x;
		    T7R = T7x - T7u;
		    T7H = FMA(KP831469612, T7t, KP555570233 * T7s);
		    T7I = FMA(KP831469612, T7w, KP555570233 * T7v);
		    T7J = T7H - T7I;
		    T7U = T7H + T7I;
	       }
	       {
		    E T7z, T7A, T7E, T7F;
		    T7z = T6G - T6D;
		    T7A = T77 - T76;
		    T7B = T7z + T7A;
		    T7V = T7A - T7z;
		    T7E = T6y - T6z;
		    T7F = T73 - T74;
		    T7G = T7E + T7F;
		    T7Q = T7E - T7F;
	       }
	       {
		    E T7C, T7K, T7r, T7D;
		    T7C = T7y + T7B;
		    T7K = T7G + T7J;
		    T7r = W[4];
		    T7D = W[5];
		    rio[WS(ios, 3)] = FNMS(T7D, T7K, T7r * T7C);
		    iio[-WS(ios, 28)] = FMA(T7r, T7K, T7D * T7C);
	       }
	       {
		    E T7Y, T80, T7X, T7Z;
		    T7Y = T7V - T7U;
		    T80 = T7Q - T7R;
		    T7X = W[20];
		    T7Z = W[21];
		    rio[WS(ios, 11)] = FNMS(T7Z, T80, T7X * T7Y);
		    iio[-WS(ios, 20)] = FMA(T7X, T80, T7Z * T7Y);
	       }
	       {
		    E T7M, T7O, T7L, T7N;
		    T7M = T7G - T7J;
		    T7O = T7B - T7y;
		    T7L = W[36];
		    T7N = W[37];
		    iio[-WS(ios, 12)] = FMA(T7L, T7M, T7N * T7O);
		    rio[WS(ios, 19)] = FNMS(T7N, T7M, T7L * T7O);
	       }
	       {
		    E T7S, T7W, T7P, T7T;
		    T7S = T7Q + T7R;
		    T7W = T7U + T7V;
		    T7P = W[52];
		    T7T = W[53];
		    iio[-WS(ios, 4)] = FMA(T7P, T7S, T7T * T7W);
		    rio[WS(ios, 27)] = FNMS(T7T, T7S, T7P * T7W);
	       }
	  }
	  {
	       E T6I, T7k, T79, T7h, T6X, T7g, T72, T7l;
	       {
		    E T6A, T6H, T75, T78;
		    T6A = T6y + T6z;
		    T6H = T6D + T6G;
		    T6I = T6A + T6H;
		    T7k = T6A - T6H;
		    T75 = T73 + T74;
		    T78 = T76 + T77;
		    T79 = T75 + T78;
		    T7h = T78 - T75;
	       }
	       {
		    E T6P, T6W, T70, T71;
		    T6P = FNMS(KP195090322, T6O, KP980785280 * T6L);
		    T6W = FMA(KP980785280, T6S, KP195090322 * T6V);
		    T6X = T6P + T6W;
		    T7g = T6W - T6P;
		    T70 = FMA(KP195090322, T6L, KP980785280 * T6O);
		    T71 = FNMS(KP195090322, T6S, KP980785280 * T6V);
		    T72 = T70 + T71;
		    T7l = T70 - T71;
	       }
	       {
		    E T6Y, T7a, T6x, T6Z;
		    T6Y = T6I + T6X;
		    T7a = T72 + T79;
		    T6x = W[60];
		    T6Z = W[61];
		    iio[0] = FMA(T6x, T6Y, T6Z * T7a);
		    rio[WS(ios, 31)] = FNMS(T6Z, T6Y, T6x * T7a);
	       }
	       {
		    E T7o, T7q, T7n, T7p;
		    T7o = T7k - T7l;
		    T7q = T7h - T7g;
		    T7n = W[44];
		    T7p = W[45];
		    iio[-WS(ios, 8)] = FMA(T7n, T7o, T7p * T7q);
		    rio[WS(ios, 23)] = FNMS(T7p, T7o, T7n * T7q);
	       }
	       {
		    E T7c, T7e, T7b, T7d;
		    T7c = T79 - T72;
		    T7e = T6I - T6X;
		    T7b = W[28];
		    T7d = W[29];
		    rio[WS(ios, 15)] = FNMS(T7d, T7e, T7b * T7c);
		    iio[-WS(ios, 16)] = FMA(T7b, T7e, T7d * T7c);
	       }
	       {
		    E T7i, T7m, T7f, T7j;
		    T7i = T7g + T7h;
		    T7m = T7k + T7l;
		    T7f = W[12];
		    T7j = W[13];
		    rio[WS(ios, 7)] = FNMS(T7j, T7m, T7f * T7i);
		    iio[-WS(ios, 24)] = FMA(T7f, T7m, T7j * T7i);
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 32},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 32, "hb_32", twinstr, {340, 114, 94, 0}, &GENUS, 0, 0, 0 };

void X(codelet_hb_32) (planner *p) {
     X(khc2hc_dif_register) (p, hb_32, &desc);
}
