/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 17:51:15 EDT 2003 */

#include "codelet-rdft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_hc2r -compact -variables 4 -sign 1 -n 14 -name hc2r_14 -include hc2r.h */

/*
 * This function contains 62 FP additions, 38 FP multiplications,
 * (or, 36 additions, 12 multiplications, 26 fused multiply/add),
 * 28 stack variables, and 28 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_hc2r.ml,v 1.14 2003/04/17 19:25:50 athena Exp $
 */

#include "hc2r.h"

static void hc2r_14(const R *ri, const R *ii, R *O, stride ris, stride iis, stride os, int v, int ivs, int ovs)
{
     DK(KP1_801937735, +1.801937735804838252472204639014890102331838324);
     DK(KP445041867, +0.445041867912628808577805128993589518932711138);
     DK(KP1_246979603, +1.246979603717467061050009768008479621264549462);
     DK(KP867767478, +0.867767478235116240951536665696717509219981456);
     DK(KP1_949855824, +1.949855824363647214036263365987862434465571601);
     DK(KP1_563662964, +1.563662964936059617416889053348115500464669037);
     DK(KP2_000000000, +2.000000000000000000000000000000000000000000000);
     int i;
     for (i = v; i > 0; i = i - 1, ri = ri + ivs, ii = ii + ivs, O = O + ovs) {
	  E T3, Td, T6, Te, Tq, Tz, Tn, Ty, Tc, Tg, Tk, Tx, T9, Tf, T1;
	  E T2;
	  T1 = ri[0];
	  T2 = ri[WS(ris, 7)];
	  T3 = T1 - T2;
	  Td = T1 + T2;
	  {
	       E T4, T5, To, Tp;
	       T4 = ri[WS(ris, 2)];
	       T5 = ri[WS(ris, 5)];
	       T6 = T4 - T5;
	       Te = T4 + T5;
	       To = ii[WS(iis, 2)];
	       Tp = ii[WS(iis, 5)];
	       Tq = To - Tp;
	       Tz = To + Tp;
	  }
	  {
	       E Tl, Tm, Ta, Tb;
	       Tl = ii[WS(iis, 6)];
	       Tm = ii[WS(iis, 1)];
	       Tn = Tl - Tm;
	       Ty = Tl + Tm;
	       Ta = ri[WS(ris, 6)];
	       Tb = ri[WS(ris, 1)];
	       Tc = Ta - Tb;
	       Tg = Ta + Tb;
	  }
	  {
	       E Ti, Tj, T7, T8;
	       Ti = ii[WS(iis, 4)];
	       Tj = ii[WS(iis, 3)];
	       Tk = Ti - Tj;
	       Tx = Ti + Tj;
	       T7 = ri[WS(ris, 4)];
	       T8 = ri[WS(ris, 3)];
	       T9 = T7 - T8;
	       Tf = T7 + T8;
	  }
	  O[WS(os, 7)] = FMA(KP2_000000000, T6 + T9 + Tc, T3);
	  O[0] = FMA(KP2_000000000, Te + Tf + Tg, Td);
	  {
	       E Tr, Th, TE, TD;
	       Tr = FNMS(KP1_949855824, Tn, KP1_563662964 * Tk) - (KP867767478 * Tq);
	       Th = FMA(KP1_246979603, Tf, Td) + FNMA(KP445041867, Tg, KP1_801937735 * Te);
	       O[WS(os, 4)] = Th - Tr;
	       O[WS(os, 10)] = Th + Tr;
	       TE = FMA(KP867767478, Tx, KP1_563662964 * Ty) - (KP1_949855824 * Tz);
	       TD = FMA(KP1_246979603, Tc, T3) + FNMA(KP1_801937735, T9, KP445041867 * T6);
	       O[WS(os, 5)] = TD - TE;
	       O[WS(os, 9)] = TD + TE;
	  }
	  {
	       E Tt, Ts, TA, Tw;
	       Tt = FMA(KP867767478, Tk, KP1_563662964 * Tn) - (KP1_949855824 * Tq);
	       Ts = FMA(KP1_246979603, Tg, Td) + FNMA(KP1_801937735, Tf, KP445041867 * Te);
	       O[WS(os, 12)] = Ts - Tt;
	       O[WS(os, 2)] = Ts + Tt;
	       TA = FNMS(KP1_949855824, Ty, KP1_563662964 * Tx) - (KP867767478 * Tz);
	       Tw = FMA(KP1_246979603, T9, T3) + FNMA(KP445041867, Tc, KP1_801937735 * T6);
	       O[WS(os, 11)] = Tw - TA;
	       O[WS(os, 3)] = Tw + TA;
	  }
	  {
	       E TC, TB, Tv, Tu;
	       TC = FMA(KP1_563662964, Tz, KP1_949855824 * Tx) + (KP867767478 * Ty);
	       TB = FMA(KP1_246979603, T6, T3) + FNMA(KP1_801937735, Tc, KP445041867 * T9);
	       O[WS(os, 1)] = TB - TC;
	       O[WS(os, 13)] = TB + TC;
	       Tv = FMA(KP1_563662964, Tq, KP1_949855824 * Tk) + (KP867767478 * Tn);
	       Tu = FMA(KP1_246979603, Te, Td) + FNMA(KP1_801937735, Tg, KP445041867 * Tf);
	       O[WS(os, 8)] = Tu - Tv;
	       O[WS(os, 6)] = Tu + Tv;
	  }
     }
}

static const khc2r_desc desc = { 14, "hc2r_14", {36, 12, 26, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_hc2r_14) (planner *p) {
     X(khc2r_register) (p, hc2r_14, &desc);
}
