/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 17:37:57 EDT 2003 */

#include "codelet-rdft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_hc2hc -compact -variables 4 -n 5 -dit -name hf_5 -include hf.h */

/*
 * This function contains 40 FP additions, 28 FP multiplications,
 * (or, 26 additions, 14 multiplications, 14 fused multiply/add),
 * 29 stack variables, and 20 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.9 2003/04/17 19:25:50 athena Exp $
 */

#include "hf.h"

static const R *hf_5(R *rio, R *iio, const R *W, stride ios, int m, int dist)
{
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     int i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 8) {
	  E T1, TE, Tu, Tx, TG, TF, TB, TC, TD, Tc, Tn, To;
	  T1 = rio[0];
	  TE = iio[-WS(ios, 4)];
	  {
	       E T6, Ts, Tm, Tw, Tb, Tt, Th, Tv;
	       {
		    E T3, T5, T2, T4;
		    T3 = rio[WS(ios, 1)];
		    T5 = iio[-WS(ios, 3)];
		    T2 = W[0];
		    T4 = W[1];
		    T6 = FMA(T2, T3, T4 * T5);
		    Ts = FNMS(T4, T3, T2 * T5);
	       }
	       {
		    E Tj, Tl, Ti, Tk;
		    Tj = rio[WS(ios, 3)];
		    Tl = iio[-WS(ios, 1)];
		    Ti = W[4];
		    Tk = W[5];
		    Tm = FMA(Ti, Tj, Tk * Tl);
		    Tw = FNMS(Tk, Tj, Ti * Tl);
	       }
	       {
		    E T8, Ta, T7, T9;
		    T8 = rio[WS(ios, 4)];
		    Ta = iio[0];
		    T7 = W[6];
		    T9 = W[7];
		    Tb = FMA(T7, T8, T9 * Ta);
		    Tt = FNMS(T9, T8, T7 * Ta);
	       }
	       {
		    E Te, Tg, Td, Tf;
		    Te = rio[WS(ios, 2)];
		    Tg = iio[-WS(ios, 2)];
		    Td = W[2];
		    Tf = W[3];
		    Th = FMA(Td, Te, Tf * Tg);
		    Tv = FNMS(Tf, Te, Td * Tg);
	       }
	       Tu = Ts - Tt;
	       Tx = Tv - Tw;
	       TG = Th - Tm;
	       TF = Tb - T6;
	       TB = Ts + Tt;
	       TC = Tv + Tw;
	       TD = TB + TC;
	       Tc = T6 + Tb;
	       Tn = Th + Tm;
	       To = Tc + Tn;
	  }
	  rio[0] = T1 + To;
	  iio[0] = TD + TE;
	  {
	       E Ty, TA, Tr, Tz, Tp, Tq;
	       Ty = FMA(KP951056516, Tu, KP587785252 * Tx);
	       TA = FNMS(KP587785252, Tu, KP951056516 * Tx);
	       Tp = KP559016994 * (Tc - Tn);
	       Tq = FNMS(KP250000000, To, T1);
	       Tr = Tp + Tq;
	       Tz = Tq - Tp;
	       iio[-WS(ios, 4)] = Tr - Ty;
	       iio[-WS(ios, 3)] = Tz + TA;
	       rio[WS(ios, 1)] = Tr + Ty;
	       rio[WS(ios, 2)] = Tz - TA;
	  }
	  {
	       E TH, TL, TK, TM, TI, TJ;
	       TH = FNMS(KP587785252, TG, KP951056516 * TF);
	       TL = FMA(KP587785252, TF, KP951056516 * TG);
	       TI = KP559016994 * (TB - TC);
	       TJ = FNMS(KP250000000, TD, TE);
	       TK = TI + TJ;
	       TM = TJ - TI;
	       rio[WS(ios, 4)] = TH - TK;
	       iio[-WS(ios, 2)] = TL + TM;
	       iio[-WS(ios, 1)] = TH + TK;
	       rio[WS(ios, 3)] = TL - TM;
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 5},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 5, "hf_5", twinstr, {26, 14, 14, 0}, &GENUS, 0, 0, 0 };

void X(codelet_hf_5) (planner *p) {
     X(khc2hc_dit_register) (p, hf_5, &desc);
}
