/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 17:28:51 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle -compact -variables 4 -n 5 -name t1_5 -include t.h */

/*
 * This function contains 40 FP additions, 28 FP multiplications,
 * (or, 26 additions, 14 multiplications, 14 fused multiply/add),
 * 29 stack variables, and 20 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle.ml,v 1.16 2003/04/16 19:51:27 athena Exp $
 */

#include "t.h"

static const R *t1_5(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     int i;
     for (i = m; i > 0; i = i - 1, ri = ri + dist, ii = ii + dist, W = W + 8) {
	  E T1, TE, Tu, Tx, TJ, TI, TB, TC, TD, Tc, Tn, To;
	  T1 = ri[0];
	  TE = ii[0];
	  {
	       E T6, Ts, Tm, Tw, Tb, Tt, Th, Tv;
	       {
		    E T3, T5, T2, T4;
		    T3 = ri[WS(ios, 1)];
		    T5 = ii[WS(ios, 1)];
		    T2 = W[0];
		    T4 = W[1];
		    T6 = FMA(T2, T3, T4 * T5);
		    Ts = FNMS(T4, T3, T2 * T5);
	       }
	       {
		    E Tj, Tl, Ti, Tk;
		    Tj = ri[WS(ios, 3)];
		    Tl = ii[WS(ios, 3)];
		    Ti = W[4];
		    Tk = W[5];
		    Tm = FMA(Ti, Tj, Tk * Tl);
		    Tw = FNMS(Tk, Tj, Ti * Tl);
	       }
	       {
		    E T8, Ta, T7, T9;
		    T8 = ri[WS(ios, 4)];
		    Ta = ii[WS(ios, 4)];
		    T7 = W[6];
		    T9 = W[7];
		    Tb = FMA(T7, T8, T9 * Ta);
		    Tt = FNMS(T9, T8, T7 * Ta);
	       }
	       {
		    E Te, Tg, Td, Tf;
		    Te = ri[WS(ios, 2)];
		    Tg = ii[WS(ios, 2)];
		    Td = W[2];
		    Tf = W[3];
		    Th = FMA(Td, Te, Tf * Tg);
		    Tv = FNMS(Tf, Te, Td * Tg);
	       }
	       Tu = Ts - Tt;
	       Tx = Tv - Tw;
	       TJ = Th - Tm;
	       TI = T6 - Tb;
	       TB = Ts + Tt;
	       TC = Tv + Tw;
	       TD = TB + TC;
	       Tc = T6 + Tb;
	       Tn = Th + Tm;
	       To = Tc + Tn;
	  }
	  ri[0] = T1 + To;
	  ii[0] = TD + TE;
	  {
	       E Ty, TA, Tr, Tz, Tp, Tq;
	       Ty = FMA(KP951056516, Tu, KP587785252 * Tx);
	       TA = FNMS(KP587785252, Tu, KP951056516 * Tx);
	       Tp = KP559016994 * (Tc - Tn);
	       Tq = FNMS(KP250000000, To, T1);
	       Tr = Tp + Tq;
	       Tz = Tq - Tp;
	       ri[WS(ios, 4)] = Tr - Ty;
	       ri[WS(ios, 3)] = Tz + TA;
	       ri[WS(ios, 1)] = Tr + Ty;
	       ri[WS(ios, 2)] = Tz - TA;
	  }
	  {
	       E TK, TL, TH, TM, TF, TG;
	       TK = FMA(KP951056516, TI, KP587785252 * TJ);
	       TL = FNMS(KP587785252, TI, KP951056516 * TJ);
	       TF = KP559016994 * (TB - TC);
	       TG = FNMS(KP250000000, TD, TE);
	       TH = TF + TG;
	       TM = TG - TF;
	       ii[WS(ios, 1)] = TH - TK;
	       ii[WS(ios, 3)] = TM - TL;
	       ii[WS(ios, 4)] = TK + TH;
	       ii[WS(ios, 2)] = TL + TM;
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 5},
     {TW_NEXT, 1, 0}
};

static const ct_desc desc = { 5, "t1_5", twinstr, {26, 14, 14, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1_5) (planner *p) {
     X(kdft_dit_register) (p, t1_5, &desc);
}
