/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:01:57 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_c -simd -trivial-stores -compact -variables 4 -sign 1 -n 12 -name n1bv_12 -include n1b.h */

/*
 * This function contains 48 FP additions, 8 FP multiplications,
 * (or, 44 additions, 4 multiplications, 4 fused multiply/add),
 * 29 stack variables, and 24 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_c.ml,v 1.9 2003/04/16 21:21:53 athena Exp $
 */

#include "n1b.h"

static void n1bv_12(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     int i;
     const R *xi;
     R *xo;
     xi = ii;
     xo = io;
     BEGIN_SIMD();
     for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs)) {
	  V Tm, TO, TC, TN, Tb, TE, Ti, TR, TB, TQ, Tt, TF;
	  {
	       V T1, T6, T4, Tk, T9, Tl, T5, Ta;
	       T1 = LD(&(xi[0]), ivs, &(xi[0]));
	       T6 = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
	       {
		    V T2, T3, T7, T8;
		    T2 = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
		    T3 = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
		    T4 = VADD(T2, T3);
		    Tk = VSUB(T2, T3);
		    T7 = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
		    T8 = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
		    T9 = VADD(T7, T8);
		    Tl = VSUB(T7, T8);
	       }
	       Tm = VMUL(LDK(KP866025403), VSUB(Tk, Tl));
	       TO = VADD(T6, T9);
	       TC = VADD(Tk, Tl);
	       TN = VADD(T1, T4);
	       T5 = VFNMS(LDK(KP500000000), T4, T1);
	       Ta = VFNMS(LDK(KP500000000), T9, T6);
	       Tb = VSUB(T5, Ta);
	       TE = VADD(T5, Ta);
	  }
	  {
	       V Tn, Tq, Te, To, Th, Tr, Tp, Ts;
	       Tn = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
	       Tq = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
	       {
		    V Tc, Td, Tf, Tg;
		    Tc = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
		    Td = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
		    Te = VSUB(Tc, Td);
		    To = VADD(Tc, Td);
		    Tf = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
		    Tg = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
		    Th = VSUB(Tf, Tg);
		    Tr = VADD(Tf, Tg);
	       }
	       Ti = VMUL(LDK(KP866025403), VSUB(Te, Th));
	       TR = VADD(Tq, Tr);
	       TB = VADD(Te, Th);
	       TQ = VADD(Tn, To);
	       Tp = VFNMS(LDK(KP500000000), To, Tn);
	       Ts = VFNMS(LDK(KP500000000), Tr, Tq);
	       Tt = VSUB(Tp, Ts);
	       TF = VADD(Tp, Ts);
	  }
	  {
	       V Tv, Tw, Tj, Tu;
	       Tj = VSUB(Tb, Ti);
	       Tu = VBYI(VADD(Tm, Tt));
	       Tv = VSUB(Tj, Tu);
	       Tw = VADD(Tj, Tu);
	       ST(&(xo[WS(os, 11)]), Tv, ovs, &(xo[WS(os, 1)]));
	       ST(&(xo[WS(os, 1)]), Tw, ovs, &(xo[WS(os, 1)]));
	  }
	  {
	       V Tz, TA, Tx, Ty;
	       Tx = VADD(Tb, Ti);
	       Ty = VBYI(VSUB(Tt, Tm));
	       Tz = VSUB(Tx, Ty);
	       TA = VADD(Tx, Ty);
	       ST(&(xo[WS(os, 7)]), Tz, ovs, &(xo[WS(os, 1)]));
	       ST(&(xo[WS(os, 5)]), TA, ovs, &(xo[WS(os, 1)]));
	  }
	  {
	       V TX, TY, TV, TW;
	       TV = VADD(TN, TO);
	       TW = VADD(TQ, TR);
	       TX = VSUB(TV, TW);
	       TY = VADD(TV, TW);
	       ST(&(xo[WS(os, 6)]), TX, ovs, &(xo[0]));
	       ST(&(xo[0]), TY, ovs, &(xo[0]));
	  }
	  {
	       V TT, TU, TP, TS;
	       TP = VSUB(TN, TO);
	       TS = VBYI(VSUB(TQ, TR));
	       TT = VSUB(TP, TS);
	       TU = VADD(TP, TS);
	       ST(&(xo[WS(os, 3)]), TT, ovs, &(xo[WS(os, 1)]));
	       ST(&(xo[WS(os, 9)]), TU, ovs, &(xo[WS(os, 1)]));
	  }
	  {
	       V TL, TM, TJ, TK;
	       TJ = VBYI(VMUL(LDK(KP866025403), VADD(TC, TB)));
	       TK = VADD(TE, TF);
	       TL = VADD(TJ, TK);
	       TM = VSUB(TK, TJ);
	       ST(&(xo[WS(os, 4)]), TL, ovs, &(xo[0]));
	       ST(&(xo[WS(os, 8)]), TM, ovs, &(xo[0]));
	  }
	  {
	       V TH, TI, TD, TG;
	       TD = VBYI(VMUL(LDK(KP866025403), VSUB(TB, TC)));
	       TG = VSUB(TE, TF);
	       TH = VADD(TD, TG);
	       TI = VSUB(TG, TD);
	       ST(&(xo[WS(os, 2)]), TH, ovs, &(xo[0]));
	       ST(&(xo[WS(os, 10)]), TI, ovs, &(xo[0]));
	  }
     }
     END_SIMD();
}

static const kdft_desc desc = { 12, "n1bv_12", {44, 4, 4, 0}, &GENUS, 0, 0, 0, 0 };
void X(codelet_n1bv_12) (planner *p) {
     X(kdft_register) (p, n1bv_12, &desc);
}
