/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:01:44 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_c -simd -trivial-stores -compact -variables 4 -n 3 -name n1fv_3 -include n1f.h */

/*
 * This function contains 6 FP additions, 2 FP multiplications,
 * (or, 5 additions, 1 multiplications, 1 fused multiply/add),
 * 14 stack variables, and 6 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_c.ml,v 1.9 2003/04/16 21:21:53 athena Exp $
 */

#include "n1f.h"

static void n1fv_3(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     int i;
     const R *xi;
     R *xo;
     xi = ri;
     xo = ro;
     BEGIN_SIMD();
     for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs)) {
	  V T1, T4, T6, T7, T2, T3, T5, T9, T8;
	  T1 = LD(&(xi[0]), ivs, &(xi[0]));
	  T2 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
	  T3 = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
	  T4 = VADD(T2, T3);
	  T6 = VFNMS(LDK(KP500000000), T4, T1);
	  T7 = VBYI(VMUL(LDK(KP866025403), VSUB(T3, T2)));
	  T5 = VADD(T1, T4);
	  ST(&(xo[0]), T5, ovs, &(xo[0]));
	  T9 = VADD(T6, T7);
	  ST(&(xo[WS(os, 1)]), T9, ovs, &(xo[WS(os, 1)]));
	  T8 = VSUB(T6, T7);
	  ST(&(xo[WS(os, 2)]), T8, ovs, &(xo[0]));
     }
     END_SIMD();
}

static const kdft_desc desc = { 3, "n1fv_3", {5, 1, 1, 0}, &GENUS, 0, 0, 0, 0 };
void X(codelet_n1fv_3) (planner *p) {
     X(kdft_register) (p, n1fv_3, &desc);
}
