/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:02:27 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_c -simd -trivial-stores -compact -variables 4 -sign 1 -n 14 -name n2bv_14 -with-ostride 2 -include n2b.h */

/*
 * This function contains 74 FP additions, 36 FP multiplications,
 * (or, 50 additions, 12 multiplications, 24 fused multiply/add),
 * 35 stack variables, and 28 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_c.ml,v 1.9 2003/04/16 21:21:53 athena Exp $
 */

#include "n2b.h"

static void n2bv_14(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     DVK(KP900968867, +0.900968867902419126236102319507445051165919162);
     DVK(KP222520933, +0.222520933956314404288902564496794759466355569);
     DVK(KP623489801, +0.623489801858733530525004884004239810632274731);
     DVK(KP781831482, +0.781831482468029808708444526674057750232334519);
     DVK(KP974927912, +0.974927912181823607018131682993931217232785801);
     DVK(KP433883739, +0.433883739117558120475768332848358754609990728);
     int i;
     const R *xi;
     R *xo;
     xi = ii;
     xo = io;
     BEGIN_SIMD();
     for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs)) {
	  V Tp, TF, Tl, TT, Tq, TL, T7, TR, Ts, TI, Te, TS, Tr, TO, Tn;
	  V To, TE, TP;
	  Tn = LD(&(xi[0]), ivs, &(xi[0]));
	  To = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
	  Tp = VSUB(Tn, To);
	  TF = VADD(Tn, To);
	  {
	       V Th, TJ, Tk, TK;
	       {
		    V Tf, Tg, Ti, Tj;
		    Tf = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
		    Tg = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
		    Th = VSUB(Tf, Tg);
		    TJ = VADD(Tf, Tg);
		    Ti = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
		    Tj = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
		    Tk = VSUB(Ti, Tj);
		    TK = VADD(Ti, Tj);
	       }
	       Tl = VSUB(Th, Tk);
	       TT = VSUB(TK, TJ);
	       Tq = VADD(Th, Tk);
	       TL = VADD(TJ, TK);
	  }
	  {
	       V T3, TG, T6, TH;
	       {
		    V T1, T2, T4, T5;
		    T1 = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
		    T2 = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
		    T3 = VSUB(T1, T2);
		    TG = VADD(T1, T2);
		    T4 = LD(&(xi[WS(is, 12)]), ivs, &(xi[0]));
		    T5 = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
		    T6 = VSUB(T4, T5);
		    TH = VADD(T4, T5);
	       }
	       T7 = VSUB(T3, T6);
	       TR = VSUB(TG, TH);
	       Ts = VADD(T3, T6);
	       TI = VADD(TG, TH);
	  }
	  {
	       V Ta, TM, Td, TN;
	       {
		    V T8, T9, Tb, Tc;
		    T8 = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
		    T9 = LD(&(xi[WS(is, 13)]), ivs, &(xi[WS(is, 1)]));
		    Ta = VSUB(T8, T9);
		    TM = VADD(T8, T9);
		    Tb = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
		    Tc = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
		    Td = VSUB(Tb, Tc);
		    TN = VADD(Tb, Tc);
	       }
	       Te = VSUB(Ta, Td);
	       TS = VSUB(TN, TM);
	       Tr = VADD(Ta, Td);
	       TO = VADD(TM, TN);
	  }
	  TE = VADD(Tp, VADD(Ts, VADD(Tq, Tr)));
	  ST(&(xo[14]), TE, ovs, &(xo[2]));
	  TP = VADD(TF, VADD(TI, VADD(TL, TO)));
	  ST(&(xo[0]), TP, ovs, &(xo[0]));
	  {
	       V Tu, Tv, Tm, Tt;
	       Tm = VBYI(VFMA(LDK(KP433883739), T7, VFNMS(LDK(KP781831482), Tl, VMUL(LDK(KP974927912), Te))));
	       Tt = VFMA(LDK(KP623489801), Tq, VFNMS(LDK(KP222520933), Tr, VFNMS(LDK(KP900968867), Ts, Tp)));
	       Tu = VADD(Tm, Tt);
	       Tv = VSUB(Tt, Tm);
	       ST(&(xo[6]), Tu, ovs, &(xo[2]));
	       ST(&(xo[22]), Tv, ovs, &(xo[2]));
	  }
	  {
	       V T13, T14, T12, T11;
	       T12 = VBYI(VFMA(LDK(KP974927912), TR, VFMA(LDK(KP433883739), TT, VMUL(LDK(KP781831482), TS))));
	       T11 = VFMA(LDK(KP623489801), TO, VFNMS(LDK(KP900968867), TL, VFNMS(LDK(KP222520933), TI, TF)));
	       T13 = VSUB(T11, T12);
	       T14 = VADD(T11, T12);
	       ST(&(xo[24]), T13, ovs, &(xo[0]));
	       ST(&(xo[4]), T14, ovs, &(xo[0]));
	  }
	  {
	       V Ty, Tz, Tw, Tx;
	       Tw = VBYI(VFMA(LDK(KP781831482), T7, VFMA(LDK(KP974927912), Tl, VMUL(LDK(KP433883739), Te))));
	       Tx = VFMA(LDK(KP623489801), Ts, VFNMS(LDK(KP900968867), Tr, VFNMS(LDK(KP222520933), Tq, Tp)));
	       Ty = VADD(Tw, Tx);
	       Tz = VSUB(Tx, Tw);
	       ST(&(xo[2]), Ty, ovs, &(xo[2]));
	       ST(&(xo[26]), Tz, ovs, &(xo[2]));
	  }
	  {
	       V TV, TW, TU, TQ;
	       TU = VBYI(VFNMS(LDK(KP433883739), TS, VFNMS(LDK(KP974927912), TT, VMUL(LDK(KP781831482), TR))));
	       TQ = VFMA(LDK(KP623489801), TI, VFNMS(LDK(KP900968867), TO, VFNMS(LDK(KP222520933), TL, TF)));
	       TV = VSUB(TQ, TU);
	       TW = VADD(TQ, TU);
	       ST(&(xo[12]), TV, ovs, &(xo[0]));
	       ST(&(xo[16]), TW, ovs, &(xo[0]));
	  }
	  {
	       V TZ, T10, TY, TX;
	       TY = VBYI(VFMA(LDK(KP433883739), TR, VFNMS(LDK(KP974927912), TS, VMUL(LDK(KP781831482), TT))));
	       TX = VFMA(LDK(KP623489801), TL, VFNMS(LDK(KP222520933), TO, VFNMS(LDK(KP900968867), TI, TF)));
	       TZ = VSUB(TX, TY);
	       T10 = VADD(TX, TY);
	       ST(&(xo[8]), TZ, ovs, &(xo[0]));
	       ST(&(xo[20]), T10, ovs, &(xo[0]));
	  }
	  {
	       V TC, TD, TB, TA;
	       TB = VBYI(VFNMS(LDK(KP781831482), Te, VFNMS(LDK(KP433883739), Tl, VMUL(LDK(KP974927912), T7))));
	       TA = VFMA(LDK(KP623489801), Tr, VFNMS(LDK(KP900968867), Tq, VFNMS(LDK(KP222520933), Ts, Tp)));
	       TC = VSUB(TA, TB);
	       TD = VADD(TB, TA);
	       ST(&(xo[10]), TC, ovs, &(xo[2]));
	       ST(&(xo[18]), TD, ovs, &(xo[2]));
	  }
     }
     END_SIMD();
}

static const kdft_desc desc = { 14, "n2bv_14", {50, 12, 24, 0}, &GENUS, 0, 2, 0, 0 };
void X(codelet_n2bv_14) (planner *p) {
     X(kdft_register) (p, n2bv_14, &desc);
}
