/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:02:18 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_c -simd -trivial-stores -compact -variables 4 -sign 1 -n 6 -name n2bv_6 -with-ostride 2 -include n2b.h */

/*
 * This function contains 18 FP additions, 4 FP multiplications,
 * (or, 16 additions, 2 multiplications, 2 fused multiply/add),
 * 23 stack variables, and 12 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_c.ml,v 1.9 2003/04/16 21:21:53 athena Exp $
 */

#include "n2b.h"

static void n2bv_6(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     int i;
     const R *xi;
     R *xo;
     xi = ii;
     xo = io;
     BEGIN_SIMD();
     for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs)) {
	  V Ta, Tg, T7, Tl, Tb, Tj, T8, T9, Tf, To;
	  T8 = LD(&(xi[0]), ivs, &(xi[0]));
	  T9 = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
	  Ta = VSUB(T8, T9);
	  Tg = VADD(T8, T9);
	  {
	       V T3, Th, T6, Ti;
	       {
		    V T1, T2, T4, T5;
		    T1 = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
		    T2 = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
		    T3 = VSUB(T1, T2);
		    Th = VADD(T1, T2);
		    T4 = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
		    T5 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
		    T6 = VSUB(T4, T5);
		    Ti = VADD(T4, T5);
	       }
	       T7 = VBYI(VMUL(LDK(KP866025403), VSUB(T3, T6)));
	       Tl = VBYI(VMUL(LDK(KP866025403), VSUB(Th, Ti)));
	       Tb = VADD(T3, T6);
	       Tj = VADD(Th, Ti);
	  }
	  Tf = VADD(Ta, Tb);
	  ST(&(xo[6]), Tf, ovs, &(xo[2]));
	  To = VADD(Tg, Tj);
	  ST(&(xo[0]), To, ovs, &(xo[0]));
	  {
	       V Td, Te, Tc, Tm, Tn, Tk;
	       Tc = VFNMS(LDK(KP500000000), Tb, Ta);
	       Td = VADD(T7, Tc);
	       Te = VSUB(Tc, T7);
	       ST(&(xo[2]), Td, ovs, &(xo[2]));
	       ST(&(xo[10]), Te, ovs, &(xo[2]));
	       Tk = VFNMS(LDK(KP500000000), Tj, Tg);
	       Tm = VSUB(Tk, Tl);
	       Tn = VADD(Tl, Tk);
	       ST(&(xo[4]), Tm, ovs, &(xo[0]));
	       ST(&(xo[8]), Tn, ovs, &(xo[0]));
	  }
     }
     END_SIMD();
}

static const kdft_desc desc = { 6, "n2bv_6", {16, 2, 2, 0}, &GENUS, 0, 2, 0, 0 };
void X(codelet_n2bv_6) (planner *p) {
     X(kdft_register) (p, n2bv_6, &desc);
}
