/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:06:41 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twidsq_c -simd -trivial-stores -compact -variables 4 -n 8 -dif -name q1bv_8 -include q1b.h -sign 1 */

/*
 * This function contains 264 FP additions, 128 FP multiplications,
 * (or, 264 additions, 128 multiplications, 0 fused multiply/add),
 * 77 stack variables, and 128 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twidsq_c.ml,v 1.1 2003/03/26 12:45:03 athena Exp $
 */

#include "q1b.h"

static const R *q1bv_8(R *ri, R *ii, const R *W, stride is, stride vs, int m, int dist)
{
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     int i;
     R *x;
     x = ii;
     BEGIN_SIMD();
     for (i = 0; i < m; i = i + VL, x = x + (VL * dist), W = W + (TWVL * 14)) {
	  V Ta, Tv, Te, Tp, T1O, T29, T1S, T23, T2m, T2H, T2q, T2B, T40, T4l, T44;
	  V T4f, TI, T13, TM, TX, T1g, T1B, T1k, T1v, T2U, T3f, T2Y, T39, T3s, T3N;
	  V T3w, T3H, T7, Tw, Tf, Ts, T1L, T2a, T1T, T26, T2j, T2I, T2r, T2E, T3X;
	  V T4m, T45, T4i, TF, T14, TN, T10, T1d, T1C, T1l, T1y, T2R, T3g, T2Z, T3c;
	  V T3p, T3O, T3x, T3K, T2b, T15;
	  {
	       V T8, T9, To, Tc, Td, Tn;
	       T8 = LD(&(x[WS(is, 2)]), dist, &(x[0]));
	       T9 = LD(&(x[WS(is, 6)]), dist, &(x[0]));
	       To = VADD(T8, T9);
	       Tc = LD(&(x[0]), dist, &(x[0]));
	       Td = LD(&(x[WS(is, 4)]), dist, &(x[0]));
	       Tn = VADD(Tc, Td);
	       Ta = VSUB(T8, T9);
	       Tv = VADD(Tn, To);
	       Te = VSUB(Tc, Td);
	       Tp = VSUB(Tn, To);
	  }
	  {
	       V T1M, T1N, T22, T1Q, T1R, T21;
	       T1M = LD(&(x[WS(vs, 3) + WS(is, 2)]), dist, &(x[WS(vs, 3)]));
	       T1N = LD(&(x[WS(vs, 3) + WS(is, 6)]), dist, &(x[WS(vs, 3)]));
	       T22 = VADD(T1M, T1N);
	       T1Q = LD(&(x[WS(vs, 3)]), dist, &(x[WS(vs, 3)]));
	       T1R = LD(&(x[WS(vs, 3) + WS(is, 4)]), dist, &(x[WS(vs, 3)]));
	       T21 = VADD(T1Q, T1R);
	       T1O = VSUB(T1M, T1N);
	       T29 = VADD(T21, T22);
	       T1S = VSUB(T1Q, T1R);
	       T23 = VSUB(T21, T22);
	  }
	  {
	       V T2k, T2l, T2A, T2o, T2p, T2z;
	       T2k = LD(&(x[WS(vs, 4) + WS(is, 2)]), dist, &(x[WS(vs, 4)]));
	       T2l = LD(&(x[WS(vs, 4) + WS(is, 6)]), dist, &(x[WS(vs, 4)]));
	       T2A = VADD(T2k, T2l);
	       T2o = LD(&(x[WS(vs, 4)]), dist, &(x[WS(vs, 4)]));
	       T2p = LD(&(x[WS(vs, 4) + WS(is, 4)]), dist, &(x[WS(vs, 4)]));
	       T2z = VADD(T2o, T2p);
	       T2m = VSUB(T2k, T2l);
	       T2H = VADD(T2z, T2A);
	       T2q = VSUB(T2o, T2p);
	       T2B = VSUB(T2z, T2A);
	  }
	  {
	       V T3Y, T3Z, T4e, T42, T43, T4d;
	       T3Y = LD(&(x[WS(vs, 7) + WS(is, 2)]), dist, &(x[WS(vs, 7)]));
	       T3Z = LD(&(x[WS(vs, 7) + WS(is, 6)]), dist, &(x[WS(vs, 7)]));
	       T4e = VADD(T3Y, T3Z);
	       T42 = LD(&(x[WS(vs, 7)]), dist, &(x[WS(vs, 7)]));
	       T43 = LD(&(x[WS(vs, 7) + WS(is, 4)]), dist, &(x[WS(vs, 7)]));
	       T4d = VADD(T42, T43);
	       T40 = VSUB(T3Y, T3Z);
	       T4l = VADD(T4d, T4e);
	       T44 = VSUB(T42, T43);
	       T4f = VSUB(T4d, T4e);
	  }
	  {
	       V TG, TH, TW, TK, TL, TV;
	       TG = LD(&(x[WS(vs, 1) + WS(is, 2)]), dist, &(x[WS(vs, 1)]));
	       TH = LD(&(x[WS(vs, 1) + WS(is, 6)]), dist, &(x[WS(vs, 1)]));
	       TW = VADD(TG, TH);
	       TK = LD(&(x[WS(vs, 1)]), dist, &(x[WS(vs, 1)]));
	       TL = LD(&(x[WS(vs, 1) + WS(is, 4)]), dist, &(x[WS(vs, 1)]));
	       TV = VADD(TK, TL);
	       TI = VSUB(TG, TH);
	       T13 = VADD(TV, TW);
	       TM = VSUB(TK, TL);
	       TX = VSUB(TV, TW);
	  }
	  {
	       V T1e, T1f, T1u, T1i, T1j, T1t;
	       T1e = LD(&(x[WS(vs, 2) + WS(is, 2)]), dist, &(x[WS(vs, 2)]));
	       T1f = LD(&(x[WS(vs, 2) + WS(is, 6)]), dist, &(x[WS(vs, 2)]));
	       T1u = VADD(T1e, T1f);
	       T1i = LD(&(x[WS(vs, 2)]), dist, &(x[WS(vs, 2)]));
	       T1j = LD(&(x[WS(vs, 2) + WS(is, 4)]), dist, &(x[WS(vs, 2)]));
	       T1t = VADD(T1i, T1j);
	       T1g = VSUB(T1e, T1f);
	       T1B = VADD(T1t, T1u);
	       T1k = VSUB(T1i, T1j);
	       T1v = VSUB(T1t, T1u);
	  }
	  {
	       V T2S, T2T, T38, T2W, T2X, T37;
	       T2S = LD(&(x[WS(vs, 5) + WS(is, 2)]), dist, &(x[WS(vs, 5)]));
	       T2T = LD(&(x[WS(vs, 5) + WS(is, 6)]), dist, &(x[WS(vs, 5)]));
	       T38 = VADD(T2S, T2T);
	       T2W = LD(&(x[WS(vs, 5)]), dist, &(x[WS(vs, 5)]));
	       T2X = LD(&(x[WS(vs, 5) + WS(is, 4)]), dist, &(x[WS(vs, 5)]));
	       T37 = VADD(T2W, T2X);
	       T2U = VSUB(T2S, T2T);
	       T3f = VADD(T37, T38);
	       T2Y = VSUB(T2W, T2X);
	       T39 = VSUB(T37, T38);
	  }
	  {
	       V T3q, T3r, T3G, T3u, T3v, T3F;
	       T3q = LD(&(x[WS(vs, 6) + WS(is, 2)]), dist, &(x[WS(vs, 6)]));
	       T3r = LD(&(x[WS(vs, 6) + WS(is, 6)]), dist, &(x[WS(vs, 6)]));
	       T3G = VADD(T3q, T3r);
	       T3u = LD(&(x[WS(vs, 6)]), dist, &(x[WS(vs, 6)]));
	       T3v = LD(&(x[WS(vs, 6) + WS(is, 4)]), dist, &(x[WS(vs, 6)]));
	       T3F = VADD(T3u, T3v);
	       T3s = VSUB(T3q, T3r);
	       T3N = VADD(T3F, T3G);
	       T3w = VSUB(T3u, T3v);
	       T3H = VSUB(T3F, T3G);
	  }
	  {
	       V T3, Tq, T6, Tr;
	       {
		    V T1, T2, T4, T5;
		    T1 = LD(&(x[WS(is, 1)]), dist, &(x[WS(is, 1)]));
		    T2 = LD(&(x[WS(is, 5)]), dist, &(x[WS(is, 1)]));
		    T3 = VSUB(T1, T2);
		    Tq = VADD(T1, T2);
		    T4 = LD(&(x[WS(is, 7)]), dist, &(x[WS(is, 1)]));
		    T5 = LD(&(x[WS(is, 3)]), dist, &(x[WS(is, 1)]));
		    T6 = VSUB(T4, T5);
		    Tr = VADD(T4, T5);
	       }
	       T7 = VMUL(LDK(KP707106781), VSUB(T3, T6));
	       Tw = VADD(Tq, Tr);
	       Tf = VMUL(LDK(KP707106781), VADD(T3, T6));
	       Ts = VBYI(VSUB(Tq, Tr));
	  }
	  {
	       V T1H, T24, T1K, T25;
	       {
		    V T1F, T1G, T1I, T1J;
		    T1F = LD(&(x[WS(vs, 3) + WS(is, 1)]), dist, &(x[WS(vs, 3) + WS(is, 1)]));
		    T1G = LD(&(x[WS(vs, 3) + WS(is, 5)]), dist, &(x[WS(vs, 3) + WS(is, 1)]));
		    T1H = VSUB(T1F, T1G);
		    T24 = VADD(T1F, T1G);
		    T1I = LD(&(x[WS(vs, 3) + WS(is, 7)]), dist, &(x[WS(vs, 3) + WS(is, 1)]));
		    T1J = LD(&(x[WS(vs, 3) + WS(is, 3)]), dist, &(x[WS(vs, 3) + WS(is, 1)]));
		    T1K = VSUB(T1I, T1J);
		    T25 = VADD(T1I, T1J);
	       }
	       T1L = VMUL(LDK(KP707106781), VSUB(T1H, T1K));
	       T2a = VADD(T24, T25);
	       T1T = VMUL(LDK(KP707106781), VADD(T1H, T1K));
	       T26 = VBYI(VSUB(T24, T25));
	  }
	  {
	       V T2f, T2C, T2i, T2D;
	       {
		    V T2d, T2e, T2g, T2h;
		    T2d = LD(&(x[WS(vs, 4) + WS(is, 1)]), dist, &(x[WS(vs, 4) + WS(is, 1)]));
		    T2e = LD(&(x[WS(vs, 4) + WS(is, 5)]), dist, &(x[WS(vs, 4) + WS(is, 1)]));
		    T2f = VSUB(T2d, T2e);
		    T2C = VADD(T2d, T2e);
		    T2g = LD(&(x[WS(vs, 4) + WS(is, 7)]), dist, &(x[WS(vs, 4) + WS(is, 1)]));
		    T2h = LD(&(x[WS(vs, 4) + WS(is, 3)]), dist, &(x[WS(vs, 4) + WS(is, 1)]));
		    T2i = VSUB(T2g, T2h);
		    T2D = VADD(T2g, T2h);
	       }
	       T2j = VMUL(LDK(KP707106781), VSUB(T2f, T2i));
	       T2I = VADD(T2C, T2D);
	       T2r = VMUL(LDK(KP707106781), VADD(T2f, T2i));
	       T2E = VBYI(VSUB(T2C, T2D));
	  }
	  {
	       V T3T, T4g, T3W, T4h;
	       {
		    V T3R, T3S, T3U, T3V;
		    T3R = LD(&(x[WS(vs, 7) + WS(is, 1)]), dist, &(x[WS(vs, 7) + WS(is, 1)]));
		    T3S = LD(&(x[WS(vs, 7) + WS(is, 5)]), dist, &(x[WS(vs, 7) + WS(is, 1)]));
		    T3T = VSUB(T3R, T3S);
		    T4g = VADD(T3R, T3S);
		    T3U = LD(&(x[WS(vs, 7) + WS(is, 7)]), dist, &(x[WS(vs, 7) + WS(is, 1)]));
		    T3V = LD(&(x[WS(vs, 7) + WS(is, 3)]), dist, &(x[WS(vs, 7) + WS(is, 1)]));
		    T3W = VSUB(T3U, T3V);
		    T4h = VADD(T3U, T3V);
	       }
	       T3X = VMUL(LDK(KP707106781), VSUB(T3T, T3W));
	       T4m = VADD(T4g, T4h);
	       T45 = VMUL(LDK(KP707106781), VADD(T3T, T3W));
	       T4i = VBYI(VSUB(T4g, T4h));
	  }
	  {
	       V TB, TY, TE, TZ;
	       {
		    V Tz, TA, TC, TD;
		    Tz = LD(&(x[WS(vs, 1) + WS(is, 1)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
		    TA = LD(&(x[WS(vs, 1) + WS(is, 5)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
		    TB = VSUB(Tz, TA);
		    TY = VADD(Tz, TA);
		    TC = LD(&(x[WS(vs, 1) + WS(is, 7)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
		    TD = LD(&(x[WS(vs, 1) + WS(is, 3)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
		    TE = VSUB(TC, TD);
		    TZ = VADD(TC, TD);
	       }
	       TF = VMUL(LDK(KP707106781), VSUB(TB, TE));
	       T14 = VADD(TY, TZ);
	       TN = VMUL(LDK(KP707106781), VADD(TB, TE));
	       T10 = VBYI(VSUB(TY, TZ));
	  }
	  {
	       V T19, T1w, T1c, T1x;
	       {
		    V T17, T18, T1a, T1b;
		    T17 = LD(&(x[WS(vs, 2) + WS(is, 1)]), dist, &(x[WS(vs, 2) + WS(is, 1)]));
		    T18 = LD(&(x[WS(vs, 2) + WS(is, 5)]), dist, &(x[WS(vs, 2) + WS(is, 1)]));
		    T19 = VSUB(T17, T18);
		    T1w = VADD(T17, T18);
		    T1a = LD(&(x[WS(vs, 2) + WS(is, 7)]), dist, &(x[WS(vs, 2) + WS(is, 1)]));
		    T1b = LD(&(x[WS(vs, 2) + WS(is, 3)]), dist, &(x[WS(vs, 2) + WS(is, 1)]));
		    T1c = VSUB(T1a, T1b);
		    T1x = VADD(T1a, T1b);
	       }
	       T1d = VMUL(LDK(KP707106781), VSUB(T19, T1c));
	       T1C = VADD(T1w, T1x);
	       T1l = VMUL(LDK(KP707106781), VADD(T19, T1c));
	       T1y = VBYI(VSUB(T1w, T1x));
	  }
	  {
	       V T2N, T3a, T2Q, T3b;
	       {
		    V T2L, T2M, T2O, T2P;
		    T2L = LD(&(x[WS(vs, 5) + WS(is, 1)]), dist, &(x[WS(vs, 5) + WS(is, 1)]));
		    T2M = LD(&(x[WS(vs, 5) + WS(is, 5)]), dist, &(x[WS(vs, 5) + WS(is, 1)]));
		    T2N = VSUB(T2L, T2M);
		    T3a = VADD(T2L, T2M);
		    T2O = LD(&(x[WS(vs, 5) + WS(is, 7)]), dist, &(x[WS(vs, 5) + WS(is, 1)]));
		    T2P = LD(&(x[WS(vs, 5) + WS(is, 3)]), dist, &(x[WS(vs, 5) + WS(is, 1)]));
		    T2Q = VSUB(T2O, T2P);
		    T3b = VADD(T2O, T2P);
	       }
	       T2R = VMUL(LDK(KP707106781), VSUB(T2N, T2Q));
	       T3g = VADD(T3a, T3b);
	       T2Z = VMUL(LDK(KP707106781), VADD(T2N, T2Q));
	       T3c = VBYI(VSUB(T3a, T3b));
	  }
	  {
	       V T3l, T3I, T3o, T3J;
	       {
		    V T3j, T3k, T3m, T3n;
		    T3j = LD(&(x[WS(vs, 6) + WS(is, 1)]), dist, &(x[WS(vs, 6) + WS(is, 1)]));
		    T3k = LD(&(x[WS(vs, 6) + WS(is, 5)]), dist, &(x[WS(vs, 6) + WS(is, 1)]));
		    T3l = VSUB(T3j, T3k);
		    T3I = VADD(T3j, T3k);
		    T3m = LD(&(x[WS(vs, 6) + WS(is, 7)]), dist, &(x[WS(vs, 6) + WS(is, 1)]));
		    T3n = LD(&(x[WS(vs, 6) + WS(is, 3)]), dist, &(x[WS(vs, 6) + WS(is, 1)]));
		    T3o = VSUB(T3m, T3n);
		    T3J = VADD(T3m, T3n);
	       }
	       T3p = VMUL(LDK(KP707106781), VSUB(T3l, T3o));
	       T3O = VADD(T3I, T3J);
	       T3x = VMUL(LDK(KP707106781), VADD(T3l, T3o));
	       T3K = VBYI(VSUB(T3I, T3J));
	  }
	  {
	       V Ty, T1E, T3i, T4o, T3Q, T2K;
	       Ty = VADD(Tv, Tw);
	       ST(&(x[0]), Ty, dist, &(x[0]));
	       T1E = VADD(T1B, T1C);
	       ST(&(x[WS(is, 2)]), T1E, dist, &(x[0]));
	       T3i = VADD(T3f, T3g);
	       ST(&(x[WS(is, 5)]), T3i, dist, &(x[WS(is, 1)]));
	       T4o = VADD(T4l, T4m);
	       ST(&(x[WS(is, 7)]), T4o, dist, &(x[WS(is, 1)]));
	       T3Q = VADD(T3N, T3O);
	       ST(&(x[WS(is, 6)]), T3Q, dist, &(x[0]));
	       T2K = VADD(T2H, T2I);
	       ST(&(x[WS(is, 4)]), T2K, dist, &(x[0]));
	  }
	  {
	       V T2c, T16, Tt, T4j, T2F, T27;
	       T2c = VADD(T29, T2a);
	       ST(&(x[WS(is, 3)]), T2c, dist, &(x[WS(is, 1)]));
	       T16 = VADD(T13, T14);
	       ST(&(x[WS(is, 1)]), T16, dist, &(x[WS(is, 1)]));
	       Tt = BYTW(&(W[TWVL * 10]), VSUB(Tp, Ts));
	       ST(&(x[WS(vs, 6)]), Tt, dist, &(x[WS(vs, 6)]));
	       T4j = BYTW(&(W[TWVL * 10]), VSUB(T4f, T4i));
	       ST(&(x[WS(vs, 6) + WS(is, 7)]), T4j, dist, &(x[WS(vs, 6) + WS(is, 1)]));
	       T2F = BYTW(&(W[TWVL * 10]), VSUB(T2B, T2E));
	       ST(&(x[WS(vs, 6) + WS(is, 4)]), T2F, dist, &(x[WS(vs, 6)]));
	       T27 = BYTW(&(W[TWVL * 10]), VSUB(T23, T26));
	       ST(&(x[WS(vs, 6) + WS(is, 3)]), T27, dist, &(x[WS(vs, 6) + WS(is, 1)]));
	  }
	  {
	       V T11, T1z, T3L, T3d, T1A, Tu;
	       T11 = BYTW(&(W[TWVL * 10]), VSUB(TX, T10));
	       ST(&(x[WS(vs, 6) + WS(is, 1)]), T11, dist, &(x[WS(vs, 6) + WS(is, 1)]));
	       T1z = BYTW(&(W[TWVL * 10]), VSUB(T1v, T1y));
	       ST(&(x[WS(vs, 6) + WS(is, 2)]), T1z, dist, &(x[WS(vs, 6)]));
	       T3L = BYTW(&(W[TWVL * 10]), VSUB(T3H, T3K));
	       ST(&(x[WS(vs, 6) + WS(is, 6)]), T3L, dist, &(x[WS(vs, 6)]));
	       T3d = BYTW(&(W[TWVL * 10]), VSUB(T39, T3c));
	       ST(&(x[WS(vs, 6) + WS(is, 5)]), T3d, dist, &(x[WS(vs, 6) + WS(is, 1)]));
	       T1A = BYTW(&(W[TWVL * 2]), VADD(T1v, T1y));
	       ST(&(x[WS(vs, 2) + WS(is, 2)]), T1A, dist, &(x[WS(vs, 2)]));
	       Tu = BYTW(&(W[TWVL * 2]), VADD(Tp, Ts));
	       ST(&(x[WS(vs, 2)]), Tu, dist, &(x[WS(vs, 2)]));
	  }
	  {
	       V T2G, T3M, T12, T28, T3e, T4k;
	       T2G = BYTW(&(W[TWVL * 2]), VADD(T2B, T2E));
	       ST(&(x[WS(vs, 2) + WS(is, 4)]), T2G, dist, &(x[WS(vs, 2)]));
	       T3M = BYTW(&(W[TWVL * 2]), VADD(T3H, T3K));
	       ST(&(x[WS(vs, 2) + WS(is, 6)]), T3M, dist, &(x[WS(vs, 2)]));
	       T12 = BYTW(&(W[TWVL * 2]), VADD(TX, T10));
	       ST(&(x[WS(vs, 2) + WS(is, 1)]), T12, dist, &(x[WS(vs, 2) + WS(is, 1)]));
	       T28 = BYTW(&(W[TWVL * 2]), VADD(T23, T26));
	       ST(&(x[WS(vs, 2) + WS(is, 3)]), T28, dist, &(x[WS(vs, 2) + WS(is, 1)]));
	       T3e = BYTW(&(W[TWVL * 2]), VADD(T39, T3c));
	       ST(&(x[WS(vs, 2) + WS(is, 5)]), T3e, dist, &(x[WS(vs, 2) + WS(is, 1)]));
	       T4k = BYTW(&(W[TWVL * 2]), VADD(T4f, T4i));
	       ST(&(x[WS(vs, 2) + WS(is, 7)]), T4k, dist, &(x[WS(vs, 2) + WS(is, 1)]));
	  }
	  {
	       V Tx, T1D, T3h, T4n, T3P, T2J;
	       Tx = BYTW(&(W[TWVL * 6]), VSUB(Tv, Tw));
	       ST(&(x[WS(vs, 4)]), Tx, dist, &(x[WS(vs, 4)]));
	       T1D = BYTW(&(W[TWVL * 6]), VSUB(T1B, T1C));
	       ST(&(x[WS(vs, 4) + WS(is, 2)]), T1D, dist, &(x[WS(vs, 4)]));
	       T3h = BYTW(&(W[TWVL * 6]), VSUB(T3f, T3g));
	       ST(&(x[WS(vs, 4) + WS(is, 5)]), T3h, dist, &(x[WS(vs, 4) + WS(is, 1)]));
	       T4n = BYTW(&(W[TWVL * 6]), VSUB(T4l, T4m));
	       ST(&(x[WS(vs, 4) + WS(is, 7)]), T4n, dist, &(x[WS(vs, 4) + WS(is, 1)]));
	       T3P = BYTW(&(W[TWVL * 6]), VSUB(T3N, T3O));
	       ST(&(x[WS(vs, 4) + WS(is, 6)]), T3P, dist, &(x[WS(vs, 4)]));
	       T2J = BYTW(&(W[TWVL * 6]), VSUB(T2H, T2I));
	       ST(&(x[WS(vs, 4) + WS(is, 4)]), T2J, dist, &(x[WS(vs, 4)]));
	  }
	  T2b = BYTW(&(W[TWVL * 6]), VSUB(T29, T2a));
	  ST(&(x[WS(vs, 4) + WS(is, 3)]), T2b, dist, &(x[WS(vs, 4) + WS(is, 1)]));
	  T15 = BYTW(&(W[TWVL * 6]), VSUB(T13, T14));
	  ST(&(x[WS(vs, 4) + WS(is, 1)]), T15, dist, &(x[WS(vs, 4) + WS(is, 1)]));
	  {
	       V Th, Ti, Tb, Tg;
	       Tb = VBYI(VSUB(T7, Ta));
	       Tg = VSUB(Te, Tf);
	       Th = BYTW(&(W[TWVL * 4]), VADD(Tb, Tg));
	       Ti = BYTW(&(W[TWVL * 8]), VSUB(Tg, Tb));
	       ST(&(x[WS(vs, 3)]), Th, dist, &(x[WS(vs, 3)]));
	       ST(&(x[WS(vs, 5)]), Ti, dist, &(x[WS(vs, 5)]));
	  }
	  {
	       V T47, T48, T41, T46;
	       T41 = VBYI(VSUB(T3X, T40));
	       T46 = VSUB(T44, T45);
	       T47 = BYTW(&(W[TWVL * 4]), VADD(T41, T46));
	       T48 = BYTW(&(W[TWVL * 8]), VSUB(T46, T41));
	       ST(&(x[WS(vs, 3) + WS(is, 7)]), T47, dist, &(x[WS(vs, 3) + WS(is, 1)]));
	       ST(&(x[WS(vs, 5) + WS(is, 7)]), T48, dist, &(x[WS(vs, 5) + WS(is, 1)]));
	  }
	  {
	       V T2t, T2u, T2n, T2s;
	       T2n = VBYI(VSUB(T2j, T2m));
	       T2s = VSUB(T2q, T2r);
	       T2t = BYTW(&(W[TWVL * 4]), VADD(T2n, T2s));
	       T2u = BYTW(&(W[TWVL * 8]), VSUB(T2s, T2n));
	       ST(&(x[WS(vs, 3) + WS(is, 4)]), T2t, dist, &(x[WS(vs, 3)]));
	       ST(&(x[WS(vs, 5) + WS(is, 4)]), T2u, dist, &(x[WS(vs, 5)]));
	  }
	  {
	       V T1V, T1W, T1P, T1U;
	       T1P = VBYI(VSUB(T1L, T1O));
	       T1U = VSUB(T1S, T1T);
	       T1V = BYTW(&(W[TWVL * 4]), VADD(T1P, T1U));
	       T1W = BYTW(&(W[TWVL * 8]), VSUB(T1U, T1P));
	       ST(&(x[WS(vs, 3) + WS(is, 3)]), T1V, dist, &(x[WS(vs, 3) + WS(is, 1)]));
	       ST(&(x[WS(vs, 5) + WS(is, 3)]), T1W, dist, &(x[WS(vs, 5) + WS(is, 1)]));
	  }
	  {
	       V TP, TQ, TJ, TO;
	       TJ = VBYI(VSUB(TF, TI));
	       TO = VSUB(TM, TN);
	       TP = BYTW(&(W[TWVL * 4]), VADD(TJ, TO));
	       TQ = BYTW(&(W[TWVL * 8]), VSUB(TO, TJ));
	       ST(&(x[WS(vs, 3) + WS(is, 1)]), TP, dist, &(x[WS(vs, 3) + WS(is, 1)]));
	       ST(&(x[WS(vs, 5) + WS(is, 1)]), TQ, dist, &(x[WS(vs, 5) + WS(is, 1)]));
	  }
	  {
	       V T1n, T1o, T1h, T1m;
	       T1h = VBYI(VSUB(T1d, T1g));
	       T1m = VSUB(T1k, T1l);
	       T1n = BYTW(&(W[TWVL * 4]), VADD(T1h, T1m));
	       T1o = BYTW(&(W[TWVL * 8]), VSUB(T1m, T1h));
	       ST(&(x[WS(vs, 3) + WS(is, 2)]), T1n, dist, &(x[WS(vs, 3)]));
	       ST(&(x[WS(vs, 5) + WS(is, 2)]), T1o, dist, &(x[WS(vs, 5)]));
	  }
	  {
	       V T3z, T3A, T3t, T3y;
	       T3t = VBYI(VSUB(T3p, T3s));
	       T3y = VSUB(T3w, T3x);
	       T3z = BYTW(&(W[TWVL * 4]), VADD(T3t, T3y));
	       T3A = BYTW(&(W[TWVL * 8]), VSUB(T3y, T3t));
	       ST(&(x[WS(vs, 3) + WS(is, 6)]), T3z, dist, &(x[WS(vs, 3)]));
	       ST(&(x[WS(vs, 5) + WS(is, 6)]), T3A, dist, &(x[WS(vs, 5)]));
	  }
	  {
	       V T31, T32, T2V, T30;
	       T2V = VBYI(VSUB(T2R, T2U));
	       T30 = VSUB(T2Y, T2Z);
	       T31 = BYTW(&(W[TWVL * 4]), VADD(T2V, T30));
	       T32 = BYTW(&(W[TWVL * 8]), VSUB(T30, T2V));
	       ST(&(x[WS(vs, 3) + WS(is, 5)]), T31, dist, &(x[WS(vs, 3) + WS(is, 1)]));
	       ST(&(x[WS(vs, 5) + WS(is, 5)]), T32, dist, &(x[WS(vs, 5) + WS(is, 1)]));
	  }
	  {
	       V T1r, T1s, T1p, T1q;
	       T1p = VBYI(VADD(T1g, T1d));
	       T1q = VADD(T1k, T1l);
	       T1r = BYTW(&(W[0]), VADD(T1p, T1q));
	       T1s = BYTW(&(W[TWVL * 12]), VSUB(T1q, T1p));
	       ST(&(x[WS(vs, 1) + WS(is, 2)]), T1r, dist, &(x[WS(vs, 1)]));
	       ST(&(x[WS(vs, 7) + WS(is, 2)]), T1s, dist, &(x[WS(vs, 7)]));
	  }
	  {
	       V Tl, Tm, Tj, Tk;
	       Tj = VBYI(VADD(Ta, T7));
	       Tk = VADD(Te, Tf);
	       Tl = BYTW(&(W[0]), VADD(Tj, Tk));
	       Tm = BYTW(&(W[TWVL * 12]), VSUB(Tk, Tj));
	       ST(&(x[WS(vs, 1)]), Tl, dist, &(x[WS(vs, 1)]));
	       ST(&(x[WS(vs, 7)]), Tm, dist, &(x[WS(vs, 7)]));
	  }
	  {
	       V T2x, T2y, T2v, T2w;
	       T2v = VBYI(VADD(T2m, T2j));
	       T2w = VADD(T2q, T2r);
	       T2x = BYTW(&(W[0]), VADD(T2v, T2w));
	       T2y = BYTW(&(W[TWVL * 12]), VSUB(T2w, T2v));
	       ST(&(x[WS(vs, 1) + WS(is, 4)]), T2x, dist, &(x[WS(vs, 1)]));
	       ST(&(x[WS(vs, 7) + WS(is, 4)]), T2y, dist, &(x[WS(vs, 7)]));
	  }
	  {
	       V T3D, T3E, T3B, T3C;
	       T3B = VBYI(VADD(T3s, T3p));
	       T3C = VADD(T3w, T3x);
	       T3D = BYTW(&(W[0]), VADD(T3B, T3C));
	       T3E = BYTW(&(W[TWVL * 12]), VSUB(T3C, T3B));
	       ST(&(x[WS(vs, 1) + WS(is, 6)]), T3D, dist, &(x[WS(vs, 1)]));
	       ST(&(x[WS(vs, 7) + WS(is, 6)]), T3E, dist, &(x[WS(vs, 7)]));
	  }
	  {
	       V TT, TU, TR, TS;
	       TR = VBYI(VADD(TI, TF));
	       TS = VADD(TM, TN);
	       TT = BYTW(&(W[0]), VADD(TR, TS));
	       TU = BYTW(&(W[TWVL * 12]), VSUB(TS, TR));
	       ST(&(x[WS(vs, 1) + WS(is, 1)]), TT, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	       ST(&(x[WS(vs, 7) + WS(is, 1)]), TU, dist, &(x[WS(vs, 7) + WS(is, 1)]));
	  }
	  {
	       V T1Z, T20, T1X, T1Y;
	       T1X = VBYI(VADD(T1O, T1L));
	       T1Y = VADD(T1S, T1T);
	       T1Z = BYTW(&(W[0]), VADD(T1X, T1Y));
	       T20 = BYTW(&(W[TWVL * 12]), VSUB(T1Y, T1X));
	       ST(&(x[WS(vs, 1) + WS(is, 3)]), T1Z, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	       ST(&(x[WS(vs, 7) + WS(is, 3)]), T20, dist, &(x[WS(vs, 7) + WS(is, 1)]));
	  }
	  {
	       V T35, T36, T33, T34;
	       T33 = VBYI(VADD(T2U, T2R));
	       T34 = VADD(T2Y, T2Z);
	       T35 = BYTW(&(W[0]), VADD(T33, T34));
	       T36 = BYTW(&(W[TWVL * 12]), VSUB(T34, T33));
	       ST(&(x[WS(vs, 1) + WS(is, 5)]), T35, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	       ST(&(x[WS(vs, 7) + WS(is, 5)]), T36, dist, &(x[WS(vs, 7) + WS(is, 1)]));
	  }
	  {
	       V T4b, T4c, T49, T4a;
	       T49 = VBYI(VADD(T40, T3X));
	       T4a = VADD(T44, T45);
	       T4b = BYTW(&(W[0]), VADD(T49, T4a));
	       T4c = BYTW(&(W[TWVL * 12]), VSUB(T4a, T49));
	       ST(&(x[WS(vs, 1) + WS(is, 7)]), T4b, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	       ST(&(x[WS(vs, 7) + WS(is, 7)]), T4c, dist, &(x[WS(vs, 7) + WS(is, 1)]));
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 8, "q1bv_8", twinstr, {264, 128, 0, 0}, &GENUS, 0, 0, 0 };

void X(codelet_q1bv_8) (planner *p) {
     X(kdft_difsq_register) (p, q1bv_8, &desc);
}
