/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:06:08 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twidsq_c -simd -trivial-stores -compact -variables 4 -n 8 -dif -name q1fv_8 -include q1f.h */

/*
 * This function contains 264 FP additions, 128 FP multiplications,
 * (or, 264 additions, 128 multiplications, 0 fused multiply/add),
 * 77 stack variables, and 128 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twidsq_c.ml,v 1.1 2003/03/26 12:45:03 athena Exp $
 */

#include "q1f.h"

static const R *q1fv_8(R *ri, R *ii, const R *W, stride is, stride vs, int m, int dist)
{
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     int i;
     R *x;
     x = ri;
     BEGIN_SIMD();
     for (i = 0; i < m; i = i + VL, x = x + (VL * dist), W = W + (TWVL * 14)) {
	  V T3, Tv, Tf, Tp, T1H, T29, T1T, T23, T2f, T2H, T2r, T2B, T3T, T4l, T45;
	  V T4f, TB, T13, TN, TX, T19, T1B, T1l, T1v, T2N, T3f, T2Z, T39, T3l, T3N;
	  V T3x, T3H, Ta, Tw, Tc, Ts, T1O, T2a, T1Q, T26, T2m, T2I, T2o, T2E, T40;
	  V T4m, T42, T4i, TI, T14, TK, T10, T1g, T1C, T1i, T1y, T2U, T3g, T2W, T3c;
	  V T3s, T3O, T3u, T3K, T2c, T16;
	  {
	       V T1, T2, Tn, Td, Te, To;
	       T1 = LD(&(x[0]), dist, &(x[0]));
	       T2 = LD(&(x[WS(is, 4)]), dist, &(x[0]));
	       Tn = VADD(T1, T2);
	       Td = LD(&(x[WS(is, 2)]), dist, &(x[0]));
	       Te = LD(&(x[WS(is, 6)]), dist, &(x[0]));
	       To = VADD(Td, Te);
	       T3 = VSUB(T1, T2);
	       Tv = VSUB(Tn, To);
	       Tf = VSUB(Td, Te);
	       Tp = VADD(Tn, To);
	  }
	  {
	       V T1F, T1G, T21, T1R, T1S, T22;
	       T1F = LD(&(x[WS(vs, 3)]), dist, &(x[WS(vs, 3)]));
	       T1G = LD(&(x[WS(vs, 3) + WS(is, 4)]), dist, &(x[WS(vs, 3)]));
	       T21 = VADD(T1F, T1G);
	       T1R = LD(&(x[WS(vs, 3) + WS(is, 2)]), dist, &(x[WS(vs, 3)]));
	       T1S = LD(&(x[WS(vs, 3) + WS(is, 6)]), dist, &(x[WS(vs, 3)]));
	       T22 = VADD(T1R, T1S);
	       T1H = VSUB(T1F, T1G);
	       T29 = VSUB(T21, T22);
	       T1T = VSUB(T1R, T1S);
	       T23 = VADD(T21, T22);
	  }
	  {
	       V T2d, T2e, T2z, T2p, T2q, T2A;
	       T2d = LD(&(x[WS(vs, 4)]), dist, &(x[WS(vs, 4)]));
	       T2e = LD(&(x[WS(vs, 4) + WS(is, 4)]), dist, &(x[WS(vs, 4)]));
	       T2z = VADD(T2d, T2e);
	       T2p = LD(&(x[WS(vs, 4) + WS(is, 2)]), dist, &(x[WS(vs, 4)]));
	       T2q = LD(&(x[WS(vs, 4) + WS(is, 6)]), dist, &(x[WS(vs, 4)]));
	       T2A = VADD(T2p, T2q);
	       T2f = VSUB(T2d, T2e);
	       T2H = VSUB(T2z, T2A);
	       T2r = VSUB(T2p, T2q);
	       T2B = VADD(T2z, T2A);
	  }
	  {
	       V T3R, T3S, T4d, T43, T44, T4e;
	       T3R = LD(&(x[WS(vs, 7)]), dist, &(x[WS(vs, 7)]));
	       T3S = LD(&(x[WS(vs, 7) + WS(is, 4)]), dist, &(x[WS(vs, 7)]));
	       T4d = VADD(T3R, T3S);
	       T43 = LD(&(x[WS(vs, 7) + WS(is, 2)]), dist, &(x[WS(vs, 7)]));
	       T44 = LD(&(x[WS(vs, 7) + WS(is, 6)]), dist, &(x[WS(vs, 7)]));
	       T4e = VADD(T43, T44);
	       T3T = VSUB(T3R, T3S);
	       T4l = VSUB(T4d, T4e);
	       T45 = VSUB(T43, T44);
	       T4f = VADD(T4d, T4e);
	  }
	  {
	       V Tz, TA, TV, TL, TM, TW;
	       Tz = LD(&(x[WS(vs, 1)]), dist, &(x[WS(vs, 1)]));
	       TA = LD(&(x[WS(vs, 1) + WS(is, 4)]), dist, &(x[WS(vs, 1)]));
	       TV = VADD(Tz, TA);
	       TL = LD(&(x[WS(vs, 1) + WS(is, 2)]), dist, &(x[WS(vs, 1)]));
	       TM = LD(&(x[WS(vs, 1) + WS(is, 6)]), dist, &(x[WS(vs, 1)]));
	       TW = VADD(TL, TM);
	       TB = VSUB(Tz, TA);
	       T13 = VSUB(TV, TW);
	       TN = VSUB(TL, TM);
	       TX = VADD(TV, TW);
	  }
	  {
	       V T17, T18, T1t, T1j, T1k, T1u;
	       T17 = LD(&(x[WS(vs, 2)]), dist, &(x[WS(vs, 2)]));
	       T18 = LD(&(x[WS(vs, 2) + WS(is, 4)]), dist, &(x[WS(vs, 2)]));
	       T1t = VADD(T17, T18);
	       T1j = LD(&(x[WS(vs, 2) + WS(is, 2)]), dist, &(x[WS(vs, 2)]));
	       T1k = LD(&(x[WS(vs, 2) + WS(is, 6)]), dist, &(x[WS(vs, 2)]));
	       T1u = VADD(T1j, T1k);
	       T19 = VSUB(T17, T18);
	       T1B = VSUB(T1t, T1u);
	       T1l = VSUB(T1j, T1k);
	       T1v = VADD(T1t, T1u);
	  }
	  {
	       V T2L, T2M, T37, T2X, T2Y, T38;
	       T2L = LD(&(x[WS(vs, 5)]), dist, &(x[WS(vs, 5)]));
	       T2M = LD(&(x[WS(vs, 5) + WS(is, 4)]), dist, &(x[WS(vs, 5)]));
	       T37 = VADD(T2L, T2M);
	       T2X = LD(&(x[WS(vs, 5) + WS(is, 2)]), dist, &(x[WS(vs, 5)]));
	       T2Y = LD(&(x[WS(vs, 5) + WS(is, 6)]), dist, &(x[WS(vs, 5)]));
	       T38 = VADD(T2X, T2Y);
	       T2N = VSUB(T2L, T2M);
	       T3f = VSUB(T37, T38);
	       T2Z = VSUB(T2X, T2Y);
	       T39 = VADD(T37, T38);
	  }
	  {
	       V T3j, T3k, T3F, T3v, T3w, T3G;
	       T3j = LD(&(x[WS(vs, 6)]), dist, &(x[WS(vs, 6)]));
	       T3k = LD(&(x[WS(vs, 6) + WS(is, 4)]), dist, &(x[WS(vs, 6)]));
	       T3F = VADD(T3j, T3k);
	       T3v = LD(&(x[WS(vs, 6) + WS(is, 2)]), dist, &(x[WS(vs, 6)]));
	       T3w = LD(&(x[WS(vs, 6) + WS(is, 6)]), dist, &(x[WS(vs, 6)]));
	       T3G = VADD(T3v, T3w);
	       T3l = VSUB(T3j, T3k);
	       T3N = VSUB(T3F, T3G);
	       T3x = VSUB(T3v, T3w);
	       T3H = VADD(T3F, T3G);
	  }
	  {
	       V T6, Tq, T9, Tr;
	       {
		    V T4, T5, T7, T8;
		    T4 = LD(&(x[WS(is, 1)]), dist, &(x[WS(is, 1)]));
		    T5 = LD(&(x[WS(is, 5)]), dist, &(x[WS(is, 1)]));
		    T6 = VSUB(T4, T5);
		    Tq = VADD(T4, T5);
		    T7 = LD(&(x[WS(is, 7)]), dist, &(x[WS(is, 1)]));
		    T8 = LD(&(x[WS(is, 3)]), dist, &(x[WS(is, 1)]));
		    T9 = VSUB(T7, T8);
		    Tr = VADD(T7, T8);
	       }
	       Ta = VMUL(LDK(KP707106781), VADD(T6, T9));
	       Tw = VBYI(VSUB(Tr, Tq));
	       Tc = VMUL(LDK(KP707106781), VSUB(T9, T6));
	       Ts = VADD(Tq, Tr);
	  }
	  {
	       V T1K, T24, T1N, T25;
	       {
		    V T1I, T1J, T1L, T1M;
		    T1I = LD(&(x[WS(vs, 3) + WS(is, 1)]), dist, &(x[WS(vs, 3) + WS(is, 1)]));
		    T1J = LD(&(x[WS(vs, 3) + WS(is, 5)]), dist, &(x[WS(vs, 3) + WS(is, 1)]));
		    T1K = VSUB(T1I, T1J);
		    T24 = VADD(T1I, T1J);
		    T1L = LD(&(x[WS(vs, 3) + WS(is, 7)]), dist, &(x[WS(vs, 3) + WS(is, 1)]));
		    T1M = LD(&(x[WS(vs, 3) + WS(is, 3)]), dist, &(x[WS(vs, 3) + WS(is, 1)]));
		    T1N = VSUB(T1L, T1M);
		    T25 = VADD(T1L, T1M);
	       }
	       T1O = VMUL(LDK(KP707106781), VADD(T1K, T1N));
	       T2a = VBYI(VSUB(T25, T24));
	       T1Q = VMUL(LDK(KP707106781), VSUB(T1N, T1K));
	       T26 = VADD(T24, T25);
	  }
	  {
	       V T2i, T2C, T2l, T2D;
	       {
		    V T2g, T2h, T2j, T2k;
		    T2g = LD(&(x[WS(vs, 4) + WS(is, 1)]), dist, &(x[WS(vs, 4) + WS(is, 1)]));
		    T2h = LD(&(x[WS(vs, 4) + WS(is, 5)]), dist, &(x[WS(vs, 4) + WS(is, 1)]));
		    T2i = VSUB(T2g, T2h);
		    T2C = VADD(T2g, T2h);
		    T2j = LD(&(x[WS(vs, 4) + WS(is, 7)]), dist, &(x[WS(vs, 4) + WS(is, 1)]));
		    T2k = LD(&(x[WS(vs, 4) + WS(is, 3)]), dist, &(x[WS(vs, 4) + WS(is, 1)]));
		    T2l = VSUB(T2j, T2k);
		    T2D = VADD(T2j, T2k);
	       }
	       T2m = VMUL(LDK(KP707106781), VADD(T2i, T2l));
	       T2I = VBYI(VSUB(T2D, T2C));
	       T2o = VMUL(LDK(KP707106781), VSUB(T2l, T2i));
	       T2E = VADD(T2C, T2D);
	  }
	  {
	       V T3W, T4g, T3Z, T4h;
	       {
		    V T3U, T3V, T3X, T3Y;
		    T3U = LD(&(x[WS(vs, 7) + WS(is, 1)]), dist, &(x[WS(vs, 7) + WS(is, 1)]));
		    T3V = LD(&(x[WS(vs, 7) + WS(is, 5)]), dist, &(x[WS(vs, 7) + WS(is, 1)]));
		    T3W = VSUB(T3U, T3V);
		    T4g = VADD(T3U, T3V);
		    T3X = LD(&(x[WS(vs, 7) + WS(is, 7)]), dist, &(x[WS(vs, 7) + WS(is, 1)]));
		    T3Y = LD(&(x[WS(vs, 7) + WS(is, 3)]), dist, &(x[WS(vs, 7) + WS(is, 1)]));
		    T3Z = VSUB(T3X, T3Y);
		    T4h = VADD(T3X, T3Y);
	       }
	       T40 = VMUL(LDK(KP707106781), VADD(T3W, T3Z));
	       T4m = VBYI(VSUB(T4h, T4g));
	       T42 = VMUL(LDK(KP707106781), VSUB(T3Z, T3W));
	       T4i = VADD(T4g, T4h);
	  }
	  {
	       V TE, TY, TH, TZ;
	       {
		    V TC, TD, TF, TG;
		    TC = LD(&(x[WS(vs, 1) + WS(is, 1)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
		    TD = LD(&(x[WS(vs, 1) + WS(is, 5)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
		    TE = VSUB(TC, TD);
		    TY = VADD(TC, TD);
		    TF = LD(&(x[WS(vs, 1) + WS(is, 7)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
		    TG = LD(&(x[WS(vs, 1) + WS(is, 3)]), dist, &(x[WS(vs, 1) + WS(is, 1)]));
		    TH = VSUB(TF, TG);
		    TZ = VADD(TF, TG);
	       }
	       TI = VMUL(LDK(KP707106781), VADD(TE, TH));
	       T14 = VBYI(VSUB(TZ, TY));
	       TK = VMUL(LDK(KP707106781), VSUB(TH, TE));
	       T10 = VADD(TY, TZ);
	  }
	  {
	       V T1c, T1w, T1f, T1x;
	       {
		    V T1a, T1b, T1d, T1e;
		    T1a = LD(&(x[WS(vs, 2) + WS(is, 1)]), dist, &(x[WS(vs, 2) + WS(is, 1)]));
		    T1b = LD(&(x[WS(vs, 2) + WS(is, 5)]), dist, &(x[WS(vs, 2) + WS(is, 1)]));
		    T1c = VSUB(T1a, T1b);
		    T1w = VADD(T1a, T1b);
		    T1d = LD(&(x[WS(vs, 2) + WS(is, 7)]), dist, &(x[WS(vs, 2) + WS(is, 1)]));
		    T1e = LD(&(x[WS(vs, 2) + WS(is, 3)]), dist, &(x[WS(vs, 2) + WS(is, 1)]));
		    T1f = VSUB(T1d, T1e);
		    T1x = VADD(T1d, T1e);
	       }
	       T1g = VMUL(LDK(KP707106781), VADD(T1c, T1f));
	       T1C = VBYI(VSUB(T1x, T1w));
	       T1i = VMUL(LDK(KP707106781), VSUB(T1f, T1c));
	       T1y = VADD(T1w, T1x);
	  }
	  {
	       V T2Q, T3a, T2T, T3b;
	       {
		    V T2O, T2P, T2R, T2S;
		    T2O = LD(&(x[WS(vs, 5) + WS(is, 1)]), dist, &(x[WS(vs, 5) + WS(is, 1)]));
		    T2P = LD(&(x[WS(vs, 5) + WS(is, 5)]), dist, &(x[WS(vs, 5) + WS(is, 1)]));
		    T2Q = VSUB(T2O, T2P);
		    T3a = VADD(T2O, T2P);
		    T2R = LD(&(x[WS(vs, 5) + WS(is, 7)]), dist, &(x[WS(vs, 5) + WS(is, 1)]));
		    T2S = LD(&(x[WS(vs, 5) + WS(is, 3)]), dist, &(x[WS(vs, 5) + WS(is, 1)]));
		    T2T = VSUB(T2R, T2S);
		    T3b = VADD(T2R, T2S);
	       }
	       T2U = VMUL(LDK(KP707106781), VADD(T2Q, T2T));
	       T3g = VBYI(VSUB(T3b, T3a));
	       T2W = VMUL(LDK(KP707106781), VSUB(T2T, T2Q));
	       T3c = VADD(T3a, T3b);
	  }
	  {
	       V T3o, T3I, T3r, T3J;
	       {
		    V T3m, T3n, T3p, T3q;
		    T3m = LD(&(x[WS(vs, 6) + WS(is, 1)]), dist, &(x[WS(vs, 6) + WS(is, 1)]));
		    T3n = LD(&(x[WS(vs, 6) + WS(is, 5)]), dist, &(x[WS(vs, 6) + WS(is, 1)]));
		    T3o = VSUB(T3m, T3n);
		    T3I = VADD(T3m, T3n);
		    T3p = LD(&(x[WS(vs, 6) + WS(is, 7)]), dist, &(x[WS(vs, 6) + WS(is, 1)]));
		    T3q = LD(&(x[WS(vs, 6) + WS(is, 3)]), dist, &(x[WS(vs, 6) + WS(is, 1)]));
		    T3r = VSUB(T3p, T3q);
		    T3J = VADD(T3p, T3q);
	       }
	       T3s = VMUL(LDK(KP707106781), VADD(T3o, T3r));
	       T3O = VBYI(VSUB(T3J, T3I));
	       T3u = VMUL(LDK(KP707106781), VSUB(T3r, T3o));
	       T3K = VADD(T3I, T3J);
	  }
	  {
	       V Tu, T1A, T3e, T4k, T3M, T2G;
	       Tu = VADD(Tp, Ts);
	       ST(&(x[0]), Tu, dist, &(x[0]));
	       T1A = VADD(T1v, T1y);
	       ST(&(x[WS(is, 2)]), T1A, dist, &(x[0]));
	       T3e = VADD(T39, T3c);
	       ST(&(x[WS(is, 5)]), T3e, dist, &(x[WS(is, 1)]));
	       T4k = VADD(T4f, T4i);
	       ST(&(x[WS(is, 7)]), T4k, dist, &(x[WS(is, 1)]));
	       T3M = VADD(T3H, T3K);
	       ST(&(x[WS(is, 6)]), T3M, dist, &(x[0]));
	       T2G = VADD(T2B, T2E);
	       ST(&(x[WS(is, 4)]), T2G, dist, &(x[0]));
	  }
	  {
	       V T28, T12, Tt, T4j, T2F, T27;
	       T28 = VADD(T23, T26);
	       ST(&(x[WS(is, 3)]), T28, dist, &(x[WS(is, 1)]));
	       T12 = VADD(TX, T10);
	       ST(&(x[WS(is, 1)]), T12, dist, &(x[WS(is, 1)]));
	       Tt = BYTWJ(&(W[TWVL * 6]), VSUB(Tp, Ts));
	       ST(&(x[WS(vs, 4)]), Tt, dist, &(x[WS(vs, 4)]));
	       T4j = BYTWJ(&(W[TWVL * 6]), VSUB(T4f, T4i));
	       ST(&(x[WS(vs, 4) + WS(is, 7)]), T4j, dist, &(x[WS(vs, 4) + WS(is, 1)]));
	       T2F = BYTWJ(&(W[TWVL * 6]), VSUB(T2B, T2E));
	       ST(&(x[WS(vs, 4) + WS(is, 4)]), T2F, dist, &(x[WS(vs, 4)]));
	       T27 = BYTWJ(&(W[TWVL * 6]), VSUB(T23, T26));
	       ST(&(x[WS(vs, 4) + WS(is, 3)]), T27, dist, &(x[WS(vs, 4) + WS(is, 1)]));
	  }
	  {
	       V T11, T1z, T3L, T3d, T1D, Tx;
	       T11 = BYTWJ(&(W[TWVL * 6]), VSUB(TX, T10));
	       ST(&(x[WS(vs, 4) + WS(is, 1)]), T11, dist, &(x[WS(vs, 4) + WS(is, 1)]));
	       T1z = BYTWJ(&(W[TWVL * 6]), VSUB(T1v, T1y));
	       ST(&(x[WS(vs, 4) + WS(is, 2)]), T1z, dist, &(x[WS(vs, 4)]));
	       T3L = BYTWJ(&(W[TWVL * 6]), VSUB(T3H, T3K));
	       ST(&(x[WS(vs, 4) + WS(is, 6)]), T3L, dist, &(x[WS(vs, 4)]));
	       T3d = BYTWJ(&(W[TWVL * 6]), VSUB(T39, T3c));
	       ST(&(x[WS(vs, 4) + WS(is, 5)]), T3d, dist, &(x[WS(vs, 4) + WS(is, 1)]));
	       T1D = BYTWJ(&(W[TWVL * 10]), VSUB(T1B, T1C));
	       ST(&(x[WS(vs, 6) + WS(is, 2)]), T1D, dist, &(x[WS(vs, 6)]));
	       Tx = BYTWJ(&(W[TWVL * 10]), VSUB(Tv, Tw));
	       ST(&(x[WS(vs, 6)]), Tx, dist, &(x[WS(vs, 6)]));
	  }
	  {
	       V T2J, T3P, T15, T2b, T3h, T4n;
	       T2J = BYTWJ(&(W[TWVL * 10]), VSUB(T2H, T2I));
	       ST(&(x[WS(vs, 6) + WS(is, 4)]), T2J, dist, &(x[WS(vs, 6)]));
	       T3P = BYTWJ(&(W[TWVL * 10]), VSUB(T3N, T3O));
	       ST(&(x[WS(vs, 6) + WS(is, 6)]), T3P, dist, &(x[WS(vs, 6)]));
	       T15 = BYTWJ(&(W[TWVL * 10]), VSUB(T13, T14));
	       ST(&(x[WS(vs, 6) + WS(is, 1)]), T15, dist, &(x[WS(vs, 6) + WS(is, 1)]));
	       T2b = BYTWJ(&(W[TWVL * 10]), VSUB(T29, T2a));
	       ST(&(x[WS(vs, 6) + WS(is, 3)]), T2b, dist, &(x[WS(vs, 6) + WS(is, 1)]));
	       T3h = BYTWJ(&(W[TWVL * 10]), VSUB(T3f, T3g));
	       ST(&(x[WS(vs, 6) + WS(is, 5)]), T3h, dist, &(x[WS(vs, 6) + WS(is, 1)]));
	       T4n = BYTWJ(&(W[TWVL * 10]), VSUB(T4l, T4m));
	       ST(&(x[WS(vs, 6) + WS(is, 7)]), T4n, dist, &(x[WS(vs, 6) + WS(is, 1)]));
	  }
	  {
	       V Ty, T1E, T3i, T4o, T3Q, T2K;
	       Ty = BYTWJ(&(W[TWVL * 2]), VADD(Tv, Tw));
	       ST(&(x[WS(vs, 2)]), Ty, dist, &(x[WS(vs, 2)]));
	       T1E = BYTWJ(&(W[TWVL * 2]), VADD(T1B, T1C));
	       ST(&(x[WS(vs, 2) + WS(is, 2)]), T1E, dist, &(x[WS(vs, 2)]));
	       T3i = BYTWJ(&(W[TWVL * 2]), VADD(T3f, T3g));
	       ST(&(x[WS(vs, 2) + WS(is, 5)]), T3i, dist, &(x[WS(vs, 2) + WS(is, 1)]));
	       T4o = BYTWJ(&(W[TWVL * 2]), VADD(T4l, T4m));
	       ST(&(x[WS(vs, 2) + WS(is, 7)]), T4o, dist, &(x[WS(vs, 2) + WS(is, 1)]));
	       T3Q = BYTWJ(&(W[TWVL * 2]), VADD(T3N, T3O));
	       ST(&(x[WS(vs, 2) + WS(is, 6)]), T3Q, dist, &(x[WS(vs, 2)]));
	       T2K = BYTWJ(&(W[TWVL * 2]), VADD(T2H, T2I));
	       ST(&(x[WS(vs, 2) + WS(is, 4)]), T2K, dist, &(x[WS(vs, 2)]));
	  }
	  T2c = BYTWJ(&(W[TWVL * 2]), VADD(T29, T2a));
	  ST(&(x[WS(vs, 2) + WS(is, 3)]), T2c, dist, &(x[WS(vs, 2) + WS(is, 1)]));
	  T16 = BYTWJ(&(W[TWVL * 2]), VADD(T13, T14));
	  ST(&(x[WS(vs, 2) + WS(is, 1)]), T16, dist, &(x[WS(vs, 2) + WS(is, 1)]));
	  {
	       V Th, Ti, Tb, Tg;
	       Tb = VADD(T3, Ta);
	       Tg = VBYI(VSUB(Tc, Tf));
	       Th = BYTWJ(&(W[TWVL * 12]), VSUB(Tb, Tg));
	       Ti = BYTWJ(&(W[0]), VADD(Tb, Tg));
	       ST(&(x[WS(vs, 7)]), Th, dist, &(x[WS(vs, 7)]));
	       ST(&(x[WS(vs, 1)]), Ti, dist, &(x[WS(vs, 1)]));
	  }
	  {
	       V T47, T48, T41, T46;
	       T41 = VADD(T3T, T40);
	       T46 = VBYI(VSUB(T42, T45));
	       T47 = BYTWJ(&(W[TWVL * 12]), VSUB(T41, T46));
	       T48 = BYTWJ(&(W[0]), VADD(T41, T46));
	       ST(&(x[WS(vs, 7) + WS(is, 7)]), T47, dist, &(x[WS(vs, 7) + WS(is, 1)]));
	       ST(&(x[WS(vs, 1) + WS(is, 7)]), T48, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	  }
	  {
	       V T2t, T2u, T2n, T2s;
	       T2n = VADD(T2f, T2m);
	       T2s = VBYI(VSUB(T2o, T2r));
	       T2t = BYTWJ(&(W[TWVL * 12]), VSUB(T2n, T2s));
	       T2u = BYTWJ(&(W[0]), VADD(T2n, T2s));
	       ST(&(x[WS(vs, 7) + WS(is, 4)]), T2t, dist, &(x[WS(vs, 7)]));
	       ST(&(x[WS(vs, 1) + WS(is, 4)]), T2u, dist, &(x[WS(vs, 1)]));
	  }
	  {
	       V T1V, T1W, T1P, T1U;
	       T1P = VADD(T1H, T1O);
	       T1U = VBYI(VSUB(T1Q, T1T));
	       T1V = BYTWJ(&(W[TWVL * 12]), VSUB(T1P, T1U));
	       T1W = BYTWJ(&(W[0]), VADD(T1P, T1U));
	       ST(&(x[WS(vs, 7) + WS(is, 3)]), T1V, dist, &(x[WS(vs, 7) + WS(is, 1)]));
	       ST(&(x[WS(vs, 1) + WS(is, 3)]), T1W, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	  }
	  {
	       V TP, TQ, TJ, TO;
	       TJ = VADD(TB, TI);
	       TO = VBYI(VSUB(TK, TN));
	       TP = BYTWJ(&(W[TWVL * 12]), VSUB(TJ, TO));
	       TQ = BYTWJ(&(W[0]), VADD(TJ, TO));
	       ST(&(x[WS(vs, 7) + WS(is, 1)]), TP, dist, &(x[WS(vs, 7) + WS(is, 1)]));
	       ST(&(x[WS(vs, 1) + WS(is, 1)]), TQ, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	  }
	  {
	       V T1n, T1o, T1h, T1m;
	       T1h = VADD(T19, T1g);
	       T1m = VBYI(VSUB(T1i, T1l));
	       T1n = BYTWJ(&(W[TWVL * 12]), VSUB(T1h, T1m));
	       T1o = BYTWJ(&(W[0]), VADD(T1h, T1m));
	       ST(&(x[WS(vs, 7) + WS(is, 2)]), T1n, dist, &(x[WS(vs, 7)]));
	       ST(&(x[WS(vs, 1) + WS(is, 2)]), T1o, dist, &(x[WS(vs, 1)]));
	  }
	  {
	       V T3z, T3A, T3t, T3y;
	       T3t = VADD(T3l, T3s);
	       T3y = VBYI(VSUB(T3u, T3x));
	       T3z = BYTWJ(&(W[TWVL * 12]), VSUB(T3t, T3y));
	       T3A = BYTWJ(&(W[0]), VADD(T3t, T3y));
	       ST(&(x[WS(vs, 7) + WS(is, 6)]), T3z, dist, &(x[WS(vs, 7)]));
	       ST(&(x[WS(vs, 1) + WS(is, 6)]), T3A, dist, &(x[WS(vs, 1)]));
	  }
	  {
	       V T31, T32, T2V, T30;
	       T2V = VADD(T2N, T2U);
	       T30 = VBYI(VSUB(T2W, T2Z));
	       T31 = BYTWJ(&(W[TWVL * 12]), VSUB(T2V, T30));
	       T32 = BYTWJ(&(W[0]), VADD(T2V, T30));
	       ST(&(x[WS(vs, 7) + WS(is, 5)]), T31, dist, &(x[WS(vs, 7) + WS(is, 1)]));
	       ST(&(x[WS(vs, 1) + WS(is, 5)]), T32, dist, &(x[WS(vs, 1) + WS(is, 1)]));
	  }
	  {
	       V T1r, T1s, T1p, T1q;
	       T1p = VSUB(T19, T1g);
	       T1q = VBYI(VADD(T1l, T1i));
	       T1r = BYTWJ(&(W[TWVL * 8]), VSUB(T1p, T1q));
	       T1s = BYTWJ(&(W[TWVL * 4]), VADD(T1p, T1q));
	       ST(&(x[WS(vs, 5) + WS(is, 2)]), T1r, dist, &(x[WS(vs, 5)]));
	       ST(&(x[WS(vs, 3) + WS(is, 2)]), T1s, dist, &(x[WS(vs, 3)]));
	  }
	  {
	       V Tl, Tm, Tj, Tk;
	       Tj = VSUB(T3, Ta);
	       Tk = VBYI(VADD(Tf, Tc));
	       Tl = BYTWJ(&(W[TWVL * 8]), VSUB(Tj, Tk));
	       Tm = BYTWJ(&(W[TWVL * 4]), VADD(Tj, Tk));
	       ST(&(x[WS(vs, 5)]), Tl, dist, &(x[WS(vs, 5)]));
	       ST(&(x[WS(vs, 3)]), Tm, dist, &(x[WS(vs, 3)]));
	  }
	  {
	       V T2x, T2y, T2v, T2w;
	       T2v = VSUB(T2f, T2m);
	       T2w = VBYI(VADD(T2r, T2o));
	       T2x = BYTWJ(&(W[TWVL * 8]), VSUB(T2v, T2w));
	       T2y = BYTWJ(&(W[TWVL * 4]), VADD(T2v, T2w));
	       ST(&(x[WS(vs, 5) + WS(is, 4)]), T2x, dist, &(x[WS(vs, 5)]));
	       ST(&(x[WS(vs, 3) + WS(is, 4)]), T2y, dist, &(x[WS(vs, 3)]));
	  }
	  {
	       V T3D, T3E, T3B, T3C;
	       T3B = VSUB(T3l, T3s);
	       T3C = VBYI(VADD(T3x, T3u));
	       T3D = BYTWJ(&(W[TWVL * 8]), VSUB(T3B, T3C));
	       T3E = BYTWJ(&(W[TWVL * 4]), VADD(T3B, T3C));
	       ST(&(x[WS(vs, 5) + WS(is, 6)]), T3D, dist, &(x[WS(vs, 5)]));
	       ST(&(x[WS(vs, 3) + WS(is, 6)]), T3E, dist, &(x[WS(vs, 3)]));
	  }
	  {
	       V TT, TU, TR, TS;
	       TR = VSUB(TB, TI);
	       TS = VBYI(VADD(TN, TK));
	       TT = BYTWJ(&(W[TWVL * 8]), VSUB(TR, TS));
	       TU = BYTWJ(&(W[TWVL * 4]), VADD(TR, TS));
	       ST(&(x[WS(vs, 5) + WS(is, 1)]), TT, dist, &(x[WS(vs, 5) + WS(is, 1)]));
	       ST(&(x[WS(vs, 3) + WS(is, 1)]), TU, dist, &(x[WS(vs, 3) + WS(is, 1)]));
	  }
	  {
	       V T1Z, T20, T1X, T1Y;
	       T1X = VSUB(T1H, T1O);
	       T1Y = VBYI(VADD(T1T, T1Q));
	       T1Z = BYTWJ(&(W[TWVL * 8]), VSUB(T1X, T1Y));
	       T20 = BYTWJ(&(W[TWVL * 4]), VADD(T1X, T1Y));
	       ST(&(x[WS(vs, 5) + WS(is, 3)]), T1Z, dist, &(x[WS(vs, 5) + WS(is, 1)]));
	       ST(&(x[WS(vs, 3) + WS(is, 3)]), T20, dist, &(x[WS(vs, 3) + WS(is, 1)]));
	  }
	  {
	       V T35, T36, T33, T34;
	       T33 = VSUB(T2N, T2U);
	       T34 = VBYI(VADD(T2Z, T2W));
	       T35 = BYTWJ(&(W[TWVL * 8]), VSUB(T33, T34));
	       T36 = BYTWJ(&(W[TWVL * 4]), VADD(T33, T34));
	       ST(&(x[WS(vs, 5) + WS(is, 5)]), T35, dist, &(x[WS(vs, 5) + WS(is, 1)]));
	       ST(&(x[WS(vs, 3) + WS(is, 5)]), T36, dist, &(x[WS(vs, 3) + WS(is, 1)]));
	  }
	  {
	       V T4b, T4c, T49, T4a;
	       T49 = VSUB(T3T, T40);
	       T4a = VBYI(VADD(T45, T42));
	       T4b = BYTWJ(&(W[TWVL * 8]), VSUB(T49, T4a));
	       T4c = BYTWJ(&(W[TWVL * 4]), VADD(T49, T4a));
	       ST(&(x[WS(vs, 5) + WS(is, 7)]), T4b, dist, &(x[WS(vs, 5) + WS(is, 1)]));
	       ST(&(x[WS(vs, 3) + WS(is, 7)]), T4c, dist, &(x[WS(vs, 3) + WS(is, 1)]));
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 8, "q1fv_8", twinstr, {264, 128, 0, 0}, &GENUS, 0, 0, 0 };

void X(codelet_q1fv_8) (planner *p) {
     X(kdft_difsq_register) (p, q1fv_8, &desc);
}
