/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:05:30 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 12 -name t1bv_12 -include t1b.h -sign 1 */

/*
 * This function contains 59 FP additions, 30 FP multiplications,
 * (or, 55 additions, 26 multiplications, 4 fused multiply/add),
 * 28 stack variables, and 24 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1b.h"

static const R *t1bv_12(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     int i;
     R *x;
     x = ii;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 22)) {
	  V T7, TY, Tf, TZ, Tv, TN, Tz, T11, TD, T12, Tr, TM;
	  {
	       V T1, T3, Td, Tb, T9, T5;
	       {
		    V T2, Tc, Ta, T8, T4;
		    T1 = LD(&(x[0]), dist, &(x[0]));
		    T2 = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
		    T3 = BYTW(&(W[TWVL * 6]), T2);
		    Tc = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
		    Td = BYTW(&(W[TWVL * 2]), Tc);
		    Ta = LD(&(x[WS(ios, 10)]), dist, &(x[0]));
		    Tb = BYTW(&(W[TWVL * 18]), Ta);
		    T8 = LD(&(x[WS(ios, 6)]), dist, &(x[0]));
		    T9 = BYTW(&(W[TWVL * 10]), T8);
		    T4 = LD(&(x[WS(ios, 8)]), dist, &(x[0]));
		    T5 = BYTW(&(W[TWVL * 14]), T4);
	       }
	       {
		    V T6, Te, Tt, Tu;
		    T6 = VADD(T3, T5);
		    T7 = VFNMS(LDK(KP500000000), T6, T1);
		    TY = VADD(T1, T6);
		    Te = VADD(Tb, Td);
		    Tf = VFNMS(LDK(KP500000000), Te, T9);
		    TZ = VADD(T9, Te);
		    Tt = VSUB(T3, T5);
		    Tu = VSUB(Tb, Td);
		    Tv = VMUL(LDK(KP866025403), VSUB(Tt, Tu));
		    TN = VADD(Tt, Tu);
	       }
	  }
	  {
	       V Ti, Tk, TB, Tx, Tp, Tn;
	       {
		    V Th, Tj, TA, Tw, To, Tm;
		    Th = LD(&(x[WS(ios, 7)]), dist, &(x[WS(ios, 1)]));
		    Ti = BYTW(&(W[TWVL * 12]), Th);
		    Tj = LD(&(x[WS(ios, 11)]), dist, &(x[WS(ios, 1)]));
		    Tk = BYTW(&(W[TWVL * 20]), Tj);
		    TA = LD(&(x[WS(ios, 9)]), dist, &(x[WS(ios, 1)]));
		    TB = BYTW(&(W[TWVL * 16]), TA);
		    Tw = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
		    Tx = BYTW(&(W[TWVL * 4]), Tw);
		    To = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
		    Tp = BYTW(&(W[TWVL * 8]), To);
		    Tm = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
		    Tn = BYTW(&(W[0]), Tm);
	       }
	       {
		    V Ty, TC, Tl, Tq;
		    Ty = VADD(Ti, Tk);
		    Tz = VFNMS(LDK(KP500000000), Ty, Tx);
		    T11 = VADD(Tx, Ty);
		    TC = VADD(Tn, Tp);
		    TD = VFNMS(LDK(KP500000000), TC, TB);
		    T12 = VADD(TB, TC);
		    Tl = VSUB(Ti, Tk);
		    Tq = VSUB(Tn, Tp);
		    Tr = VMUL(LDK(KP866025403), VSUB(Tl, Tq));
		    TM = VADD(Tl, Tq);
	       }
	  }
	  {
	       V T14, T15, T10, T13;
	       T10 = VSUB(TY, TZ);
	       T13 = VBYI(VSUB(T11, T12));
	       T14 = VSUB(T10, T13);
	       T15 = VADD(T10, T13);
	       ST(&(x[WS(ios, 3)]), T14, dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 9)]), T15, dist, &(x[WS(ios, 1)]));
	  }
	  {
	       V T18, T19, T16, T17;
	       T16 = VADD(TY, TZ);
	       T17 = VADD(T11, T12);
	       T18 = VSUB(T16, T17);
	       T19 = VADD(T16, T17);
	       ST(&(x[WS(ios, 6)]), T18, dist, &(x[0]));
	       ST(&(x[0]), T19, dist, &(x[0]));
	  }
	  {
	       V Ts, TI, TF, TJ, Tg, TE;
	       Tg = VSUB(T7, Tf);
	       Ts = VSUB(Tg, Tr);
	       TI = VADD(Tg, Tr);
	       TE = VSUB(Tz, TD);
	       TF = VBYI(VADD(Tv, TE));
	       TJ = VBYI(VSUB(TE, Tv));
	       {
		    V TG, TL, TH, TK;
		    TG = VSUB(Ts, TF);
		    ST(&(x[WS(ios, 11)]), TG, dist, &(x[WS(ios, 1)]));
		    TL = VADD(TI, TJ);
		    ST(&(x[WS(ios, 5)]), TL, dist, &(x[WS(ios, 1)]));
		    TH = VADD(Ts, TF);
		    ST(&(x[WS(ios, 1)]), TH, dist, &(x[WS(ios, 1)]));
		    TK = VSUB(TI, TJ);
		    ST(&(x[WS(ios, 7)]), TK, dist, &(x[WS(ios, 1)]));
	       }
	  }
	  {
	       V TO, TU, TR, TV, TP, TQ;
	       TO = VBYI(VMUL(LDK(KP866025403), VSUB(TM, TN)));
	       TU = VBYI(VMUL(LDK(KP866025403), VADD(TN, TM)));
	       TP = VADD(T7, Tf);
	       TQ = VADD(Tz, TD);
	       TR = VSUB(TP, TQ);
	       TV = VADD(TP, TQ);
	       {
		    V TS, TX, TT, TW;
		    TS = VADD(TO, TR);
		    ST(&(x[WS(ios, 2)]), TS, dist, &(x[0]));
		    TX = VSUB(TV, TU);
		    ST(&(x[WS(ios, 8)]), TX, dist, &(x[0]));
		    TT = VSUB(TR, TO);
		    ST(&(x[WS(ios, 10)]), TT, dist, &(x[0]));
		    TW = VADD(TU, TV);
		    ST(&(x[WS(ios, 4)]), TW, dist, &(x[0]));
	       }
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     VTW(8),
     VTW(9),
     VTW(10),
     VTW(11),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 12, "t1bv_12", twinstr, {55, 26, 4, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1bv_12) (planner *p) {
     X(kdft_dit_register) (p, t1bv_12, &desc);
}
