/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:05:36 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 16 -name t1bv_16 -include t1b.h -sign 1 */

/*
 * This function contains 87 FP additions, 42 FP multiplications,
 * (or, 83 additions, 38 multiplications, 4 fused multiply/add),
 * 31 stack variables, and 32 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1b.h"

static const R *t1bv_16(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     int i;
     R *x;
     x = ii;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 30)) {
	  V TD, TJ, T1l, T1u, Ty, TK, T1h, T1v, Tb, TM, T1a, T1x, Tm, TN, T1d;
	  V T1y;
	  {
	       V TG, TI, TA, TC, TH, Tz, TB, T1j, T1k;
	       TG = LD(&(x[0]), dist, &(x[0]));
	       TH = LD(&(x[WS(ios, 8)]), dist, &(x[0]));
	       TI = BYTW(&(W[TWVL * 14]), TH);
	       Tz = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
	       TA = BYTW(&(W[TWVL * 6]), Tz);
	       TB = LD(&(x[WS(ios, 12)]), dist, &(x[0]));
	       TC = BYTW(&(W[TWVL * 22]), TB);
	       TD = VSUB(TA, TC);
	       TJ = VSUB(TG, TI);
	       T1j = VADD(TG, TI);
	       T1k = VADD(TA, TC);
	       T1l = VSUB(T1j, T1k);
	       T1u = VADD(T1j, T1k);
	  }
	  {
	       V Tp, Tw, Tr, Tu;
	       {
		    V To, Tv, Tq, Tt;
		    To = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
		    Tp = BYTW(&(W[TWVL * 2]), To);
		    Tv = LD(&(x[WS(ios, 6)]), dist, &(x[0]));
		    Tw = BYTW(&(W[TWVL * 10]), Tv);
		    Tq = LD(&(x[WS(ios, 10)]), dist, &(x[0]));
		    Tr = BYTW(&(W[TWVL * 18]), Tq);
		    Tt = LD(&(x[WS(ios, 14)]), dist, &(x[0]));
		    Tu = BYTW(&(W[TWVL * 26]), Tt);
	       }
	       {
		    V Ts, Tx, T1f, T1g;
		    Ts = VSUB(Tp, Tr);
		    Tx = VSUB(Tu, Tw);
		    Ty = VMUL(LDK(KP707106781), VSUB(Ts, Tx));
		    TK = VMUL(LDK(KP707106781), VADD(Ts, Tx));
		    T1f = VADD(Tp, Tr);
		    T1g = VADD(Tu, Tw);
		    T1h = VSUB(T1f, T1g);
		    T1v = VADD(T1f, T1g);
	       }
	  }
	  {
	       V T2, T9, T4, T7;
	       {
		    V T1, T8, T3, T6;
		    T1 = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
		    T2 = BYTW(&(W[0]), T1);
		    T8 = LD(&(x[WS(ios, 13)]), dist, &(x[WS(ios, 1)]));
		    T9 = BYTW(&(W[TWVL * 24]), T8);
		    T3 = LD(&(x[WS(ios, 9)]), dist, &(x[WS(ios, 1)]));
		    T4 = BYTW(&(W[TWVL * 16]), T3);
		    T6 = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
		    T7 = BYTW(&(W[TWVL * 8]), T6);
	       }
	       {
		    V T5, Ta, T18, T19;
		    T5 = VSUB(T2, T4);
		    Ta = VSUB(T7, T9);
		    Tb = VFNMS(LDK(KP382683432), Ta, VMUL(LDK(KP923879532), T5));
		    TM = VFMA(LDK(KP382683432), T5, VMUL(LDK(KP923879532), Ta));
		    T18 = VADD(T2, T4);
		    T19 = VADD(T7, T9);
		    T1a = VSUB(T18, T19);
		    T1x = VADD(T18, T19);
	       }
	  }
	  {
	       V Td, Tk, Tf, Ti;
	       {
		    V Tc, Tj, Te, Th;
		    Tc = LD(&(x[WS(ios, 15)]), dist, &(x[WS(ios, 1)]));
		    Td = BYTW(&(W[TWVL * 28]), Tc);
		    Tj = LD(&(x[WS(ios, 11)]), dist, &(x[WS(ios, 1)]));
		    Tk = BYTW(&(W[TWVL * 20]), Tj);
		    Te = LD(&(x[WS(ios, 7)]), dist, &(x[WS(ios, 1)]));
		    Tf = BYTW(&(W[TWVL * 12]), Te);
		    Th = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
		    Ti = BYTW(&(W[TWVL * 4]), Th);
	       }
	       {
		    V Tg, Tl, T1b, T1c;
		    Tg = VSUB(Td, Tf);
		    Tl = VSUB(Ti, Tk);
		    Tm = VFMA(LDK(KP923879532), Tg, VMUL(LDK(KP382683432), Tl));
		    TN = VFNMS(LDK(KP382683432), Tg, VMUL(LDK(KP923879532), Tl));
		    T1b = VADD(Td, Tf);
		    T1c = VADD(Ti, Tk);
		    T1d = VSUB(T1b, T1c);
		    T1y = VADD(T1b, T1c);
	       }
	  }
	  {
	       V T1A, T1B, T1w, T1z;
	       T1w = VSUB(T1u, T1v);
	       T1z = VBYI(VSUB(T1x, T1y));
	       T1A = VSUB(T1w, T1z);
	       T1B = VADD(T1w, T1z);
	       ST(&(x[WS(ios, 12)]), T1A, dist, &(x[0]));
	       ST(&(x[WS(ios, 4)]), T1B, dist, &(x[0]));
	  }
	  {
	       V T1E, T1F, T1C, T1D;
	       T1C = VADD(T1u, T1v);
	       T1D = VADD(T1x, T1y);
	       T1E = VSUB(T1C, T1D);
	       T1F = VADD(T1C, T1D);
	       ST(&(x[WS(ios, 8)]), T1E, dist, &(x[0]));
	       ST(&(x[0]), T1F, dist, &(x[0]));
	  }
	  {
	       V T1i, T1q, T1n, T1r, T1e, T1m;
	       T1e = VMUL(LDK(KP707106781), VSUB(T1a, T1d));
	       T1i = VBYI(VSUB(T1e, T1h));
	       T1q = VBYI(VADD(T1h, T1e));
	       T1m = VMUL(LDK(KP707106781), VADD(T1a, T1d));
	       T1n = VSUB(T1l, T1m);
	       T1r = VADD(T1l, T1m);
	       {
		    V T1o, T1t, T1p, T1s;
		    T1o = VADD(T1i, T1n);
		    ST(&(x[WS(ios, 6)]), T1o, dist, &(x[0]));
		    T1t = VSUB(T1r, T1q);
		    ST(&(x[WS(ios, 14)]), T1t, dist, &(x[0]));
		    T1p = VSUB(T1n, T1i);
		    ST(&(x[WS(ios, 10)]), T1p, dist, &(x[0]));
		    T1s = VADD(T1q, T1r);
		    ST(&(x[WS(ios, 2)]), T1s, dist, &(x[0]));
	       }
	  }
	  {
	       V TF, TS, TP, TT;
	       {
		    V Tn, TE, TL, TO;
		    Tn = VSUB(Tb, Tm);
		    TE = VSUB(Ty, TD);
		    TF = VBYI(VSUB(Tn, TE));
		    TS = VBYI(VADD(TE, Tn));
		    TL = VSUB(TJ, TK);
		    TO = VSUB(TM, TN);
		    TP = VSUB(TL, TO);
		    TT = VADD(TL, TO);
	       }
	       {
		    V TQ, TV, TR, TU;
		    TQ = VADD(TF, TP);
		    ST(&(x[WS(ios, 5)]), TQ, dist, &(x[WS(ios, 1)]));
		    TV = VSUB(TT, TS);
		    ST(&(x[WS(ios, 13)]), TV, dist, &(x[WS(ios, 1)]));
		    TR = VSUB(TP, TF);
		    ST(&(x[WS(ios, 11)]), TR, dist, &(x[WS(ios, 1)]));
		    TU = VADD(TS, TT);
		    ST(&(x[WS(ios, 3)]), TU, dist, &(x[WS(ios, 1)]));
	       }
	  }
	  {
	       V TY, T14, T11, T15;
	       {
		    V TW, TX, TZ, T10;
		    TW = VADD(TJ, TK);
		    TX = VADD(Tb, Tm);
		    TY = VADD(TW, TX);
		    T14 = VSUB(TW, TX);
		    TZ = VADD(TD, Ty);
		    T10 = VADD(TM, TN);
		    T11 = VBYI(VADD(TZ, T10));
		    T15 = VBYI(VSUB(T10, TZ));
	       }
	       {
		    V T12, T17, T13, T16;
		    T12 = VSUB(TY, T11);
		    ST(&(x[WS(ios, 15)]), T12, dist, &(x[WS(ios, 1)]));
		    T17 = VADD(T14, T15);
		    ST(&(x[WS(ios, 7)]), T17, dist, &(x[WS(ios, 1)]));
		    T13 = VADD(TY, T11);
		    ST(&(x[WS(ios, 1)]), T13, dist, &(x[WS(ios, 1)]));
		    T16 = VSUB(T14, T15);
		    ST(&(x[WS(ios, 9)]), T16, dist, &(x[WS(ios, 1)]));
	       }
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     VTW(8),
     VTW(9),
     VTW(10),
     VTW(11),
     VTW(12),
     VTW(13),
     VTW(14),
     VTW(15),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 16, "t1bv_16", twinstr, {83, 38, 4, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1bv_16) (planner *p) {
     X(kdft_dit_register) (p, t1bv_16, &desc);
}
