/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:05:10 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 3 -name t1bv_3 -include t1b.h -sign 1 */

/*
 * This function contains 8 FP additions, 6 FP multiplications,
 * (or, 7 additions, 5 multiplications, 1 fused multiply/add),
 * 11 stack variables, and 6 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1b.h"

static const R *t1bv_3(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     int i;
     R *x;
     x = ii;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 4)) {
	  V T6, T5, T7;
	  T6 = LD(&(x[0]), dist, &(x[0]));
	  {
	       V T2, T4, T1, T3;
	       T1 = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
	       T2 = BYTW(&(W[0]), T1);
	       T3 = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
	       T4 = BYTW(&(W[TWVL * 2]), T3);
	       T5 = VBYI(VMUL(LDK(KP866025403), VSUB(T2, T4)));
	       T7 = VADD(T2, T4);
	  }
	  {
	       V Tb, T9, Ta, T8;
	       Tb = VADD(T6, T7);
	       ST(&(x[0]), Tb, dist, &(x[0]));
	       T8 = VFNMS(LDK(KP500000000), T7, T6);
	       T9 = VADD(T5, T8);
	       Ta = VSUB(T8, T5);
	       ST(&(x[WS(ios, 1)]), T9, dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 2)]), Ta, dist, &(x[0]));
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 3, "t1bv_3", twinstr, {7, 5, 1, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1bv_3) (planner *p) {
     X(kdft_dit_register) (p, t1bv_3, &desc);
}
