/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:05:12 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 6 -name t1bv_6 -include t1b.h -sign 1 */

/*
 * This function contains 23 FP additions, 14 FP multiplications,
 * (or, 21 additions, 12 multiplications, 2 fused multiply/add),
 * 25 stack variables, and 12 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1b.h"

static const R *t1bv_6(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     int i;
     R *x;
     x = ii;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 10)) {
	  V Tf, Tl, T5, Ta, Tg, Tm, Tn, To, Tc, Te, Td, Tk, Tt;
	  Tc = LD(&(x[0]), dist, &(x[0]));
	  Td = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
	  Te = BYTW(&(W[TWVL * 4]), Td);
	  Tf = VSUB(Tc, Te);
	  Tl = VADD(Tc, Te);
	  {
	       V T2, T9, T4, T7;
	       {
		    V T1, T8, T3, T6;
		    T1 = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
		    T2 = BYTW(&(W[TWVL * 2]), T1);
		    T8 = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
		    T9 = BYTW(&(W[0]), T8);
		    T3 = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
		    T4 = BYTW(&(W[TWVL * 8]), T3);
		    T6 = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
		    T7 = BYTW(&(W[TWVL * 6]), T6);
	       }
	       T5 = VSUB(T2, T4);
	       Ta = VSUB(T7, T9);
	       Tg = VADD(T5, Ta);
	       Tm = VADD(T2, T4);
	       Tn = VADD(T7, T9);
	       To = VADD(Tm, Tn);
	  }
	  Tk = VADD(Tf, Tg);
	  ST(&(x[WS(ios, 3)]), Tk, dist, &(x[WS(ios, 1)]));
	  Tt = VADD(Tl, To);
	  ST(&(x[0]), Tt, dist, &(x[0]));
	  {
	       V Ti, Tj, Tb, Th;
	       Tb = VBYI(VMUL(LDK(KP866025403), VSUB(T5, Ta)));
	       Th = VFNMS(LDK(KP500000000), Tg, Tf);
	       Ti = VADD(Tb, Th);
	       Tj = VSUB(Th, Tb);
	       ST(&(x[WS(ios, 1)]), Ti, dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 5)]), Tj, dist, &(x[WS(ios, 1)]));
	  }
	  {
	       V Tr, Ts, Tp, Tq;
	       Tp = VFNMS(LDK(KP500000000), To, Tl);
	       Tq = VBYI(VMUL(LDK(KP866025403), VSUB(Tm, Tn)));
	       Tr = VSUB(Tp, Tq);
	       Ts = VADD(Tq, Tp);
	       ST(&(x[WS(ios, 2)]), Tr, dist, &(x[0]));
	       ST(&(x[WS(ios, 4)]), Ts, dist, &(x[0]));
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 6, "t1bv_6", twinstr, {21, 12, 2, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1bv_6) (planner *p) {
     X(kdft_dit_register) (p, t1bv_6, &desc);
}
