/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:05:21 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 9 -name t1bv_9 -include t1b.h -sign 1 */

/*
 * This function contains 54 FP additions, 42 FP multiplications,
 * (or, 38 additions, 26 multiplications, 16 fused multiply/add),
 * 39 stack variables, and 18 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1b.h"

static const R *t1bv_9(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP342020143, +0.342020143325668733044099614682259580763083368);
     DVK(KP813797681, +0.813797681349373692844693217248393223289101568);
     DVK(KP939692620, +0.939692620785908384054109277324731469936208134);
     DVK(KP296198132, +0.296198132726023843175338011893050938967728390);
     DVK(KP642787609, +0.642787609686539326322643409907263432907559884);
     DVK(KP663413948, +0.663413948168938396205421319635891297216863310);
     DVK(KP556670399, +0.556670399226419366452912952047023132968291906);
     DVK(KP766044443, +0.766044443118978035202392650555416673935832457);
     DVK(KP984807753, +0.984807753012208059366743024589523013670643252);
     DVK(KP150383733, +0.150383733180435296639271897612501926072238258);
     DVK(KP852868531, +0.852868531952443209628250963940074071936020296);
     DVK(KP173648177, +0.173648177666930348851716626769314796000375677);
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     int i;
     R *x;
     x = ii;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 16)) {
	  V Tu, T7, TM, TK, Tp, Tq, Tr, Tw, TJ, Tf, Tg, Th, Tv;
	  {
	       V T1, T5, T3, T4, T2, T6;
	       T1 = LD(&(x[0]), dist, &(x[0]));
	       T4 = LD(&(x[WS(ios, 6)]), dist, &(x[0]));
	       T5 = BYTW(&(W[TWVL * 10]), T4);
	       T2 = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
	       T3 = BYTW(&(W[TWVL * 4]), T2);
	       Tu = VMUL(LDK(KP866025403), VSUB(T3, T5));
	       T6 = VADD(T3, T5);
	       T7 = VFNMS(LDK(KP500000000), T6, T1);
	       TM = VADD(T1, T6);
	  }
	  {
	       V Tj, Tl, Tn, To, Ti, Tk, Tm;
	       Ti = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
	       Tj = BYTW(&(W[TWVL * 2]), Ti);
	       Tk = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
	       Tl = BYTW(&(W[TWVL * 8]), Tk);
	       Tm = LD(&(x[WS(ios, 8)]), dist, &(x[0]));
	       Tn = BYTW(&(W[TWVL * 14]), Tm);
	       To = VADD(Tl, Tn);
	       TK = VADD(Tj, To);
	       Tp = VFNMS(LDK(KP500000000), To, Tj);
	       Tq = VSUB(Tl, Tn);
	       Tr = VFNMS(LDK(KP852868531), Tq, VMUL(LDK(KP173648177), Tp));
	       Tw = VFMA(LDK(KP150383733), Tq, VMUL(LDK(KP984807753), Tp));
	  }
	  {
	       V T9, Tb, Td, Te, T8, Ta, Tc;
	       T8 = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
	       T9 = BYTW(&(W[0]), T8);
	       Ta = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
	       Tb = BYTW(&(W[TWVL * 6]), Ta);
	       Tc = LD(&(x[WS(ios, 7)]), dist, &(x[WS(ios, 1)]));
	       Td = BYTW(&(W[TWVL * 12]), Tc);
	       Te = VADD(Tb, Td);
	       TJ = VADD(T9, Te);
	       Tf = VFNMS(LDK(KP500000000), Te, T9);
	       Tg = VSUB(Tb, Td);
	       Th = VFNMS(LDK(KP556670399), Tg, VMUL(LDK(KP766044443), Tf));
	       Tv = VFMA(LDK(KP663413948), Tg, VMUL(LDK(KP642787609), Tf));
	  }
	  {
	       V TH, TI, TF, TG;
	       TF = VFMA(LDK(KP852868531), Tg, VFMA(LDK(KP173648177), Tf, VFMA(LDK(KP296198132), Tq, VFNMS(LDK(KP939692620), Tp, T7))));
	       TG = VBYI(VSUB(VFMA(LDK(KP984807753), Tf, VFMA(LDK(KP813797681), Tq, VFNMS(LDK(KP150383733), Tg, VMUL(LDK(KP342020143), Tp)))), Tu));
	       TH = VSUB(TF, TG);
	       TI = VADD(TF, TG);
	       ST(&(x[WS(ios, 7)]), TH, dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 2)]), TI, dist, &(x[0]));
	  }
	  {
	       V TL, TO, TR, TN, TQ, TP;
	       TL = VBYI(VMUL(LDK(KP866025403), VSUB(TJ, TK)));
	       TN = VADD(TJ, TK);
	       TO = VFNMS(LDK(KP500000000), TN, TM);
	       TR = VADD(TM, TN);
	       ST(&(x[0]), TR, dist, &(x[0]));
	       TQ = VSUB(TO, TL);
	       ST(&(x[WS(ios, 6)]), TQ, dist, &(x[0]));
	       TP = VADD(TL, TO);
	       ST(&(x[WS(ios, 3)]), TP, dist, &(x[WS(ios, 1)]));
	  }
	  {
	       V Tt, TC, Ty, TB, Ts, Tx;
	       Ts = VADD(Th, Tr);
	       Tt = VADD(T7, Ts);
	       TC = VFMA(LDK(KP866025403), VSUB(Tw, Tv), VFNMS(LDK(KP500000000), Ts, T7));
	       Tx = VADD(Tv, Tw);
	       Ty = VBYI(VADD(Tu, Tx));
	       TB = VBYI(VADD(Tu, VFNMS(LDK(KP500000000), Tx, VMUL(LDK(KP866025403), VSUB(Th, Tr)))));
	       {
		    V Tz, TE, TA, TD;
		    Tz = VSUB(Tt, Ty);
		    ST(&(x[WS(ios, 8)]), Tz, dist, &(x[0]));
		    TE = VSUB(TC, TB);
		    ST(&(x[WS(ios, 5)]), TE, dist, &(x[WS(ios, 1)]));
		    TA = VADD(Tt, Ty);
		    ST(&(x[WS(ios, 1)]), TA, dist, &(x[WS(ios, 1)]));
		    TD = VADD(TB, TC);
		    ST(&(x[WS(ios, 4)]), TD, dist, &(x[0]));
	       }
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     VTW(8),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 9, "t1bv_9", twinstr, {38, 26, 16, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1bv_9) (planner *p) {
     X(kdft_dit_register) (p, t1bv_9, &desc);
}
