/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:04:55 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 12 -name t1fv_12 -include t1f.h */

/*
 * This function contains 59 FP additions, 30 FP multiplications,
 * (or, 55 additions, 26 multiplications, 4 fused multiply/add),
 * 28 stack variables, and 24 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1f.h"

static const R *t1fv_12(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     int i;
     R *x;
     x = ri;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 22)) {
	  V T7, TE, Tf, TF, TN, T12, To, TO, Tw, TP, TJ, T11;
	  {
	       V T1, T3, Td, Tb, T9, T5;
	       {
		    V T2, Tc, Ta, T8, T4;
		    T1 = LD(&(x[0]), dist, &(x[0]));
		    T2 = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
		    T3 = BYTWJ(&(W[TWVL * 6]), T2);
		    Tc = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
		    Td = BYTWJ(&(W[TWVL * 2]), Tc);
		    Ta = LD(&(x[WS(ios, 10)]), dist, &(x[0]));
		    Tb = BYTWJ(&(W[TWVL * 18]), Ta);
		    T8 = LD(&(x[WS(ios, 6)]), dist, &(x[0]));
		    T9 = BYTWJ(&(W[TWVL * 10]), T8);
		    T4 = LD(&(x[WS(ios, 8)]), dist, &(x[0]));
		    T5 = BYTWJ(&(W[TWVL * 14]), T4);
	       }
	       {
		    V T6, Te, TL, TM;
		    T6 = VADD(T3, T5);
		    T7 = VADD(T1, T6);
		    TE = VFNMS(LDK(KP500000000), T6, T1);
		    Te = VADD(Tb, Td);
		    Tf = VADD(T9, Te);
		    TF = VFNMS(LDK(KP500000000), Te, T9);
		    TL = VSUB(T5, T3);
		    TM = VSUB(Td, Tb);
		    TN = VMUL(LDK(KP866025403), VSUB(TL, TM));
		    T12 = VADD(TL, TM);
	       }
	  }
	  {
	       V Ti, Tk, Tu, Ts, Tq, Tm;
	       {
		    V Th, Tj, Tt, Tr, Tp, Tl;
		    Th = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
		    Ti = BYTWJ(&(W[TWVL * 4]), Th);
		    Tj = LD(&(x[WS(ios, 7)]), dist, &(x[WS(ios, 1)]));
		    Tk = BYTWJ(&(W[TWVL * 12]), Tj);
		    Tt = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
		    Tu = BYTWJ(&(W[TWVL * 8]), Tt);
		    Tr = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
		    Ts = BYTWJ(&(W[0]), Tr);
		    Tp = LD(&(x[WS(ios, 9)]), dist, &(x[WS(ios, 1)]));
		    Tq = BYTWJ(&(W[TWVL * 16]), Tp);
		    Tl = LD(&(x[WS(ios, 11)]), dist, &(x[WS(ios, 1)]));
		    Tm = BYTWJ(&(W[TWVL * 20]), Tl);
	       }
	       {
		    V Tn, Tv, TH, TI;
		    Tn = VADD(Tk, Tm);
		    To = VADD(Ti, Tn);
		    TO = VFNMS(LDK(KP500000000), Tn, Ti);
		    Tv = VADD(Ts, Tu);
		    Tw = VADD(Tq, Tv);
		    TP = VFNMS(LDK(KP500000000), Tv, Tq);
		    TH = VSUB(Tm, Tk);
		    TI = VSUB(Tu, Ts);
		    TJ = VMUL(LDK(KP866025403), VSUB(TH, TI));
		    T11 = VADD(TH, TI);
	       }
	  }
	  {
	       V Ty, Tz, Tg, Tx;
	       Tg = VSUB(T7, Tf);
	       Tx = VBYI(VSUB(To, Tw));
	       Ty = VSUB(Tg, Tx);
	       Tz = VADD(Tg, Tx);
	       ST(&(x[WS(ios, 9)]), Ty, dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 3)]), Tz, dist, &(x[WS(ios, 1)]));
	  }
	  {
	       V TC, TD, TA, TB;
	       TA = VADD(T7, Tf);
	       TB = VADD(To, Tw);
	       TC = VSUB(TA, TB);
	       TD = VADD(TA, TB);
	       ST(&(x[WS(ios, 6)]), TC, dist, &(x[0]));
	       ST(&(x[0]), TD, dist, &(x[0]));
	  }
	  {
	       V TK, TV, TR, TU, TG, TQ;
	       TG = VSUB(TE, TF);
	       TK = VSUB(TG, TJ);
	       TV = VADD(TG, TJ);
	       TQ = VSUB(TO, TP);
	       TR = VBYI(VADD(TN, TQ));
	       TU = VBYI(VSUB(TN, TQ));
	       {
		    V TS, TX, TT, TW;
		    TS = VSUB(TK, TR);
		    ST(&(x[WS(ios, 5)]), TS, dist, &(x[WS(ios, 1)]));
		    TX = VSUB(TV, TU);
		    ST(&(x[WS(ios, 11)]), TX, dist, &(x[WS(ios, 1)]));
		    TT = VADD(TR, TK);
		    ST(&(x[WS(ios, 7)]), TT, dist, &(x[WS(ios, 1)]));
		    TW = VADD(TU, TV);
		    ST(&(x[WS(ios, 1)]), TW, dist, &(x[WS(ios, 1)]));
	       }
	  }
	  {
	       V T13, T17, T10, T16, TY, TZ;
	       T13 = VBYI(VMUL(LDK(KP866025403), VSUB(T11, T12)));
	       T17 = VBYI(VMUL(LDK(KP866025403), VADD(T12, T11)));
	       TY = VADD(TE, TF);
	       TZ = VADD(TO, TP);
	       T10 = VSUB(TY, TZ);
	       T16 = VADD(TY, TZ);
	       {
		    V T14, T19, T15, T18;
		    T14 = VSUB(T10, T13);
		    ST(&(x[WS(ios, 10)]), T14, dist, &(x[0]));
		    T19 = VADD(T16, T17);
		    ST(&(x[WS(ios, 4)]), T19, dist, &(x[0]));
		    T15 = VADD(T10, T13);
		    ST(&(x[WS(ios, 2)]), T15, dist, &(x[0]));
		    T18 = VSUB(T16, T17);
		    ST(&(x[WS(ios, 8)]), T18, dist, &(x[0]));
	       }
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     VTW(8),
     VTW(9),
     VTW(10),
     VTW(11),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 12, "t1fv_12", twinstr, {55, 26, 4, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1fv_12) (planner *p) {
     X(kdft_dit_register) (p, t1fv_12, &desc);
}
