/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:04:59 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 16 -name t1fv_16 -include t1f.h */

/*
 * This function contains 87 FP additions, 42 FP multiplications,
 * (or, 83 additions, 38 multiplications, 4 fused multiply/add),
 * 31 stack variables, and 32 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1f.h"

static const R *t1fv_16(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     int i;
     R *x;
     x = ri;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 30)) {
	  V TD, TJ, T1a, T1u, Ty, TK, T1l, T1v, Tb, TN, T1g, T1y, Tm, TM, T1d;
	  V T1x;
	  {
	       V TG, TI, TA, TC, TH, Tz, TB, T18, T19;
	       TG = LD(&(x[0]), dist, &(x[0]));
	       TH = LD(&(x[WS(ios, 8)]), dist, &(x[0]));
	       TI = BYTWJ(&(W[TWVL * 14]), TH);
	       Tz = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
	       TA = BYTWJ(&(W[TWVL * 6]), Tz);
	       TB = LD(&(x[WS(ios, 12)]), dist, &(x[0]));
	       TC = BYTWJ(&(W[TWVL * 22]), TB);
	       TD = VSUB(TA, TC);
	       TJ = VSUB(TG, TI);
	       T18 = VADD(TG, TI);
	       T19 = VADD(TA, TC);
	       T1a = VSUB(T18, T19);
	       T1u = VADD(T18, T19);
	  }
	  {
	       V Tp, Tw, Tr, Tu;
	       {
		    V To, Tv, Tq, Tt;
		    To = LD(&(x[WS(ios, 14)]), dist, &(x[0]));
		    Tp = BYTWJ(&(W[TWVL * 26]), To);
		    Tv = LD(&(x[WS(ios, 10)]), dist, &(x[0]));
		    Tw = BYTWJ(&(W[TWVL * 18]), Tv);
		    Tq = LD(&(x[WS(ios, 6)]), dist, &(x[0]));
		    Tr = BYTWJ(&(W[TWVL * 10]), Tq);
		    Tt = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
		    Tu = BYTWJ(&(W[TWVL * 2]), Tt);
	       }
	       {
		    V Ts, Tx, T1j, T1k;
		    Ts = VSUB(Tp, Tr);
		    Tx = VSUB(Tu, Tw);
		    Ty = VMUL(LDK(KP707106781), VSUB(Ts, Tx));
		    TK = VMUL(LDK(KP707106781), VADD(Tx, Ts));
		    T1j = VADD(Tp, Tr);
		    T1k = VADD(Tu, Tw);
		    T1l = VSUB(T1j, T1k);
		    T1v = VADD(T1k, T1j);
	       }
	  }
	  {
	       V T2, T9, T4, T7;
	       {
		    V T1, T8, T3, T6;
		    T1 = LD(&(x[WS(ios, 15)]), dist, &(x[WS(ios, 1)]));
		    T2 = BYTWJ(&(W[TWVL * 28]), T1);
		    T8 = LD(&(x[WS(ios, 11)]), dist, &(x[WS(ios, 1)]));
		    T9 = BYTWJ(&(W[TWVL * 20]), T8);
		    T3 = LD(&(x[WS(ios, 7)]), dist, &(x[WS(ios, 1)]));
		    T4 = BYTWJ(&(W[TWVL * 12]), T3);
		    T6 = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
		    T7 = BYTWJ(&(W[TWVL * 4]), T6);
	       }
	       {
		    V T5, Ta, T1e, T1f;
		    T5 = VSUB(T2, T4);
		    Ta = VSUB(T7, T9);
		    Tb = VFNMS(LDK(KP923879532), Ta, VMUL(LDK(KP382683432), T5));
		    TN = VFMA(LDK(KP923879532), T5, VMUL(LDK(KP382683432), Ta));
		    T1e = VADD(T2, T4);
		    T1f = VADD(T7, T9);
		    T1g = VSUB(T1e, T1f);
		    T1y = VADD(T1e, T1f);
	       }
	  }
	  {
	       V Td, Tk, Tf, Ti;
	       {
		    V Tc, Tj, Te, Th;
		    Tc = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
		    Td = BYTWJ(&(W[0]), Tc);
		    Tj = LD(&(x[WS(ios, 13)]), dist, &(x[WS(ios, 1)]));
		    Tk = BYTWJ(&(W[TWVL * 24]), Tj);
		    Te = LD(&(x[WS(ios, 9)]), dist, &(x[WS(ios, 1)]));
		    Tf = BYTWJ(&(W[TWVL * 16]), Te);
		    Th = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
		    Ti = BYTWJ(&(W[TWVL * 8]), Th);
	       }
	       {
		    V Tg, Tl, T1b, T1c;
		    Tg = VSUB(Td, Tf);
		    Tl = VSUB(Ti, Tk);
		    Tm = VFMA(LDK(KP382683432), Tg, VMUL(LDK(KP923879532), Tl));
		    TM = VFNMS(LDK(KP382683432), Tl, VMUL(LDK(KP923879532), Tg));
		    T1b = VADD(Td, Tf);
		    T1c = VADD(Ti, Tk);
		    T1d = VSUB(T1b, T1c);
		    T1x = VADD(T1b, T1c);
	       }
	  }
	  {
	       V T1A, T1B, T1w, T1z;
	       T1w = VADD(T1u, T1v);
	       T1z = VADD(T1x, T1y);
	       T1A = VSUB(T1w, T1z);
	       T1B = VADD(T1w, T1z);
	       ST(&(x[WS(ios, 8)]), T1A, dist, &(x[0]));
	       ST(&(x[0]), T1B, dist, &(x[0]));
	  }
	  {
	       V T1E, T1F, T1C, T1D;
	       T1C = VSUB(T1u, T1v);
	       T1D = VBYI(VSUB(T1y, T1x));
	       T1E = VSUB(T1C, T1D);
	       T1F = VADD(T1C, T1D);
	       ST(&(x[WS(ios, 12)]), T1E, dist, &(x[0]));
	       ST(&(x[WS(ios, 4)]), T1F, dist, &(x[0]));
	  }
	  {
	       V T1i, T1q, T1n, T1r, T1h, T1m;
	       T1h = VMUL(LDK(KP707106781), VADD(T1d, T1g));
	       T1i = VADD(T1a, T1h);
	       T1q = VSUB(T1a, T1h);
	       T1m = VMUL(LDK(KP707106781), VSUB(T1g, T1d));
	       T1n = VBYI(VADD(T1l, T1m));
	       T1r = VBYI(VSUB(T1m, T1l));
	       {
		    V T1o, T1t, T1p, T1s;
		    T1o = VSUB(T1i, T1n);
		    ST(&(x[WS(ios, 14)]), T1o, dist, &(x[0]));
		    T1t = VADD(T1q, T1r);
		    ST(&(x[WS(ios, 6)]), T1t, dist, &(x[0]));
		    T1p = VADD(T1i, T1n);
		    ST(&(x[WS(ios, 2)]), T1p, dist, &(x[0]));
		    T1s = VSUB(T1q, T1r);
		    ST(&(x[WS(ios, 10)]), T1s, dist, &(x[0]));
	       }
	  }
	  {
	       V TF, TS, TP, TT;
	       {
		    V Tn, TE, TL, TO;
		    Tn = VSUB(Tb, Tm);
		    TE = VSUB(Ty, TD);
		    TF = VBYI(VSUB(Tn, TE));
		    TS = VBYI(VADD(TE, Tn));
		    TL = VADD(TJ, TK);
		    TO = VADD(TM, TN);
		    TP = VSUB(TL, TO);
		    TT = VADD(TL, TO);
	       }
	       {
		    V TQ, TV, TR, TU;
		    TQ = VADD(TF, TP);
		    ST(&(x[WS(ios, 7)]), TQ, dist, &(x[WS(ios, 1)]));
		    TV = VSUB(TT, TS);
		    ST(&(x[WS(ios, 15)]), TV, dist, &(x[WS(ios, 1)]));
		    TR = VSUB(TP, TF);
		    ST(&(x[WS(ios, 9)]), TR, dist, &(x[WS(ios, 1)]));
		    TU = VADD(TS, TT);
		    ST(&(x[WS(ios, 1)]), TU, dist, &(x[WS(ios, 1)]));
	       }
	  }
	  {
	       V TY, T14, T11, T15;
	       {
		    V TW, TX, TZ, T10;
		    TW = VSUB(TJ, TK);
		    TX = VADD(Tm, Tb);
		    TY = VADD(TW, TX);
		    T14 = VSUB(TW, TX);
		    TZ = VADD(TD, Ty);
		    T10 = VSUB(TN, TM);
		    T11 = VBYI(VADD(TZ, T10));
		    T15 = VBYI(VSUB(T10, TZ));
	       }
	       {
		    V T12, T17, T13, T16;
		    T12 = VSUB(TY, T11);
		    ST(&(x[WS(ios, 13)]), T12, dist, &(x[WS(ios, 1)]));
		    T17 = VADD(T14, T15);
		    ST(&(x[WS(ios, 5)]), T17, dist, &(x[WS(ios, 1)]));
		    T13 = VADD(TY, T11);
		    ST(&(x[WS(ios, 3)]), T13, dist, &(x[WS(ios, 1)]));
		    T16 = VSUB(T14, T15);
		    ST(&(x[WS(ios, 11)]), T16, dist, &(x[WS(ios, 1)]));
	       }
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     VTW(8),
     VTW(9),
     VTW(10),
     VTW(11),
     VTW(12),
     VTW(13),
     VTW(14),
     VTW(15),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 16, "t1fv_16", twinstr, {83, 38, 4, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1fv_16) (planner *p) {
     X(kdft_dit_register) (p, t1fv_16, &desc);
}
