/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:04:50 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 6 -name t1fv_6 -include t1f.h */

/*
 * This function contains 23 FP additions, 14 FP multiplications,
 * (or, 21 additions, 12 multiplications, 2 fused multiply/add),
 * 25 stack variables, and 12 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1f.h"

static const R *t1fv_6(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     int i;
     R *x;
     x = ri;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 10)) {
	  V T4, Tl, T9, Te, Tf, Tm, Tn, To, T1, T3, T2, Tg, Tp;
	  T1 = LD(&(x[0]), dist, &(x[0]));
	  T2 = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
	  T3 = BYTWJ(&(W[TWVL * 4]), T2);
	  T4 = VSUB(T1, T3);
	  Tl = VADD(T1, T3);
	  {
	       V T6, Td, T8, Tb;
	       {
		    V T5, Tc, T7, Ta;
		    T5 = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
		    T6 = BYTWJ(&(W[TWVL * 2]), T5);
		    Tc = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
		    Td = BYTWJ(&(W[0]), Tc);
		    T7 = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
		    T8 = BYTWJ(&(W[TWVL * 8]), T7);
		    Ta = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
		    Tb = BYTWJ(&(W[TWVL * 6]), Ta);
	       }
	       T9 = VSUB(T6, T8);
	       Te = VSUB(Tb, Td);
	       Tf = VADD(T9, Te);
	       Tm = VADD(T6, T8);
	       Tn = VADD(Tb, Td);
	       To = VADD(Tm, Tn);
	  }
	  Tg = VADD(T4, Tf);
	  ST(&(x[WS(ios, 3)]), Tg, dist, &(x[WS(ios, 1)]));
	  Tp = VADD(Tl, To);
	  ST(&(x[0]), Tp, dist, &(x[0]));
	  {
	       V Tj, Tk, Th, Ti;
	       Th = VFNMS(LDK(KP500000000), Tf, T4);
	       Ti = VBYI(VMUL(LDK(KP866025403), VSUB(Te, T9)));
	       Tj = VSUB(Th, Ti);
	       Tk = VADD(Th, Ti);
	       ST(&(x[WS(ios, 5)]), Tj, dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 1)]), Tk, dist, &(x[WS(ios, 1)]));
	  }
	  {
	       V Ts, Tt, Tq, Tr;
	       Tq = VFNMS(LDK(KP500000000), To, Tl);
	       Tr = VBYI(VMUL(LDK(KP866025403), VSUB(Tn, Tm)));
	       Ts = VSUB(Tq, Tr);
	       Tt = VADD(Tq, Tr);
	       ST(&(x[WS(ios, 2)]), Ts, dist, &(x[0]));
	       ST(&(x[WS(ios, 4)]), Tt, dist, &(x[0]));
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 6, "t1fv_6", twinstr, {21, 12, 2, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1fv_6) (planner *p) {
     X(kdft_dit_register) (p, t1fv_6, &desc);
}
