/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:04:50 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twiddle_c -simd -trivial-stores -compact -variables 4 -n 7 -name t1fv_7 -include t1f.h */

/*
 * This function contains 36 FP additions, 30 FP multiplications,
 * (or, 24 additions, 18 multiplications, 12 fused multiply/add),
 * 20 stack variables, and 14 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1f.h"

static const R *t1fv_7(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP900968867, +0.900968867902419126236102319507445051165919162);
     DVK(KP222520933, +0.222520933956314404288902564496794759466355569);
     DVK(KP623489801, +0.623489801858733530525004884004239810632274731);
     DVK(KP781831482, +0.781831482468029808708444526674057750232334519);
     DVK(KP974927912, +0.974927912181823607018131682993931217232785801);
     DVK(KP433883739, +0.433883739117558120475768332848358754609990728);
     int i;
     R *x;
     x = ri;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 12)) {
	  V T1, Tg, Tk, T6, Tj, Tb, Tl, Th;
	  T1 = LD(&(x[0]), dist, &(x[0]));
	  {
	       V Td, Tf, Tc, Te;
	       Tc = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
	       Td = BYTWJ(&(W[TWVL * 4]), Tc);
	       Te = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
	       Tf = BYTWJ(&(W[TWVL * 6]), Te);
	       Tg = VADD(Td, Tf);
	       Tk = VSUB(Tf, Td);
	  }
	  {
	       V T3, T5, T2, T4;
	       T2 = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
	       T3 = BYTWJ(&(W[0]), T2);
	       T4 = LD(&(x[WS(ios, 6)]), dist, &(x[0]));
	       T5 = BYTWJ(&(W[TWVL * 10]), T4);
	       T6 = VADD(T3, T5);
	       Tj = VSUB(T5, T3);
	  }
	  {
	       V T8, Ta, T7, T9;
	       T7 = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
	       T8 = BYTWJ(&(W[TWVL * 2]), T7);
	       T9 = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
	       Ta = BYTWJ(&(W[TWVL * 8]), T9);
	       Tb = VADD(T8, Ta);
	       Tl = VSUB(Ta, T8);
	  }
	  Th = VADD(T1, VADD(T6, VADD(Tb, Tg)));
	  ST(&(x[0]), Th, dist, &(x[0]));
	  {
	       V Tv, Tw, Tu, Tt;
	       Tu = VBYI(VFMA(LDK(KP433883739), Tj, VFNMS(LDK(KP781831482), Tl, VMUL(LDK(KP974927912), Tk))));
	       Tt = VFMA(LDK(KP623489801), Tb, VFNMS(LDK(KP222520933), Tg, VFNMS(LDK(KP900968867), T6, T1)));
	       Tv = VSUB(Tt, Tu);
	       Tw = VADD(Tt, Tu);
	       ST(&(x[WS(ios, 4)]), Tv, dist, &(x[0]));
	       ST(&(x[WS(ios, 3)]), Tw, dist, &(x[WS(ios, 1)]));
	  }
	  {
	       V Tn, To, Tm, Ti;
	       Tm = VBYI(VFNMS(LDK(KP781831482), Tk, VFNMS(LDK(KP433883739), Tl, VMUL(LDK(KP974927912), Tj))));
	       Ti = VFMA(LDK(KP623489801), Tg, VFNMS(LDK(KP900968867), Tb, VFNMS(LDK(KP222520933), T6, T1)));
	       Tn = VSUB(Ti, Tm);
	       To = VADD(Ti, Tm);
	       ST(&(x[WS(ios, 5)]), Tn, dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 2)]), To, dist, &(x[0]));
	  }
	  {
	       V Tr, Ts, Tq, Tp;
	       Tq = VBYI(VFMA(LDK(KP781831482), Tj, VFMA(LDK(KP974927912), Tl, VMUL(LDK(KP433883739), Tk))));
	       Tp = VFMA(LDK(KP623489801), T6, VFNMS(LDK(KP900968867), Tg, VFNMS(LDK(KP222520933), Tb, T1)));
	       Tr = VSUB(Tp, Tq);
	       Ts = VADD(Tp, Tq);
	       ST(&(x[WS(ios, 6)]), Tr, dist, &(x[0]));
	       ST(&(x[WS(ios, 1)]), Ts, dist, &(x[WS(ios, 1)]));
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 7, "t1fv_7", twinstr, {24, 18, 12, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1fv_7) (planner *p) {
     X(kdft_dit_register) (p, t1fv_7, &desc);
}
