/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 17:51:25 EDT 2003 */

#include "codelet-rdft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_hc2hc -compact -variables 4 -sign 1 -n 4 -dif -name hb_4 -include hb.h */

/*
 * This function contains 22 FP additions, 12 FP multiplications,
 * (or, 16 additions, 6 multiplications, 6 fused multiply/add),
 * 13 stack variables, and 16 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.9 2003/04/17 19:25:50 athena Exp $
 */

#include "hb.h"

static const R *hb_4(R *rio, R *iio, const R *W, stride ios, int m, int dist)
{
     int i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 6) {
	  E T3, Ti, Tc, Tn, T6, Tm, Tf, Tj;
	  {
	       E T1, T2, Ta, Tb;
	       T1 = rio[0];
	       T2 = iio[-WS(ios, 2)];
	       T3 = T1 + T2;
	       Ti = T1 - T2;
	       Ta = iio[0];
	       Tb = rio[WS(ios, 2)];
	       Tc = Ta - Tb;
	       Tn = Ta + Tb;
	  }
	  {
	       E T4, T5, Td, Te;
	       T4 = rio[WS(ios, 1)];
	       T5 = iio[-WS(ios, 3)];
	       T6 = T4 + T5;
	       Tm = T4 - T5;
	       Td = iio[-WS(ios, 1)];
	       Te = rio[WS(ios, 3)];
	       Tf = Td - Te;
	       Tj = Td + Te;
	  }
	  rio[0] = T3 + T6;
	  iio[-WS(ios, 3)] = Tc + Tf;
	  {
	       E Tq, Ts, Tp, Tr;
	       Tq = Tn - Tm;
	       Ts = Ti + Tj;
	       Tp = W[4];
	       Tr = W[5];
	       iio[0] = FMA(Tp, Tq, Tr * Ts);
	       rio[WS(ios, 3)] = FNMS(Tr, Tq, Tp * Ts);
	  }
	  {
	       E T8, Tg, T7, T9;
	       T8 = T3 - T6;
	       Tg = Tc - Tf;
	       T7 = W[2];
	       T9 = W[3];
	       rio[WS(ios, 2)] = FNMS(T9, Tg, T7 * T8);
	       iio[-WS(ios, 1)] = FMA(T9, T8, T7 * Tg);
	  }
	  {
	       E Tk, To, Th, Tl;
	       Tk = Ti - Tj;
	       To = Tm + Tn;
	       Th = W[0];
	       Tl = W[1];
	       rio[WS(ios, 1)] = FNMS(Tl, To, Th * Tk);
	       iio[-WS(ios, 2)] = FMA(Th, To, Tl * Tk);
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 4},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 4, "hb_4", twinstr, {16, 6, 6, 0}, &GENUS, 0, 0, 0 };

void X(codelet_hb_4) (planner *p) {
     X(khc2hc_dif_register) (p, hb_4, &desc);
}
