/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 17:51:24 EDT 2003 */

#include "codelet-rdft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_hc2r_noinline -compact -variables 4 -sign 1 -n 128 -name mhc2r_128 -include hc2r.h */

/*
 * This function contains 956 FP additions, 342 FP multiplications,
 * (or, 812 additions, 198 multiplications, 144 fused multiply/add),
 * 197 stack variables, and 256 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_hc2r_noinline.ml,v 1.1 2003/04/17 19:25:50 athena Exp $
 */

#include "hc2r.h"

static void mhc2r_128_0(const R *ri, const R *ii, R *O, stride ris, stride iis, stride os)
{
     DK(KP1_028205488, +1.028205488386443453187387677937631545216098241);
     DK(KP1_715457220, +1.715457220000544139804539968569540274084981599);
     DK(KP1_606415062, +1.606415062961289819613353025926283847759138854);
     DK(KP1_191398608, +1.191398608984866686934073057659939779023852677);
     DK(KP1_940062506, +1.940062506389087985207968414572200502913731924);
     DK(KP485960359, +0.485960359806527779896548324154942236641981567);
     DK(KP293460948, +0.293460948910723503317700259293435639412430633);
     DK(KP1_978353019, +1.978353019929561946903347476032486127967379067);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP855110186, +0.855110186860564188641933713777597068609157259);
     DK(KP1_807978586, +1.807978586246886663172400594461074097420264050);
     DK(KP1_481902250, +1.481902250709918182351233794990325459457910619);
     DK(KP1_343117909, +1.343117909694036801250753700854843606457501264);
     DK(KP1_883088130, +1.883088130366041556825018805199004714371179592);
     DK(KP673779706, +0.673779706784440101378506425238295140955533559);
     DK(KP098135348, +0.098135348654836028509909953885365316629490726);
     DK(KP1_997590912, +1.997590912410344785429543209518201388886407229);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP580569354, +0.580569354508924735272384751634790549382952557);
     DK(KP1_913880671, +1.913880671464417729871595773960539938965698411);
     DK(KP942793473, +0.942793473651995297112775251810508755314920638);
     DK(KP1_763842528, +1.763842528696710059425513727320776699016885241);
     DK(KP1_111140466, +1.111140466039204449485661627897065748749874382);
     DK(KP1_662939224, +1.662939224605090474157576755235811513477121624);
     DK(KP1_268786568, +1.268786568327290996430343226450986741351374190);
     DK(KP1_546020906, +1.546020906725473921621813219516939601942082586);
     DK(KP196034280, +0.196034280659121203988391127777283691722273346);
     DK(KP1_990369453, +1.990369453344393772489673906218959843150949737);
     DK(KP390180644, +0.390180644032256535696569736954044481855383236);
     DK(KP1_961570560, +1.961570560806460898252364472268478073947867462);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP765366864, +0.765366864730179543456919968060797733522689125);
     DK(KP1_847759065, +1.847759065022573512256366378793576573644833252);
     DK(KP1_414213562, +1.414213562373095048801688724209698078569671875);
     DK(KP2_000000000, +2.000000000000000000000000000000000000000000000);
     {
	  E Ta, T6q, T2a, T5k, T8x, Tbx, TcF, Ten, Th, T6r, T2j, T5l, T8E, Tby, TcI;
	  E Teo, Tx, T6t, TcM, Teq, TcP, Ter, T2t, T5n, T2C, T5o, T8Q, TbA, T8X, TbB;
	  E T6w, T7L, T1j, T6L, Tde, TeC, TdL, TeR, T3v, T5z, T4I, T5O, T9O, TbM, TaV;
	  E Tc1, T78, T7Z, TN, T6z, TcU, Teu, Td8, Tey, T2N, T5r, T3j, T5v, T9a, TbE;
	  E T9A, TbI, T6H, T7O, T1O, T7V, T48, T4u, Tds, TeG, T5E, T5K, Taf, TbP, Tdp;
	  E TeF, T6U, T72, Tam, TbQ, T23, T7U, T4r, T4v, Tdz, TeJ, T5H, T5L, Tay, TbS;
	  E Tdw, TeI, T6Z, T73, TaF, TbT, T1y, T75, Tdl, TeQ, TdI, TeD, T3O, T5N, T4z;
	  E T5A, Ta3, Tc0, TaO, TbN, T6O, T80, T12, T6E, Td1, Tex, Td5, Tev, T36, T5u;
	  E T3a, T5s, T9p, TbH, T9t, TbF, T6C, T7P;
	  {
	       E T5, T8s, T3, T8q, T9, T8u, T29, T8v, T6, T26;
	       {
		    E T4, T8r, T1, T2;
		    T4 = ri[WS(ris, 32)];
		    T5 = KP2_000000000 * T4;
		    T8r = ii[WS(iis, 32)];
		    T8s = KP2_000000000 * T8r;
		    T1 = ri[0];
		    T2 = ri[WS(ris, 64)];
		    T3 = T1 + T2;
		    T8q = T1 - T2;
		    {
			 E T7, T8, T27, T28;
			 T7 = ri[WS(ris, 16)];
			 T8 = ri[WS(ris, 48)];
			 T9 = KP2_000000000 * (T7 + T8);
			 T8u = T7 - T8;
			 T27 = ii[WS(iis, 16)];
			 T28 = ii[WS(iis, 48)];
			 T29 = KP2_000000000 * (T27 - T28);
			 T8v = T27 + T28;
		    }
	       }
	       T6 = T3 + T5;
	       Ta = T6 + T9;
	       T6q = T6 - T9;
	       T26 = T3 - T5;
	       T2a = T26 - T29;
	       T5k = T26 + T29;
	       {
		    E T8t, T8w, TcD, TcE;
		    T8t = T8q - T8s;
		    T8w = KP1_414213562 * (T8u - T8v);
		    T8x = T8t + T8w;
		    Tbx = T8t - T8w;
		    TcD = T8q + T8s;
		    TcE = KP1_414213562 * (T8u + T8v);
		    TcF = TcD - TcE;
		    Ten = TcD + TcE;
	       }
	  }
	  {
	       E Td, T8y, T2e, T8C, Tg, T8B, T2h, T8z, T2b, T2i;
	       {
		    E Tb, Tc, T2c, T2d;
		    Tb = ri[WS(ris, 8)];
		    Tc = ri[WS(ris, 56)];
		    Td = Tb + Tc;
		    T8y = Tb - Tc;
		    T2c = ii[WS(iis, 8)];
		    T2d = ii[WS(iis, 56)];
		    T2e = T2c - T2d;
		    T8C = T2c + T2d;
	       }
	       {
		    E Te, Tf, T2f, T2g;
		    Te = ri[WS(ris, 40)];
		    Tf = ri[WS(ris, 24)];
		    Tg = Te + Tf;
		    T8B = Te - Tf;
		    T2f = ii[WS(iis, 40)];
		    T2g = ii[WS(iis, 24)];
		    T2h = T2f - T2g;
		    T8z = T2f + T2g;
	       }
	       Th = KP2_000000000 * (Td + Tg);
	       T6r = KP2_000000000 * (T2h + T2e);
	       T2b = Td - Tg;
	       T2i = T2e - T2h;
	       T2j = KP1_414213562 * (T2b - T2i);
	       T5l = KP1_414213562 * (T2b + T2i);
	       {
		    E T8A, T8D, TcG, TcH;
		    T8A = T8y - T8z;
		    T8D = T8B + T8C;
		    T8E = FNMS(KP765366864, T8D, KP1_847759065 * T8A);
		    Tby = FMA(KP765366864, T8A, KP1_847759065 * T8D);
		    TcG = T8y + T8z;
		    TcH = T8C - T8B;
		    TcI = FNMS(KP1_847759065, TcH, KP765366864 * TcG);
		    Teo = FMA(KP1_847759065, TcG, KP765366864 * TcH);
	       }
	  }
	  {
	       E Tl, T8G, T2x, T8V, To, T8U, T2A, T8H, Tv, T8S, T2o, T8O, Ts, T8R, T2r;
	       E T8L;
	       {
		    E Tj, Tk, T2y, T2z;
		    Tj = ri[WS(ris, 4)];
		    Tk = ri[WS(ris, 60)];
		    Tl = Tj + Tk;
		    T8G = Tj - Tk;
		    {
			 E T2v, T2w, Tm, Tn;
			 T2v = ii[WS(iis, 4)];
			 T2w = ii[WS(iis, 60)];
			 T2x = T2v - T2w;
			 T8V = T2v + T2w;
			 Tm = ri[WS(ris, 36)];
			 Tn = ri[WS(ris, 28)];
			 To = Tm + Tn;
			 T8U = Tm - Tn;
		    }
		    T2y = ii[WS(iis, 36)];
		    T2z = ii[WS(iis, 28)];
		    T2A = T2y - T2z;
		    T8H = T2y + T2z;
		    {
			 E Tt, Tu, T8M, T2m, T2n, T8N;
			 Tt = ri[WS(ris, 12)];
			 Tu = ri[WS(ris, 52)];
			 T8M = Tt - Tu;
			 T2m = ii[WS(iis, 52)];
			 T2n = ii[WS(iis, 12)];
			 T8N = T2n + T2m;
			 Tv = Tt + Tu;
			 T8S = T8M + T8N;
			 T2o = T2m - T2n;
			 T8O = T8M - T8N;
		    }
		    {
			 E Tq, Tr, T8J, T2p, T2q, T8K;
			 Tq = ri[WS(ris, 20)];
			 Tr = ri[WS(ris, 44)];
			 T8J = Tq - Tr;
			 T2p = ii[WS(iis, 20)];
			 T2q = ii[WS(iis, 44)];
			 T8K = T2p + T2q;
			 Ts = Tq + Tr;
			 T8R = T8J + T8K;
			 T2r = T2p - T2q;
			 T8L = T8J - T8K;
		    }
	       }
	       {
		    E Tp, Tw, TcK, TcL;
		    Tp = Tl + To;
		    Tw = Ts + Tv;
		    Tx = KP2_000000000 * (Tp + Tw);
		    T6t = Tp - Tw;
		    TcK = T8G + T8H;
		    TcL = KP707106781 * (T8R + T8S);
		    TcM = TcK - TcL;
		    Teq = TcK + TcL;
	       }
	       {
		    E TcN, TcO, T2l, T2s;
		    TcN = KP707106781 * (T8L - T8O);
		    TcO = T8V - T8U;
		    TcP = TcN + TcO;
		    Ter = TcO - TcN;
		    T2l = Tl - To;
		    T2s = T2o - T2r;
		    T2t = T2l + T2s;
		    T5n = T2l - T2s;
	       }
	       {
		    E T2u, T2B, T8I, T8P;
		    T2u = Ts - Tv;
		    T2B = T2x - T2A;
		    T2C = T2u + T2B;
		    T5o = T2B - T2u;
		    T8I = T8G - T8H;
		    T8P = KP707106781 * (T8L + T8O);
		    T8Q = T8I + T8P;
		    TbA = T8I - T8P;
	       }
	       {
		    E T8T, T8W, T6u, T6v;
		    T8T = KP707106781 * (T8R - T8S);
		    T8W = T8U + T8V;
		    T8X = T8T + T8W;
		    TbB = T8W - T8T;
		    T6u = T2A + T2x;
		    T6v = T2r + T2o;
		    T6w = T6u - T6v;
		    T7L = KP2_000000000 * (T6v + T6u);
	       }
	  }
	  {
	       E T17, T9E, T4D, TaT, T1a, TaS, T4G, T9F, T1h, TaQ, T3q, T9M, T1e, TaP, T3t;
	       E T9J;
	       {
		    E T15, T16, T4E, T4F;
		    T15 = ri[WS(ris, 1)];
		    T16 = ri[WS(ris, 63)];
		    T17 = T15 + T16;
		    T9E = T15 - T16;
		    {
			 E T4B, T4C, T18, T19;
			 T4B = ii[WS(iis, 1)];
			 T4C = ii[WS(iis, 63)];
			 T4D = T4B - T4C;
			 TaT = T4B + T4C;
			 T18 = ri[WS(ris, 33)];
			 T19 = ri[WS(ris, 31)];
			 T1a = T18 + T19;
			 TaS = T18 - T19;
		    }
		    T4E = ii[WS(iis, 33)];
		    T4F = ii[WS(iis, 31)];
		    T4G = T4E - T4F;
		    T9F = T4E + T4F;
		    {
			 E T1f, T1g, T9K, T3o, T3p, T9L;
			 T1f = ri[WS(ris, 15)];
			 T1g = ri[WS(ris, 49)];
			 T9K = T1f - T1g;
			 T3o = ii[WS(iis, 49)];
			 T3p = ii[WS(iis, 15)];
			 T9L = T3p + T3o;
			 T1h = T1f + T1g;
			 TaQ = T9K + T9L;
			 T3q = T3o - T3p;
			 T9M = T9K - T9L;
		    }
		    {
			 E T1c, T1d, T9H, T3r, T3s, T9I;
			 T1c = ri[WS(ris, 17)];
			 T1d = ri[WS(ris, 47)];
			 T9H = T1c - T1d;
			 T3r = ii[WS(iis, 17)];
			 T3s = ii[WS(iis, 47)];
			 T9I = T3r + T3s;
			 T1e = T1c + T1d;
			 TaP = T9H + T9I;
			 T3t = T3r - T3s;
			 T9J = T9H - T9I;
		    }
	       }
	       {
		    E T1b, T1i, Tdc, Tdd;
		    T1b = T17 + T1a;
		    T1i = T1e + T1h;
		    T1j = T1b + T1i;
		    T6L = T1b - T1i;
		    Tdc = T9E + T9F;
		    Tdd = KP707106781 * (TaP + TaQ);
		    Tde = Tdc - Tdd;
		    TeC = Tdc + Tdd;
	       }
	       {
		    E TdJ, TdK, T3n, T3u;
		    TdJ = KP707106781 * (T9J - T9M);
		    TdK = TaT - TaS;
		    TdL = TdJ + TdK;
		    TeR = TdK - TdJ;
		    T3n = T17 - T1a;
		    T3u = T3q - T3t;
		    T3v = T3n + T3u;
		    T5z = T3n - T3u;
	       }
	       {
		    E T4A, T4H, T9G, T9N;
		    T4A = T1e - T1h;
		    T4H = T4D - T4G;
		    T4I = T4A + T4H;
		    T5O = T4H - T4A;
		    T9G = T9E - T9F;
		    T9N = KP707106781 * (T9J + T9M);
		    T9O = T9G + T9N;
		    TbM = T9G - T9N;
	       }
	       {
		    E TaR, TaU, T76, T77;
		    TaR = KP707106781 * (TaP - TaQ);
		    TaU = TaS + TaT;
		    TaV = TaR + TaU;
		    Tc1 = TaU - TaR;
		    T76 = T4G + T4D;
		    T77 = T3t + T3q;
		    T78 = T76 - T77;
		    T7Z = T77 + T76;
	       }
	  }
	  {
	       E TB, T90, T3e, T9y, TE, T9x, T3h, T91, TL, T9v, T2I, T98, TI, T9u, T2L;
	       E T95;
	       {
		    E Tz, TA, T3f, T3g;
		    Tz = ri[WS(ris, 2)];
		    TA = ri[WS(ris, 62)];
		    TB = Tz + TA;
		    T90 = Tz - TA;
		    {
			 E T3c, T3d, TC, TD;
			 T3c = ii[WS(iis, 2)];
			 T3d = ii[WS(iis, 62)];
			 T3e = T3c - T3d;
			 T9y = T3c + T3d;
			 TC = ri[WS(ris, 34)];
			 TD = ri[WS(ris, 30)];
			 TE = TC + TD;
			 T9x = TC - TD;
		    }
		    T3f = ii[WS(iis, 34)];
		    T3g = ii[WS(iis, 30)];
		    T3h = T3f - T3g;
		    T91 = T3f + T3g;
		    {
			 E TJ, TK, T96, T2G, T2H, T97;
			 TJ = ri[WS(ris, 14)];
			 TK = ri[WS(ris, 50)];
			 T96 = TJ - TK;
			 T2G = ii[WS(iis, 50)];
			 T2H = ii[WS(iis, 14)];
			 T97 = T2H + T2G;
			 TL = TJ + TK;
			 T9v = T96 + T97;
			 T2I = T2G - T2H;
			 T98 = T96 - T97;
		    }
		    {
			 E TG, TH, T93, T2J, T2K, T94;
			 TG = ri[WS(ris, 18)];
			 TH = ri[WS(ris, 46)];
			 T93 = TG - TH;
			 T2J = ii[WS(iis, 18)];
			 T2K = ii[WS(iis, 46)];
			 T94 = T2J + T2K;
			 TI = TG + TH;
			 T9u = T93 + T94;
			 T2L = T2J - T2K;
			 T95 = T93 - T94;
		    }
	       }
	       {
		    E TF, TM, TcS, TcT;
		    TF = TB + TE;
		    TM = TI + TL;
		    TN = TF + TM;
		    T6z = TF - TM;
		    TcS = T90 + T91;
		    TcT = KP707106781 * (T9u + T9v);
		    TcU = TcS - TcT;
		    Teu = TcS + TcT;
	       }
	       {
		    E Td6, Td7, T2F, T2M;
		    Td6 = KP707106781 * (T95 - T98);
		    Td7 = T9y - T9x;
		    Td8 = Td6 + Td7;
		    Tey = Td7 - Td6;
		    T2F = TB - TE;
		    T2M = T2I - T2L;
		    T2N = T2F + T2M;
		    T5r = T2F - T2M;
	       }
	       {
		    E T3b, T3i, T92, T99;
		    T3b = TI - TL;
		    T3i = T3e - T3h;
		    T3j = T3b + T3i;
		    T5v = T3i - T3b;
		    T92 = T90 - T91;
		    T99 = KP707106781 * (T95 + T98);
		    T9a = T92 + T99;
		    TbE = T92 - T99;
	       }
	       {
		    E T9w, T9z, T6F, T6G;
		    T9w = KP707106781 * (T9u - T9v);
		    T9z = T9x + T9y;
		    T9A = T9w + T9z;
		    TbI = T9z - T9w;
		    T6F = T3h + T3e;
		    T6G = T2L + T2I;
		    T6H = T6F - T6G;
		    T7O = T6G + T6F;
	       }
	  }
	  {
	       E T1G, Taj, T3Q, Ta5, T46, Tak, T6R, Ta6, T1N, Tag, Tah, T3X, T3Z, Taa, Tad;
	       E T6S, Tdn, Tdo;
	       {
		    E T1A, T1B, T1C, T1D, T1E, T1F;
		    T1A = ri[WS(ris, 5)];
		    T1B = ri[WS(ris, 59)];
		    T1C = T1A + T1B;
		    T1D = ri[WS(ris, 37)];
		    T1E = ri[WS(ris, 27)];
		    T1F = T1D + T1E;
		    T1G = T1C + T1F;
		    Taj = T1D - T1E;
		    T3Q = T1C - T1F;
		    Ta5 = T1A - T1B;
	       }
	       {
		    E T40, T41, T42, T43, T44, T45;
		    T40 = ii[WS(iis, 5)];
		    T41 = ii[WS(iis, 59)];
		    T42 = T40 - T41;
		    T43 = ii[WS(iis, 37)];
		    T44 = ii[WS(iis, 27)];
		    T45 = T43 - T44;
		    T46 = T42 - T45;
		    Tak = T40 + T41;
		    T6R = T45 + T42;
		    Ta6 = T43 + T44;
	       }
	       {
		    E T1J, Ta8, T3W, Ta9, T1M, Tab, T3T, Tac;
		    {
			 E T1H, T1I, T3U, T3V;
			 T1H = ri[WS(ris, 21)];
			 T1I = ri[WS(ris, 43)];
			 T1J = T1H + T1I;
			 Ta8 = T1H - T1I;
			 T3U = ii[WS(iis, 21)];
			 T3V = ii[WS(iis, 43)];
			 T3W = T3U - T3V;
			 Ta9 = T3U + T3V;
		    }
		    {
			 E T1K, T1L, T3R, T3S;
			 T1K = ri[WS(ris, 11)];
			 T1L = ri[WS(ris, 53)];
			 T1M = T1K + T1L;
			 Tab = T1K - T1L;
			 T3R = ii[WS(iis, 53)];
			 T3S = ii[WS(iis, 11)];
			 T3T = T3R - T3S;
			 Tac = T3S + T3R;
		    }
		    T1N = T1J + T1M;
		    Tag = Ta8 + Ta9;
		    Tah = Tab + Tac;
		    T3X = T3T - T3W;
		    T3Z = T1J - T1M;
		    Taa = Ta8 - Ta9;
		    Tad = Tab - Tac;
		    T6S = T3W + T3T;
	       }
	       T1O = T1G + T1N;
	       T7V = T6S + T6R;
	       {
		    E T3Y, T47, Tdq, Tdr;
		    T3Y = T3Q + T3X;
		    T47 = T3Z + T46;
		    T48 = FNMS(KP382683432, T47, KP923879532 * T3Y);
		    T4u = FMA(KP382683432, T3Y, KP923879532 * T47);
		    Tdq = KP707106781 * (Taa - Tad);
		    Tdr = Tak - Taj;
		    Tds = Tdq + Tdr;
		    TeG = Tdr - Tdq;
	       }
	       {
		    E T5C, T5D, Ta7, Tae;
		    T5C = T3Q - T3X;
		    T5D = T46 - T3Z;
		    T5E = FNMS(KP923879532, T5D, KP382683432 * T5C);
		    T5K = FMA(KP923879532, T5C, KP382683432 * T5D);
		    Ta7 = Ta5 - Ta6;
		    Tae = KP707106781 * (Taa + Tad);
		    Taf = Ta7 + Tae;
		    TbP = Ta7 - Tae;
	       }
	       Tdn = Ta5 + Ta6;
	       Tdo = KP707106781 * (Tag + Tah);
	       Tdp = Tdn - Tdo;
	       TeF = Tdn + Tdo;
	       {
		    E T6Q, T6T, Tai, Tal;
		    T6Q = T1G - T1N;
		    T6T = T6R - T6S;
		    T6U = T6Q - T6T;
		    T72 = T6Q + T6T;
		    Tai = KP707106781 * (Tag - Tah);
		    Tal = Taj + Tak;
		    Tam = Tai + Tal;
		    TbQ = Tal - Tai;
	       }
	  }
	  {
	       E T1V, TaC, T49, Tao, T4p, TaD, T6W, Tap, T22, Taz, TaA, T4g, T4i, Tat, Taw;
	       E T6X, Tdu, Tdv;
	       {
		    E T1P, T1Q, T1R, T1S, T1T, T1U;
		    T1P = ri[WS(ris, 3)];
		    T1Q = ri[WS(ris, 61)];
		    T1R = T1P + T1Q;
		    T1S = ri[WS(ris, 29)];
		    T1T = ri[WS(ris, 35)];
		    T1U = T1S + T1T;
		    T1V = T1R + T1U;
		    TaC = T1S - T1T;
		    T49 = T1R - T1U;
		    Tao = T1P - T1Q;
	       }
	       {
		    E T4j, T4k, T4l, T4m, T4n, T4o;
		    T4j = ii[WS(iis, 61)];
		    T4k = ii[WS(iis, 3)];
		    T4l = T4j - T4k;
		    T4m = ii[WS(iis, 29)];
		    T4n = ii[WS(iis, 35)];
		    T4o = T4m - T4n;
		    T4p = T4l - T4o;
		    TaD = T4k + T4j;
		    T6W = T4o + T4l;
		    Tap = T4m + T4n;
	       }
	       {
		    E T1Y, Tar, T4f, Tas, T21, Tau, T4c, Tav;
		    {
			 E T1W, T1X, T4d, T4e;
			 T1W = ri[WS(ris, 13)];
			 T1X = ri[WS(ris, 51)];
			 T1Y = T1W + T1X;
			 Tar = T1W - T1X;
			 T4d = ii[WS(iis, 13)];
			 T4e = ii[WS(iis, 51)];
			 T4f = T4d - T4e;
			 Tas = T4d + T4e;
		    }
		    {
			 E T1Z, T20, T4a, T4b;
			 T1Z = ri[WS(ris, 19)];
			 T20 = ri[WS(ris, 45)];
			 T21 = T1Z + T20;
			 Tau = T1Z - T20;
			 T4a = ii[WS(iis, 45)];
			 T4b = ii[WS(iis, 19)];
			 T4c = T4a - T4b;
			 Tav = T4b + T4a;
		    }
		    T22 = T1Y + T21;
		    Taz = Tar + Tas;
		    TaA = Tau + Tav;
		    T4g = T4c - T4f;
		    T4i = T1Y - T21;
		    Tat = Tar - Tas;
		    Taw = Tau - Tav;
		    T6X = T4f + T4c;
	       }
	       T23 = T1V + T22;
	       T7U = T6X + T6W;
	       {
		    E T4h, T4q, Tdx, Tdy;
		    T4h = T49 + T4g;
		    T4q = T4i + T4p;
		    T4r = FMA(KP923879532, T4h, KP382683432 * T4q);
		    T4v = FNMS(KP382683432, T4h, KP923879532 * T4q);
		    Tdx = KP707106781 * (Tat - Taw);
		    Tdy = TaC + TaD;
		    Tdz = Tdx - Tdy;
		    TeJ = Tdx + Tdy;
	       }
	       {
		    E T5F, T5G, Taq, Tax;
		    T5F = T49 - T4g;
		    T5G = T4p - T4i;
		    T5H = FMA(KP382683432, T5F, KP923879532 * T5G);
		    T5L = FNMS(KP923879532, T5F, KP382683432 * T5G);
		    Taq = Tao - Tap;
		    Tax = KP707106781 * (Tat + Taw);
		    Tay = Taq + Tax;
		    TbS = Taq - Tax;
	       }
	       Tdu = Tao + Tap;
	       Tdv = KP707106781 * (Taz + TaA);
	       Tdw = Tdu - Tdv;
	       TeI = Tdu + Tdv;
	       {
		    E T6V, T6Y, TaB, TaE;
		    T6V = T1V - T22;
		    T6Y = T6W - T6X;
		    T6Z = T6V + T6Y;
		    T73 = T6Y - T6V;
		    TaB = KP707106781 * (Taz - TaA);
		    TaE = TaC - TaD;
		    TaF = TaB + TaE;
		    TbT = TaE - TaB;
	       }
	  }
	  {
	       E T1m, T3z, T1p, T3C, T3w, T3D, Tdg, Tdf, T9U, T9R, T1t, T3I, T1w, T3L, T3F;
	       E T3M, Tdj, Tdi, Ta1, T9Y;
	       {
		    E T9P, T9T, T9S, T9Q;
		    {
			 E T1k, T1l, T3x, T3y;
			 T1k = ri[WS(ris, 9)];
			 T1l = ri[WS(ris, 55)];
			 T1m = T1k + T1l;
			 T9P = T1k - T1l;
			 T3x = ii[WS(iis, 9)];
			 T3y = ii[WS(iis, 55)];
			 T3z = T3x - T3y;
			 T9T = T3x + T3y;
		    }
		    {
			 E T1n, T1o, T3A, T3B;
			 T1n = ri[WS(ris, 41)];
			 T1o = ri[WS(ris, 23)];
			 T1p = T1n + T1o;
			 T9S = T1n - T1o;
			 T3A = ii[WS(iis, 41)];
			 T3B = ii[WS(iis, 23)];
			 T3C = T3A - T3B;
			 T9Q = T3A + T3B;
		    }
		    T3w = T1m - T1p;
		    T3D = T3z - T3C;
		    Tdg = T9T - T9S;
		    Tdf = T9P + T9Q;
		    T9U = T9S + T9T;
		    T9R = T9P - T9Q;
	       }
	       {
		    E T9W, Ta0, T9Z, T9X;
		    {
			 E T1r, T1s, T3G, T3H;
			 T1r = ri[WS(ris, 7)];
			 T1s = ri[WS(ris, 57)];
			 T1t = T1r + T1s;
			 T9W = T1r - T1s;
			 T3G = ii[WS(iis, 57)];
			 T3H = ii[WS(iis, 7)];
			 T3I = T3G - T3H;
			 Ta0 = T3H + T3G;
		    }
		    {
			 E T1u, T1v, T3J, T3K;
			 T1u = ri[WS(ris, 25)];
			 T1v = ri[WS(ris, 39)];
			 T1w = T1u + T1v;
			 T9Z = T1u - T1v;
			 T3J = ii[WS(iis, 25)];
			 T3K = ii[WS(iis, 39)];
			 T3L = T3J - T3K;
			 T9X = T3J + T3K;
		    }
		    T3F = T1t - T1w;
		    T3M = T3I - T3L;
		    Tdj = T9Z + Ta0;
		    Tdi = T9W + T9X;
		    Ta1 = T9Z - Ta0;
		    T9Y = T9W - T9X;
	       }
	       {
		    E T1q, T1x, Tdh, Tdk;
		    T1q = T1m + T1p;
		    T1x = T1t + T1w;
		    T1y = T1q + T1x;
		    T75 = T1q - T1x;
		    Tdh = FNMS(KP923879532, Tdg, KP382683432 * Tdf);
		    Tdk = FNMS(KP923879532, Tdj, KP382683432 * Tdi);
		    Tdl = Tdh + Tdk;
		    TeQ = Tdh - Tdk;
	       }
	       {
		    E TdG, TdH, T3E, T3N;
		    TdG = FMA(KP923879532, Tdf, KP382683432 * Tdg);
		    TdH = FMA(KP923879532, Tdi, KP382683432 * Tdj);
		    TdI = TdG - TdH;
		    TeD = TdG + TdH;
		    T3E = T3w - T3D;
		    T3N = T3F + T3M;
		    T3O = KP707106781 * (T3E + T3N);
		    T5N = KP707106781 * (T3E - T3N);
	       }
	       {
		    E T4x, T4y, T9V, Ta2;
		    T4x = T3w + T3D;
		    T4y = T3M - T3F;
		    T4z = KP707106781 * (T4x + T4y);
		    T5A = KP707106781 * (T4y - T4x);
		    T9V = FNMS(KP382683432, T9U, KP923879532 * T9R);
		    Ta2 = FMA(KP923879532, T9Y, KP382683432 * Ta1);
		    Ta3 = T9V + Ta2;
		    Tc0 = T9V - Ta2;
	       }
	       {
		    E TaM, TaN, T6M, T6N;
		    TaM = FMA(KP382683432, T9R, KP923879532 * T9U);
		    TaN = FNMS(KP382683432, T9Y, KP923879532 * Ta1);
		    TaO = TaM + TaN;
		    TbN = TaN - TaM;
		    T6M = T3L + T3I;
		    T6N = T3C + T3z;
		    T6O = T6M - T6N;
		    T80 = T6N + T6M;
	       }
	  }
	  {
	       E TQ, T2R, TT, T2U, T2O, T2V, TcW, TcV, T9g, T9d, TX, T30, T10, T33, T2X;
	       E T34, TcZ, TcY, T9n, T9k;
	       {
		    E T9b, T9f, T9e, T9c;
		    {
			 E TO, TP, T2P, T2Q;
			 TO = ri[WS(ris, 10)];
			 TP = ri[WS(ris, 54)];
			 TQ = TO + TP;
			 T9b = TO - TP;
			 T2P = ii[WS(iis, 10)];
			 T2Q = ii[WS(iis, 54)];
			 T2R = T2P - T2Q;
			 T9f = T2P + T2Q;
		    }
		    {
			 E TR, TS, T2S, T2T;
			 TR = ri[WS(ris, 42)];
			 TS = ri[WS(ris, 22)];
			 TT = TR + TS;
			 T9e = TR - TS;
			 T2S = ii[WS(iis, 42)];
			 T2T = ii[WS(iis, 22)];
			 T2U = T2S - T2T;
			 T9c = T2S + T2T;
		    }
		    T2O = TQ - TT;
		    T2V = T2R - T2U;
		    TcW = T9f - T9e;
		    TcV = T9b + T9c;
		    T9g = T9e + T9f;
		    T9d = T9b - T9c;
	       }
	       {
		    E T9i, T9m, T9l, T9j;
		    {
			 E TV, TW, T2Y, T2Z;
			 TV = ri[WS(ris, 6)];
			 TW = ri[WS(ris, 58)];
			 TX = TV + TW;
			 T9i = TV - TW;
			 T2Y = ii[WS(iis, 58)];
			 T2Z = ii[WS(iis, 6)];
			 T30 = T2Y - T2Z;
			 T9m = T2Z + T2Y;
		    }
		    {
			 E TY, TZ, T31, T32;
			 TY = ri[WS(ris, 26)];
			 TZ = ri[WS(ris, 38)];
			 T10 = TY + TZ;
			 T9l = TY - TZ;
			 T31 = ii[WS(iis, 26)];
			 T32 = ii[WS(iis, 38)];
			 T33 = T31 - T32;
			 T9j = T31 + T32;
		    }
		    T2X = TX - T10;
		    T34 = T30 - T33;
		    TcZ = T9l + T9m;
		    TcY = T9i + T9j;
		    T9n = T9l - T9m;
		    T9k = T9i - T9j;
	       }
	       {
		    E TU, T11, TcX, Td0;
		    TU = TQ + TT;
		    T11 = TX + T10;
		    T12 = TU + T11;
		    T6E = TU - T11;
		    TcX = FNMS(KP923879532, TcW, KP382683432 * TcV);
		    Td0 = FNMS(KP923879532, TcZ, KP382683432 * TcY);
		    Td1 = TcX + Td0;
		    Tex = TcX - Td0;
	       }
	       {
		    E Td3, Td4, T2W, T35;
		    Td3 = FMA(KP923879532, TcV, KP382683432 * TcW);
		    Td4 = FMA(KP923879532, TcY, KP382683432 * TcZ);
		    Td5 = Td3 - Td4;
		    Tev = Td3 + Td4;
		    T2W = T2O - T2V;
		    T35 = T2X + T34;
		    T36 = KP707106781 * (T2W + T35);
		    T5u = KP707106781 * (T2W - T35);
	       }
	       {
		    E T38, T39, T9h, T9o;
		    T38 = T2O + T2V;
		    T39 = T34 - T2X;
		    T3a = KP707106781 * (T38 + T39);
		    T5s = KP707106781 * (T39 - T38);
		    T9h = FNMS(KP382683432, T9g, KP923879532 * T9d);
		    T9o = FMA(KP923879532, T9k, KP382683432 * T9n);
		    T9p = T9h + T9o;
		    TbH = T9h - T9o;
	       }
	       {
		    E T9r, T9s, T6A, T6B;
		    T9r = FMA(KP382683432, T9d, KP923879532 * T9g);
		    T9s = FNMS(KP382683432, T9k, KP923879532 * T9n);
		    T9t = T9r + T9s;
		    TbF = T9s - T9r;
		    T6A = T33 + T30;
		    T6B = T2U + T2R;
		    T6C = T6A - T6B;
		    T7P = T6B + T6A;
	       }
	  }
	  {
	       E T13, T8f, Ty, T8e, T25, T8h, T8k, T8p, Ti, T14, T8o;
	       T13 = KP2_000000000 * (TN + T12);
	       T8f = KP2_000000000 * (T7P + T7O);
	       Ti = Ta + Th;
	       Ty = Ti + Tx;
	       T8e = Ti - Tx;
	       {
		    E T1z, T24, T8i, T8j;
		    T1z = T1j + T1y;
		    T24 = T1O + T23;
		    T25 = KP2_000000000 * (T1z + T24);
		    T8h = T1z - T24;
		    T8i = T80 + T7Z;
		    T8j = T7V + T7U;
		    T8k = T8i - T8j;
		    T8p = KP2_000000000 * (T8j + T8i);
	       }
	       T14 = Ty + T13;
	       O[WS(os, 64)] = T14 - T25;
	       O[0] = T14 + T25;
	       T8o = Ty - T13;
	       O[WS(os, 32)] = T8o - T8p;
	       O[WS(os, 96)] = T8o + T8p;
	       {
		    E T8g, T8l, T8m, T8n;
		    T8g = T8e - T8f;
		    T8l = KP1_414213562 * (T8h - T8k);
		    O[WS(os, 80)] = T8g - T8l;
		    O[WS(os, 16)] = T8g + T8l;
		    T8m = T8e + T8f;
		    T8n = KP1_414213562 * (T8h + T8k);
		    O[WS(os, 48)] = T8m - T8n;
		    O[WS(os, 112)] = T8m + T8n;
	       }
	  }
	  {
	       E T7M, T86, T82, T8a, T7R, T87, T7X, T89, T7K, T7Y, T81;
	       T7K = Ta - Th;
	       T7M = T7K - T7L;
	       T86 = T7K + T7L;
	       T7Y = T1O - T23;
	       T81 = T7Z - T80;
	       T82 = T7Y + T81;
	       T8a = T81 - T7Y;
	       {
		    E T7N, T7Q, T7T, T7W;
		    T7N = TN - T12;
		    T7Q = T7O - T7P;
		    T7R = KP1_414213562 * (T7N - T7Q);
		    T87 = KP1_414213562 * (T7N + T7Q);
		    T7T = T1j - T1y;
		    T7W = T7U - T7V;
		    T7X = T7T + T7W;
		    T89 = T7T - T7W;
	       }
	       {
		    E T7S, T83, T8c, T8d;
		    T7S = T7M + T7R;
		    T83 = FNMS(KP765366864, T82, KP1_847759065 * T7X);
		    O[WS(os, 72)] = T7S - T83;
		    O[WS(os, 8)] = T7S + T83;
		    T8c = T86 + T87;
		    T8d = FMA(KP1_847759065, T89, KP765366864 * T8a);
		    O[WS(os, 56)] = T8c - T8d;
		    O[WS(os, 120)] = T8c + T8d;
	       }
	       {
		    E T84, T85, T88, T8b;
		    T84 = T7M - T7R;
		    T85 = FMA(KP765366864, T7X, KP1_847759065 * T82);
		    O[WS(os, 40)] = T84 - T85;
		    O[WS(os, 104)] = T84 + T85;
		    T88 = T86 - T87;
		    T8b = FNMS(KP1_847759065, T8a, KP765366864 * T89);
		    O[WS(os, 88)] = T88 - T8b;
		    O[WS(os, 24)] = T88 + T8b;
	       }
	  }
	  {
	       E T2E, T4O, T4K, T4S, T3l, T4P, T4t, T4R;
	       {
		    E T2k, T2D, T4w, T4J;
		    T2k = T2a + T2j;
		    T2D = FNMS(KP765366864, T2C, KP1_847759065 * T2t);
		    T2E = T2k + T2D;
		    T4O = T2k - T2D;
		    T4w = T4u + T4v;
		    T4J = T4z + T4I;
		    T4K = T4w + T4J;
		    T4S = T4J - T4w;
	       }
	       {
		    E T37, T3k, T3P, T4s;
		    T37 = T2N + T36;
		    T3k = T3a + T3j;
		    T3l = FNMS(KP390180644, T3k, KP1_961570560 * T37);
		    T4P = FMA(KP390180644, T37, KP1_961570560 * T3k);
		    T3P = T3v + T3O;
		    T4s = T48 + T4r;
		    T4t = T3P + T4s;
		    T4R = T3P - T4s;
	       }
	       {
		    E T3m, T4L, T4U, T4V;
		    T3m = T2E + T3l;
		    T4L = FNMS(KP196034280, T4K, KP1_990369453 * T4t);
		    O[WS(os, 66)] = T3m - T4L;
		    O[WS(os, 2)] = T3m + T4L;
		    T4U = T4O + T4P;
		    T4V = FMA(KP1_546020906, T4R, KP1_268786568 * T4S);
		    O[WS(os, 50)] = T4U - T4V;
		    O[WS(os, 114)] = T4U + T4V;
	       }
	       {
		    E T4M, T4N, T4Q, T4T;
		    T4M = T2E - T3l;
		    T4N = FMA(KP196034280, T4t, KP1_990369453 * T4K);
		    O[WS(os, 34)] = T4M - T4N;
		    O[WS(os, 98)] = T4M + T4N;
		    T4Q = T4O - T4P;
		    T4T = FNMS(KP1_546020906, T4S, KP1_268786568 * T4R);
		    O[WS(os, 82)] = T4Q - T4T;
		    O[WS(os, 18)] = T4Q + T4T;
	       }
	  }
	  {
	       E T6y, T7e, T7a, T7i, T6J, T7f, T71, T7h;
	       {
		    E T6s, T6x, T74, T79;
		    T6s = T6q - T6r;
		    T6x = KP1_414213562 * (T6t - T6w);
		    T6y = T6s + T6x;
		    T7e = T6s - T6x;
		    T74 = KP707106781 * (T72 + T73);
		    T79 = T75 + T78;
		    T7a = T74 + T79;
		    T7i = T79 - T74;
	       }
	       {
		    E T6D, T6I, T6P, T70;
		    T6D = T6z + T6C;
		    T6I = T6E + T6H;
		    T6J = FNMS(KP765366864, T6I, KP1_847759065 * T6D);
		    T7f = FMA(KP765366864, T6D, KP1_847759065 * T6I);
		    T6P = T6L + T6O;
		    T70 = KP707106781 * (T6U + T6Z);
		    T71 = T6P + T70;
		    T7h = T6P - T70;
	       }
	       {
		    E T6K, T7b, T7k, T7l;
		    T6K = T6y + T6J;
		    T7b = FNMS(KP390180644, T7a, KP1_961570560 * T71);
		    O[WS(os, 68)] = T6K - T7b;
		    O[WS(os, 4)] = T6K + T7b;
		    T7k = T7e + T7f;
		    T7l = FMA(KP1_662939224, T7h, KP1_111140466 * T7i);
		    O[WS(os, 52)] = T7k - T7l;
		    O[WS(os, 116)] = T7k + T7l;
	       }
	       {
		    E T7c, T7d, T7g, T7j;
		    T7c = T6y - T6J;
		    T7d = FMA(KP390180644, T71, KP1_961570560 * T7a);
		    O[WS(os, 36)] = T7c - T7d;
		    O[WS(os, 100)] = T7c + T7d;
		    T7g = T7e - T7f;
		    T7j = FNMS(KP1_662939224, T7i, KP1_111140466 * T7h);
		    O[WS(os, 84)] = T7g - T7j;
		    O[WS(os, 20)] = T7g + T7j;
	       }
	  }
	  {
	       E T4Y, T5c, T58, T5g, T51, T5d, T55, T5f;
	       {
		    E T4W, T4X, T56, T57;
		    T4W = T2a - T2j;
		    T4X = FMA(KP765366864, T2t, KP1_847759065 * T2C);
		    T4Y = T4W - T4X;
		    T5c = T4W + T4X;
		    T56 = T48 - T4r;
		    T57 = T4I - T4z;
		    T58 = T56 + T57;
		    T5g = T57 - T56;
	       }
	       {
		    E T4Z, T50, T53, T54;
		    T4Z = T2N - T36;
		    T50 = T3j - T3a;
		    T51 = FNMS(KP1_662939224, T50, KP1_111140466 * T4Z);
		    T5d = FMA(KP1_662939224, T4Z, KP1_111140466 * T50);
		    T53 = T3v - T3O;
		    T54 = T4v - T4u;
		    T55 = T53 + T54;
		    T5f = T53 - T54;
	       }
	       {
		    E T52, T59, T5i, T5j;
		    T52 = T4Y + T51;
		    T59 = FNMS(KP942793473, T58, KP1_763842528 * T55);
		    O[WS(os, 74)] = T52 - T59;
		    O[WS(os, 10)] = T52 + T59;
		    T5i = T5c + T5d;
		    T5j = FMA(KP1_913880671, T5f, KP580569354 * T5g);
		    O[WS(os, 58)] = T5i - T5j;
		    O[WS(os, 122)] = T5i + T5j;
	       }
	       {
		    E T5a, T5b, T5e, T5h;
		    T5a = T4Y - T51;
		    T5b = FMA(KP942793473, T55, KP1_763842528 * T58);
		    O[WS(os, 42)] = T5a - T5b;
		    O[WS(os, 106)] = T5a + T5b;
		    T5e = T5c - T5d;
		    T5h = FNMS(KP1_913880671, T5g, KP580569354 * T5f);
		    O[WS(os, 90)] = T5e - T5h;
		    O[WS(os, 26)] = T5e + T5h;
	       }
	  }
	  {
	       E T7o, T7C, T7y, T7G, T7r, T7D, T7v, T7F;
	       {
		    E T7m, T7n, T7w, T7x;
		    T7m = T6q + T6r;
		    T7n = KP1_414213562 * (T6t + T6w);
		    T7o = T7m - T7n;
		    T7C = T7m + T7n;
		    T7w = KP707106781 * (T6U - T6Z);
		    T7x = T78 - T75;
		    T7y = T7w + T7x;
		    T7G = T7x - T7w;
	       }
	       {
		    E T7p, T7q, T7t, T7u;
		    T7p = T6z - T6C;
		    T7q = T6H - T6E;
		    T7r = FNMS(KP1_847759065, T7q, KP765366864 * T7p);
		    T7D = FMA(KP1_847759065, T7p, KP765366864 * T7q);
		    T7t = T6L - T6O;
		    T7u = KP707106781 * (T73 - T72);
		    T7v = T7t + T7u;
		    T7F = T7t - T7u;
	       }
	       {
		    E T7s, T7z, T7I, T7J;
		    T7s = T7o + T7r;
		    T7z = FNMS(KP1_111140466, T7y, KP1_662939224 * T7v);
		    O[WS(os, 76)] = T7s - T7z;
		    O[WS(os, 12)] = T7s + T7z;
		    T7I = T7C + T7D;
		    T7J = FMA(KP1_961570560, T7F, KP390180644 * T7G);
		    O[WS(os, 60)] = T7I - T7J;
		    O[WS(os, 124)] = T7I + T7J;
	       }
	       {
		    E T7A, T7B, T7E, T7H;
		    T7A = T7o - T7r;
		    T7B = FMA(KP1_111140466, T7v, KP1_662939224 * T7y);
		    O[WS(os, 44)] = T7A - T7B;
		    O[WS(os, 108)] = T7A + T7B;
		    T7E = T7C - T7D;
		    T7H = FNMS(KP1_961570560, T7G, KP390180644 * T7F);
		    O[WS(os, 92)] = T7E - T7H;
		    O[WS(os, 28)] = T7E + T7H;
	       }
	  }
	  {
	       E T5q, T5U, T5Q, T5Y, T5x, T5V, T5J, T5X;
	       {
		    E T5m, T5p, T5M, T5P;
		    T5m = T5k - T5l;
		    T5p = FNMS(KP1_847759065, T5o, KP765366864 * T5n);
		    T5q = T5m + T5p;
		    T5U = T5m - T5p;
		    T5M = T5K + T5L;
		    T5P = T5N + T5O;
		    T5Q = T5M + T5P;
		    T5Y = T5P - T5M;
	       }
	       {
		    E T5t, T5w, T5B, T5I;
		    T5t = T5r + T5s;
		    T5w = T5u + T5v;
		    T5x = FNMS(KP1_111140466, T5w, KP1_662939224 * T5t);
		    T5V = FMA(KP1_111140466, T5t, KP1_662939224 * T5w);
		    T5B = T5z + T5A;
		    T5I = T5E + T5H;
		    T5J = T5B + T5I;
		    T5X = T5B - T5I;
	       }
	       {
		    E T5y, T5R, T60, T61;
		    T5y = T5q + T5x;
		    T5R = FNMS(KP580569354, T5Q, KP1_913880671 * T5J);
		    O[WS(os, 70)] = T5y - T5R;
		    O[WS(os, 6)] = T5y + T5R;
		    T60 = T5U + T5V;
		    T61 = FMA(KP1_763842528, T5X, KP942793473 * T5Y);
		    O[WS(os, 54)] = T60 - T61;
		    O[WS(os, 118)] = T60 + T61;
	       }
	       {
		    E T5S, T5T, T5W, T5Z;
		    T5S = T5q - T5x;
		    T5T = FMA(KP580569354, T5J, KP1_913880671 * T5Q);
		    O[WS(os, 38)] = T5S - T5T;
		    O[WS(os, 102)] = T5S + T5T;
		    T5W = T5U - T5V;
		    T5Z = FNMS(KP1_763842528, T5Y, KP942793473 * T5X);
		    O[WS(os, 86)] = T5W - T5Z;
		    O[WS(os, 22)] = T5W + T5Z;
	       }
	  }
	  {
	       E T64, T6i, T6e, T6m, T67, T6j, T6b, T6l;
	       {
		    E T62, T63, T6c, T6d;
		    T62 = T5k + T5l;
		    T63 = FMA(KP1_847759065, T5n, KP765366864 * T5o);
		    T64 = T62 - T63;
		    T6i = T62 + T63;
		    T6c = T5E - T5H;
		    T6d = T5O - T5N;
		    T6e = T6c + T6d;
		    T6m = T6d - T6c;
	       }
	       {
		    E T65, T66, T69, T6a;
		    T65 = T5r - T5s;
		    T66 = T5v - T5u;
		    T67 = FNMS(KP1_961570560, T66, KP390180644 * T65);
		    T6j = FMA(KP1_961570560, T65, KP390180644 * T66);
		    T69 = T5z - T5A;
		    T6a = T5L - T5K;
		    T6b = T69 + T6a;
		    T6l = T69 - T6a;
	       }
	       {
		    E T68, T6f, T6o, T6p;
		    T68 = T64 + T67;
		    T6f = FNMS(KP1_268786568, T6e, KP1_546020906 * T6b);
		    O[WS(os, 78)] = T68 - T6f;
		    O[WS(os, 14)] = T68 + T6f;
		    T6o = T6i + T6j;
		    T6p = FMA(KP1_990369453, T6l, KP196034280 * T6m);
		    O[WS(os, 62)] = T6o - T6p;
		    O[WS(os, 126)] = T6o + T6p;
	       }
	       {
		    E T6g, T6h, T6k, T6n;
		    T6g = T64 - T67;
		    T6h = FMA(KP1_268786568, T6b, KP1_546020906 * T6e);
		    O[WS(os, 46)] = T6g - T6h;
		    O[WS(os, 110)] = T6g + T6h;
		    T6k = T6i - T6j;
		    T6n = FNMS(KP1_990369453, T6m, KP196034280 * T6l);
		    O[WS(os, 94)] = T6k - T6n;
		    O[WS(os, 30)] = T6k + T6n;
	       }
	  }
	  {
	       E T8Z, Tb1, T9C, Tb2, Tbe, Tbq, Tbb, Tbp, TaX, Tbs, Tb5, Tbi, TaI, Tbt, Tb4;
	       E Tbl;
	       {
		    E T8F, T8Y, Tb9, Tba;
		    T8F = T8x + T8E;
		    T8Y = FNMS(KP390180644, T8X, KP1_961570560 * T8Q);
		    T8Z = T8F + T8Y;
		    Tb1 = T8F - T8Y;
		    {
			 E T9q, T9B, Tbc, Tbd;
			 T9q = T9a + T9p;
			 T9B = T9t + T9A;
			 T9C = FNMS(KP196034280, T9B, KP1_990369453 * T9q);
			 Tb2 = FMA(KP196034280, T9q, KP1_990369453 * T9B);
			 Tbc = T9a - T9p;
			 Tbd = T9A - T9t;
			 Tbe = FNMS(KP1_546020906, Tbd, KP1_268786568 * Tbc);
			 Tbq = FMA(KP1_546020906, Tbc, KP1_268786568 * Tbd);
		    }
		    Tb9 = T8x - T8E;
		    Tba = FMA(KP390180644, T8Q, KP1_961570560 * T8X);
		    Tbb = Tb9 - Tba;
		    Tbp = Tb9 + Tba;
		    {
			 E TaW, Tbg, TaL, Tbh, TaJ, TaK;
			 TaW = TaO + TaV;
			 Tbg = T9O - Ta3;
			 TaJ = FMA(KP195090322, Taf, KP980785280 * Tam);
			 TaK = FNMS(KP195090322, Tay, KP980785280 * TaF);
			 TaL = TaJ + TaK;
			 Tbh = TaK - TaJ;
			 TaX = TaL + TaW;
			 Tbs = Tbg - Tbh;
			 Tb5 = TaW - TaL;
			 Tbi = Tbg + Tbh;
		    }
		    {
			 E Ta4, Tbk, TaH, Tbj, Tan, TaG;
			 Ta4 = T9O + Ta3;
			 Tbk = TaV - TaO;
			 Tan = FNMS(KP195090322, Tam, KP980785280 * Taf);
			 TaG = FMA(KP980785280, Tay, KP195090322 * TaF);
			 TaH = Tan + TaG;
			 Tbj = Tan - TaG;
			 TaI = Ta4 + TaH;
			 Tbt = Tbk - Tbj;
			 Tb4 = Ta4 - TaH;
			 Tbl = Tbj + Tbk;
		    }
	       }
	       {
		    E T9D, TaY, Tbr, Tbu;
		    T9D = T8Z + T9C;
		    TaY = FNMS(KP098135348, TaX, KP1_997590912 * TaI);
		    O[WS(os, 65)] = T9D - TaY;
		    O[WS(os, 1)] = T9D + TaY;
		    Tbr = Tbp - Tbq;
		    Tbu = FNMS(KP1_883088130, Tbt, KP673779706 * Tbs);
		    O[WS(os, 89)] = Tbr - Tbu;
		    O[WS(os, 25)] = Tbr + Tbu;
	       }
	       {
		    E Tbv, Tbw, TaZ, Tb0;
		    Tbv = Tbp + Tbq;
		    Tbw = FMA(KP1_883088130, Tbs, KP673779706 * Tbt);
		    O[WS(os, 57)] = Tbv - Tbw;
		    O[WS(os, 121)] = Tbv + Tbw;
		    TaZ = T8Z - T9C;
		    Tb0 = FMA(KP098135348, TaI, KP1_997590912 * TaX);
		    O[WS(os, 33)] = TaZ - Tb0;
		    O[WS(os, 97)] = TaZ + Tb0;
	       }
	       {
		    E Tb3, Tb6, Tbf, Tbm;
		    Tb3 = Tb1 - Tb2;
		    Tb6 = FNMS(KP1_481902250, Tb5, KP1_343117909 * Tb4);
		    O[WS(os, 81)] = Tb3 - Tb6;
		    O[WS(os, 17)] = Tb3 + Tb6;
		    Tbf = Tbb + Tbe;
		    Tbm = FNMS(KP855110186, Tbl, KP1_807978586 * Tbi);
		    O[WS(os, 73)] = Tbf - Tbm;
		    O[WS(os, 9)] = Tbf + Tbm;
	       }
	       {
		    E Tbn, Tbo, Tb7, Tb8;
		    Tbn = Tbb - Tbe;
		    Tbo = FMA(KP855110186, Tbi, KP1_807978586 * Tbl);
		    O[WS(os, 41)] = Tbn - Tbo;
		    O[WS(os, 105)] = Tbn + Tbo;
		    Tb7 = Tb1 + Tb2;
		    Tb8 = FMA(KP1_481902250, Tb4, KP1_343117909 * Tb5);
		    O[WS(os, 49)] = Tb7 - Tb8;
		    O[WS(os, 113)] = Tb7 + Tb8;
	       }
	  }
	  {
	       E TcR, TdR, Tda, TdS, Te4, Teg, Te1, Tef, TdN, Tei, TdV, Te8, TdC, Tej, TdU;
	       E Teb;
	       {
		    E TcJ, TcQ, TdZ, Te0;
		    TcJ = TcF + TcI;
		    TcQ = FNMS(KP1_111140466, TcP, KP1_662939224 * TcM);
		    TcR = TcJ + TcQ;
		    TdR = TcJ - TcQ;
		    {
			 E Td2, Td9, Te2, Te3;
			 Td2 = TcU + Td1;
			 Td9 = Td5 + Td8;
			 Tda = FNMS(KP580569354, Td9, KP1_913880671 * Td2);
			 TdS = FMA(KP580569354, Td2, KP1_913880671 * Td9);
			 Te2 = TcU - Td1;
			 Te3 = Td8 - Td5;
			 Te4 = FNMS(KP1_763842528, Te3, KP942793473 * Te2);
			 Teg = FMA(KP1_763842528, Te2, KP942793473 * Te3);
		    }
		    TdZ = TcF - TcI;
		    Te0 = FMA(KP1_111140466, TcM, KP1_662939224 * TcP);
		    Te1 = TdZ - Te0;
		    Tef = TdZ + Te0;
		    {
			 E TdM, Te6, TdF, Te7, TdD, TdE;
			 TdM = TdI + TdL;
			 Te6 = Tde - Tdl;
			 TdD = FMA(KP555570233, Tdp, KP831469612 * Tds);
			 TdE = FNMS(KP555570233, Tdw, KP831469612 * Tdz);
			 TdF = TdD + TdE;
			 Te7 = TdE - TdD;
			 TdN = TdF + TdM;
			 Tei = Te6 - Te7;
			 TdV = TdM - TdF;
			 Te8 = Te6 + Te7;
		    }
		    {
			 E Tdm, Tea, TdB, Te9, Tdt, TdA;
			 Tdm = Tde + Tdl;
			 Tea = TdL - TdI;
			 Tdt = FNMS(KP555570233, Tds, KP831469612 * Tdp);
			 TdA = FMA(KP831469612, Tdw, KP555570233 * Tdz);
			 TdB = Tdt + TdA;
			 Te9 = Tdt - TdA;
			 TdC = Tdm + TdB;
			 Tej = Tea - Te9;
			 TdU = Tdm - TdB;
			 Teb = Te9 + Tea;
		    }
	       }
	       {
		    E Tdb, TdO, Teh, Tek;
		    Tdb = TcR + Tda;
		    TdO = FNMS(KP293460948, TdN, KP1_978353019 * TdC);
		    O[WS(os, 67)] = Tdb - TdO;
		    O[WS(os, 3)] = Tdb + TdO;
		    Teh = Tef - Teg;
		    Tek = FNMS(KP1_940062506, Tej, KP485960359 * Tei);
		    O[WS(os, 91)] = Teh - Tek;
		    O[WS(os, 27)] = Teh + Tek;
	       }
	       {
		    E Tel, Tem, TdP, TdQ;
		    Tel = Tef + Teg;
		    Tem = FMA(KP1_940062506, Tei, KP485960359 * Tej);
		    O[WS(os, 59)] = Tel - Tem;
		    O[WS(os, 123)] = Tel + Tem;
		    TdP = TcR - Tda;
		    TdQ = FMA(KP293460948, TdC, KP1_978353019 * TdN);
		    O[WS(os, 35)] = TdP - TdQ;
		    O[WS(os, 99)] = TdP + TdQ;
	       }
	       {
		    E TdT, TdW, Te5, Tec;
		    TdT = TdR - TdS;
		    TdW = FNMS(KP1_606415062, TdV, KP1_191398608 * TdU);
		    O[WS(os, 83)] = TdT - TdW;
		    O[WS(os, 19)] = TdT + TdW;
		    Te5 = Te1 + Te4;
		    Tec = FNMS(KP1_028205488, Teb, KP1_715457220 * Te8);
		    O[WS(os, 75)] = Te5 - Tec;
		    O[WS(os, 11)] = Te5 + Tec;
	       }
	       {
		    E Ted, Tee, TdX, TdY;
		    Ted = Te1 - Te4;
		    Tee = FMA(KP1_028205488, Te8, KP1_715457220 * Teb);
		    O[WS(os, 43)] = Ted - Tee;
		    O[WS(os, 107)] = Ted + Tee;
		    TdX = TdR + TdS;
		    TdY = FMA(KP1_606415062, TdU, KP1_191398608 * TdV);
		    O[WS(os, 51)] = TdX - TdY;
		    O[WS(os, 115)] = TdX + TdY;
	       }
	  }
	  {
	       E TbD, Tc7, TbK, Tc8, Tck, Tcw, Tch, Tcv, Tc3, Tcy, Tcb, Tco, TbW, Tcz, Tca;
	       E Tcr;
	       {
		    E Tbz, TbC, Tcf, Tcg;
		    Tbz = Tbx - Tby;
		    TbC = FNMS(KP1_662939224, TbB, KP1_111140466 * TbA);
		    TbD = Tbz + TbC;
		    Tc7 = Tbz - TbC;
		    {
			 E TbG, TbJ, Tci, Tcj;
			 TbG = TbE + TbF;
			 TbJ = TbH + TbI;
			 TbK = FNMS(KP942793473, TbJ, KP1_763842528 * TbG);
			 Tc8 = FMA(KP942793473, TbG, KP1_763842528 * TbJ);
			 Tci = TbE - TbF;
			 Tcj = TbI - TbH;
			 Tck = FNMS(KP1_913880671, Tcj, KP580569354 * Tci);
			 Tcw = FMA(KP1_913880671, Tci, KP580569354 * Tcj);
		    }
		    Tcf = Tbx + Tby;
		    Tcg = FMA(KP1_662939224, TbA, KP1_111140466 * TbB);
		    Tch = Tcf - Tcg;
		    Tcv = Tcf + Tcg;
		    {
			 E Tc2, Tcm, TbZ, Tcn, TbX, TbY;
			 Tc2 = Tc0 + Tc1;
			 Tcm = TbM - TbN;
			 TbX = FMA(KP831469612, TbP, KP555570233 * TbQ);
			 TbY = FNMS(KP831469612, TbS, KP555570233 * TbT);
			 TbZ = TbX + TbY;
			 Tcn = TbY - TbX;
			 Tc3 = TbZ + Tc2;
			 Tcy = Tcm - Tcn;
			 Tcb = Tc2 - TbZ;
			 Tco = Tcm + Tcn;
		    }
		    {
			 E TbO, Tcq, TbV, Tcp, TbR, TbU;
			 TbO = TbM + TbN;
			 Tcq = Tc1 - Tc0;
			 TbR = FNMS(KP831469612, TbQ, KP555570233 * TbP);
			 TbU = FMA(KP555570233, TbS, KP831469612 * TbT);
			 TbV = TbR + TbU;
			 Tcp = TbR - TbU;
			 TbW = TbO + TbV;
			 Tcz = Tcq - Tcp;
			 Tca = TbO - TbV;
			 Tcr = Tcp + Tcq;
		    }
	       }
	       {
		    E TbL, Tc4, Tcx, TcA;
		    TbL = TbD + TbK;
		    Tc4 = FNMS(KP485960359, Tc3, KP1_940062506 * TbW);
		    O[WS(os, 69)] = TbL - Tc4;
		    O[WS(os, 5)] = TbL + Tc4;
		    Tcx = Tcv - Tcw;
		    TcA = FNMS(KP1_978353019, Tcz, KP293460948 * Tcy);
		    O[WS(os, 93)] = Tcx - TcA;
		    O[WS(os, 29)] = Tcx + TcA;
	       }
	       {
		    E TcB, TcC, Tc5, Tc6;
		    TcB = Tcv + Tcw;
		    TcC = FMA(KP1_978353019, Tcy, KP293460948 * Tcz);
		    O[WS(os, 61)] = TcB - TcC;
		    O[WS(os, 125)] = TcB + TcC;
		    Tc5 = TbD - TbK;
		    Tc6 = FMA(KP485960359, TbW, KP1_940062506 * Tc3);
		    O[WS(os, 37)] = Tc5 - Tc6;
		    O[WS(os, 101)] = Tc5 + Tc6;
	       }
	       {
		    E Tc9, Tcc, Tcl, Tcs;
		    Tc9 = Tc7 - Tc8;
		    Tcc = FNMS(KP1_715457220, Tcb, KP1_028205488 * Tca);
		    O[WS(os, 85)] = Tc9 - Tcc;
		    O[WS(os, 21)] = Tc9 + Tcc;
		    Tcl = Tch + Tck;
		    Tcs = FNMS(KP1_191398608, Tcr, KP1_606415062 * Tco);
		    O[WS(os, 77)] = Tcl - Tcs;
		    O[WS(os, 13)] = Tcl + Tcs;
	       }
	       {
		    E Tct, Tcu, Tcd, Tce;
		    Tct = Tch - Tck;
		    Tcu = FMA(KP1_191398608, Tco, KP1_606415062 * Tcr);
		    O[WS(os, 45)] = Tct - Tcu;
		    O[WS(os, 109)] = Tct + Tcu;
		    Tcd = Tc7 + Tc8;
		    Tce = FMA(KP1_715457220, Tca, KP1_028205488 * Tcb);
		    O[WS(os, 53)] = Tcd - Tce;
		    O[WS(os, 117)] = Tcd + Tce;
	       }
	  }
	  {
	       E Tet, TeX, TeA, TeY, Tfa, Tfm, Tf7, Tfl, TeT, Tfo, Tf1, Tfe, TeM, Tfp, Tf0;
	       E Tfh;
	       {
		    E Tep, Tes, Tf5, Tf6;
		    Tep = Ten - Teo;
		    Tes = FNMS(KP1_961570560, Ter, KP390180644 * Teq);
		    Tet = Tep + Tes;
		    TeX = Tep - Tes;
		    {
			 E Tew, Tez, Tf8, Tf9;
			 Tew = Teu - Tev;
			 Tez = Tex + Tey;
			 TeA = FNMS(KP1_268786568, Tez, KP1_546020906 * Tew);
			 TeY = FMA(KP1_268786568, Tew, KP1_546020906 * Tez);
			 Tf8 = Teu + Tev;
			 Tf9 = Tey - Tex;
			 Tfa = FNMS(KP1_990369453, Tf9, KP196034280 * Tf8);
			 Tfm = FMA(KP1_990369453, Tf8, KP196034280 * Tf9);
		    }
		    Tf5 = Ten + Teo;
		    Tf6 = FMA(KP1_961570560, Teq, KP390180644 * Ter);
		    Tf7 = Tf5 - Tf6;
		    Tfl = Tf5 + Tf6;
		    {
			 E TeS, Tfc, TeP, Tfd, TeN, TeO;
			 TeS = TeQ + TeR;
			 Tfc = TeC + TeD;
			 TeN = FMA(KP980785280, TeF, KP195090322 * TeG);
			 TeO = FMA(KP980785280, TeI, KP195090322 * TeJ);
			 TeP = TeN - TeO;
			 Tfd = TeN + TeO;
			 TeT = TeP + TeS;
			 Tfo = Tfc + Tfd;
			 Tf1 = TeS - TeP;
			 Tfe = Tfc - Tfd;
		    }
		    {
			 E TeE, Tfg, TeL, Tff, TeH, TeK;
			 TeE = TeC - TeD;
			 Tfg = TeR - TeQ;
			 TeH = FNMS(KP980785280, TeG, KP195090322 * TeF);
			 TeK = FNMS(KP980785280, TeJ, KP195090322 * TeI);
			 TeL = TeH + TeK;
			 Tff = TeH - TeK;
			 TeM = TeE + TeL;
			 Tfp = Tfg - Tff;
			 Tf0 = TeE - TeL;
			 Tfh = Tff + Tfg;
		    }
	       }
	       {
		    E TeB, TeU, Tfn, Tfq;
		    TeB = Tet + TeA;
		    TeU = FNMS(KP673779706, TeT, KP1_883088130 * TeM);
		    O[WS(os, 71)] = TeB - TeU;
		    O[WS(os, 7)] = TeB + TeU;
		    Tfn = Tfl - Tfm;
		    Tfq = FNMS(KP1_997590912, Tfp, KP098135348 * Tfo);
		    O[WS(os, 95)] = Tfn - Tfq;
		    O[WS(os, 31)] = Tfn + Tfq;
	       }
	       {
		    E Tfr, Tfs, TeV, TeW;
		    Tfr = Tfl + Tfm;
		    Tfs = FMA(KP1_997590912, Tfo, KP098135348 * Tfp);
		    O[WS(os, 63)] = Tfr - Tfs;
		    O[WS(os, 127)] = Tfr + Tfs;
		    TeV = Tet - TeA;
		    TeW = FMA(KP673779706, TeM, KP1_883088130 * TeT);
		    O[WS(os, 39)] = TeV - TeW;
		    O[WS(os, 103)] = TeV + TeW;
	       }
	       {
		    E TeZ, Tf2, Tfb, Tfi;
		    TeZ = TeX - TeY;
		    Tf2 = FNMS(KP1_807978586, Tf1, KP855110186 * Tf0);
		    O[WS(os, 87)] = TeZ - Tf2;
		    O[WS(os, 23)] = TeZ + Tf2;
		    Tfb = Tf7 + Tfa;
		    Tfi = FNMS(KP1_343117909, Tfh, KP1_481902250 * Tfe);
		    O[WS(os, 79)] = Tfb - Tfi;
		    O[WS(os, 15)] = Tfb + Tfi;
	       }
	       {
		    E Tfj, Tfk, Tf3, Tf4;
		    Tfj = Tf7 - Tfa;
		    Tfk = FMA(KP1_343117909, Tfe, KP1_481902250 * Tfh);
		    O[WS(os, 47)] = Tfj - Tfk;
		    O[WS(os, 111)] = Tfj + Tfk;
		    Tf3 = TeX + TeY;
		    Tf4 = FMA(KP1_807978586, Tf0, KP855110186 * Tf1);
		    O[WS(os, 55)] = Tf3 - Tf4;
		    O[WS(os, 119)] = Tf3 + Tf4;
	       }
	  }
     }
}

static void mhc2r_128(const R *ri, const R *ii, R *O, stride ris, stride iis, stride os, int v, int ivs, int ovs)
{
     int i;
     for (i = v; i > 0; --i) {
	  mhc2r_128_0(ri, ii, O, ris, iis, os);
	  ri += ivs;
	  ii += ivs;
	  O += ovs;
     }
}

static const khc2r_desc desc = { 128, "mhc2r_128", {812, 198, 144, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_mhc2r_128) (planner *p) {
     X(khc2r_register) (p, mhc2r_128, &desc);
}
