/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 17:37:48 EDT 2003 */

#include "codelet-rdft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_r2hc -compact -variables 4 -n 15 -name r2hc_15 -include r2hc.h */

/*
 * This function contains 64 FP additions, 25 FP multiplications,
 * (or, 50 additions, 11 multiplications, 14 fused multiply/add),
 * 47 stack variables, and 30 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_r2hc.ml,v 1.13 2003/04/17 19:25:50 athena Exp $
 */

#include "r2hc.h"

static void r2hc_15(const R *I, R *ro, R *io, stride is, stride ros, stride ios, int v, int ivs, int ovs)
{
     DK(KP484122918, +0.484122918275927110647408174972799951354115213);
     DK(KP216506350, +0.216506350946109661690930792688234045867850657);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP509036960, +0.509036960455127183450980863393907648510733164);
     DK(KP823639103, +0.823639103546331925877420039278190003029660514);
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     int i;
     for (i = v; i > 0; i = i - 1, I = I + ivs, ro = ro + ovs, io = io + ovs) {
	  E Ti, TR, TL, TD, TE, T7, Te, Tf, TV, TW, TX, Tv, Ty, TH, To;
	  E Tr, TG, TS, TT, TU;
	  {
	       E TJ, Tg, Th, TK;
	       TJ = I[0];
	       Tg = I[WS(is, 10)];
	       Th = I[WS(is, 5)];
	       TK = Th + Tg;
	       Ti = Tg - Th;
	       TR = TJ + TK;
	       TL = FNMS(KP500000000, TK, TJ);
	  }
	  {
	       E Tm, Tt, Tw, Tp, T3, Tx, Ta, Tn, Td, Tq, T6, Tu;
	       Tm = I[WS(is, 3)];
	       Tt = I[WS(is, 6)];
	       Tw = I[WS(is, 9)];
	       Tp = I[WS(is, 12)];
	       {
		    E T1, T2, T8, T9;
		    T1 = I[WS(is, 14)];
		    T2 = I[WS(is, 4)];
		    T3 = T1 - T2;
		    Tx = T1 + T2;
		    T8 = I[WS(is, 13)];
		    T9 = I[WS(is, 8)];
		    Ta = T8 - T9;
		    Tn = T9 + T8;
	       }
	       {
		    E Tb, Tc, T4, T5;
		    Tb = I[WS(is, 7)];
		    Tc = I[WS(is, 2)];
		    Td = Tb - Tc;
		    Tq = Tc + Tb;
		    T4 = I[WS(is, 1)];
		    T5 = I[WS(is, 11)];
		    T6 = T4 - T5;
		    Tu = T5 + T4;
	       }
	       TD = Ta - Td;
	       TE = T6 + T3;
	       T7 = T3 - T6;
	       Te = Ta + Td;
	       Tf = T7 - Te;
	       TV = Tt + Tu;
	       TW = Tw + Tx;
	       TX = TV + TW;
	       Tv = FNMS(KP500000000, Tu, Tt);
	       Ty = FNMS(KP500000000, Tx, Tw);
	       TH = Tv + Ty;
	       To = FNMS(KP500000000, Tn, Tm);
	       Tr = FNMS(KP500000000, Tq, Tp);
	       TG = To + Tr;
	       TS = Tm + Tn;
	       TT = Tp + Tq;
	       TU = TS + TT;
	  }
	  io[WS(ios, 5)] = KP866025403 * (Tf - Ti);
	  {
	       E TF, TP, TI, TM, TN, TQ, TO;
	       TF = FMA(KP823639103, TD, KP509036960 * TE);
	       TP = FNMS(KP509036960, TD, KP823639103 * TE);
	       TI = KP559016994 * (TG - TH);
	       TM = TG + TH;
	       TN = FNMS(KP250000000, TM, TL);
	       ro[WS(ros, 5)] = TL + TM;
	       TQ = TN - TI;
	       ro[WS(ros, 2)] = TP + TQ;
	       ro[WS(ros, 7)] = TQ - TP;
	       TO = TI + TN;
	       ro[WS(ros, 1)] = TF + TO;
	       ro[WS(ros, 4)] = TO - TF;
	  }
	  {
	       E T11, T12, T10, TY, TZ;
	       T11 = TS - TT;
	       T12 = TW - TV;
	       io[WS(ios, 3)] = FMA(KP587785252, T11, KP951056516 * T12);
	       io[WS(ios, 6)] = FNMS(KP951056516, T11, KP587785252 * T12);
	       T10 = KP559016994 * (TU - TX);
	       TY = TU + TX;
	       TZ = FNMS(KP250000000, TY, TR);
	       ro[WS(ros, 3)] = TZ - T10;
	       ro[0] = TR + TY;
	       ro[WS(ros, 6)] = T10 + TZ;
	       {
		    E Tl, TB, TA, TC;
		    {
			 E Tj, Tk, Ts, Tz;
			 Tj = FMA(KP866025403, Ti, KP216506350 * Tf);
			 Tk = KP484122918 * (Te + T7);
			 Tl = Tj + Tk;
			 TB = Tk - Tj;
			 Ts = To - Tr;
			 Tz = Tv - Ty;
			 TA = FMA(KP951056516, Ts, KP587785252 * Tz);
			 TC = FNMS(KP587785252, Ts, KP951056516 * Tz);
		    }
		    io[WS(ios, 1)] = Tl - TA;
		    io[WS(ios, 7)] = TC - TB;
		    io[WS(ios, 4)] = Tl + TA;
		    io[WS(ios, 2)] = TB + TC;
	       }
	  }
     }
}

static const kr2hc_desc desc = { 15, "r2hc_15", {50, 11, 14, 0}, &GENUS, 0, 0, 0, 0, 0 };

void X(codelet_r2hc_15) (planner *p) {
     X(kr2hc_register) (p, r2hc_15, &desc);
}
