.\"
.\" Copyright (c) Christos Zoulas 2003.
.\" All Rights Reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice immediately at the beginning of the file, without modification,
.\"    this list of conditions, and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. The name of the author may not be used to endorse or promote products
.\"    derived from this software without specific prior written permission.
.\" 
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
.\" ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.Dd March 22, 2003
.Dt MAGIC 3
.Os
.Sh NAME
.Nm magic_open ,
.Nm magic_close ,
.Nm magic_error ,
.Nm magic_file ,
.Nm magic_buffer ,
.Nm magic_setflags ,
.Nm magic_check ,
.Nm magic_compile ,
.Nm magic_load
.Nd Magic number recognition library.
.Sh LIBRARY
.Lb libmagic
.Sh SYNOPSIS
.Fd #include \*[Lt]magic.h\*[Gt]
.Ft magic_t
.Fn magic_open "int flags"
.Ft void
.Fn magic_close "magic_t cookie"
.Ft const char *
.Fn magic_error "magic_t cookie"
.Ft const char *
.Fn magic_file "magic_t cookie, const char *filename"
.Ft const char *
.Fn magic_buffer "magic_t cookie, const void *buffer, size_t length"
.Ft void
.Fn magic_setflags "magic_t cookie, int flags"
.Ft int
.Fn magic_check "magic_t cookie, const char *filename"
.Ft int
.Fn magic_compile "magic_t cookie, const char *filename"
.Ft int
.Fn magic_load "magic_t cookie, const char *filename"
.Sh DESCRIPTION
These functions
operate on the magic database file
which is described
in
.Xr magic __FSECTION__ .
.Pp
The function
.Fn magic_open
creates a magic cookie pointer and returns it. It returns NULL if
there was an error allocating the magic cookie. The 
.Ar flags
argument specifies how the other magic functions should behave:
.Bl -tag -width MAGIC_COMPRESS
.It Dv MAGIC_NONE
No special handling.
.It Dv MAGIC_DEBUG
Print debugging messages to stderr.
.It Dv MAGIC_SYMLINK
If the file queried is a symlink, follow it.
.It Dv MAGIC_COMPRESS
If the file is compressed, unpack it and look at the contents.
.It Dv MAGIC_DEVICES
If the file is a block or character special device, then open the device
and try to look in its contents.
.It Dv MAGIC_MIME
Return a mime string, instead of a textual description.
.It Dv MAGIC_CONTINUE
Return all matches, not just the first.
.It Dv MAGIC_CHECK
Check the magic database for consistency and print warnings to stderr.
.El
.Pp
The
.Fn magic_close
function closes the
.Xr magic __FSECTION__
database and deallocates any resources used.
.Pp
The
.Fn magic_error
function returns a textual explanation of the last error, or NULL if there was
no error.
.Pp
The
.Fn magic_file
function returns a textual description of the contents of the
.Ar filename
argument, or NULL if an error occurred.
If the
.Ar filename
is NULL, then stdin is used.
.Pp
The
.Fn magic_buffer
function returns a textual description of the contents of the
.Ar buffer
argument with
.Ar length
bytes size.
.Pp
The
.Fn magic_setflags
function, sets the 
.Ar flags
described above.
.Pp
The
.Fn magic_check
function can be used to check the validity of entries in the colon
separated database files passed in as
.Ar filename ,
or NULL for the default database. It returns 0 on success and -1 on
failure.
.Pp
The
.Fn magic_compile
function can be used to compile the the colon
separated list of database files passed in as
.Ar filename ,
or NULL for the default database. It returns 0 on success and -1 on
failure. The compiled files created are named from the
.Xr basename 1
of each file argument with ".mgc" appended to it.
.Pp
The
.Fn magic_load
function must be used to load the the colon
separated list of database files passed in as
.Ar filename ,
or NULL for the default database
before any magic queries can performed.
.Sh RETURN VALUES
The function
.Fn magic_open
returns a magic cookie on success and NULL on failure setting errno to
an appropriate value.
The
.Fn magic_load ,
.Fn magic_compile ,
and
.Fn magic_check
functions return 0 on success and -1 on failure.
The
.Fn magic_file ,
and
.Fn magic_buffer 
functions return a string on success and NULL on failure. The
.Fn magic_error
function returns a textual description of the errors of the above
functions, or NULL if there was no error.
.Sh FILES
.Bl -tag -width __MAGIC__.mime.mgc -compact
.It Pa __MAGIC__.mime
The non-compiled magic mime database.
.It Pa __MAGIC__.mime.mgc
The compiled magic mime database.
.It Pa __MAGIC__
The non-compiled magic database.
.It Pa __MAGIC__.mgc
The compiled magic database.
.El
.Sh SEE ALSO
.Xr file __CSECTION__ ,
.Xr magic __FSECTION__ 
.Sh AUTHORS
Mns Rullgrd Initial libmagic implementation,
and configuration.
Christos Zoulas API cleanup, error code and allocation handling.
