/*
firetalk-int.h - FireTalk wrapper declarations
Copyright (C) 2000 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _FIRETALK_INT_H
#define _FIRETALK_INT_H

#ifndef MSG_WAITALL
#define MSG_WAITALL 0x100
#endif

#ifndef SHUT_RDWR
#define SHUT_RDWR 2
#endif

typedef void (*ptrtofnct)(void *,...);

typedef struct s_firetalk_buddy {
	struct s_firetalk_buddy *next;
	char *nickname;
	int online;
	int away;
	int idletime;
	int tempint;
	int tempint2;
} s_firetalk_buddy;

typedef struct s_firetalk_deny {
	struct s_firetalk_deny *next;
	char *nickname;
} s_firetalk_deny;

typedef struct s_firetalk_member {
	struct s_firetalk_member *next;
	char *nickname;
	int admin;
} s_firetalk_member;

typedef struct s_firetalk_room {
	struct s_firetalk_room *next;
	struct s_firetalk_member *member_head;
	char *name;
} s_firetalk_room;

typedef struct s_firetalk_handle {
	void *handle;
	int protocol;
	ptrtofnct callbacks[FC_MAX];
	int (*comparenicks)(const char * const, const char * const);
	struct s_firetalk_handle *next;
	struct s_firetalk_handle *prev;
	struct s_firetalk_buddy *buddy_head;
	struct s_firetalk_deny *deny_head;
	struct s_firetalk_room *room_head;
} s_firetalk_handle;

void firetalk_callback_im_getmessage(void * const c, const char * const sender, const int automessage, const char * const message);
void firetalk_callback_im_getaction(void * const c, const char * const sender, const int automessage, const char * const message);
void firetalk_callback_im_buddyonline(void * const c, const char * const nickname, const int online);
void firetalk_callback_im_buddyaway(void * const c,  const char * const nickname, const int away);
void firetalk_callback_error(void * const c, const int error, const char * const roomoruser);
void firetalk_callback_disconnect(void * const c, const int error);
void firetalk_callback_gotinfo(void * const c, const char * const nickname, const char * const info, const int warning, const int idle, const int flags);
void firetalk_callback_idleinfo(void * const c, char const * const nickname, const long idletime);
void firetalk_callback_doinit(void * const c);
void firetalk_callback_setidle(void * const c, long * const idle);
void firetalk_callback_eviled(void * const c, const int newevil, const char * const eviler);
void firetalk_callback_chat_joined(void * const c, const char * const room);
void firetalk_callback_chat_left(void * const c, const char * const room);
void firetalk_callback_chat_getmessage(void * const c, const char * const room, const char * const from, const int automessage, const char * const message);
void firetalk_callback_chat_getaction(void * const c, const char * const room, const char * const from, const int automessage, const char * const message);
void firetalk_callback_chat_invited(void * const c, const char * const room, const char * const from, const char * const message);
void firetalk_callback_chat_user_joined(void * const c, const char * const room, const char * const who);
void firetalk_callback_chat_user_left(void * const c, const char * const room, const char * const who);
void firetalk_callback_chat_user_quit(void * const c, const char * const who);
void firetalk_callback_chat_gottopic(void * const c, const char * const room, const char * const topic, const char * const author);
void firetalk_callback_chat_user_opped(void * const c, const char * const room, const char * const who, const char * const by);
void firetalk_callback_chat_user_deopped(void * const c, const char * const room, const char * const who, const char * const by);

struct s_firetalk_handle *firetalk_find_handle(void * const c);

int firetalk_chat_internal_add_room(void * const c, const char * const name);
int firetalk_chat_internal_add_member(void * const c, const char * const room, const char * const nickname);
int firetalk_chat_internal_remove_room(void * const c, const char * const name);
int firetalk_chat_internal_remove_member(void * const c, const char * const room, const char * const nickname);

#endif
