/*
firetalk.h - FireTalk wrapper declarations
Copyright (C) 2000 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _FIRETALK_H
#define _FIRETALK_H

#include <unistd.h>
#include <sys/time.h>

#define LIBFIRETALK_VERSION "0.0.11"
#define LIBFIRETALK_HOMEPAGE "http://www.penguinhosting.net/~ian/firetalk/"

#define FP_AIMTOC 0
#define FP_IRC 1
#define FP_MAX 2

/* Firetalk functions */
void *firetalk_create_handle(const int protocol);
void firetalk_destroy_handle(void * const c);
void firetalk_perror(const char * const string);
int firetalk_disconnect(void * const c);
int firetalk_signon(void * const c, const char * const server, const int port, const char * const username, const char * const password);
int firetalk_get_protocol(void * const c);
int firetalk_register_callback(void * const c, const int type, void (*function)(void *, ...));
#define FC_DOINIT 1
		/* void *connection */
#define FC_ERROR 2
		/* void *connection, int error, char *roomoruser (room or user that error applies to, null if none) */
#define FC_DISCONNECT 3
		/* void *connection */
#define FC_IDLEINFO 4
		/* void *connection, char *nickname, long idletime */
#define FC_SETIDLE 5
		/* void *connection, long *idle */
#define FC_GOTINFO 6
		/* void *connection, char *nickname, char *info, int warning, int idle */
#define FC_EVILED 7
		/* void *connection, int newevil, char *eviler */
#define FC_IM_GETMESSAGE 8
		/* void *connection, char *sender, int automessage_flag, char *message */
#define FC_IM_GETACTION 9
		/* void *connection, char *sender, int automessage_flag, char *message */
#define FC_IM_BUDDYONLINE 10
		/* void *connection, char *nickname */
#define FC_IM_BUDDYOFFLINE 11
		/* void *connection, char *nickname */
#define FC_IM_BUDDYAWAY 12
		/* void *connection, char *nickname */
#define FC_IM_BUDDYUNAWAY 13
		/* void *connection, char *nickname */
#define FC_IM_LISTBUDDY 14
		/* void *connection, char *nickname, char online, char away */
#define FC_CHAT_JOINED 15
		/* void *connection, char *room */
#define FC_CHAT_LEFT 16
		/* void *connection, char *room */
#define FC_CHAT_GETMESSAGE 17
		/* void *connection, char *room, char *from, int automessage_flag, char *message */
#define FC_CHAT_GETACTION 18
		/* void *connection, char *room, char *from, int automessage_flag, char *message */
#define FC_CHAT_INVITED 19
		/* void *connection, char *room, char *from, char *message */
#define FC_CHAT_USER_JOINED 20
		/* void *connection, char *room, char *who */
#define FC_CHAT_USER_LEFT 21
		/* void *connection, char *room, char *who */
#define FC_CHAT_GOTTOPIC 22
		/* void *connection, char *room, char *topic, char *author */
#define FC_CHAT_USER_OPPED 23
		/* void *connection, char *room, char *who, char *by */
#define FC_CHAT_USER_DEOPPED 24
		/* void *connection, char *room, char *who, char *by */
#define FC_MAX 25

int firetalk_im_add_buddy(void * const c, const char * const nickname);
int firetalk_im_remove_buddy(void * const c, const char * const nickname);
int firetalk_im_add_deny(void * const c, const char * const nickname);
int firetalk_im_remove_deny(void * const c, const char * const nickname);
int firetalk_im_upload_buddies(void * const c);
int firetalk_im_upload_denies(void * const c);
int firetalk_im_send_message(void * const c, const char * const dest, const char * const message, const int auto_flag);
int firetalk_im_send_action(void * const c, const char * const dest, const char * const message, const int auto_flag);
int firetalk_im_list_buddies(void * const c);
int firetalk_im_evil(void * const c, const char * const who);

int firetalk_chat_join(void * const c, const char * const room);
int firetalk_chat_part(void * const c, const char * const room);
int firetalk_chat_send_message(void * const c, const char * const room, const char * const message, const int auto_flag);
int firetalk_chat_send_action(void * const c, const char * const room, const char * const message, const int auto_flag);
int firetalk_chat_invite(void * const c, const char * const room, const char * const who, const char * const message);
int firetalk_chat_set_topic(void * const c, const char * const room, const char * const topic);
int firetalk_chat_op(void * const c, const char * const room, const char * const who);
int firetalk_chat_deop(void * const c, const char * const room, const char * const who);

int firetalk_im_internal_add_buddy(void * const c, const char * const nickname);
int firetalk_im_internal_add_deny(void * const c, const char * const nickname);
int firetalk_im_internal_remove_buddy(void * const c, const char * const nickname);
int firetalk_im_internal_remove_deny(void * const c, const char * const nickname);

int firetalk_save_config(void * const c);
int firetalk_get_info(void * const c, const char * const nickname);
int firetalk_set_info(void * const c, const char * const info);
int firetalk_set_away(void * const c, const char * const message);
int firetalk_select();
int firetalk_select_custom(int n, fd_set *fd_read, fd_set *fd_write, fd_set *fd_except, struct timeval *timeout);

#ifndef FIRETALK
extern int firetalkerror;
extern char *firetalkerrors[];
extern char *firetalkprotocols[];
#endif

#define FF_SUBSTANDARD                  0x0001
#define FF_NORMAL                       0x0002
#define FF_ADMIN                        0x0004

#define FE_SUCCESS                      0
#define FE_CONNECT                      1
#define FE_NOMATCH                      2
#define FE_PACKET                       3
#define FE_BADUSERPASS                  4
#define FE_SEQUENCE                     5
#define FE_FRAMETYPE                    6
#define FE_PACKETSIZE                   7
#define FE_SERVER                       8
#define FE_UNKNOWN                      9
#define FE_BLOCKED                     10
#define FE_WIERDPACKET                 11
#define FE_CALLBACKNUM                 12
#define FE_BADUSER                     13
#define FE_NOTFOUND                    14
#define FE_DISCONNECT                  15
#define FE_SOCKET                      16
#define FE_RESOLV                      17
#define FE_VERSION                     18
#define FE_USERUNAVAILABLE             19
#define FE_USERINFOUNAVAILABLE         20
#define FE_TOOFAST                     21
#define FE_ROOMUNAVAILABLE             22
#define FE_INCOMINGERROR               23
#define FE_USERDISCONNECT              24
#define FE_INVALIDFORMAT               25
#define FE_IDLEFAST                    26
#define FE_BADROOM                     27
#define FE_BADMESSAGE                  28
#define FE_BADPROTO                    29
#define FE_NOTCONNECTED                30
#define FE_BADCONNECTION               31
#define FE_NOPERMS                     32

#endif
