/*
icqv5.c - FireTalk ICQ v5 protocol definitions
Copyright (C) 2000 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "firetalk.h"
#include "firetalk-int.h"

typedef struct s_icqv5_outgoing_packet {
	unsigned char version[2];
	unsigned char zeros[4];
	unsigned char uin[4];
	unsigned char session_id[4];
	unsigned char command[2];
	unsigned short seq1;
	unsigned short seq2;
	unsigned char checkcode[4];
	unsigned char data[426];
	unsigned short length;       /* never to be sent, just internal */
} s_icqv5_outgoing_packet;

static __inline__ int icqv5_encrypt_packet(struct s_icqv5_outgoing_packet * const packet) {
	return 0;
}
