/*
irc.h - FireTalk IRC protocol declarations
Copyright (C) 2000 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _IRC_H
#define _IRC_H

int irc_disconnect(void * const c);
void *irc_connect_server(const char * server, short port, const char * const nickname, const char * const password);
int irc_got_data(void * const c);
int irc_compare_nicks(const char * const nick1, const char * const nick2);
int irc_get_fd(void * const c);
int irc_check_buddies(struct s_firetalk_handle * const c);
int irc_get_info(void * const c, const char * const nickname);

int irc_chat_join(void * const c, const char * const room);
int irc_chat_part(void * const c, const char * const room);
int irc_chat_send_message(void * const c, const char * const room, const char * const message, const int auto_flag);
int irc_chat_send_action(void * const c, const char * const room, const char * const message, const int auto_flag);
int irc_chat_invite(void * const c, const char * const room, const char * const who);
int irc_chat_set_topic(void * const c, const char * const room, const char * const topic);
int irc_chat_op(void * const c, const char * const room, const char * const who);
int irc_chat_deop(void * const c, const char * const room, const char * const who);

int irc_im_send_message(void * const c, const char * const dest, const char * const message, const int auto_flag);
int irc_im_send_action(void * const c, const char * const dest, const char * const message, const int auto_flag);
int irc_im_add_buddy(void * const c, const char * const nickname);

#endif
