/*
 * Decompiled with CFR 0.152.
 */
package Freenet;

import Freenet.ConduitException;
import Freenet.Core;
import Freenet.MessageHandler;
import Freenet.MessageObject;
import Freenet.support.Logger;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Conduit
extends Thread {
    private static int num = 0;
    private MessageHandler mh;
    private int cnum;
    private InputStream in;
    private OutputStream out;
    private MessageObject mo;
    private long bytesToMove = -1L;
    private long bytesMoved = 0L;

    public Conduit(InputStream inputStream, OutputStream outputStream, MessageHandler messageHandler) {
        super("Conduit#" + ++num);
        this.setDaemon(false);
        this.in = inputStream;
        this.out = outputStream;
        this.mh = messageHandler;
    }

    public long bytesMoved() {
        return this.bytesMoved;
    }

    public void asyncFeed(MessageObject messageObject) {
        if (!this.isAlive()) {
            this.mo = messageObject;
            this.start();
        }
    }

    public void asyncFeed(MessageObject messageObject, long l) {
        if (!this.isAlive()) {
            this.mo = messageObject;
            this.bytesToMove = l;
            this.start();
        }
    }

    /*
     * Loose catch block
     */
    public void run() {
        byte[] byArray = new byte[Core.bufferSize];
        Core.logger.log(this, this.cnum + "- Conduit starting, reading " + this.bytesToMove + " bytes.", Logger.DEBUG);
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                block28: {
                    int n;
                    do {
                        try {
                            n = this.in.read(byArray, 0, this.bytesToMove < 0L || this.bytesToMove - this.bytesMoved >= (long)byArray.length ? byArray.length : (int)(this.bytesToMove - this.bytesMoved));
                        }
                        catch (IOException iOException) {
                            throw new ConduitException(iOException, this.in, this.out, true, this.bytesMoved);
                        }
                        try {
                            if (n > 0) {
                                this.out.write(byArray, 0, n);
                            }
                        }
                        catch (IOException iOException) {
                            throw new ConduitException(iOException, this.in, this.out, false, this.bytesMoved);
                        }
                        this.bytesMoved += (long)n;
                    } while (n >= 0 && this.bytesMoved != this.bytesToMove);
                    try {
                        this.out.flush();
                    }
                    catch (IOException iOException) {
                        throw new ConduitException(iOException, this.in, this.out, false, this.bytesMoved);
                    }
                    if (this.bytesToMove != 0L && this.bytesMoved != this.bytesToMove) {
                        throw new ConduitException(new EOFException(), this.in, this.out, true, this.bytesMoved);
                    }
                    Object var7_9 = null;
                    try {
                        this.out.flush();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    if (this.mo != null) {
                        this.mh.handle(this.mo);
                    }
                    Core.logger.log(this, this.cnum + "- Conduit finished moved " + this.bytesMoved + " bytes.", Logger.DEBUG);
                    {
                        break block28;
                        catch (ConduitException conduitException) {
                            Core.logger.log(this, this.cnum + "- " + conduitException.toString(), Logger.MINOR);
                            if (this.mo != null) {
                                this.mo.setException(conduitException);
                            }
                            Object var7_10 = null;
                            try {
                                this.out.flush();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            if (this.mo != null) {
                                this.mh.handle(this.mo);
                            }
                            Core.logger.log(this, this.cnum + "- Conduit finished moved " + this.bytesMoved + " bytes.", Logger.DEBUG);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        try {
                            this.out.flush();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        if (this.mo != null) {
                            this.mh.handle(this.mo);
                        }
                        Core.logger.log(this, this.cnum + "- Conduit finished moved " + this.bytesMoved + " bytes.", Logger.DEBUG);
                        throw throwable;
                    }
                }
            }
        }
    }
}

