/*
 * Decompiled with CFR 0.152.
 */
package Freenet;

import Freenet.Address;
import Freenet.Conduit;
import Freenet.Connection;
import Freenet.Core;
import Freenet.InvalidMessageException;
import Freenet.ListeningAddress;
import Freenet.Message;
import Freenet.MessageFactory;
import Freenet.MessageHandler;
import Freenet.MessageObject;
import Freenet.Presentation;
import Freenet.RawMessage;
import Freenet.SendFailedException;
import Freenet.crypt.EntropySource;
import Freenet.support.Logger;
import Freenet.thread.ERunnable;
import Freenet.thread.EThread;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;

public class ConnectionHandler
implements ERunnable {
    private static int highid = 32769;
    private Connection c;
    private Presentation t;
    private MessageHandler mh;
    private int id;
    private volatile long lastActiveTime;
    private volatile boolean closeOnInactive = false;
    private volatile boolean closed = false;
    private volatile boolean writing = false;
    private boolean persist = false;
    private Thread exec_instance;
    private static EntropySource sendTimer = new EntropySource();
    private static EntropySource recvTimer = new EntropySource();
    public Object initLock = new Object();
    public Object sendLock = new Object();
    public boolean ready;

    public ConnectionHandler(Presentation presentation, Connection connection, MessageHandler messageHandler) {
        this.id = highid++;
        if (highid > 65536) {
            highid = 32769;
        }
        this.t = presentation;
        this.c = connection;
        this.mh = messageHandler;
        this.lastActiveTime = System.currentTimeMillis();
        Core.logger.log(this, "New connectionhandler with " + this.peer(), Logger.DEBUGGING);
    }

    public void start() {
        this.exec_instance = new Thread((Runnable)this, this.peer() + " ConnectionHandler");
        this.exec_instance.start();
    }

    public void setExecutionInstance(EThread eThread) {
        this.exec_instance = eThread.getThread();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        PushbackInputStream pushbackInputStream;
        Object object;
        Object object2;
        Message message;
        Object object3 = this.sendLock;
        synchronized (object3) {
            try {
                try {
                    Core.logger.log(this, "Authenticating " + this.c, Logger.DEBUG);
                    this.t.initConnection(this.c);
                    this.ready = true;
                    Core.logger.log(this, this.c + " authenticated", Logger.DEBUG);
                }
                catch (IOException iOException) {
                    Core.logger.log(this, "Failed to initialize connection: " + iOException, Logger.MINOR);
                    this.closed = true;
                    this.forceClose();
                    Object var4_3 = null;
                    this.sendLock.notifyAll();
                    Object object6 = this.c.initLock;
                    synchronized (object6) {
                        this.c.initLock.notifyAll();
                    }
                    Object object4 = this.initLock;
                    synchronized (object4) {
                        this.initLock.notifyAll();
                        return;
                    }
                }
                message = null;
                this.sendLock.notifyAll();
                object2 = this.c.initLock;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.sendLock.notifyAll();
                Object object4 = this.c.initLock;
                synchronized (object4) {
                    this.c.initLock.notifyAll();
                }
                Object object5 = this.initLock;
                synchronized (object5) {
                    this.initLock.notifyAll();
                    throw throwable;
                }
            }
            synchronized (object2) {
                this.c.initLock.notifyAll();
            }
            object = this.initLock;
            synchronized (object) {
                this.initLock.notifyAll();
            }
        }
        this.c.setReady();
        try {
            pushbackInputStream = new PushbackInputStream(this.t.getReceiveStream(this.c));
        }
        catch (IOException iOException) {
            Core.logger.log(this, "Stream died right away", Logger.DEBUGGING);
            this.forceClose();
            return;
        }
        do {
            RawMessage rawMessage = null;
            message = null;
            try {
                if (this.c == null) break;
                this.lastActiveTime = System.currentTimeMillis();
                this.c.setSoTimeout(1000);
                while (!this.closed) {
                    try {
                        int n = pushbackInputStream.read();
                        if (n == -1) {
                            this.closed = true;
                            continue;
                        }
                        if (n == 0) continue;
                        pushbackInputStream.unread(n);
                        break;
                    }
                    catch (InterruptedIOException object7) {
                        if (this.writing || !this.closeOnInactive || System.currentTimeMillis() < this.lastActiveTime + (long)Core.connectionTimeout) continue;
                        this.close();
                    }
                }
                if (this.closed) break;
                this.c.setSoTimeout(600000);
                rawMessage = this.t.readMessage(pushbackInputStream);
                if (rawMessage.persist < 0) {
                    this.persist = false;
                } else if (rawMessage.persist > 0) {
                    this.persist = true;
                }
                this.closed = !this.persist && !rawMessage.keepAlive;
                Core.randSource.acceptTimerEntropy(recvTimer);
                Core.logger.log(this, "Rawmessage:\n" + rawMessage, Logger.DEBUG);
                message = MessageFactory.toMessage(rawMessage);
            }
            catch (InvalidMessageException invalidMessageException) {
                Core.logger.log(this, "Invalid message: " + invalidMessageException.toString(), Logger.MINOR);
                continue;
            }
            catch (EOFException eOFException) {
                break;
            }
            catch (IOException interruptedException) {
                break;
            }
            object2 = rawMessage.messageType + " <- " + this.c.getPeerAddress();
            object2 = Long.toHexString(message.id) + " - " + (String)object2;
            Core.logger.log(this, (String)object2, Logger.MINOR);
            Core.logger.log(this, "Message:\n" + message, Logger.DEBUG);
            this.closeOnInactive = rawMessage.source != null && !this.persist;
            Core.logger.log(this, "Got on " + this.c.getMyAddress() + " from " + (rawMessage.source != null ? this.c.getPeerAddress(rawMessage.source.listenPart()) : this.c.getPeerAddress()), Logger.DEBUGGING);
            message.initSources(this.c.getMyAddress(), rawMessage.source == null ? null : this.c.getPeerAddress(rawMessage.source.listenPart()), rawMessage.keepAlive ? this : null);
            if (rawMessage.trailingFieldLength == 0L) {
                this.mh.handle(message);
            } else {
                object = rawMessage.trailingFieldStream;
                synchronized (object) {
                    this.mh.handle(message);
                    try {
                        rawMessage.trailingFieldStream.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Core.logger.log(this, "I got interrupted!", Logger.DEBUGGING);
                    }
                    Core.logger.log(this, "I am awake!", Logger.DEBUGGING);
                }
            }
            Core.logger.log(this, "Finished with message", Logger.DEBUGGING);
            this.lastActiveTime = System.currentTimeMillis();
        } while (!this.closed);
        if (this.c.out != null) {
            Core.logger.log(this, "Finished with connection - closing", Logger.DEBUGGING);
            this.forceClose();
        }
    }

    public void sendMessage(Message message) throws SendFailedException {
        this.sendMessage(message, null);
    }

    public void sendMessage(Message message, MessageObject messageObject) throws SendFailedException {
        Object object;
        while (!this.c.ready() && !this.closed) {
            object = this.initLock;
            synchronized (object) {
                try {
                    this.initLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.closed) {
            throw new SendFailedException(this.c.getPeerAddress());
        }
        object = this.sendLock;
        synchronized (object) {
            this.unlockedSend(message, messageObject);
            Thread.currentThread();
            Thread.yield();
        }
    }

    public void unlockedSend(Message message, MessageObject messageObject) throws SendFailedException {
        OutputStream outputStream;
        if (this.closed) {
            throw new SendFailedException(this.c.getPeerAddress());
        }
        Core.logger.log(this, "Sending a message", Logger.DEBUGGING);
        RawMessage rawMessage = message.toRawMessage(this.t);
        Address address = this.c.getPeerAddress();
        String string = rawMessage.messageType + " -> " + address;
        string = Long.toHexString(message.id) + " - " + string;
        Core.logger.log(this, string, Logger.MINOR);
        try {
            outputStream = this.t.getSendStream(this.c);
        }
        catch (IOException iOException) {
            throw new SendFailedException(address);
        }
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            try {
                rawMessage.writeMessage(outputStream);
                outputStream.flush();
            }
            catch (IOException iOException) {
                throw new SendFailedException(address);
            }
            InputStream inputStream = rawMessage.trailingFieldStream;
            if (inputStream != null) {
                SendObjectWrapper sendObjectWrapper = new SendObjectWrapper(messageObject, rawMessage.keepAlive || this.persist);
                this.writing = true;
                Conduit conduit = new Conduit(inputStream, outputStream, new SendObjectHandler());
                conduit.asyncFeed(sendObjectWrapper, rawMessage.trailingFieldLength);
            } else {
                this.lastActiveTime = System.currentTimeMillis();
                if (!rawMessage.keepAlive && !this.persist) {
                    this.close();
                }
            }
            Core.logger.log(this, "Message sent.", Logger.DEBUGGING);
        }
        Thread.currentThread();
        Thread.yield();
        Core.randSource.acceptTimerEntropy(sendTimer);
    }

    public void close() {
        this.closed = true;
    }

    public void forceClose() {
        this.closed = true;
        this.c.close();
        this.exec_instance.interrupt();
    }

    public boolean isOpen() {
        return this.exec_instance.isAlive() && !this.closed;
    }

    public Address peer() {
        return this.c.getPeerAddress();
    }

    public Address peer(ListeningAddress listeningAddress) {
        return this.c.getPeerAddress(listeningAddress);
    }

    public Address local() {
        return this.c.getMyAddress();
    }

    public Address local(ListeningAddress listeningAddress) {
        return this.c.getMyAddress(listeningAddress);
    }

    protected class SendObjectWrapper
    implements MessageObject {
        MessageObject mo;
        boolean keepAlive;

        public SendObjectWrapper(MessageObject messageObject, boolean bl) {
            this.mo = messageObject;
            this.keepAlive = bl;
        }

        public long id() {
            return ConnectionHandler.this.id;
        }

        public void done() {
            ConnectionHandler.this.lastActiveTime = System.currentTimeMillis();
            ConnectionHandler.this.writing = false;
            if (this.mo != null) {
                ConnectionHandler.this.mh.handle(this.mo);
            }
            if (!this.keepAlive) {
                ConnectionHandler.this.close();
            }
        }

        public void setException(Exception exception) {
            if (this.mo != null) {
                this.mo.setException(exception);
            }
        }
    }

    protected class SendObjectHandler
    implements MessageHandler {
        protected SendObjectHandler() {
        }

        public void handle(MessageObject messageObject) {
            if (messageObject instanceof SendObjectWrapper) {
                ((SendObjectWrapper)messageObject).done();
            } else {
                Core.logger.log(this, "Got MessageObject I can't handle: " + messageObject, Logger.ERROR);
            }
        }
    }
}

