/*
 * Decompiled with CFR 0.152.
 */
package Freenet;

import Freenet.Address;
import Freenet.ConnectFailedException;
import Freenet.Connection;
import Freenet.ConnectionFactory;
import Freenet.ConnectionHandler;
import Freenet.HandshakeHandler;
import Freenet.Key;
import Freenet.ListenException;
import Freenet.Listener;
import Freenet.ListenerFactory;
import Freenet.ListeningAddress;
import Freenet.Message;
import Freenet.MessageHandler;
import Freenet.MessageObject;
import Freenet.Params;
import Freenet.Presentation;
import Freenet.SendFailedException;
import Freenet.Ticker;
import Freenet.crypt.RandomSource;
import Freenet.crypt.Yarrow;
import Freenet.keys.CHK;
import Freenet.keys.KHK;
import Freenet.keys.KSK;
import Freenet.keys.SVK;
import Freenet.support.Logger;
import Freenet.support.SuppressedLogger;
import Freenet.thread.ThreadManager;
import Freenet.thread.ThreadPool;
import java.io.File;
import java.io.IOException;

public abstract class Core {
    public static final long defaultTickerTime = 500L;
    public static final int defaultConnectTimeout = 30000;
    public static final int defaultAuthTimeout = 30000;
    public static final int defaultConnectionTimeout = 180000;
    public static final int defaultHandshakeTimeout = 30000;
    public static final int defaultHandshakeLife = 10000000;
    public static final int defaultHopTimeExpected = 12000;
    public static final int defaultHopTimeDeviation = 12000;
    public static final int defaultMaximumConnectionThreads = 50;
    public static final int defaultBufferSize = 4096;
    public static final boolean defaultTransience = false;
    public static final int defaultListenPort = 19114;
    public static final String freenetVersion = "0.3";
    public static final String protocolVersion = "1.299";
    public static final String buildNumber = "161";
    public static String serverRevision;
    public static boolean debug;
    public static int connectTimeout;
    public static int authTimeout;
    public static long tickerTime;
    public static int connectionTimeout;
    public static int handshakeTimeout;
    public static int handshakeLife;
    private static boolean transience;
    public static int maximumConnectionThreads;
    public static int hopTimeExpected;
    public static int hopTimeDeviation;
    public static int bufferSize;
    public static RandomSource randSource;
    public static Logger logger;
    private static boolean initialized;
    public Ticker timer;
    public ThreadManager threadManager;
    public ThreadGroup threadGroup;
    public ListeningAddress myAddress;
    public Presentation presentation;
    public MessageHandler mh;
    public HandshakeHandler hh;
    public Listener listener;
    public boolean listen = true;
    static /* synthetic */ Class class$Freenet$keys$KHK;
    static /* synthetic */ Class class$Freenet$keys$KSK;
    static /* synthetic */ Class class$Freenet$keys$SVK;
    static /* synthetic */ Class class$Freenet$keys$CHK;

    public boolean getTransience() {
        return transience;
    }

    public static void setLogger(Logger logger) {
        Core.logger = logger;
    }

    public static void init(Params params) {
        if (initialized) {
            return;
        }
        initialized = true;
        tickerTime = params.getlong("tickerTime", 500L);
        transience = params.getboolean("transient", false);
        connectTimeout = params.getint("connectTimeout", 30000);
        authTimeout = params.getint("authTimeout", 30000);
        connectionTimeout = params.getint("connectionTimeout", 180000);
        handshakeTimeout = params.getint("handshakeTimeout", 30000);
        handshakeLife = params.getint("handshakeLife", 10000000);
        hopTimeExpected = params.getint("hopTimeExpected", 12000);
        hopTimeDeviation = params.getint("hopTimeDeviation", 12000);
        maximumConnectionThreads = params.getint("maximumConnectionThreads", 50);
        bufferSize = params.getint("bufferSize", 4096);
        Key.addKeyType(KHK.keyNumber, class$Freenet$keys$KHK == null ? (class$Freenet$keys$KHK = Core.class$("Freenet.keys.KHK")) : class$Freenet$keys$KHK);
        Key.addKeyType(KSK.keyNumber, class$Freenet$keys$KSK == null ? (class$Freenet$keys$KSK = Core.class$("Freenet.keys.KSK")) : class$Freenet$keys$KSK);
        Key.addKeyType(SVK.keyNumber, class$Freenet$keys$SVK == null ? (class$Freenet$keys$SVK = Core.class$("Freenet.keys.SVK")) : class$Freenet$keys$SVK);
        Key.addKeyType(CHK.keyNumber, class$Freenet$keys$CHK == null ? (class$Freenet$keys$CHK = Core.class$("Freenet.keys.CHK")) : class$Freenet$keys$CHK);
        String[] stringArray = params.getlist("keyTypes");
        int n = 1;
        while (stringArray != null && n < stringArray.length) {
            try {
                Key.addKeyType(Integer.parseInt(stringArray[n - 1]), Class.forName(stringArray[n]));
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(null, "No such class: " + stringArray[n] + " for Key type " + stringArray[n - 1], Logger.ERROR);
            }
            n += 2;
        }
    }

    public Core(ListeningAddress listeningAddress, Presentation presentation, HandshakeHandler handshakeHandler) throws ListenException {
        this.listener = ListenerFactory.listen(listeningAddress);
        this.presentation = presentation;
        this.myAddress = this.listener.address;
        this.hh = handshakeHandler;
        this.mh = new VoidMessageHandler();
        this.threadGroup = new ThreadGroup("Freenet on " + listeningAddress);
        if (maximumConnectionThreads > 0) {
            this.threadManager = new ThreadPool(this.threadGroup, maximumConnectionThreads);
            this.threadManager.start();
        }
        this.timer = new Ticker(this.mh, this.threadManager, tickerTime);
        this.timer.setDaemon(true);
        logger.log(this, "Freenet Core running on " + this.listener + " (build " + buildNumber + ")", Logger.NORMAL);
    }

    public void acceptConnections(MessageHandler messageHandler) {
        this.acceptConnections(messageHandler, false, true);
    }

    public void acceptConnections(MessageHandler messageHandler, boolean bl, boolean bl2) {
        this.mh = messageHandler;
        this.timer.setMessageHandler(messageHandler);
        this.timer.start();
        ConnectionAcceptor connectionAcceptor = new ConnectionAcceptor(this.threadGroup, this.listener);
        connectionAcceptor.setDaemon(bl);
        connectionAcceptor.start();
        if (bl2) {
            try {
                connectionAcceptor.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public ConnectionHandler makeConnection(Address address) throws ConnectFailedException {
        if (address == null) {
            throw new ConnectFailedException(address);
        }
        ConnectionHandler connectionHandler = this.connect(address);
        if (!this.hh.getHandshake(this, connectionHandler)) {
            throw new ConnectFailedException(address);
        }
        if (!connectionHandler.isOpen()) {
            connectionHandler = this.connect(address);
        }
        return connectionHandler;
    }

    public ConnectionHandler connect(Address address) throws ConnectFailedException {
        Connection connection = null;
        try {
            connection = ConnectionFactory.connect(address);
        }
        catch (Throwable throwable) {
            String string = throwable.toString() + " when attempting to connect to " + address;
            logger.log(this, string, Logger.MINOR);
            throw new ConnectFailedException(address, string);
        }
        logger.log(this, "Connection between: " + connection.getMyAddress(this.myAddress) + " and " + connection.getPeerAddress(), Logger.DEBUGGING);
        if (connection.getMyAddress(this.myAddress).equals(connection.getPeerAddress())) {
            logger.log(this, "No connecting to yourself", Logger.MINOR);
            connection.close();
            throw new ConnectFailedException(address);
        }
        ConnectionHandler connectionHandler = new ConnectionHandler(this.presentation, connection, this.mh);
        connectionHandler.start();
        return connectionHandler;
    }

    public void sendMessage(Message message, Address address) throws SendFailedException {
        try {
            ConnectionHandler connectionHandler = this.makeConnection(address);
            connectionHandler.sendMessage(message);
        }
        catch (ConnectFailedException connectFailedException) {
            throw new SendFailedException(address);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        logger = new SuppressedLogger();
        initialized = false;
        randSource = new Yarrow(new File("/dev/urandom").exists() ? "/dev/urandom" : "prng.seed", "SHA1", "Rijndael");
    }

    private class ConnectionAcceptor
    extends Thread {
        public ConnectionAcceptor(ThreadGroup threadGroup, Listener listener) {
            super(threadGroup, "Freenet Core connection listener on " + listener);
        }

        public void run() {
            logger.log(this, "Accepting connections.", Logger.MINOR);
            while (Core.this.listen) {
                Connection connection;
                try {
                    connection = Core.this.listener.accept();
                    logger.log(this, "Accepted connection:" + connection, Logger.DEBUGGING);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(logger.getOut());
                    throw new RuntimeException("Problem accepting next connection:" + iOException);
                }
                ConnectionHandler connectionHandler = new ConnectionHandler(Core.this.presentation, connection, Core.this.mh);
                if (maximumConnectionThreads > 0 && Core.this.threadManager != null) {
                    if (Core.this.threadManager.run(connectionHandler)) continue;
                    logger.log(this, "Rejected connection:" + connection + " (connection limit reached)", Logger.NORMAL);
                    connectionHandler.forceClose();
                    continue;
                }
                connectionHandler.start();
            }
        }
    }

    private static class VoidMessageHandler
    implements MessageHandler {
        private VoidMessageHandler() {
        }

        public void handle(MessageObject messageObject) {
        }
    }
}

