/*
 * Decompiled with CFR 0.152.
 */
package Freenet;

import Freenet.Core;
import Freenet.support.Logger;
import Freenet.support.io.ReadInputStream;
import Freenet.support.io.WriteOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class FieldSet {
    public static long MAX_PARSE_SIZE = 65536L;
    private Hashtable fields = new Hashtable();
    private int size = 0;

    public FieldSet() {
    }

    public FieldSet(ReadInputStream readInputStream) throws IOException {
        this.parseFields(readInputStream);
    }

    public String get(String string) {
        Object v = this.fields.get(string);
        if (v == null || !(v instanceof String)) {
            return null;
        }
        String string2 = (String)this.fields.get(string);
        return string2;
    }

    public FieldSet getSet(String string) {
        Object v = this.fields.get(string);
        if (v == null || !(v instanceof FieldSet)) {
            return null;
        }
        return (FieldSet)v;
    }

    public void remove(String string) {
        this.fields.remove(string);
    }

    public void put(String string, String string2) {
        this.add(string, string2);
    }

    public void put(String string, FieldSet fieldSet) {
        this.put(string, fieldSet);
    }

    public void add(String string, String string2) {
        this.readField(string, string2, '.');
    }

    public void add(String string, FieldSet fieldSet) {
        this.fields.put(string, fieldSet);
    }

    public boolean isString(String string) {
        return this.fields.get(string) != null && this.fields.get(string) instanceof String;
    }

    public boolean isSet(String string) {
        return this.fields.get(string) != null && this.fields.get(string) instanceof FieldSet;
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public void writeFields(WriteOutputStream writeOutputStream) throws IOException {
        this.writeFields(writeOutputStream, "End", '\n', '=', '.');
    }

    public void writeFields(WriteOutputStream writeOutputStream, String string, char c, char c2, char c3) throws IOException {
        this.inWriteFields(writeOutputStream, "", c, c2, c3);
        writeOutputStream.writeUTF(string, c);
    }

    private void inWriteFields(WriteOutputStream writeOutputStream, String string, char c, char c2, char c3) throws IOException {
        Enumeration enumeration = this.fieldNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (this.isSet(string2)) {
                this.getSet(string2).inWriteFields(writeOutputStream, string + string2 + c3, c, c2, c3);
                continue;
            }
            if (this.isString(string2)) {
                writeOutputStream.writeUTF(string + string2 + c2 + this.get(string2), c);
                continue;
            }
            Core.logger.log(this, "Could not interpret field as string when trying to send.", Logger.MINOR);
        }
    }

    public String parseFields(ReadInputStream readInputStream) throws IOException {
        return this.parseFields(readInputStream, '\n', '=', '.');
    }

    public String parseFields(ReadInputStream readInputStream, char c, char c2, char c3) throws IOException {
        return this.privParse(readInputStream, c, '\u0000', c2, c3, false);
    }

    public String parseFields(ReadInputStream readInputStream, char c, char c2, char c3, char c4) throws IOException {
        return this.privParse(readInputStream, c, c2, c3, c4, true);
    }

    private String privParse(ReadInputStream readInputStream, char c, char c2, char c3, char c4, boolean bl) throws IOException {
        String string;
        block3: {
            long l = 0L;
            do {
                try {
                    string = bl ? readInputStream.readToEOF(c, c2) : readInputStream.readToEOF(c);
                }
                catch (EOFException eOFException) {
                    return null;
                }
                l += (long)string.length();
                int n = string.indexOf(c3);
                if (n < 0) break block3;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                this.readField(string2, string3, c4);
            } while (l <= MAX_PARSE_SIZE);
            throw new IOException("Message too large");
        }
        return string;
    }

    public Enumeration keys() {
        return this.fieldNames();
    }

    public Enumeration fieldNames() {
        return this.fields.keys();
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            WriteOutputStream writeOutputStream = new WriteOutputStream(byteArrayOutputStream);
            this.inWriteFields(writeOutputStream, "", ',', '=', '.');
            writeOutputStream.flush();
            return "{" + new String(byteArrayOutputStream.toByteArray(), "UTF8") + "}";
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected void readField(String string, String string2, char c) {
        int n = string.indexOf(c);
        if (n < 0) {
            this.fields.put(string, string2);
        } else {
            FieldSet fieldSet;
            String string3 = string.substring(0, n);
            Object v = this.fields.get(string3);
            if (v == null || !(v instanceof FieldSet)) {
                fieldSet = new FieldSet();
                this.fields.put(string3, fieldSet);
            } else {
                fieldSet = (FieldSet)v;
            }
            fieldSet.readField(string.substring(n + 1), string2, c);
        }
    }
}

