/*
 * Decompiled with CFR 0.152.
 */
package Freenet;

import Freenet.Core;
import Freenet.FieldSet;
import Freenet.KeyException;
import Freenet.support.Fields;
import Freenet.support.Logger;
import Freenet.support.io.DataNotValidIOException;
import Freenet.support.io.VerifyingInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

public class Key
implements Serializable {
    private static Hashtable keytypes = new Hashtable();
    protected byte[] val;
    static /* synthetic */ Class class$Freenet$Key;
    static /* synthetic */ Class array$B;

    public static void addKeyType(int n, Class clazz) throws ClassCastException {
        Object object;
        if (!(class$Freenet$Key == null ? (class$Freenet$Key = Key.class$("Freenet.Key")) : class$Freenet$Key).isAssignableFrom(clazz)) {
            throw new ClassCastException();
        }
        try {
            object = clazz.getConstructor(array$B == null ? (array$B = Key.class$("[B")) : array$B);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ClassCastException();
        }
        object = new Integer(n);
        keytypes.put(object, clazz);
    }

    public static Key readKey(String string) throws KeyException {
        if ((string.length() & 1) == 1) {
            throw new KeyException("Key string did not contain bytes");
        }
        byte[] byArray = new byte[string.length() >> 1];
        Fields.hexToBytes(string, byArray, 0);
        Integer n = new Integer(byArray[byArray.length - 2] << 8 | byArray[byArray.length - 1]);
        Class clazz = (Class)keytypes.get(n);
        if (clazz != null) {
            try {
                Constructor constructor = clazz.getConstructor(array$B == null ? (array$B = Key.class$("[B")) : array$B);
                return (Key)constructor.newInstance(new Object[]{byArray});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new Error("Key method borked on constructor checks.");
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof KeyException) {
                    throw (KeyException)throwable;
                }
                throw new RuntimeException();
            }
            catch (Exception exception) {
                throw new RuntimeException();
            }
        }
        Core.logger.log(null, "Got unknown key type : " + Integer.toHexString(n), Logger.MINOR);
        return new Key(byArray);
    }

    protected Key(byte[] byArray) {
        this.val = byArray;
    }

    public VerifyingInputStream verifyStream(InputStream inputStream, FieldSet fieldSet, long l) throws DataNotValidIOException {
        Core.logger.log(this, "Warning: Default Key.verify() called. All known keytypes should override this.", Logger.DEBUGGING);
        return new VerifyingInputStream(inputStream, l);
    }

    public boolean isCachable() {
        return false;
    }

    public final boolean compare(Key key, Key key2) throws KeyException {
        int n = Math.max(Math.max(key.val.length, key2.val.length), this.val.length);
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        while (n2 < n) {
            if (Math.abs(l *= 256L) > 65536L && Math.abs(l2 *= 256L) > 65536L) {
                l %= 65536L;
                l2 %= 65536L;
            }
            if (Math.abs(l2 += (long)(this.at(key2.val, n2) - this.at(this.val, n2))) - Math.abs(l += (long)(this.at(key.val, n2) - this.at(this.val, n2))) > 1L) {
                return true;
            }
            if (Math.abs(l) - Math.abs(l2) > 1L) {
                return false;
            }
            ++n2;
        }
        return Math.abs(l) < Math.abs(l2);
    }

    private final int at(byte[] byArray, int n) {
        return (n < byArray.length ? byArray[n] : (byte)0) & 0xFF;
    }

    private boolean isGreater(Key key) {
        int n = 0;
        while (n != key.val.length) {
            if (n == this.val.length) {
                return true;
            }
            if (this.val[n] < key.val[n]) {
                return true;
            }
            if (this.val[n] > key.val[n]) {
                return false;
            }
            ++n;
        }
        return false;
    }

    public final boolean equals(Object object) {
        if (object instanceof Key && ((Key)object).val.length == this.val.length) {
            int n = 0;
            while (n < this.val.length) {
                if (((Key)object).val[n] != this.val[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public static final byte lengthLimit(long l) {
        byte by = 0;
        while ((long)(1 << by) <= l) {
            by = (byte)(by + 1);
        }
        return by;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.val.length - 1;
        while (n2 >= 0) {
            n ^= this.val[n2] << ((n2 & 3) << 3);
            --n2;
        }
        return n;
    }

    public String toString() {
        return Fields.bytesToHex(this.val, 0, this.val.length);
    }

    public byte[] getVal() {
        return this.val;
    }

    public static void main(String[] stringArray) {
        Key key = new Key(new byte[]{0, 0, 0});
        Key key2 = new Key(new byte[]{0, -1, 0});
        Key key3 = new Key(new byte[]{1, -1, -1});
        System.out.println(key2.compare(key, key3));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

