/*
 * Decompiled with CFR 0.152.
 */
package Freenet;

import Freenet.Address;
import Freenet.ConnectFailedException;
import Freenet.ConnectionHandler;
import Freenet.Core;
import Freenet.FieldSet;
import Freenet.InvalidMessageException;
import Freenet.MessageMemory;
import Freenet.Presentation;
import Freenet.RawMessage;
import Freenet.SendFailedException;
import Freenet.client.ClientMessageObject;
import Freenet.crypt.EntropySource;
import Freenet.message.TimedOut;
import Freenet.node.Node;
import Freenet.node.NodeMessageObject;
import Freenet.support.Fields;
import Freenet.support.Logger;

public abstract class Message
implements NodeMessageObject,
ClientMessageObject {
    public static final String messageName = "";
    private static EntropySource uniqueIdEntropy = new EntropySource();
    public Address source;
    public Address receivedAt = null;
    public ConnectionHandler receivedWith = null;
    public long hopsToLive;
    public long depth;
    public long id;
    public boolean keepAlive = true;
    public FieldSet otherFields;

    protected Message(long l, long l2, long l3, FieldSet fieldSet) {
        this.id = l;
        this.hopsToLive = l2;
        this.depth = l3;
        this.otherFields = fieldSet;
    }

    protected Message(RawMessage rawMessage) throws InvalidMessageException {
        try {
            this.otherFields = rawMessage.fs;
            this.id = Fields.stringToLong(this.otherFields.get("UniqueID"));
            if (this.id >= 0L && this.id < 65536L) {
                throw new InvalidMessageException("Message id out of range");
            }
            Core.randSource.acceptEntropy(uniqueIdEntropy, this.id, 64);
            this.otherFields.remove("UniquieID");
            this.hopsToLive = Fields.stringToLong(this.otherFields.get("HopsToLive"));
            this.otherFields.remove("HopsToLive");
            this.depth = Fields.stringToLong(this.otherFields.get("Depth"));
            this.otherFields.remove("Depth");
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidMessageException("Bad number");
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new InvalidMessageException("Necessary Field Missing");
        }
    }

    public RawMessage toRawMessage(Presentation presentation) {
        RawMessage rawMessage = presentation.newMessage(messageName, this.source, this.keepAlive, this.otherFields, 0L, "EndMessage", null);
        rawMessage.fs.add("UniqueID", Fields.longToString(this.id));
        rawMessage.fs.add("HopsToLive", Fields.longToString(this.hopsToLive));
        rawMessage.fs.add("Depth", Fields.longToString(this.depth));
        return rawMessage;
    }

    public void initSources(Address address, Address address2, ConnectionHandler connectionHandler) {
        this.receivedAt = address;
        this.source = address2;
        this.receivedWith = connectionHandler;
    }

    public long id() {
        return this.id;
    }

    public final MessageMemory received(Node node, MessageMemory messageMemory) {
        this.hopsToLive = this.hopsToLive > (long)Node.maxHopsToLive ? (long)Node.maxHopsToLive : (this.hopsToLive = this.hopsToLive - 1L);
        ++this.depth;
        return this.hopsToLive <= 0L ? this.timeOut(node, messageMemory) : this.pReceived(node, messageMemory);
    }

    public void setException(Exception exception) {
    }

    public void sending(Core core, ConnectionHandler connectionHandler) throws SendFailedException {
        this.sending(core, connectionHandler.peer(), connectionHandler.local(core.myAddress));
    }

    public void sending(Core core, Address address, Address address2) throws SendFailedException {
        if (address2.equals(address)) {
            throw new SendFailedException(address);
        }
        this.source = address2;
    }

    protected abstract MessageMemory pReceived(Node var1, MessageMemory var2);

    protected MessageMemory timeOut(Node node, MessageMemory messageMemory) {
        Core.logger.log(this, "Message timed out, sending timeout to original source", Logger.MINOR);
        TimedOut timedOut = new TimedOut(this.id, this.depth);
        try {
            ConnectionHandler connectionHandler = this.sendReply(node, timedOut);
            if (connectionHandler != null) {
                connectionHandler.close();
            }
        }
        catch (SendFailedException sendFailedException) {
            Core.logger.log(this, "Send of timeout failed", Logger.NORMAL);
        }
        return messageMemory;
    }

    protected ConnectionHandler sendReply(Node node, Message message) throws SendFailedException {
        try {
            ConnectionHandler connectionHandler;
            if (this.receivedWith == null) {
                connectionHandler = node.makeConnection(this.source);
                message.keepAlive = false;
            } else {
                connectionHandler = !this.receivedWith.isOpen() ? node.makeConnection(this.source) : this.receivedWith;
            }
            message.sending(node, connectionHandler);
            connectionHandler.sendMessage(message);
            return this.receivedWith == null ? null : connectionHandler;
        }
        catch (ConnectFailedException connectFailedException) {
            throw new SendFailedException(connectFailedException.peer);
        }
    }

    public ConnectionHandler sendBack(Node node, MessageMemory messageMemory) throws SendFailedException {
        try {
            ConnectionHandler connectionHandler;
            if (messageMemory.replyCon == null) {
                connectionHandler = node.makeConnection(messageMemory.origRec);
                this.keepAlive = false;
            } else {
                connectionHandler = !messageMemory.replyCon.isOpen() ? node.makeConnection(messageMemory.origRec) : messageMemory.replyCon;
            }
            this.sending(node, connectionHandler);
            connectionHandler.sendMessage(this);
            return messageMemory.replyCon == null ? null : connectionHandler;
        }
        catch (ConnectFailedException connectFailedException) {
            throw new SendFailedException(connectFailedException.peer);
        }
    }

    public String toString() {
        return "Src:" + this.source + " htl:" + this.hopsToLive + " depth:" + this.depth + " id:" + Long.toHexString(this.id) + " type:" + this.getClass().getName();
    }
}

