/*
 * Decompiled with CFR 0.152.
 */
package Freenet;

import Freenet.Core;
import Freenet.FieldSet;
import Freenet.support.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Params {
    public static final String[] defaultRCFiles = new String[]{".freenetrc", "freenet.ini"};
    FieldSet params = new FieldSet();
    Vector argVector = new Vector();
    private String savedOption = null;
    private boolean noMoreOptions = false;

    public static void main(String[] stringArray) {
        try {
            Params params = new Params(".freenetrc", stringArray);
            System.out.println("Params: " + params.params);
            System.out.println("Args: " + params.argVector);
        }
        catch (IOException iOException) {
            System.out.println("Error reading .freenetrc: " + iOException);
        }
    }

    public Params() {
    }

    public Params(String string) throws FileNotFoundException {
        this.init(ArrayFactory.makeArray(string), null);
    }

    public Params(String[] stringArray) {
        try {
            this.init(null, stringArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public Params(String string, String[] stringArray) throws FileNotFoundException {
        this.init(ArrayFactory.makeArray(string), stringArray);
    }

    public Params(String[] stringArray, String[] stringArray2) throws FileNotFoundException {
        this.init(stringArray, stringArray2);
    }

    private void init(String[] stringArray, String[] stringArray2) throws FileNotFoundException {
        String string;
        if (stringArray2 != null) {
            int n = 0;
            while (n < stringArray2.length) {
                if (stringArray2[n] != null) {
                    if (this.isOption(stringArray2[n])) {
                        if (this.savedOption != null) {
                            this.setParam(this.savedOption, "");
                        }
                        if (!stringArray2[n].equals("--")) {
                            this.savedOption = stringArray2[n].substring(1);
                        } else {
                            this.noMoreOptions = true;
                            this.savedOption = null;
                        }
                    } else {
                        if (this.savedOption != null) {
                            this.setParam(this.savedOption, stringArray2[n]);
                        } else {
                            this.argVector.addElement(stringArray2[n]);
                        }
                        this.savedOption = null;
                    }
                }
                ++n;
            }
            if (this.savedOption != null) {
                this.setParam(this.savedOption, "");
            }
        }
        if ((string = this.getParam("paramFile")) != null) {
            if (stringArray != null) {
                String[] stringArray3 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
                stringArray3[stringArray.length] = string;
                stringArray = stringArray3;
            } else {
                stringArray = ArrayFactory.makeArray(string);
            }
        }
        if (stringArray != null) {
            boolean bl = false;
            int n = stringArray.length - 1;
            while (n >= 0) {
                if (stringArray[n] != null) {
                    try {
                        Core.logger.log(this, "Reading config file " + stringArray[n], Logger.DEBUGGING);
                        this.readParams(stringArray[n], false);
                        bl = true;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Core.logger.log(this, "Couldn't load config file (this is not a problem, and if Freenet procedes not to work for you 100/1 says this is not the reason)." + stringArray[n], Logger.MINOR);
                    }
                }
                --n;
            }
            if (!bl) {
                StringBuffer stringBuffer = new StringBuffer();
                if (stringArray.length > 1) {
                    stringBuffer.append("any of ");
                }
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(stringArray[n2]);
                    ++n2;
                }
                throw new FileNotFoundException(stringBuffer.toString());
            }
        }
    }

    public void readParams(String string) throws FileNotFoundException {
        this.readParams(string, true);
    }

    /*
     * Loose catch block
     */
    public void readParams(String string, boolean bl) throws FileNotFoundException {
        block16: {
            String string2;
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                int n;
                String string3 = string2.trim();
                if (string3.length() == 0 || "#;*".indexOf(string3.charAt(0)) >= 0 || (n = string2.indexOf(61)) < 0) continue;
                String string4 = string2.substring(0, n);
                String string5 = string2.substring(n + 1);
                String string6 = string4.trim().toLowerCase();
                String string7 = string5.trim();
                if (!bl && this.getParam(string6) != null) continue;
                this.params.put(string6, string7);
            }
            Object var13_14 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileReader != null) {
                    fileReader.close();
                }
                break block16;
            }
            catch (IOException iOException) {
                Core.logger.log(this, "Error while closing config file", Logger.ERROR);
            }
            break block16;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    throw fileNotFoundException;
                }
                catch (IOException iOException) {
                    Core.logger.log(this, "Error while reading config file", Logger.ERROR);
                    Object var13_15 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (fileReader != null) {
                            fileReader.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException2) {
                        Core.logger.log(this, "Error while closing config file", Logger.ERROR);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (IOException iOException) {
                    Core.logger.log(this, "Error while closing config file", Logger.ERROR);
                }
                throw throwable;
            }
        }
    }

    public void removeParam(String string) {
        this.params.remove(string.toLowerCase());
    }

    public void setParam(String string, String string2) {
        Core.logger.log(this, "set \"" + string + "\" to \"" + string2 + "\"", Logger.MINOR);
        this.params.put(string.toLowerCase(), string2);
    }

    public String getParam(String string, String string2) {
        String string3 = this.getParam(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public int getNumArgs() {
        return this.argVector.size();
    }

    public String getArg(int n) {
        if (n >= 0 && n < this.argVector.size()) {
            return (String)this.argVector.elementAt(n);
        }
        return null;
    }

    public String[] getlist(String string, String[] stringArray) {
        if (this.getParam(string) == null) {
            return stringArray;
        }
        return this.getlist(string);
    }

    public FieldSet getset(String string, FieldSet fieldSet) {
        FieldSet fieldSet2 = this.getset(string);
        if (fieldSet2 == null) {
            return fieldSet;
        }
        return fieldSet2;
    }

    public FieldSet getset(String string) {
        return this.params.getSet(string);
    }

    public String[] getlist(String string) {
        String string2 = this.getParam(string);
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",:;");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        return stringArray;
    }

    public long getlong(String string, long l) {
        String string2 = this.getParam(string);
        if (string2 == null) {
            return l;
        }
        return this.getlong(string);
    }

    public long getlong(String string) {
        return Long.parseLong(this.getParam(string));
    }

    public int getint(String string, int n) {
        String string2 = this.getParam(string);
        if (string2 == null) {
            return n;
        }
        return this.getint(string);
    }

    public int getint(String string) {
        return Integer.parseInt(this.getParam(string));
    }

    public short getshort(String string, short s) {
        String string2 = this.getParam(string);
        if (string2 == null) {
            return s;
        }
        return this.getshort(string);
    }

    public short getshort(String string) {
        return Short.parseShort(this.getParam(string));
    }

    public boolean getboolean(String string, boolean bl) {
        String string2 = this.getParam(string);
        if (string2 == null) {
            return bl;
        }
        if (!bl) {
            return string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true");
        }
        return !string2.equalsIgnoreCase("no") && !string2.equalsIgnoreCase("false");
    }

    public boolean getboolean(String string) {
        return this.getParam(string).equalsIgnoreCase("yes") || this.getParam(string).equalsIgnoreCase("true");
    }

    public String getParam(String string) {
        FieldSet fieldSet = this.params;
        String string2 = "";
        while (true) {
            int n;
            if ((n = string.indexOf(46)) < 0) {
                String string3 = fieldSet.get(string.toLowerCase());
                if (string3 == null) {
                    Core.logger.log(this, "No value specified for parameter '" + string2 + string + "'", Logger.DEBUGGING);
                }
                return string3;
            }
            if ((fieldSet = fieldSet.getSet(string.substring(0, n))) == null) {
                Core.logger.log(this, "No set specified for parameter '" + string2 + string.substring(0, n) + "'", Logger.DEBUGGING);
                return null;
            }
            string2 = string2 + string.substring(0, n) + ".";
            string = string.substring(n + 1);
        }
    }

    private void recursiveWriteParams(String string, FieldSet fieldSet, Hashtable hashtable, PrintWriter printWriter) {
        Enumeration enumeration = fieldSet.fieldNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (fieldSet.isSet(string2)) {
                this.recursiveWriteParams(string + string2 + ".", fieldSet.getSet(string2), hashtable, printWriter);
                continue;
            }
            String string3 = string + string2;
            if (hashtable.containsKey(string3)) continue;
            printWriter.println(string3 + "=" + fieldSet.get(string2));
        }
    }

    /*
     * Loose catch block
     */
    public void writeParams(String string) {
        Object object;
        StringBuffer stringBuffer;
        Hashtable<String, String> hashtable;
        File file;
        block23: {
            BufferedReader bufferedReader;
            FileReader fileReader;
            block22: {
                file = new File(string);
                hashtable = new Hashtable<String, String>();
                stringBuffer = new StringBuffer();
                fileReader = null;
                bufferedReader = null;
                if (!file.exists()) break block22;
                fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
                while ((object = bufferedReader.readLine()) != null) {
                    int n = ((String)object).indexOf(61);
                    if (n >= 0) {
                        String string2 = ((String)object).substring(0, n);
                        if (!hashtable.containsKey(string2)) {
                            String string3 = this.getParam(string2.trim());
                            if (string3 == null) {
                                stringBuffer.append((String)object);
                            } else {
                                stringBuffer.append(string2 + "=" + string3);
                            }
                            hashtable.put(string2.toLowerCase(), string2);
                        }
                    } else {
                        stringBuffer.append((String)object);
                    }
                    stringBuffer.append("\r\n");
                }
            }
            Object var12_13 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileReader != null) {
                    fileReader.close();
                }
                break block23;
            }
            catch (IOException iOException) {
                Core.logger.log(this, "Error while closing old config file during config write", Logger.ERROR);
            }
            break block23;
            {
                catch (IOException iOException) {
                    Core.logger.log(this, "Error while reading old config file during config write", Logger.ERROR);
                    Object var12_14 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (fileReader != null) {
                            fileReader.close();
                        }
                        break block23;
                    }
                    catch (IOException iOException2) {
                        Core.logger.log(this, "Error while closing old config file during config write", Logger.ERROR);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (IOException iOException) {
                    Core.logger.log(this, "Error while closing old config file during config write", Logger.ERROR);
                }
                throw throwable;
            }
        }
        try {
            object = new PrintWriter(new FileWriter(file));
            ((PrintWriter)object).print(stringBuffer.toString());
            this.recursiveWriteParams("", this.params, hashtable, (PrintWriter)object);
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            Core.logger.log(this, "Could not write to config file", Logger.ERROR);
        }
    }

    private boolean isOption(String string) {
        return !this.noMoreOptions && string.startsWith("-") && !string.equals("-");
    }

    static class ArrayFactory {
        ArrayFactory() {
        }

        public static String[] makeArray(String string) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
    }
}

