/*
 * Decompiled with CFR 0.152.
 */
package Freenet;

import Freenet.Core;
import Freenet.MessageHandler;
import Freenet.MessageObject;
import Freenet.support.Logger;
import Freenet.support.Schedulable;
import Freenet.support.TickerToken;
import Freenet.thread.ThreadManager;
import java.util.Enumeration;
import java.util.Vector;

public class Ticker
extends Thread {
    public Vector events;
    private long ticker;
    private MessageHandler mh;
    private ThreadManager tm;

    public Ticker(MessageHandler messageHandler, ThreadManager threadManager) {
        this(messageHandler, threadManager, 100L);
    }

    public void setTickerTime(long l) {
        this.ticker = l;
    }

    public Ticker(MessageHandler messageHandler, ThreadManager threadManager, long l) {
        super("Ticker");
        this.mh = messageHandler;
        this.ticker = l;
        this.events = new Vector(50, 20);
        this.tm = threadManager;
        this.events.addElement(new Object());
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.mh = messageHandler;
    }

    public void add(long l, MessageObject messageObject) {
        Event event = new Event(messageObject, l += System.currentTimeMillis());
        if (messageObject instanceof Schedulable) {
            ((Schedulable)messageObject).getToken(event);
        }
        this.events.addElement(event);
        int n = this.events.size() - 1;
        while (n > 1 && event.time() < ((Event)this.events.elementAt(n >> 1)).time()) {
            Event event2 = (Event)this.events.elementAt(n >> 1);
            event2.setPos(n);
            this.events.setElementAt(event2, n);
            n >>= 1;
        }
        event.setPos(n);
        this.events.setElementAt(event, n);
    }

    public void run() {
        Core.logger.log(this, "Thread started", Logger.DEBUGGING);
        while (true) {
            if (this.events.size() > 1 && this.first().time() <= System.currentTimeMillis()) {
                this.delete().execute();
                continue;
            }
            try {
                Thread.sleep(this.ticker);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.events.elements();
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            Event event = (Event)enumeration.nextElement();
            stringBuffer.append(event.time() + " - " + event.getOwner().id() + "\n");
        }
        return stringBuffer.toString();
    }

    public synchronized void remove(int n) {
        Event event = (Event)this.events.lastElement();
        ((Event)this.events.elementAt(n)).setPos(0);
        this.events.removeElementAt(this.events.size() - 1);
        if (this.events.size() <= n) {
            return;
        }
        while (n << 1 <= this.events.size() - 1) {
            int n2;
            if (n << 1 > this.events.size() - 2) {
                n2 = n << 1;
            } else {
                int n3 = n2 = ((Event)this.events.elementAt(n << 1)).time() < ((Event)this.events.elementAt((n << 1) + 1)).time() ? n << 1 : (n << 1) + 1;
            }
            if (((Event)this.events.elementAt(n2)).time() > event.time()) break;
            Event event2 = (Event)this.events.elementAt(n2);
            event2.setPos(n);
            this.events.setElementAt(event2, n);
            n = n2;
        }
        event.setPos(n);
        this.events.setElementAt(event, n);
    }

    private Event first() {
        return this.events.size() == 1 ? null : (Event)this.events.elementAt(1);
    }

    private synchronized Event delete() {
        if (this.events.size() == 1) {
            return null;
        }
        Event event = (Event)this.events.elementAt(1);
        this.remove(1);
        return event;
    }

    private class Event
    implements Runnable,
    TickerToken {
        private boolean executed;
        private MessageObject mo;
        private long time;
        private int pos = 0;

        public Event(MessageObject messageObject, long l) {
            this.mo = messageObject;
            this.time = l;
        }

        public synchronized void execute() {
            this.executed = true;
            if (Ticker.this.tm != null) {
                Ticker.this.tm.blockingRun(this);
            } else {
                new Thread((Runnable)this, "Scheduled MessageObject: " + this.mo).start();
            }
        }

        public boolean executed() {
            return this.executed;
        }

        public synchronized boolean cancel() {
            if (this.executed || this.pos == 0) {
                return false;
            }
            Ticker.this.remove(this.pos);
            return true;
        }

        public synchronized void setPos(int n) {
            this.pos = n;
        }

        public long time() {
            return this.time;
        }

        public void run() {
            Ticker.this.mh.handle(this.mo);
        }

        public MessageObject getOwner() {
            return this.mo;
        }
    }
}

