/*
 * Decompiled with CFR 0.152.
 */
package Freenet.client;

import Freenet.FieldSet;
import Freenet.Key;
import Freenet.KeyException;
import Freenet.client.ClientKey;
import Freenet.client.Document;
import Freenet.client.FreenetURI;
import Freenet.crypt.BlockCipher;
import Freenet.crypt.DigestInputStream;
import Freenet.crypt.ProgressiveHashOutputStream;
import Freenet.crypt.SHA1;
import Freenet.crypt.SHA1Factory;
import Freenet.crypt.Util;
import Freenet.keys.CHK;
import Freenet.support.Bucket;
import Freenet.support.Fields;
import java.io.IOException;
import java.io.InputStream;

public class ClientCHK
implements ClientKey {
    private InputStream in;
    private long plainLength;
    private byte[] cryptKey;
    private long totalLength = 0L;
    private long partSize = 0L;
    private CHK value;

    public ClientCHK(InputStream inputStream, long l) {
        this.in = inputStream;
        this.plainLength = l;
    }

    public ClientCHK(FreenetURI freenetURI) throws KeyException {
        if (!freenetURI.getKeyType().equals("CHK")) {
            throw new KeyException("Not a CHK URI");
        }
        this.value = new CHK(freenetURI.getKeyVal());
        this.cryptKey = freenetURI.getCryptoKey();
    }

    public ClientCHK(CHK cHK, byte[] byArray) {
        this.value = cHK;
        this.cryptKey = byArray;
    }

    public byte[] getEncryptionKey(int n) throws KeyException {
        if (this.cryptKey != null) {
            if (n != this.cryptKey.length) {
                throw new KeyException("Requested key length did not match that provided by URI (have " + this.cryptKey.length + " bytes, asked for " + n + ")");
            }
            return this.cryptKey;
        }
        if (this.in != null) {
            byte[] byArray;
            Object object;
            try {
                object = new DigestInputStream(new SHA1(), this.in);
                byte[] byArray2 = new byte[512];
                long l = this.plainLength;
                while (l > 0L) {
                    int n2 = ((DigestInputStream)object).read(byArray2, 0, (long)byArray2.length > l ? (int)l : byArray2.length);
                    l -= (long)n2;
                }
                byArray = ((DigestInputStream)object).getDigest().digest();
            }
            catch (IOException iOException) {
                throw new KeyException("Generating encryption key for CHK data failed");
            }
            object = new byte[n];
            Util.makeKey(byArray, (byte[])object, 0, n);
            this.cryptKey = (byte[])object;
            return this.cryptKey;
        }
        throw new KeyException("Cannot create key entropy from no data");
    }

    public InputStream docToStream(Document document, BlockCipher blockCipher, Bucket bucket) throws IOException {
        this.partSize = Math.max(this.plainLength >> 7, 16364L);
        if (this.partSize >= this.plainLength) {
            this.partSize = 0L;
        }
        ProgressiveHashOutputStream progressiveHashOutputStream = new ProgressiveHashOutputStream(this.partSize, new SHA1Factory(), bucket);
        document.write(progressiveHashOutputStream, blockCipher);
        progressiveHashOutputStream.finish();
        System.out.println(progressiveHashOutputStream.getLength());
        boolean bl = false;
        byte[] byArray = new byte[23];
        System.arraycopy(progressiveHashOutputStream.getDigest(), 0, byArray, 0, 20);
        this.totalLength = progressiveHashOutputStream.getLength();
        byArray[20] = Key.lengthLimit(this.partSize != 0L ? this.partSize : this.totalLength);
        byArray[21] = (byte)(CHK.keyNumber >> 8 & 0xFF);
        byArray[22] = (byte)(CHK.keyNumber & 0xFF);
        this.value = new CHK(byArray);
        return progressiveHashOutputStream.getData();
    }

    public Key getKey(FieldSet fieldSet) {
        fieldSet.add("PartSize", Fields.longToString(this.partSize == 0L ? this.partSize : this.partSize + 20L));
        return this.value;
    }

    public Key getKey() {
        return this.value;
    }

    public long getDataLength() {
        return this.totalLength;
    }

    public long getPlainLength(long l, FieldSet fieldSet) {
        String string = fieldSet.get("PartSize");
        if (string == null) {
            return l - 1L;
        }
        try {
            this.partSize = Fields.stringToLong(string);
            if (this.partSize == 0L) {
                return l - 1L;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
        int n = (int)(l / (this.partSize + 1L));
        long l2 = l % (this.partSize + 1L);
        return (long)n * (this.partSize - 20L) + l2 - 1L;
    }

    public FreenetURI getURI() {
        return new FreenetURI("CHK", null, this.value.getVal(), this.cryptKey);
    }

    public String toString() {
        return this.value == null ? "new CHK" : this.getURI().toString();
    }
}

